--
-- JD8400
-- Specialization for magnum tractors
--
-- @author  Knagsted
-- @date  15/03/10
--

-- Do not edit without my permission
--
JD8400 = {}

function JD8400.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD8400:load(xmlFile)
	self.numHeadLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.headLights#count"), 0);
    self.headLights = {};
    for i=1, self.numHeadLights do
        local headLightsNamei = string.format("vehicle.headLights.headLight" .. "%d", i);
        self.headLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, headLightsNamei .. "#index"));
        setVisibility(self.headLights[i], false);
    end;

	self.numFrontWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontWorkLights#count"), 0);
    self.frontWorkLights = {};
    for i=1, self.numFrontWorkLights do
        local frontWorkLightsNamei = string.format("vehicle.frontWorkLights.frontWorkLight" .. "%d", i);
        self.frontWorkLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, frontWorkLightsNamei .. "#index"));
        setVisibility(self.frontWorkLights[i], false);
    end;
	
	self.numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, self.numWorkLights do
        local workLightsNamei = string.format("vehicle.workLights.workLight" .. "%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, workLightsNamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	
	-- Digital Display digits RPM
	self.numDigitRPMOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOne#count"), 0);
	self.digitRPMOne = {};
    for i=1, self.numDigitRPMOne do
        local objname = string.format("vehicle.displayDigitRPMOne.digitRPM" .. "%d", i);
		self.digitRPMOne[i] = {};
        self.digitRPMOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOne[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOne[self.numDigitRPMOne].rotNode,true);
	
	self.numDigitRPMTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwo#count"), 0);
	self.digitRPMTwo = {};
    for i=1, self.numDigitRPMTwo do
        local objname = string.format("vehicle.displayDigitRPMTwo.digitRPM" .. "%d", i);
		self.digitRPMTwo[i] = {};
        self.digitRPMTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwo[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwo[self.numDigitRPMTwo].rotNode,true);

	self.numDigitRPMThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThree#count"), 0);
	self.digitRPMThree = {};
    for i=1, self.numDigitRPMThree do
        local objname = string.format("vehicle.displayDigitRPMThree.digitRPM" .. "%d", i);
		self.digitRPMThree[i] = {};
        self.digitRPMThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThree[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThree[self.numDigitRPMThree].rotNode,true);
	
	self.numDigitRPMFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFour#count"), 0);
	self.digitRPMFour = {};
    for i=1, self.numDigitRPMFour do
        local objname = string.format("vehicle.displayDigitRPMFour.digitRPM" .. "%d", i);
		self.digitRPMFour[i] = {};
        self.digitRPMFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFour[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFour[self.numDigitRPMFour].rotNode,true);
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOne#count"), 0);
	self.digitSPEEDOne = {};
    for i=1, self.numDigitSPEEDOne do
        local objname = string.format("vehicle.displayDigitSPEEDOne.digitSPEED" .. "%d", i);
		self.digitSPEEDOne[i] = {};
        self.digitSPEEDOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOne[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOne[self.numDigitSPEEDOne].rotNode,true);
	
	self.numDigitSPEEDTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwo#count"), 0);
	self.digitSPEEDTwo = {};
    for i=1, self.numDigitSPEEDTwo do
        local objname = string.format("vehicle.displayDigitSPEEDTwo.digitSPEED" .. "%d", i);
		self.digitSPEEDTwo[i] = {};
        self.digitSPEEDTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwo[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwo[self.numDigitSPEEDTwo].rotNode,true);

	self.numDigitSPEEDThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThree#count"), 0);
	self.digitSPEEDThree = {};
    for i=1, self.numDigitSPEEDThree do
        local objname = string.format("vehicle.displayDigitSPEEDThree.digitSPEED" .. "%d", i);
		self.digitSPEEDThree[i] = {};
        self.digitSPEEDThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThree[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThree[self.numDigitSPEEDThree].rotNode,true);
		
	-- Digital display ligth on
	-- Digital Display digits RPM
	self.numDigitRPMOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOneLight#count"), 0);
	self.digitRPMOneLight = {};
    for i=1, self.numDigitRPMOneLight do
        local objname = string.format("vehicle.displayDigitRPMOneLight.digitRPM" .. "%d", i);
		self.digitRPMOneLight[i] = {};
        self.digitRPMOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOneLight[self.numDigitRPMOneLight].rotNode,true);
	
	self.numDigitRPMTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwoLight#count"), 0);
	self.digitRPMTwoLight = {};
    for i=1, self.numDigitRPMTwoLight do
        local objname = string.format("vehicle.displayDigitRPMTwoLight.digitRPM" .. "%d", i);
		self.digitRPMTwoLight[i] = {};
        self.digitRPMTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwoLight[self.numDigitRPMTwoLight].rotNode,true);

	self.numDigitRPMThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThreeLight#count"), 0);
	self.digitRPMThreeLight = {};
    for i=1, self.numDigitRPMThreeLight do
        local objname = string.format("vehicle.displayDigitRPMThreeLight.digitRPM" .. "%d", i);
		self.digitRPMThreeLight[i] = {};
        self.digitRPMThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThreeLight[self.numDigitRPMThreeLight].rotNode,true);
	
	self.numDigitRPMFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFourLight#count"), 0);
	self.digitRPMFourLight = {};
    for i=1, self.numDigitRPMFourLight do
        local objname = string.format("vehicle.displayDigitRPMFourLight.digitRPM" .. "%d", i);
		self.digitRPMFourLight[i] = {};
        self.digitRPMFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFourLight[self.numDigitRPMFourLight].rotNode,true);
	
	-- Digital Display digits Speed
	self.numDigitSPEEDOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDOneLight#count"), 0);
	self.digitSPEEDOneLight = {};
    for i=1, self.numDigitSPEEDOneLight do
        local objname = string.format("vehicle.displayDigitSPEEDOneLight.digitSPEED" .. "%d", i);
		self.digitSPEEDOneLight[i] = {};
        self.digitSPEEDOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDOneLight[self.numDigitSPEEDOneLight].rotNode,true);
	
	self.numDigitSPEEDTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDTwoLight#count"), 0);
	self.digitSPEEDTwoLight = {};
    for i=1, self.numDigitSPEEDTwoLight do
        local objname = string.format("vehicle.displayDigitSPEEDTwoLight.digitSPEED" .. "%d", i);
		self.digitSPEEDTwoLight[i] = {};
        self.digitSPEEDTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDTwoLight[self.numDigitSPEEDTwoLight].rotNode,true);

	self.numDigitSPEEDThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitSPEEDThreeLight#count"), 0);
	self.digitSPEEDThreeLight = {};
    for i=1, self.numDigitSPEEDThreeLight do
        local objname = string.format("vehicle.displayDigitSPEEDThreeLight.digitSPEED" .. "%d", i);
		self.digitSPEEDThreeLight[i] = {};
        self.digitSPEEDThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitSPEEDThreeLight[self.numDigitSPEEDThreeLight].rotNode,true);

	-- Indicator needles
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeVoltnadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#index"));
    if rotationPartNodeVoltnadel ~= nil then
        self.rotationPartVoltnadel = {};
        self.rotationPartVoltnadel.node = rotationPartNodeVoltnadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#minRot"));
        self.rotationPartVoltnadel.minRot = {};
        self.rotationPartVoltnadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartVoltnadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartVoltnadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#maxRot"));
        self.rotationPartVoltnadel.maxRot = {};
        self.rotationPartVoltnadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartVoltnadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartVoltnadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartVoltnadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#rotTime"), 2)*1000;
        self.rotationPartVoltnadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartVoltnadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTempnadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTempnadel#index"));
    if rotationPartNodeTempnadel ~= nil then
        self.rotationPartTempnadel = {};
        self.rotationPartTempnadel.node = rotationPartNodeTempnadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#minRot"));
        self.rotationPartTempnadel.minRot = {};
        self.rotationPartTempnadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTempnadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTempnadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#maxRot"));
        self.rotationPartTempnadel.maxRot = {};
        self.rotationPartTempnadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTempnadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTempnadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTempnadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#rotTime"), 2)*1000;
        self.rotationPartTempnadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTempnadel#touchRotLimit"), 10));
    end;
			
	-- Root display nodes
	self.displayRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayRootNode#index"));
	self.displayRootNodeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayRootNodeLight#index"));
	setVisibility(self.displayRootNode,true);
	setVisibility(self.displayRootNodeLight,false);
	
	-- Rear lift animation
	self.lifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifter#index"));
	self.lifterAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterAttacher#index"));
	self.lifterArmLower = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLower#index"));
	self.lifterArmLowerAttacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLowerAttacherJoint#index"));
	self.push1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push1#index"));
	self.push2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push2#index"));
	self.hydraulics1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics1#index"));
	self.hydraulics2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics2#index"));
	self.hydraulicsJoint1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint1#index"));
	self.hydraulicsJoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint2#index"));
	
	-- Front axle animation
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));
	self.frontAxle.steeringHydraulicsLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringHydraulicsLeft"));
	self.frontAxle.steeringHydraulicsRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringHydraulicsRight"));
	self.frontAxle.steeringPushLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushLeft"));
	self.frontAxle.steeringPushRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushRight"));
	self.frontAxle.steeringPushLeftAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushLeftAttach"));
	self.frontAxle.steeringPushRightAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPushRightAttach"));
	self.frontAxle.guidanceRod = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#guidanceRod"));
	
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;
	
	-- Moveable camera
	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	
	
	-- Switches leavers etc
	self.liftSwitch = {}; 
	self.liftSwitch.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftSwitch#index"));
	
	self.liftLeaver = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftLeaver#index"));
	self.liftLeaverRelationship = 0;
	if self.attacherJoints[1].maxRot[1] ~= nil and self.attacherJoints[1].minRot[1] ~= nil then
		self.liftLeaverRelationship = (self.attacherJoints[1].minRot[1] - self.attacherJoints[1].maxRot[1])/Utils.degToRad(-8);
	end;
	
	local doorNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door#index"));
    if doorNode ~= nil then
        self.door = {};
        self.door.node = doorNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door#minRot"));
        self.door.minRot = {};
        self.door.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door#maxRot"));
        self.door.maxRot = {};
        self.door.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.door.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door#rotTime"), 200);
        self.door.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.door#touchRotLimit"), 10));
    end;
	
	local rearWindowNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearWindow#index"));
    if rearWindowNode ~= nil then
        self.rearWindow = {};
        self.rearWindow.node = rearWindowNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rearWindow#minRot"));
        self.rearWindow.minRot = {};
        self.rearWindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rearWindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rearWindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rearWindow#maxRot"));
        self.rearWindow.maxRot = {};
        self.rearWindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rearWindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rearWindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rearWindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rearWindow#rotTime"), 200);
        self.rearWindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rearWindow#touchRotLimit"), 10));
    end;
	
	self.lightSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightSwitch#index"));
	self.key = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.key#index"));
	self.engineRunTime = 0;	

	self.frontLightMode = 0;
	self.headLightActive = false;
	self.frontWorkLightActive = false;
	self.workLightActive = false;
	
	self.displayValue = 0;
	self.prevousDigitRPMFour = self.numDigitRPMFour;
	self.prevousDigitRPMThree = self.numDigitRPMThree;
	self.prevousDigitRPMTwo = self.numDigitRPMTwo;
	self.prevousDigitRPMOne = 0;
	
	self.prevousDigitSPEEDFour = self.numDigitSPEEDFour;
	self.prevousDigitSPEEDThree = self.numDigitSPEEDThree;
	self.prevousDigitSPEEDTwo = self.numDigitSPEEDTwo;
	self.prevousDigitSPEEDOne = self.numDigitSPEEDOne;
	
	self.prevousFuelPercentage = 0;
	
	self.cycleRoundMax = 30;
	self.currentCycle = 0;
	self.lastRpm = 0;
	
	self.lifterStartAngle = 0;
	
	self.startAngel1 = 0;
	self.startAngel2 = 0;
	self.startTranslation = 0;
	self.liftInitialized = false;
	self.shiftMode = 1;
	self.lastLiftXRot = 0;
	
	self.mirrorsEnabled = false;
	self.leftMirrorGlass = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMirrorGlass#index"));
	self.rightMirrorGlass = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMirrorGlass#index"));	
	self.leftMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMirror#index"));
	self.rightMirror = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMirror#index"));
	
	if self.mirrorRotationOffsetXleft == nil then
		self.mirrorRotationOffsetXleft = 10.214;
	end;
	
	if self.mirrorRotationOffsetYleft == nil then
		self.mirrorRotationOffsetYleft = -27.29;
	end;

	if self.mirrorRotationOffsetXright == nil then
		self.mirrorRotationOffsetXright = -10.214;
	end;

	if self.mirrorRotationOffsetYright == nil then
		self.mirrorRotationOffsetYright = -27.29;
	end;
	
	if self.mirrorRotationOffsetZleft == nil then
		self.mirrorRotationOffsetZleft = 178.60001;
	end;
	
	if self.mirrorRotationOffsetZright == nil then
		self.mirrorRotationOffsetZright = 1.39319;
	end;
	
	if self.camPositionX == nil then
		self.camPositionX = 0;
	end;
	
	if self.camPositionZ == nil then
		self.camPositionZ = 0;
	end;
	
	self.rpmDisplaysSetOff = false;
	self.speedDisplaysSetOff = false;
	
	-- HUD --
	self.HUDActive = true;
	self.HUDpath = Utils.getFilename("HUD_Controls.png", self.baseDirectory);
	self.HUDWidth = 0.100;
    self.HUDHeight = 0.22;
	self.HUDPoxX = 0.90;
    self.HUDPoxY = 0.167
    self.HUDOverlay = Overlay:new("HUD", self.HUDpath, self.HUDPoxX, self.HUDPoxY, self.HUDWidth, self.HUDHeight);
end;
      
function JD8400:delete()
end;

function JD8400:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function JD8400:keyEvent(unicode, sym, modifier, isDown)
end;

function JD8400:update(dt)
	if self.isMotorStarted then
		self.engineRunTime = dt + self.engineRunTime;
	else
		self.engineRunTime = 0;
	end;
	
	-- Indication Needles
	if self.isMotorStarted then
		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;
			
		if self.rotationPartVoltnadel ~= nil then
			setRotation(self.rotationPartVoltnadel.node, 0, Utils.degToRad(-112.5),0);
		end;
		
		if self.rotationPartTempnadel ~= nil then
			setRotation(self.rotationPartTempnadel.node, 0, Utils.degToRad(-75),0);
		end;
	else
		setRotation(self.rotationPartTanknadel.node, 0, 0 , 0);
		setRotation(self.rotationPartVoltnadel.node, 0, 0 , 0);
		setRotation(self.rotationPartTempnadel.node, 0, 0 , 0);
	end;
	
	-- Front axle animation
	if self.attacherJoints[1] ~= nil then
		if self.attacherJoints[1].maxRot[1] ~= nil then
			if not self.liftInitialized then
				self.maxLiftDebth = self.attacherJoints[1].maxRot[1];
				self.minLiftDebth = self.attacherJoints[1].minRot[1];
				self.liftInitialized = true;
			end;
		end;
	end;
				
	if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[1].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[2].repr);
		
		--[[local yDiff = by-ay;
		local xDiff = 2 * 0.88;
		
		local angle = 0;
		if yDiff ~= 0 then
			angle = yDiff/math.tan(xDiff);
		end;]]
		
		--setRotation(self.frontAxle.rotNode,0,0,angle);
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);
		
        setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);
		
		local x2,y2,z2 = getRotation(self.frontAxle.rotNode);
		
		--renderText(0.5, 0.65, 0.040, "x=" .. string.format((x2/3.14) * 180));
		--renderText(0.5, 0.75, 0.040, "y=" .. string.format((y2/3.14) * 180));
		--renderText(0.5, 0.85, 0.040, "z=" .. string.format((z2/3.14) * 180));
		
		setRotation(self.frontAxle.rotNode,x2 - 1.571,y2,z2 + 1.571);
	end;
	
	for i=1, self.numAnimatedWheels do
		if self.wheels[i].repr ~= nil then
			local x,y,z = getRotation(self.wheels[i].driveNode);
			local x2,y2,z2 = getRotation(self.wheels[i].repr);
			setRotation(self.animatedWheel[i].wheel, x,y,z);
			setRotation(self.animatedWheel[i].rotNode, x2,y2,z2);
		end;
	end;
	
	--[[if self.frontAxle.steeringPushLeftAttach ~= nil and self.animatedWheel[1].fenderAttach ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringPushLeftAttach);
        local bx, by, bz = getWorldTranslation(self.animatedWheel[1].fenderAttach);
        local cx, cy, cz = getWorldTranslation(self.frontAxle.rotNode);
		
		local zDiff = bz-az;
		local xDiff = bx-ax;
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringPushLeftAttach), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringPushLeftAttach, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.frontAxle.steeringPushLeftAttach);
		setRotation(self.frontAxle.steeringPushLeftAttach,x2,y2+4.71,z2);

		local x,y,z = getRotation(self.animatedWheel[1].rotNode);
		self.translation = -0.2094 * math.tan(y);
		setTranslation(self.frontAxle.steeringPushLeft,(self.translation)*0.81,0,0);	
	end;]]
	
	if self.frontAxle.steeringHydraulicsLeft ~= nil and self.frontAxle.steeringPushLeftAttach ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringHydraulicsLeft);
        local bx, by, bz = getWorldTranslation(self.frontAxle.steeringPushLeftAttach);

		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringHydraulicsLeft), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringHydraulicsLeft, x, y, z, 0, -1, 0);
		
		local x,y,z = getRotation(self.animatedWheel[1].rotNode);
		self.translation = -0.17 * math.tan(y);
		setTranslation(self.frontAxle.steeringPushLeft,(self.translation)*0.7,0,0);	
		--local x2,y2,z2 = getRotation(self.frontAxle.steeringHydraulicsLeft);
		--renderText(0.5, 0.65, 0.040, string.format((y2/3.14) * 180));
	end;
	
	if self.frontAxle.steeringHydraulicsRight ~= nil and self.frontAxle.steeringPushRightAttach ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringPushRightAttach);
        local bx, by, bz = getWorldTranslation(self.frontAxle.steeringHydraulicsRight);

		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringHydraulicsRight), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringHydraulicsRight, x, y, z, 0, 1, 0);
		
		local x,y,z = getRotation(self.animatedWheel[2].rotNode);
		self.translation = 0.17 * math.tan(y);
		setTranslation(self.frontAxle.steeringPushRight,(self.translation)*0.7,0,0);
		--local x2,y2,z2 = getRotation(self.frontAxle.steeringHydraulicsRight);
		--renderText(0.5, 0.65, 0.040, string.format((y2/3.14) * 180));
	end;
	
	if self.animatedWheel[1].fenderAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil then
		local ax, ay, az = getWorldTranslation(self.animatedWheel[1].fenderAttach);
        local bx, by, bz = getWorldTranslation(self.animatedWheel[2].fenderAttach);
		
		local x, y, z = worldDirectionToLocal(getParent(self.animatedWheel[2].fenderAttach), bx-ax, by-ay, bz-az);
        setDirection(self.animatedWheel[1].fenderAttach, x, y, z, 0, 1, 0);
		
		--local x2,y2,z2 = getRotation(self.animatedWheel[1].fenderAttach);
		--renderText(0.5, 0.65, 0.040, string.format(y2));
	end;
	
	--self.frontAxle.guidanceRod
	
	--[[if self.frontAxle.steeringPushRightAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil and self.frontAxle.steeringPush ~= nil then
		local ax, ay, az = getWorldTranslation(self.frontAxle.steeringPushRightAttach);
        local bx, by, bz = getWorldTranslation(self.animatedWheel[2].fenderAttach);
		--local cx, cy, cz = getWorldTranslation(self.frontAxle.rotNode);
		
		local zDiff = bz-az;
		local xDiff = bx-ax;
		
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.steeringPushRightAttach), bx-ax, by-ay, bz-az);
        setDirection(self.frontAxle.steeringPushRightAttach, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.frontAxle.steeringPushRightAttach);
		setRotation(self.frontAxle.steeringPushRightAttach,x2,y2-4.71,z2);
	end;]]
	
	-- Lift Arm simulation
	if self.lifterArmLower ~= nil and self.lifter ~= nil then
		local x,y,z = getRotation(self.lifterArmLower);
		if self.lifterStartAngle == 0 and x ~= nil then
			self.lifterStartAngle = x;
		end;
		
		local lifterFactor = 1.47;
		local lifterRotation =  x * lifterFactor ;
		setRotation(self.lifter, lifterRotation, y,z);
		
		if self.lifterAttacher ~= nil and self.lifterArmLowerAttacherJoint ~= nil then
			local ax, ay, az = getWorldTranslation(self.lifterAttacher);
			local bx, by, bz = getWorldTranslation(self.lifterArmLowerAttacherJoint);

			local x, y, z = worldDirectionToLocal(getParent(self.lifterAttacher), bx-ax, by-ay, bz-az);
			setDirection(self.lifterAttacher, x, y, z, 0, 1, 0);		
		end;
	end;
	
	if self.hydraulicsJoint1 ~= nil and self.hydraulics1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics1);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint1);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics1), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics1, x, y, z, 0, 1, 0);
		local xFactor = 1;
		if self.lifterArmLower ~= nil then
			local x,y,z = getRotation(self.lifterArmLower);
			local startX = (9/180) * 3.14;
			
			xFactor = 0.152 * (startX-x);
		end;
		
		local xTransLation = math.sqrt((bx-ax)^2 + (by-ay)^2 + (bz-az)^2);
		--renderText(0.5, 0.65, 0.040, string.format(xTransLation));
		
		setTranslation(self.push1,xTransLation + xFactor,0,0);
		
		local x2,y2,z2 = getRotation(self.hydraulics1);
		setRotation(self.hydraulics1,x2, y2+1.57,z2);
	end;
	
	if self.hydraulicsJoint2 ~= nil and self.hydraulics2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics2);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint2);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics2), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics2, x, y, z, 0, 1, 0);
		
		local xFactor = 1;
		if self.lifterArmLower ~= nil then
			local x,y,z = getRotation(self.lifterArmLower);
			local startX = (9/180) * 3.14;
			
			xFactor = 0.152 * (startX-x);
		end;
		
		local xTransLation = math.sqrt((bx-ax)^2 + (by-ay)^2 + (bz-az)^2);
		--renderText(0.5, 0.65, 0.040, string.format(xTransLation));
		
		setTranslation(self.push2,xTransLation + xFactor,0,0);
		
		local x2,y2,z2 = getRotation(self.hydraulics2);
		setRotation(self.hydraulics2,x2, y2+1.57,z2);
	end;
	
	if self.door ~= nil then
		local x, y, z = getRotation(self.door.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.door.minRot, self.door.maxRot, 3, self.door.rotTime, dt, self.openDoor);
		setRotation(self.door.node, unpack(newRot));
	end;

	if self.rearWindow ~= nil then
		local x, y, z = getRotation(self.rearWindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rearWindow.minRot, self.rearWindow.maxRot, 3, self.rearWindow.rotTime, dt, self.openrearWindow);
		setRotation(self.rearWindow.node, unpack(newRot));
	end;

	-- Key animation
	if self.key ~= nil then
		if self.isMotorStarted and self.engineRunTime < 1500 then
			setRotation(self.key, Utils.degToRad(-74.51489),Utils.degToRad(-29.51921) ,Utils.degToRad(60.65189));
		elseif self.isMotorStarted then
			setRotation(self.key, Utils.degToRad(-60.11575),Utils.degToRad(-14.71329) ,Utils.degToRad(23.84418));
		else
			setRotation(self.key, Utils.degToRad(-57.08946),Utils.degToRad(2.67945) ,Utils.degToRad(-4.13145));
		end;
	end;

	-- Input reading
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.LIGHTSCYCLE) then
			self.frontLightMode = self.frontLightMode + 1;
			if self.frontLightMode > 5 then
				self.frontLightMode = 0;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMLEFT) then
			if 	self.shiftMode == 1 then
				self.camPositionX = self.camPositionX + 0.02;
				if self.camPositionX >= 0.3 then
					self.camPositionX = 0.3;
				end;
			elseif self.shiftMode == 2 then
				self.mirrorRotationOffsetYleft = self.mirrorRotationOffsetYleft + 0.5;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetYright = self.mirrorRotationOffsetYright + 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMRIGHT) then
			if 	self.shiftMode == 1 then
				self.camPositionX = self.camPositionX - 0.02;
				if self.camPositionX <= -0.3 then
					self.camPositionX = -0.3;
				end;
			elseif self.shiftMode == 2 then
				self.mirrorRotationOffsetYleft = self.mirrorRotationOffsetYleft - 0.5;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetYright = self.mirrorRotationOffsetYright - 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMFORWARD) then
			if 	self.shiftMode == 1 then
				self.camPositionZ = self.camPositionZ + 0.02;
				if self.camPositionZ >= 0.3 then
					self.camPositionZ = 0.3;
				end;
			elseif self.shiftMode == 2 then
				self.mirrorRotationOffsetXleft = self.mirrorRotationOffsetXleft + 0.5;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetXright = self.mirrorRotationOffsetXright - 0.5;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMBACK) then
			if 	self.shiftMode == 1 then
				self.camPositionZ = self.camPositionZ - 0.02;
				if self.camPositionZ <= -0.3 then
					self.camPositionZ = -0.3;
				end;
			elseif self.shiftMode == 2 then
				self.mirrorRotationOffsetXleft = self.mirrorRotationOffsetXleft - 0.5;
			elseif self.shiftMode == 3 then
				self.mirrorRotationOffsetXright = self.mirrorRotationOffsetXright + 0.5;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.MOVECAMRESET) then
			if 	self.shiftMode == 1 then
				self.camPositionX = 0;
				self.camPositionZ = 0;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.SHIFT) then
			self.shiftMode = self.shiftMode + 1;
			if self.shiftMode > 3 then
				self.shiftMode = 1;
			end;
		end;

		if InputBinding.hasEvent(InputBinding.ACTIVATEMIRRORS) then
			self.mirrorsEnabled = not self.mirrorsEnabled;
		end;
		
		if InputBinding.hasEvent(InputBinding.OPENLEFTDOOR) then
			self.openDoor = not self.openDoor;
		end;
		
		if InputBinding.hasEvent(InputBinding.REARWINDOW) then
			self.openrearWindow = not self.openrearWindow;
		end;
		
		if InputBinding.isPressed(InputBinding.JDINCREASELIFTDEBTH) then
			if self.attacherJoints[1] ~= nil then
				if self.attacherJoints[1].maxRot[1] ~= nil then
					if self.attacherJoints[1].maxRot[1] > self.maxLiftDebth then
						self.attacherJoints[1].maxRot[1] = self.attacherJoints[1].maxRot[1] - 0.005;
					end;
				end;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.JDDECRESELIFTDEBTH) then
			if self.attacherJoints[1] ~= nil then
				if self.attacherJoints[1].maxRot[1] ~= nil then
					if self.attacherJoints[1].maxRot[1] < self.minLiftDebth then
						self.attacherJoints[1].maxRot[1] = self.attacherJoints[1].maxRot[1] + 0.005;
					end;
				end;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.JDINCREASELIFTROT) then
			if self.attacherJoints[1] ~= nil then
				if self.attacherJoints[1].maxRot2[1] ~= nil and self.attacherJoints[1].maxRot2[1] > 0.0 then
					self.attacherJoints[1].maxRot2[1] = self.attacherJoints[1].maxRot2[1] - 0.005;
					self.attacherJoints[1].minRot2[1] = self.attacherJoints[1].minRot2[1] - 0.005;
				end;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.JDDECRESELIFTROT) then
			if self.attacherJoints[1] ~= nil then
				if self.attacherJoints[1].maxRot2[1] ~= nil and self.attacherJoints[1].maxRot2[1] < 0.3 then
					self.attacherJoints[1].maxRot2[1] = self.attacherJoints[1].maxRot2[1] + 0.005;
					self.attacherJoints[1].minRot2[1] = self.attacherJoints[1].minRot2[1] + 0.005;
				end;
			end;
		end;
		
		--renderText(0.5, 0.1, 0.020, string.format(self.attacherJoints[1].maxRot2[1]));
		
		if InputBinding.hasEvent(InputBinding.JDHUD) then
			self.HUDActive = not self.HUDActive;
		end;
	end;
	
	-- lift switch and leaver
	if self.attacherJoints[1].rotationNode ~= nil then
		
		--renderText(0.5, 0.42, 0.020, string.format("min rot=" .. "%f", self.attacherJoints[1].minRot[1]));
		--renderText(0.5, 0.40, 0.020, string.format("max rot=" .. "%f", self.attacherJoints[1].maxRot[1]));
		--renderText(0.5, 0.38, 0.020, string.format("current rot=" .. "%f", x));
		--renderText(0.5, 0.36, 0.020, string.format("self.liftLeaverRelationship=" .. "%f", self.liftLeaverRelationship));
		
		
		local x,y,z = getRotation(self.attacherJoints[1].rotationNode);
		if x < self.lastLiftXRot then
			setRotation(self.liftSwitch.node, 0, 0, Utils.degToRad(-10));
		elseif x > self.lastLiftXRot then
			setRotation(self.liftSwitch.node, 0, 0, Utils.degToRad(10));
		end;
		self.lastLiftXRot = x; 
	end;
		
	if self.liftLeaver ~= nil then
		setRotation(self.liftLeaver, (self.attacherJoints[1].maxRot[1] * self.liftLeaverRelationship), 0 ,0);
	end;
	
	-- Mirrors
	if self.leftMirrorGlass ~= nil then
		setVisibility(self.leftMirrorGlass,self.mirrorsEnabled);
	end;
	
	if self.rightMirrorGlass ~= nil then
		setVisibility(self.rightMirrorGlass,self.mirrorsEnabled);
	end;
	
	if self.leftMirror ~= nil then
		setRotation(self.leftMirror,Utils.degToRad(self.mirrorRotationOffsetXleft),Utils.degToRad(self.mirrorRotationOffsetYleft),Utils.degToRad(self.mirrorRotationOffsetZleft));
	end;
	
	if self.rightMirror ~= nil then
		setRotation(self.rightMirror,Utils.degToRad(self.mirrorRotationOffsetXright),Utils.degToRad(self.mirrorRotationOffsetYright),Utils.degToRad(self.mirrorRotationOffsetZright));
	end;
	
	-- Camera translation
	if self.internalCamera ~= nil then
		setTranslation(self.internalCamera, self.camPositionX, 0, self.camPositionZ);
	end;
	
	-- lights
	if self.frontLightMode == 0  then
		self.headLightActive = false;
		self.workLightActive = false;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(0), 0);
		end;
	elseif self.frontLightMode == 1 or self.frontLightMode == 5 then
		self.headLightActive = true;
		self.workLightActive = false;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-30), 0);
		end;
	elseif self.frontLightMode == 2 or self.frontLightMode == 4 then
		self.headLightActive = true;
		self.workLightActive = true;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-60), 0);
		end;
	elseif self.frontLightMode == 3 then
		self.headLightActive = false;
		self.workLightActive = true;
		self.frontWorkLightActive = true;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-90), 0);
		end;
	end;
	
	if self.frontLightMode == 0 then
		setVisibility(self.displayRootNode,true);
		setVisibility(self.displayRootNodeLight,false);
	else
		setVisibility(self.displayRootNode,false);
		setVisibility(self.displayRootNodeLight,true);
	end;
	
	if not self.isMotorStarted then
		setVisibility(self.displayRootNode,false);
		setVisibility(self.displayRootNodeLight,false);
	end;
	
	for i=1, self.numHeadLights do
		setVisibility(self.headLights[i], self.headLightActive);
	end;
	
	for i=1, self.numFrontWorkLights do
		setVisibility(self.frontWorkLights[i], self.frontWorkLightActive);
	end;
	
	for i=1, self.numWorkLights do
		setVisibility(self.workLights[i], self.workLightActive);
	end;
	
	-- Digital Display handling RPM
	if self.isEntered then
		--setVisibility(self.digitRPMTwo[1].rotNode,false);
		--if self.displaySelectorMode == 0 then
		if self.isMotorStarted then
			if self.currentCycle < self.cycleRoundMax then
				self.currentCycle = self.currentCycle + 1;
				self.currentRPM = self.motor.lastMotorRpm;
				if self.rpmMeterValue ~= nil then
					self.currentRPM = self.rpmMeterValue;
				end;
				self.lastRpm = math.floor((self.lastRpm + self.currentRPM)/2);
			else
				self.currentCycle = 0;
				self.displayValue = self.lastRpm;
			end;
		else
			self.displayValue = 0;
		end;
		
		--end;
		local displayValue = self.displayValue;
		
		--if self.displaySelectorMode == 1 then
			--displayValue = math.floor(displayValue);
		--end;

		-- Handle the digitRPMs in the display
		if self.isMotorStarted then
			local thousends = math.floor(displayValue/1000);
			local displayIndex = thousends;
			if self.prevousDigitRPMFour ~= thousends then
				if self.prevousDigitRPMFour > 0 then
					setVisibility(self.digitRPMFour[self.prevousDigitRPMFour].rotNode,false);
					setVisibility(self.digitRPMFourLight[self.prevousDigitRPMFour].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitRPMFour; 
				end;
				setVisibility(self.digitRPMFour[displayIndex].rotNode,true);
				setVisibility(self.digitRPMFourLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMFour = displayIndex;
				
			displayValue = displayValue - thousends * 1000;
			local hundreds = math.floor(displayValue/100);
			displayIndex = hundreds;
			if self.prevousDigitRPMThree ~= hundreds then
				if self.prevousDigitRPMThree > 0 then
					setVisibility(self.digitRPMThree[self.prevousDigitRPMThree].rotNode,false);
					setVisibility(self.digitRPMThreeLight[self.prevousDigitRPMThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					displayIndex = self.numDigitRPMThree;
				elseif displayIndex == 0 then 
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitRPMThree[displayIndex].rotNode,true);
				setVisibility(self.digitRPMThreeLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMThree = displayIndex;
			
			displayValue = displayValue - hundreds * 100;
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitRPMTwo ~= tens then
				if self.prevousDigitRPMTwo > 0 then
					setVisibility(self.digitRPMTwo[self.prevousDigitRPMTwo].rotNode,false);
					setVisibility(self.digitRPMTwoLight[self.prevousDigitRPMTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					displayIndex = self.numDigitRPMTwo;
				elseif displayIndex == 0 then 
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitRPMTwo[displayIndex].rotNode,true);
				setVisibility(self.digitRPMTwoLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMTwo = displayIndex;
			
			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			displayIndex = 10;
			if self.prevousDigitRPMOne ~= ones then
				if self.prevousDigitRPMOne > 0 then
					setVisibility(self.digitRPMOne[displayIndex+1].rotNode,false);
					setVisibility(self.digitRPMOneLight[displayIndex+1].rotNode,false);
				end;

				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitRPMOne[displayIndex].rotNode,true);
				setVisibility(self.digitRPMOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitRPMOne = displayIndex;
			self.rpmDisplaysSetOff = false;
		else
			if not self.rpmDisplaysSetOff then
				for i=1, self.numDigitRPMOne do
					setVisibility(self.digitRPMOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMTwo do
					setVisibility(self.digitRPMTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThree do
					setVisibility(self.digitRPMThree[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMFour do
					setVisibility(self.digitRPMFour[i].rotNode,false);
				end;
				
				for i=1, self.numDigitRPMOneLight do
					setVisibility(self.digitRPMOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMTwoLight do
					setVisibility(self.digitRPMTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThreeLight do
					setVisibility(self.digitRPMThreeLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitRPMFourLight do
					setVisibility(self.digitRPMFourLight[i].rotNode,false);
				end;
				
				self.rpmDisplaysSetOff = true;
			end;
		end;
	end;
	
	-- Digital Display handling Speed
	if self.isEntered then
		--if self.displaySelectorMode == 0 then
		
		--end;
		local displayValueSpeed = math.floor(self.lastSpeed * 3600 * 100);
		displayValueSpeed = displayValueSpeed/10;
		
		--if self.displaySelectorMode == 1 then
			--displayValueSpeed = math.floor(displayValueSpeed);
		--end;

		-- Handle the digitSPEEDs in the display
		if self.isMotorStarted then
			setVisibility(self.digitSPEEDTwo[11].rotNode,true);
			setVisibility(self.digitSPEEDTwoLight[11].rotNode,true);
			local thousends = math.floor(displayValueSpeed/1000);
			local displayIndex = thousends;
			
			self.prevousDigitSPEEDFour = displayIndex;
				
			displayValueSpeed = displayValueSpeed - thousends * 1000;
			local hundreds = math.floor(displayValueSpeed/100);
			displayIndex = hundreds;
			if self.prevousDigitSPEEDThree ~= hundreds then
				if self.prevousDigitSPEEDThree > 0 then
					setVisibility(self.digitSPEEDThree[self.prevousDigitSPEEDThree].rotNode,false);
					setVisibility(self.digitSPEEDThreeLight[self.prevousDigitSPEEDThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					displayIndex = self.numDigitSPEEDThree;
				elseif displayIndex == 0 then 
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDThree[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDThreeLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDThree = displayIndex;
			
			displayValueSpeed = displayValueSpeed - hundreds * 100;
			local tens = math.floor(displayValueSpeed/10);
			displayIndex = tens;
			if self.prevousDigitSPEEDTwo ~= tens then
				if self.prevousDigitSPEEDTwo > 0 then
					setVisibility(self.digitSPEEDTwo[self.prevousDigitSPEEDTwo].rotNode,false);
					setVisibility(self.digitSPEEDTwoLight[self.prevousDigitSPEEDTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					displayIndex = 10;
				elseif displayIndex == 0 then 
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				setVisibility(self.digitSPEEDTwo[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDTwoLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDTwo = displayIndex;
			
			displayValueSpeed = displayValueSpeed - tens * 10;
			local ones = math.floor(displayValueSpeed);
			displayIndex = ones;
			if self.prevousDigitSPEEDOne ~= ones then
				if self.prevousDigitSPEEDOne > 0 then
					setVisibility(self.digitSPEEDOne[self.prevousDigitSPEEDOne].rotNode,false);
					setVisibility(self.digitSPEEDOneLight[self.prevousDigitSPEEDOne].rotNode,false);
				end;

				if displayIndex == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitSPEEDOne[displayIndex].rotNode,true);
				setVisibility(self.digitSPEEDOneLight[displayIndex].rotNode,true);
			end;
			self.prevousDigitSPEEDOne = displayIndex;
			self.speedDisplaysSetOff = false;
		else
			if not self.speedDisplaysSetOff then
				for i=1, self.numDigitSPEEDOne do
					setVisibility(self.digitSPEEDOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwo do
					setVisibility(self.digitSPEEDTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThree do
					setVisibility(self.digitSPEEDThree[i].rotNode,false);
				end;
				
				for i=1, self.numDigitSPEEDOneLight do
					setVisibility(self.digitSPEEDOneLight[i].rotNode,false);
				end;
		
				for i=1, self.numDigitSPEEDTwoLight do
					setVisibility(self.digitSPEEDTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitSPEEDThreeLight do
					setVisibility(self.digitSPEEDThreeLight[i].rotNode,false);
				end;
		
				self.speedDisplaysSetOff = true;
			end;
		end;
	end;
	
end;

function JD8400:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    self.mirrorRotationOffsetXleft = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetXleft"), 0);
    self.mirrorRotationOffsetYleft = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetYleft"), 0);
	self.mirrorRotationOffsetXright = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetXright"), 0);
    self.mirrorRotationOffsetYright = Utils.getNoNil(getXMLFloat(xmlFile, key.."#mirrorRotationOffsetYright"), 0);
	
	self.camPositionX = Utils.getNoNil(getXMLFloat(xmlFile, key.."#camPositionX"), 0);
	self.camPositionZ = Utils.getNoNil(getXMLFloat(xmlFile, key.."#camPositionZ"), 0);
end;

function JD8400:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'mirrorRotationOffsetXleft="'..self.mirrorRotationOffsetXleft..'" mirrorRotationOffsetYleft="'..self.mirrorRotationOffsetYleft..'" mirrorRotationOffsetXright="'..self.mirrorRotationOffsetXright..'" mirrorRotationOffsetYright="'..self.mirrorRotationOffsetYright..'" camPositionX="'..self.camPositionX..'" camPositionZ="'..self.camPositionZ..'"';
    return attributes, nil;
end;

function JD8400:onLeave()
end;

function JD8400:draw()
	g_currentMission:addExtraPrintText(string.format("Key Enter: HUD ON/OFF"));
	g_currentMission:addExtraPrintText(string.format("Key %s: Start/Stop engine", "KP , + s"));
	if self.HUDOverlay ~= nil then
		if self.HUDActive then
			self.HUDOverlay:render();
			setTextBold(true);

			setTextColor(1, 1, 1, 1.0);
			if self.shiftMode == 1 then
				renderText(0.01, 0.08, 0.020, string.format("Move camera mode[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.SHIFT)));
				renderText(0.01, 0.06, 0.020, string.format("left[%s], right[%s], fwd[%s], back[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMBACK)));
				renderText(0.01, 0.04, 0.020, string.format("Reset[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMRESET)));
			elseif self.shiftMode == 2 then
				renderText(0.01, 0.08, 0.020, string.format("Adjust left mirror mode[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.SHIFT)));
				renderText(0.01, 0.06, 0.020, string.format("left[%s], right[%s], down[%s], up[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMBACK)));
			elseif self.shiftMode == 3 then
				renderText(0.01, 0.08, 0.020, string.format("Adjust right mirror mode[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.SHIFT)));
				renderText(0.01, 0.06, 0.020, string.format("left[%s], right[%s], down[%s], up[%s], ",InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMLEFT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMRIGHT), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMFORWARD), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MOVECAMBACK)));
			end;
	
			if not self.mirrorsEnabled then
				renderText(0.01, 0.02, 0.020, string.format("Mirrors off[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATEMIRRORS)));
			else
				renderText(0.01, 0.02, 0.020, string.format("Mirrors on[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATEMIRRORS)));
			end;
		end;
	end;
end;
