--
-- Camera
-- Specialization for a reversible camera
--
-- @author  Templaer
-- @date  03/12/09
-- @version:	v1.1
-- @history:	v1.0 - 03/12/09: initial implementation by Templaer
--				v1.1 - 01/04/11: converted to LS2011 by Michael
--

Camera = {};

function Camera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Camera:load(xmlFile)
	self.isCameraNormal = true;
end;

function Camera:delete()
end;

function Camera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Camera:keyEvent(unicode, sym, modifier, isDown)
end;

function Camera:update(dt)
	if self.isEntered then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.CAMERA_ROTATE) then						
				if self.isCameraNormal then
					self.cameras[self.camIndex].rotX = self.cameras[self.camIndex].origRotX - 0.1;
					self.cameras[self.camIndex].rotY = 0;
				else
					self.cameras[self.camIndex].rotX = self.cameras[self.camIndex].origRotX;
					self.cameras[self.camIndex].rotY = self.cameras[self.camIndex].origRotY;
				end;
				self.isCameraNormal = not self.isCameraNormal;
			end;
			
			if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
				self.isCameraNormal = true;
			end;
		end;
	end;
end;

function Camera:draw()
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CameraRotate"), self.typeDesc), InputBinding.CAMERA_ROTATE);
end;