
movingHitch = {};

function movingHitch.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function movingHitch:load(xmlFile)

	self.moveableHitch = {};
	self.moveableHitch.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableHitch#index"));
	self.moveableHitch.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableHitch#maxY"), 0); 
	self.moveableHitch.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableHitch#minY"), 0); 
	
end;

function movingHitch:delete()
end;

function movingHitch:mouseEvent(posX, posY, isDown, isUp, button)
end;

function movingHitch:keyEvent(unicode, sym, modifier, isDown)

end;

function movingHitch:update(dt)

	if self.moveableHitch ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableHitch.index);
		local maxY = self.moveableHitch.max;
		local minY = self.moveableHitch.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.HITCH_UP) and InputBinding.isPressed(InputBinding.ACTIVATION) then
				if yAttacher < maxY then
					yAttacher = yAttacher + moveSpeed;
				else
					yAttacher = maxY;
				end;
			elseif InputBinding.isPressed(InputBinding.HITCH_DOWN) and InputBinding.isPressed(InputBinding.ACTIVATION) then
				if yAttacher > minY then
					yAttacher = yAttacher - moveSpeed;
				else
					yAttacher = minY;
				end;
			end;
		setTranslation(self.moveableHitch.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function movingHitch:onLeave()

end;

function movingHitch:draw()

end;

function movingHitch:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

