Setblends5Event = {};
Setblends5Event_mt = Class(Setblends5Event, Event);
InitEventClass(Setblends5Event, "Setblends5Event");
function Setblends5Event:emptyNew()
      local self = Event:new(Setblends5Event_mt);
      self.className="Setblends5Event";
      return self;
end;
function Setblends5Event:new(object, active)
      local self = Setblends5Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends5Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends5Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends5Event:run(connection)
      self.object:setblends5Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends5Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;