--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.77, 0.22, 0.02, "NP_0: Turn HUD On");
	 else
		renderText(0.77, 0.22, 0.02, "NP_0: Turn HUD Off");
		setTextColor(0, 1, 0, 1);
		setTextBold(true);
		renderText(0.72, 0.81, 0.025, "-- John Deere 8345R --");	
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		renderText(0.72, 0.78, 0.02, "NP_Enter: Engine On/Off");		
		renderText(0.72, 0.76, 0.02, "Home: Beacons On/Off");
		renderText(0.72, 0.74, 0.02, "Key 0: Horn");
		renderText(0.72, 0.72, 0.02, "NP_Period: Wheel Beacons In/Out");
		renderText(0.72, 0.70, 0.02, "NP_1: Left Turn Signal");
		renderText(0.72, 0.68, 0.02, "NP_2: Hazard Lights");
		renderText(0.72, 0.66, 0.02, "NP_3: Right Turn Signal");
		renderText(0.72, 0.64, 0.02, "NP_4: Front Fenders On/Off");
		renderText(0.72, 0.62, 0.02, "NP_5: Front Working Lights");
		renderText(0.72, 0.60, 0.02, "NP_6: Rear Working Lights");
		renderText(0.72, 0.58, 0.02, "NP_7: Front Duals On/Off");
		renderText(0.72, 0.56, 0.02, "NP_8: Rear Duals On/Off");
		renderText(0.72, 0.54, 0.02, "NP_9: Toggle Front Attachments");	
		renderText(0.72, 0.52, 0.02, "Pg_Up/Pg_Down: Throttle up/down");
		renderText(0.72, 0.50, 0.02, "insert: Attacher Up");
		renderText(0.72, 0.48, 0.02, "delete: Attacher Down");
		setTextColor(0, 1, 0, 1);
		setTextBold(true);
		renderText(0.72, 0.45, 0.015, "-- SndGrdn Edit V1 - PloughingSpec --");
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




