
moveAttacher = {};

function moveAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveAttacher:load(xmlFile)

	self.moveableAttacher = {};
	self.moveableAttacher.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacher#index"));
	self.moveableAttacher.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#maxY"), 0); 
	self.moveableAttacher.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#minY"), 0); 
	
end;

function moveAttacher:delete()
end;

function moveAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveAttacher:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttacher:update(dt)

	if self.moveableAttacher ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher.index);
		local maxY = self.moveableAttacher.max;
		local minY = self.moveableAttacher.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.ATTACHER_UP_8345R) then
				if yAttacher < maxY then
					yAttacher = yAttacher + moveSpeed;
				else
					yAttacher = maxY;
				end;
			elseif InputBinding.isPressed(InputBinding.ATTACHER_DOWN_8345R) then
				if yAttacher > minY then
					yAttacher = yAttacher - moveSpeed;
				else
					yAttacher = minY;
				end;
			end;
		setTranslation(self.moveableAttacher.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function moveAttacher:onLeave()

end;

function moveAttacher:draw()
    -- Draws HUD Text
	if g_currentMission.showHelpText then
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("RA_controls"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHER_UP_8345R) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHER_DOWN_8345R));
		--g_currentMission:addHelpButtonText("Rear Attacher Up/Down Keys: Ins/Del", InputBinding.ATTACHER_UP_8345R);
	end;
end;

function moveAttacher:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

