--
-- Show/Hide Front Fenders
-- 
--
-- @author SndGrdn
-- @date  11/07/2011
-- 1st .lua script for FS2011
-- 
-- Mega Thanks go out to Xentro...You are the man!
--

FrontFenders = {};

function FrontFenders.prerequisitesPresent(specializations)
	return true;
end;

function FrontFenders:load(xmlFile)
	self.setFFRloc = SpecializationUtil.callSpecializationsFunction("setFFRloc");
	self.FFRloc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FrontFenderRight#index"));
	self.FFLloc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FrontFenderLeft#index"));
	self.FFRlocActive = false;
	setVisibility(self.FFRloc, false);
	setVisibility(self.FFLloc, false);
end;

function FrontFenders:delete()
end;

function FrontFenders:keyEvent(unicode, sym, modifier, isDown)
end;

function FrontFenders:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FrontFenders:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setFFRloc(state,true);
end;
	
function FrontFenders:writeStream(streamId, connection)
	streamWriteBool(streamId, self.FLlocActive);
end;

function FrontFenders:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.JD8345R_ToggleFenders) then
				self:setFFRloc(not self.FFRlocActive); 
			end;
		end;
	end;	
end;

function FrontFenders:draw()
    -- Draws HUD Text
	if g_currentMission.showHelpText then
		g_currentMission:addHelpButtonText(g_i18n:getText("JD8345R_ToggleFenders"), InputBinding.JD8345R_ToggleFenders);
	end;
end;

function FrontFenders:onDetach()
	if self.FFRlocActive then
		self:setFFRloc(false); 
	end;
end;

function FrontFenders:setFFRloc(state,noEventSend)
	self.FFRlocActive = state;
	if self.FFRlocActive then
		setVisibility(self.FFRloc, true);
		setVisibility(self.FFLloc, true);
		-- do true stuff here
	else
		setVisibility(self.FFRloc, false);
		setVisibility(self.FFLloc, false);
		-- do false stuff here 
	end;
	setFFRlocEvent.sendEvent(self,state,noEventSend);
end;


-- Event --
setFFRlocEvent = {};
setFFRlocEvent_mt = Class(setFFRlocEvent, Event);
InitEventClass(setFFRlocEvent, "setFFRlocEvent");

function setFFRlocEvent:emptyNew()
    local self = Event:new(setFFRlocEvent_mt);
    self.className="setFFRlocEvent";
    return self;
end;

function setFFRlocEvent:new(object, state)
	local self = setFFRlocEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function setFFRlocEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setFFRlocEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function setFFRlocEvent:run(connection)
	self.object:setFFRloc(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setFFRlocEvent:new(self.object, self.state), nil, connection, self.object);
	end;	
end;

function setFFRlocEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setFFRlocEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setFFRlocEvent:new(vehicle, state));
		end;
	end;
end;