--unisound
--by ? / Blackdragon223 / Hummel


unisound = {};

function unisound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function unisound:load(xmlFile)

    self.pipeLight = nil
    if self.pipeLight ~= nil then
	  setVisibility(self.pipeLight, false);
    end;
	self.pipeLightActive = false;
	self.indoorCam = Utils.getNoNil(getXMLString(xmlFile, "vehicle.indoorCam#index"), 2);	
	self.controlled_sounds = {"motorSound", "motorSoundRun", "motorStartSound", "motorStopSound", "reverseDriveSound", "compressedAirSound", "compressionSound", "aiMotorSound", "aiThreshingSound", "pipeSound", "threshingStartSound", "threshingSound", "cutterthreshingSound", "threshingStopSound", "attachSound", "honkSound"}
end;		

function unisound:delete()
end;

function unisound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function unisound:keyEvent(unicode, sym, modifier, isDown)
end;

function unisound:update(dt)
	if self.isEntered then
		local indoor_sound = false;
		
		if self.camIndex * 1 ==  self.indoorCam * 1 then
			indoor_sound = true
		end
		
		if self.windows_open ~= nil then
		  for k,state in pairs(self.windows_open) do
		     if state == true then
				indoor_sound = false
			 end
		  end
		end
	
		if indoor_sound then
			for k,sound in pairs(self.controlled_sounds) do
				if self[sound] ~= nil then
				  local volume_name = sound .. "Volume"
				  if self[volume_name] ~= nil then
				    setSampleVolume(self[sound], self[volume_name]/2.5);
				  end
				end
			end
		else
			for k,sound in pairs(self.controlled_sounds) do
				if self[sound] ~= nil then					 
					local volume_name = sound .. "Volume"
					setSampleVolume(self[sound], self[volume_name]);
				end
			end			
		end;
	
		if self.pipeLight ~= nil then
			if self.pipeLightActive then
				setVisibility(self.pipeLight, self.pipeLightActive);
			else
				setVisibility(self.pipeLight, self.pipeLightActive);
			end;
		end;
		
		if self.numAttachedCutters == 0 then
			self.lepcsoMax = true;
		else
			self.lepcsoMax = false;
		end;
	end;	
end;

function unisound:draw()  
end;

function unisound:onEnter()

    self.lepcsoMax = true;

end;

function unisound:onLeave()

    if self.pipeLight ~= nil then
    	setVisibility(self.pipeLight, false);
    end;
	
end;