--
-- JD
-- Specialization class for Gears
--
-- @author  MySQly
-- @date  10/06/09
--
-- Copyright (C) MySQly, All Rights Reserved.

JD = {};

function JD.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD:load(xmlFile)
 local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;
	

  function JD_6820:mouseEvent(posX, posY, isDown, isUp, button)

end;


    end;

	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;
	end;
end;

function JD:onEnter()
	
end;

function JD:onLeave()

end;

