
    rotations = {};
    function rotations.prerequisitesPresent(specializations)
        return SpecializationUtil.hasSpecialization(Steerable, specializations);
    end;
    
function rotations:load(xmlFile)
		self.rotpart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart#index"));
        self.rotpart2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart2#index"));
		self.rotpart3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart3#index"));
		self.rotpart4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart4#index"));
		self.rotpart5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart5#index"));
		self.rotpart6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart6#index"));
		
		self.extraParticleSystems = {};
		local extraParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraParticleSystems#count"), 0);
			for i=1, extraParticleSystemCount do
				local namei = string.format("vehicle.extraParticleSystems.extraParticleSystem%d", i);
				Utils.loadParticleSystem(xmlFile, self.extraParticleSystems, namei, self.components, false, nil, self.baseDirectory)
			end;
		self.extraParticleSystemsexhaust = {};
		local extraParticleSystemexhaustCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraParticleSystemsexhaust#count"), 0);
			for i=1, extraParticleSystemCount do
				local namei = string.format("vehicle.extraParticleSystemsexhaust.extraParticleSystemexhaust%d", i);
				Utils.loadParticleSystem(xmlFile, self.extraParticleSystemsexhaust, namei, self.components, false, nil, self.baseDirectory)
			end;


		self.MaxReelSpeed = 0.003;
		self.MinReelSpeed = 0.0007;
		self.SpeedAddValue = 0.00005;
end;

   function rotations:delete()  
		Utils.deleteParticleSystem(self.extraParticleSystems);
		Utils.deleteParticleSystem(self.extraParticleSystemsexhaust);
		delete(self.grainwarningSoundId);
   end;
   

     
   function rotations:mouseEvent(posX, posY, isDown, isUp, button)
   end;
   
   function rotations:keyEvent(unicode, sym, modifier, isDown)
   end;
  
   function rotations:update(dt)
			 
			 
			if self.isMotorStarted then
				rotate(self.rotpart2, dt*0.01, 0, 0);
				Utils.setEmittingState(self.extraParticleSystemsexhaust, true)
			  else
				Utils.setEmittingState(self.extraParticleSystemsexhaust, false)
			end;	
						if self.isClient then
							if self.isThreshing then
								rotate(self.rotpart3, dt*0.01, 0, 0);
								rotate(self.rotpart, dt*0.01, 0, 0);
								rotate(self.rotpart4, dt*0, 0, 0.3);
								if self.movingDirection ~= 0 then
										Utils.setEmittingState(self.extraParticleSystems, true)
								else
										Utils.setEmittingState(self.extraParticleSystems, false)
								end;
							end;	
						end;
	end;

	
	
	

function rotations:updateTick(dt)
end;
  
function rotations:draw()
end;