--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;

function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.70, 0.30, 0.02, "Taste Numpad 0: Info Einschalten");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.70, 0.30, 0.02, "Taste Numpad 0: Info Abschalten");
		renderText(0.70, 0.79, 0.03, "- John Deere 1175 Hydro 4 Info -");
		renderText(0.70, 0.73, 0.02, "Taste NumEnter: Motor Start/Stop");
		renderText(0.70, 0.71, 0.02, "Pos1: RUL ein/aus");
		renderText(0.70, 0.69, 0.02, "Taste Num5: Arbeitslicht vorne an/aus");
		renderText(0.70, 0.67, 0.02, "Taste Num6: Arbeitslicht hinte an/aus");
		renderText(0.70, 0.65, 0.02, "Taste Num1: Blinker Links");
		renderText(0.70, 0.63, 0.02, "Taste Num2: Warnblinker");
		renderText(0.70, 0.61, 0.02, "Taste Num3: Blinker Rechts");
       
		renderText(0.70, 0.57, 0.02, "Taste X: Strohaecksler an/aus");
		renderText(0.70, 0.55, 0.02, "Taste J: Arbeitsmodus");
		renderText(0.70, 0.53, 0.02, "Taste 5: Sonnenblende hoch/runter klappen");
		renderText(0.70, 0.51, 0.02, "Taste 6: Korntank auf/zu");
		renderText(0.70, 0.49, 0.02, "Taste 7: Schneidwerkaufnahme heben");
		renderText(0.70, 0.47, 0.02, "Taste 8: Schneidwerkaufnahme senken");
		renderText(0.70, 0.45, 0.02, "Taste u: Korntank zuruecksetzen");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




