--- Script for Hectarcounter
--- Full MP Hitman
---@date 13/5/11


Hectar = {};


function Hectar.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Hectar:load(xmlFile)



	self.hecdX = 0.7543;
	self.hecdY = 0.1715;
	self.yOffset = 0.0077;
	self.hecdOverlay = Overlay:new("hudOHOverlay", Utils.getFilename("Textur/Hectar_today.png", self.baseDirectory), self.hecdX, self.hecdY, 0.11855, 0.039525);
	self.hectX = 0.7543;
	self.hectY = 0.1715;
	self.yOffset = 0.0077;
	self.hectOverlay = Overlay:new("hudOHOverlay", Utils.getFilename("Textur/Hectar_total.png", self.baseDirectory), self.hectX, self.hectY, 0.2371, 0.039525);		


	self.TreshedNumber = 0;
	self.TreshedTotalNumber = 0;
	
	local CounterReset  = getXMLString(xmlFile, "vehicle.counterReset#file");
	resetSoundFile = Utils.getFilename(CounterReset, self.baseDirectory);
    self.resetSoundId = createSample("reset");
    loadSample(self.resetSoundId, resetSoundFile, false);
    self.resetPlaying = false;	
end;

function Hectar:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
		local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
		self.TreshedTotalNumber = TreshedTotalNumber;
		return BaseMission.VEHICLE_LOAD_OK;
	end;
	
function Hectar:getSaveAttributesAndNodes(nodeIdent)
	local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
	local attributes = 'TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"';
	return attributes, nil;
end;
	

function Hectar:keyEvent(unicode, sym, modifier, isDown)
end;

function Hectar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hectar:readUpdateStream(streamId, connection)  
    self.TreshedNumber = streamReadFloat32(streamId);
	self.TreshedTotalNumber = streamReadFloat32(streamId);
end;

function Hectar:writeUpdateStream(streamId, connection)	
    streamWriteFloat32(streamId, self.TreshedNumber);
	streamWriteFloat32(streamId, self.TreshedTotalNumber);
end;


function Hectar:update(dt)	
		
		
	if self.isThreshing or self.isAIThreshing then
        local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
		 
    end;
	
	if self.isClient then
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.COUNTDEL) then
				playSample(self.resetSoundId, 1, 1, 0);
		        self.TreshedNumber = 0;				
	        end;
	end;
	
	end;
		
end;



function Hectar:draw()

g_currentMission:addExtraPrintText(string.format(g_i18n:getText("COUNTDEL"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.COUNTDEL));



self.hecdOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	renderText(self.hecdX+0.082, self.hecdY+self.yOffset, 0.022, string.format("%.1f", self.TreshedNumber));
self.hectOverlay:render();
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);	
	renderText(self.hectX+0.13, self.hectY+0.0085, 0.022, string.format("%.1f", self.TreshedTotalNumber));



	--setTextBold(true);
	--	renderText(0.835, 0.350, 0.021, string.format("Hektar"));
	--	renderText(0.835, 0.335, 0.021, string.format("am Tag"));
	--	renderText(0.835, 0.315, 0.021, string.format("%.1f", self.TreshedNumber));
	--	renderText(0.835, 0.285, 0.021, string.format("Hektar"));
	--	renderText(0.835, 0.270, 0.021, string.format("gesamt"));
	--	renderText(0.835, 0.250, 0.021, string.format("%.1f", self.TreshedTotalNumber));
   -- setTextBold(false);
end;

function Hectar:onEnter()
end;

function Hectar:onLeave()
end;

function Hectar:delete()
end;