--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.25, 0.02, "Numpad 0: Info");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.25, 0.02, "Key Numpad 0: Info");
		renderText(0.72, 0.86, 0.025, "- John Deere 8220 Full Info -");			
		renderText(0.72, 0.81, 0.02, "Key num 5: Front Work L. on/off");
		renderText(0.72, 0.79, 0.02, "Key num 6: Rear Work L. on/off");
		renderText(0.72, 0.77, 0.02, "Key num 1: Left turnlights");
		renderText(0.72, 0.75, 0.02, "Key num 2: Hazard lights");
		renderText(0.72, 0.73, 0.02, "Key num 3: Right turnlights");
		renderText(0.72, 0.71, 0.02, "Key T: Wheel Change 2 modes");
		renderText(0.72, 0.69, 0.02, "Key 5: Unfold signals-*weight*");
		renderText(0.72, 0.67, 0.02, "Key 6: Open door");
		renderText(0.72, 0.65, 0.02, "Key 7: Open rear window");
		renderText(0.72, 0.63, 0.02, "Key 8: Unfol dual light");
		renderText(0.72, 0.61, 0.02, "Key R: Beacon on/off");
		renderText(0.72, 0.59, 0.02, "Key num 8: Active front weight");
		renderText(0.72, 0.57, 0.02, "Key num 4: Active 4WD");
		renderText(0.72, 0.50, 0.025, "by Julian11-AGI");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




