--
-- Semoir_Nodet
-- Specialization for Semoir_Nodet
--
-- 	
-- 
--

Semoir_Nodet = {};

function Semoir_Nodet.prerequisitesPresent(specializations)
     return true;
end;

function Semoir_Nodet:load(xmlFile)
	self.setTraceurDroit = SpecializationUtil.callSpecializationsFunction("setTraceurDroit");		
	self.setTraceurGauche = SpecializationUtil.callSpecializationsFunction("setTraceurGauche");		

	self.TraceurDroitAnimation = getXMLString(xmlFile, "vehicle.TraceurDroit#animationName");
	self.TraceurGaucheAnimation = getXMLString(xmlFile, "vehicle.TraceurGauche#animationName");
	self.traceurDroit = false;
	self.traceurGauche = false;
	
end;

function Semoir_Nodet:delete()
end;

function Semoir_Nodet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Semoir_Nodet:keyEvent(unicode, sym, modifier, isDown)
end;
function Semoir_Nodet:readStream(streamId, connection)
   self:setTraceurDroit(streamReadBool(streamId), true);
   self:setTraceurGauche(streamReadBool(streamId), true);
end;

function Semoir_Nodet:writeStream(streamId, connection)
	streamWriteBool(streamId, self.traceurDroit);
	streamWriteBool(streamId, self.traceurGauche);
end;

function Semoir_Nodet:readUpdateStream(streamId, timestamp, connection)
end;

function Semoir_Nodet:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Semoir_Nodet:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TRACEUR_DROIT) then
			self:setTraceurDroit(not self.traceurDroit);
		end;	
		if InputBinding.hasEvent(InputBinding.TRACEUR_GAUCHE) then
			self:setTraceurGauche(not self.traceurGauche);
		end;
	end;
end;

function Semoir_Nodet:draw()
	if self.traceurDroit then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_DROIT_DOWN"), self.typeDesc), InputBinding.TRACEUR_DROIT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_DROIT_UP"), self.typeDesc), InputBinding.TRACEUR_DROIT);
	end;
	if self.traceurGauche then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_GAUCHE_DOWN"), self.typeDesc), InputBinding.TRACEUR_GAUCHE);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRACEUR_GAUCHE_UP"), self.typeDesc), InputBinding.TRACEUR_GAUCHE);
	end;
end;

function Semoir_Nodet:onDeactivate()
end;

function Semoir_Nodet:onDetach()
end;

function Semoir_Nodet:onAttach()
end;

function Semoir_Nodet:setTraceurDroit(traceurDroit,noEventSend)
	SetTraceurDroitEvent.sendEvent(self, traceurDroit, noEventSend);
	if not traceurDroit then
		if self.TraceurDroitAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurDroitAnimation, -1, nil, true);
			self.traceurDroit = false;
		end;
	else
		if self.TraceurDroitAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurDroitAnimation, 1, nil, true);
			self.traceurDroit = true;
		end;
	end;
end;

function Semoir_Nodet:setTraceurGauche(traceurGauche,noEventSend)
	SetTraceurGaucheEvent.sendEvent(self, traceurGauche, noEventSend);
	if not traceurGauche then
		if self.TraceurGaucheAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurGaucheAnimation, -1, nil, true);
			self.traceurGauche = false;
		end;
	else
		if self.TraceurGaucheAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TraceurGaucheAnimation, 1, nil, true);
			self.traceurGauche = true;
		end;
	end;
end;