--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);	
	if self.count ~= 0 then	
		for i=1, self.count do	
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);	
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
		
			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, g_i18n:getText("ic_button_on"), g_i18n:getText("ic_button_off"), Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)

	if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.beaconLightsActive;
		end;
	end;
	if self.event == "togglePipe" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.targetPipeState ~= 1;
		end;
	end;
	if self.event == "toggleThreshing" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.isThreshing;
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	
	if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			self.vehicle:setBeaconLightsVisibility(not self.vehicle.beaconLightsActive);
		end;
	end;
	if self.event == "togglePipe" then
		if self.vehicle ~= nil then
			if forceAction == nil then
				local nextState = self.vehicle.targetPipeState+1;
				if nextState > self.vehicle.numPipeStates then
					nextState = 1;
				end;
				self.vehicle:setPipeState(nextState, true);
			end;
		end;
	end;
	if self.event == "toggleThreshing" then
		if self.vehicle ~= nil then
			self.vehicle:setIsThreshing(not self.vehicle.isThreshing);
		end;	
	end;	
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;