-- MapDirtObjects
-- ModEventlistener for Steering of DirtObjects on Map
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  05/08/2011

MapDirtObjects = {};
MapDirtObjects.dirtObjects = {};
MapDirtObjects.saveDirtObjects = false;
MapDirtObjects.rainDeletingTime = 300000;--5min

-- sendObjects Wrapper
local Server_sendObjects_old = Server.sendObjects;
function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
	for _, dirtObject in pairs(MapDirtObjects.dirtObjects) do
		local filename = Utils.convertToNetworkFilename(dirtObject.filename);
		local tx, ty, tz = getWorldTranslation(dirtObject.id);
		local rx, ry, rz = getWorldRotation(dirtObject.id);
		connection:sendEvent(CreateNewDirtObjectEvent:new(filename, tx, ty, tz, rx, ry, rz, dirtObject.alphaValue));
	end;	
	Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;

function MapDirtObjects:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapDirtObjects_xml = dir .. "/mapDirtObjects.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapDirtObjects_xml);
		self.firstTimeRun = false;
	end;
	self.oldPlayerCount = 0;
end;

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapDirtObjects:saveDirtObjectsMap()
end;

function MapDirtObjects:deleteMap()
	for k, _ in pairs(self.dirtObjects) do
		self:deleteDirtObject(k);
	end;
end;

function MapDirtObjects:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapDirtObjects:keyEvent(unicode, sym, modifier, isDown)
end;	

function MapDirtObjects:update(dt)
	if g_server ~= nil then
		if self.firstTimeRun then
			self:loadDirtObjectsMap();			
			self.firstTimeRun = false;
		end;
		local playerCount = 0;
		for _,_ in pairs(g_currentMission.players) do
			playerCount = playerCount + 1;
		end;
		if playerCount ~= self.oldPlayerCount then
			self.oldPlayerCount = playerCount;
			--Do some Stuff to get Mp-synchron!
		end;
		for pos, object in pairs(self.dirtObjects) do
			if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
				self:lowerAlphaValueRain(pos, dt)
			end;
			if object.alphaValue < 0.2 then
				self:deleteDirtObject(pos)
				g_server:broadcastEvent(DeleteMapDirtObjectEvent:new(num), nil, nil, self);	
			end;
		end;
	end;
end;

function MapDirtObjects:draw()
end;

function MapDirtObjects:deleteDirtObject(num)
	if self.dirtObjects[num] ~= nil then
		delete(self.dirtObjects[num].id)
		table.remove(self.dirtObjects, num);
	end;
end;

function MapDirtObjects:loadDirtObjectsMap()
	local existDir = io.open (self.mapDirtObjects_xml, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.mapDirtObjects_xml);
		local saveDirtObjects = getXMLBool(xmlFile, "mapDirtObjects#saveDirtObjects");
		self.saveDirtObjects = saveDirtObjects;
		if self.saveDirtObjects and hasXMLProperty(xmlFile, "mapDirtObjects.dirtObject") then
			local i = 0;
			while true do
				local key = string.format("mapDirtObjects.dirtObject(%d)", i);
				local filename = getXMLString(xmlFile, key.."#filename");
				local rotation = Utils.getRadiansFromString(getXMLString(xmlFile, key.."#rotation"), 3);
				local translation = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#translation"), 3);
				local alphaValue = getXMLFloat(xmlFile, key.."#alphaValue");
				if (filename and rotation and translation and alphaValue) ~= nil then
					local tx, ty, tz = unpack(translation);
					local rx, ry, rz = unpack(rotation);
					self:createNewDirtObject(filename, tx, ty, tz, rx, ry, rz, alphaValue)
				else
					break;
				end;
				i = i + 1;
			end;
		end;
		delete(xmlFile);
	else
		print("Warning: ", self.mapDirtObjects_xml, " can not be found, Map Dirt Obejcts not loaded.");
	end;
end;

function MapDirtObjects:saveDirtObjectsMap()
	local existDir = io.open (self.mapDirtObjects_xml, "w");	
	if existDir == nil then
		createXMLFile("createDirtObjects", self.mapDirtObjects_xml, "saveDirtObjects");
	end;
	local xmlFile = io.open (self.mapDirtObjects_xml, "w");
	if xmlFile ~= nil then
		xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
		xmlFile:write('<mapDirtObjects saveDirtObjects="'..tostring(self.saveDirtObjects)..'">\n');
		if self.saveDirtObjects then
			for _,dirtObject in pairs(self.dirtObjects) do
				local tx, ty, tz = getWorldTranslation(dirtObject.id)
				local rx, ry, rz = getWorldRotation(dirtObject.id)
				local filename = Utils.convertToNetworkFilename(dirtObject.filename);
				xmlFile:write('    <dirtObject filename="'..filename..'" rotation="'..math.deg(rx)..' '..math.deg(ry)..' '..math.deg(rz)..'"  translation="'..tx..' '..ty..' '..tz..'"  alphaValue="'..dirtObject.alphaValue..'"/>\n');
			end;
		end;
		xmlFile:write("</mapDirtObjects>");
		xmlFile:close();
	end;
end;

function MapDirtObjects:setAlphaValue(num, newAlpha, allAlphas, noEventSend)
	if self.dirtObjects[num] ~= nil then
		SendAlphaValueEvent.sendEvent(num, newAlpha, allAlphas, noEventSend)
		if self.dirtObjects[num].alphaValue-0.1 > newAlpha or allAlphas then
			setShaderParameter(self.dirtObjects[num].id, "alpha", newAlpha,0,0,0,false);
		end;
		self.dirtObjects[num].alphaValue = newAlpha;
	end;
end;

function MapDirtObjects:lowerAlphaValueTick(num, deltaAlpha, noEventSend)
	if self.dirtObjects[num] ~= nil then
		local newAlpha = self.dirtObjects[num].alphaValue-deltaAlpha
		self:setAlphaValue(num, newAlpha, false, noEventSend);
	end;
end;

function MapDirtObjects:lowerAlphaValueRain(num, dt, noEventSend)
	if self.dirtObjects[num] ~= nil then
		local newAlpha = Utils.getMovedLimitedValues({self.dirtObjects[num].alphaValue}, {1}, {0}, 1, self.rainDeletingTime, dt, true);
		self:setAlphaValue(num, newAlpha[1], false, noEventSend);
	end;
end;

function MapDirtObjects:createNewDirtObject(filename, tx, ty, tz, rx, ry, rz, alpha)
	filename = Utils.convertFromNetworkFilename(filename);
	local dirtObject = {};
	dirtObject.filename = filename;
	local dirtObjectRoot = Utils.loadSharedI3DFile(filename, "");
	local dirtId = getChildAt(dirtObjectRoot, 0);
	setRigidBodyType(dirtId, "NoRigidBody");
	link(getRootNode(), dirtId);
	delete(dirtObjectRoot);
	dirtObject.id = dirtId;
	setTranslation(dirtId, tx, ty, tz);
	setRotation(dirtId, rx, ry, rz);	
	dirtObject.alphaValue = Utils.getNoNil(alpha, 1.0);
	setShaderParameter(dirtId, "alpha", alpha,0,0,0,false);
	table.insert(self.dirtObjects, dirtObject);
end;

function MapDirtObjects:gsSetMapDirtObjectsSave(state)
	if state == nil then 
		state = false; 
	end;
	if state then
		MapDirtObjects.saveDirtObjects = state;
	else
		MapDirtObjects.saveDirtObjects = state;
	end;
	return "gsSetMapDirtObjectsSave "..tostring(state);
end;
addConsoleCommand("gsSetMapDirtObjectsSave", "Changes the savestate of MapDirtObjects", "gsSetMapDirtObjectsSave", MapDirtObjects);
addModEventListener(MapDirtObjects);

-- CreateNewDirtObjectEvent
-- CreateNewDirtObjectEvent-Script
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  05/08/2011

CreateNewDirtObjectEvent = {};
CreateNewDirtObjectEvent_mt = Class(CreateNewDirtObjectEvent, Event);
InitEventClass(CreateNewDirtObjectEvent, "CreateNewDirtObjectEvent");

function  CreateNewDirtObjectEvent:emptyNew()
	local self = Event:new(CreateNewDirtObjectEvent_mt);
	self.className = "CreateNewDirtObjectEvent";
	return self;
end;

function CreateNewDirtObjectEvent:new(filename, tx, ty, tz, rx, ry, rz, alphaValue)
	local self = CreateNewDirtObjectEvent:emptyNew()
	self.filename = filename;
	self.tx = tx;
	self.ty = ty;
	self.tz = tz;
	self.rx = rx;
	self.ry = ry;
	self.rz = rz;
	self.alphaValue = alphaValue;
	return self;
end;
  
function CreateNewDirtObjectEvent:readStream(streamId, connection)
	self.filename = streamReadString(streamId);
	self.tx = streamReadFloat32(streamId);
	self.ty = streamReadFloat32(streamId);
	self.tz = streamReadFloat32(streamId);
	self.rx = streamReadFloat32(streamId);
	self.ry = streamReadFloat32(streamId);
	self.rz = streamReadFloat32(streamId);
	self.alphaValue = streamReadFloat32(streamId);
	self:run(connection);
end;

function CreateNewDirtObjectEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.filename);
	streamWriteFloat32(streamId, self.tx);
	streamWriteFloat32(streamId, self.ty);
	streamWriteFloat32(streamId, self.tz);
	streamWriteFloat32(streamId, self.rx);
	streamWriteFloat32(streamId, self.ry);
	streamWriteFloat32(streamId, self.rz);
	streamWriteFloat32(streamId, self.alphaValue);
end;

function CreateNewDirtObjectEvent:run(connection)
	MapDirtObjects:createNewDirtObject(self.filename, self.tx, self.ty, self.tz, self.rx, self.ry, self.rz, self.alphaValue)
end;

-- DeleteMapDirtObjectEvent
-- DeleteMapDirtObjectEvent-Script
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  05/08/2011

DeleteMapDirtObjectEvent = {};
DeleteMapDirtObjectEvent_mt = Class(DeleteMapDirtObjectEvent, Event);

InitEventClass(DeleteMapDirtObjectEvent, "DeleteMapDirtObjectEvent");

function  DeleteMapDirtObjectEvent:emptyNew()
	local self = Event:new(DeleteMapDirtObjectEvent_mt);
	self.className="DeleteMapDirtObjectEvent";
	return self;
end;

function DeleteMapDirtObjectEvent:new(num)
	local self = DeleteMapDirtObjectEvent:emptyNew()
	self.num = num;
	return self;
end;
  
function DeleteMapDirtObjectEvent:readStream(streamId, connection)
	self.num = streamReadInt32(streamId);
	self:run(connection);
end;

function DeleteMapDirtObjectEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.num);
end;

function DeleteMapDirtObjectEvent:run(connection)
	MapDirtObjects:deleteDirtObject(self.num)
end;

-- SendAlphaValueEvent
-- SendAlphaValueEvent-Script
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  05/08/2011

SendAlphaValueEvent = {};
SendAlphaValueEvent_mt = Class(SendAlphaValueEvent, Event);

InitEventClass(SendAlphaValueEvent, "SendAlphaValueEvent");

function SendAlphaValueEvent:emptyNew()
	local self = Event:new(SendAlphaValueEvent_mt);
	self.className="SendAlphaValueEvent";
	return self;
end;

function SendAlphaValueEvent:new(num, alphaValue, allAlphas)
	local self = SendAlphaValueEvent:emptyNew()
	self.num = num;
	self.alphaValue = alphaValue;
	self.allAlphas = allAlphas;
	return self;
end;

function SendAlphaValueEvent:readStream(streamId, connection)
	self.num = streamReadInt32(streamId);
	self.alphaValue = streamReadFloat32(streamId);
	self.allAlphas = streamReadBool(streamId);
	self:run(connection);
end;

function SendAlphaValueEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.num);
	streamWriteFloat32(streamId, self.alphaValue);
	streamWriteBool(streamId, self.allAlphas);
end;

function SendAlphaValueEvent:run(connection)
	MapDirtObjects:setAlphaValue(self.num, self.alphaValue, self.allAlphas, true)
end;

function SendAlphaValueEvent.sendEvent(num, alphaValue, allAlphas, noEventSend)
	if MapDirtObjects.dirtObjects[num] ~= nil then
		if alphaValue ~= MapDirtObjects.dirtObjects[num].alphaValue then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SendAlphaValueEvent:new(num, alphaValue, allAlphas), nil, nil, MapDirtObjects);
				else
					g_client:getServerConnection():sendEvent(SendAlphaValueEvent:new(num, alphaValue, allAlphas));
				end;
			end;
		end;
	end;
end;