-- WheelDirtSpecialization
-- Specialisation for the John Deere Front Roll
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  21/11/2010

JohnDeereFrontRoll = {};

Vehicle.registerJointType("jd_fastCoupler");

function JohnDeereFrontRoll.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JohnDeereFrontRoll:load(xmlFile)
	self.liftZylinder = {};
	self.liftZylinder.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftZylinder#index"));
	self.liftZylinder.nodeBackUpRot = {getRotation(self.liftZylinder.node)};
	self.liftZylinder.nodeBackUpTrans = {getTranslation(self.liftZylinder.node)};
	self.liftZylinder.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftZylinder#punch"));
	self.liftZylinder.punchBackUpRot = {getRotation(self.liftZylinder.punch)};
	self.liftZylinder.punchBackUpTrans = {getTranslation(self.liftZylinder.punch)};
	self.liftZylinder.punchFixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftZylinder#punchFixpoint"));
	self.liftZylinder.directionVector = {Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.liftZylinder#directionVector"))};
	local ax, ay, az = getWorldTranslation(self.liftZylinder.punch);
	local bx, by, bz = getWorldTranslation(self.liftZylinder.punchFixpoint);		
	self.liftZylinder.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.hydraulicUpdateTime = 30;
end;

function JohnDeereFrontRoll:delete()
end;

function JohnDeereFrontRoll:readStream(streamId, connection)
end;

function JohnDeereFrontRoll:writeStream(streamId, connection)	
end;

function JohnDeereFrontRoll:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeereFrontRoll:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeereFrontRoll:update(dt)
	if self:getIsActive() then
		self.hydraulicUpdateTime = 30;
	end;
end;

function JohnDeereFrontRoll:updateTick(dt)
	if self.hydraulicUpdateTime >= 0 then
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.jdLiftZylinderNode ~= nil then
				local ax, ay, az = getWorldTranslation(self.liftZylinder.node);
				local bx, by, bz = getWorldTranslation(self.attacherVehicle.jdLiftZylinderNode);
				local x, y, z = worldDirectionToLocal(getParent(self.liftZylinder.node), bx-ax, by-ay, bz-az);
				setDirection(self.liftZylinder.node, x, y, z, unpack(self.liftZylinder.directionVector));
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.liftZylinder.punch, 0, 0, distance-self.liftZylinder.punchDistance);
			end;
		end;
	end;
end;

function JohnDeereFrontRoll:draw()
end;

function JohnDeereFrontRoll:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function JohnDeereFrontRoll:getSaveAttributesAndNodes(nodeIdent)
end;

function JohnDeereFrontRoll:onAttach()
end;

function JohnDeereFrontRoll:onDetach()
	setTranslation(self.liftZylinder.node, unpack(self.liftZylinder.nodeBackUpTrans));
	setTranslation(self.liftZylinder.punch, unpack(self.liftZylinder.punchBackUpTrans));
	setRotation(self.liftZylinder.node, unpack(self.liftZylinder.nodeBackUpRot));
	setRotation(self.liftZylinder.punch, unpack(self.liftZylinder.punchBackUpRot));
end;