-- JohnDeereFastWeightCoupler
-- Specialisation for the John Deere Fast Coupler
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  21/11/2010

JohnDeereFastWeightCoupler = {};

function JohnDeereFastWeightCoupler.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JohnDeereFastWeightCoupler:load(xmlFile)
end;

function JohnDeereFastWeightCoupler:delete()
end;

function JohnDeereFastWeightCoupler:readStream(streamId, connection)
end;

function JohnDeereFastWeightCoupler:writeStream(streamId, connection)	
end;

function JohnDeereFastWeightCoupler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeereFastWeightCoupler:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeereFastWeightCoupler:update(dt)
end;

function JohnDeereFastWeightCoupler:updateTick(dt)
end;

function JohnDeereFastWeightCoupler:draw()
end;

function JohnDeereFastWeightCoupler:attachImplement(implement)		
	local currentMass = getMass(implement.object.components[1].node);
	setMass(implement.object.components[1].node, currentMass/10)
	print("attach: "..currentMass)
end;

function JohnDeereFastWeightCoupler:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local currentMass = getMass(implement.object.components[1].node);
	setMass(implement.object.components[1].node, currentMass*10)
	print("detach: "..currentMass)
end;
