-- JohnDeereFastCoupler
-- Specialisation for the John Deere Fast Coupler
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  21/11/2010

JohnDeereFastCoupler = {};

function JohnDeereFastCoupler.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JohnDeereFastCoupler:load(xmlFile)
	self.jdLiftZylinderNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.jdLiftZylinderNode#index"));
	
	local x,y,z = getCenterOfMass(self.components[1].node);
	self.centerOfMassDetachedCollision = {x,y,z};
end;

function JohnDeereFastCoupler:delete()
end;

function JohnDeereFastCoupler:readStream(streamId, connection)
end;

function JohnDeereFastCoupler:writeStream(streamId, connection)	
end;

function JohnDeereFastCoupler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeereFastCoupler:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeereFastCoupler:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:handleLowerImplementEvent()
		end;
	end;
end;

function JohnDeereFastCoupler:updateTick(dt)
end;

function JohnDeereFastCoupler:draw()
    if self.selectedImplement ~= 0 then
        local implement = self.attachedImplements[self.selectedImplement];
        if implement.object.allowsLowering then
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            if jointDesc.moveDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_OBJECT"), implement.object.typeDesc), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower_OBJECT"), implement.object.typeDesc), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;
end;

function JohnDeereFastCoupler:onAttach(attacherVehicle)
	local x,y,z = getCenterOfMass(attacherVehicle.rootNode);
	if x ~= nil then
		x,y,z = localToWorld(attacherVehicle.rootNode, x,y,z);
		x,y,z = worldToLocal(self.components[1].node, x,y,z);
		setCenterOfMass(self.components[1].node, x,y,z);
	end;
end;

function JohnDeereFastCoupler:onDetach()
	setCenterOfMass(self.components[1].node, unpack(self.centerOfMassDetachedCollision));
end;