-- JohnDeere3650
-- Specialisation for the John Deere 3650
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  21/11/2010

JohnDeere3650 = {};

function JohnDeere3650.initSpecialization()
	Vehicle.registerJointType("jd_frontCoupler");
	Vehicle.registerJointType("jd_weight");
	Vehicle.registerJointType("jd_fastCoupler");
end;

function JohnDeere3650.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JohnDeere3650:load(xmlFile)	
	self.getIsTurnedOnAttachedImplements = JohnDeere3650.getIsTurnedOnAttachedImplements;
	
	self.rearCoupling = {};
	self.rearCoupling.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearCoupling#index"));
	self.rearCoupling.normalAttacherJointY = getXMLFloat(xmlFile, "vehicle.rearCoupling#normalAttacherJointY");
	self.rearCoupling.lowAttacherJointY = getXMLFloat(xmlFile, "vehicle.rearCoupling#lowAttacherJointY");

	self.doorLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.doorLight#index"));
	self.doorIObject = nil;
	
	self.rearAttacherJoint = {};
	self.rearAttacherJoint.mainPullerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#mainPullerIndex"));
	self.rearAttacherJoint.orientNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#orientIndex"));
	
	self.frontAttacherJointCoordination = {};
	self.frontAttacherJointCoordination.activeJointNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAttacherJointCoordination#activeJointIndex"));
	self.frontAttacherJointCoordination.deactiveJointNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAttacherJointCoordination#deactiveJointIndex"));

	self.steerings = {};
	self.steerings.powerSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steerings#powerSteering"));
	self.steerings.powerSteeringMaxRot = Utils.getRadiansFromString(getXMLString(xmlFile, "vehicle.steerings#powerSteeringMaxRot"), 1);
	self.steerings.powerSteeringMinRot = Utils.getRadiansFromString(getXMLString(xmlFile, "vehicle.steerings#powerSteeringMinRot"), 1);
	self.steerings.powerSteeringMoveTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.steerings#powerSteeringMoveTime"), 1.0)*1000;
	self.steerings.rearHydraulicSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steerings#rearHydraulicSteering"));
	self.steerings.rearHydraulicSteeringMaxRot = Utils.getRadiansFromString(getXMLString(xmlFile, "vehicle.steerings#rearHydraulicSteeringMaxRot"), 1);
	self.steerings.rearHydraulicSteeringMinRot = Utils.getRadiansFromString(getXMLString(xmlFile, "vehicle.steerings#rearHydraulicSteeringMinRot"), 1);
	
	self.updateJoint = false;
end;

function JohnDeere3650:delete()
end;

function JohnDeere3650:getIsTurnedOnAttachedImplements()
	for _,v in pairs(self.attachedImplements) do
		if v.object.isTurnedOn ~= nil then
			if v.object.isTurnedOn == true then
				return true;
			end;
		end;
	end;
	return false
end;

function JohnDeere3650:readStream(streamId, connection)
end;

function JohnDeere3650:writeStream(streamId, connection)	
end;

function JohnDeere3650:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere3650:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeere3650:update(dt)
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
	if self.doorIObject == nil then
		for k,iObject in pairs(self.interactiveObjects) do
			if iObject.name == g_i18n:getText("leftDoor") then
				self.doorIObject = iObject;
			end;
		end;
	end;
end;

function JohnDeere3650:updateTick(dt)
	if self:getIsActive() then
		if self.steerings.rearHydraulicSteering ~= nil then
			local jointDesc = self.attacherJoints[1]
			local x, y, z = getRotation(self.steerings.rearHydraulicSteering);
			local rot = {x};
			local newRot = Utils.getMovedLimitedValues(rot, self.steerings.rearHydraulicSteeringMaxRot, self.steerings.rearHydraulicSteeringMinRot, 1, jointDesc.moveTime, dt, not jointDesc.moveDown);
			setRotation(self.steerings.rearHydraulicSteering, newRot[1], y, z);
		end;
		if self.steerings.powerSteering ~= nil then
			local x, y, z = getRotation(self.steerings.powerSteering);
			local rot = {x};
			local newRot = Utils.getMovedLimitedValues(rot, self.steerings.powerSteeringMaxRot, self.steerings.powerSteeringMinRot, 1, self.steerings.powerSteeringMoveTime, dt, not self:getIsTurnedOnAttachedImplements());
			setRotation(self.steerings.powerSteering, newRot[1], y, z);
		end;
		if self.rearAttacherJoint.mainPullerNode ~= nil and self.rearAttacherJoint.orientNode ~= nil then
			local x,_,_ = getRotation(self.rearAttacherJoint.orientNode)
			local _,y,z = getRotation(self.rearAttacherJoint.mainPullerNode)
			setRotation(self.rearAttacherJoint.mainPullerNode, x,y,z);
		end;
	end;
	if self.doorLight ~= nil and self.doorIObject ~= nil then
		setVisibility(self.doorLight, self.doorIObject.isOpen);
	end;
end;

function JohnDeere3650:draw()
end;

function JohnDeere3650:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function JohnDeere3650:getSaveAttributesAndNodes(nodeIdent)
end;

function JohnDeere3650:attachImplement(implement)	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility(self.rearCoupling.node, false);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER or jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
			local x,y,z = getTranslation(self.rearCoupling.node);
			setTranslation(self.rearCoupling.node, x, self.rearCoupling.normalAttacherJointY, z);
		elseif jointIndex == 5 then
			local x,y,z = getTranslation(self.rearCoupling.node);
			setTranslation(self.rearCoupling.node, x, self.rearCoupling.lowAttacherJointY, z);
		elseif jointIndex == 6 then
			self.attacherJoints[2].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
			self.attacherJoints[3].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
		end;
	elseif jointType == Vehicle.JOINTTYPE_JD_FRONTCOUPLER then
		if jointIndex == 2 then
			self.attacherJoints[3].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
			self.attacherJoints[6].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
		end;
	elseif jointType == Vehicle.JOINTTYPE_JD_WEIGHT then
		if jointIndex == 3 then
			self.attacherJoints[2].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
			self.attacherJoints[6].jointTransform = self.frontAttacherJointCoordination.deactiveJointNode;
		end;
	end;
	self.updateJoint = true;
end;

function JohnDeere3650:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if jointIndex == 1 then
		setVisibility(self.rearCoupling.node, true);
	elseif jointIndex == 2 or jointIndex == 3 or jointIndex == 6 then
		self.attacherJoints[2].jointTransform = self.frontAttacherJointCoordination.activeJointNode;
		self.attacherJoints[3].jointTransform = self.frontAttacherJointCoordination.activeJointNode;
		self.attacherJoints[6].jointTransform = self.frontAttacherJointCoordination.activeJointNode;
	end;
end;

function JohnDeere3650:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;