--
-- Specialization for autosteer
-- 
-- version 1 and 2 by Henly20 (Ls_uk Modteam)
-- @author:		Xentro (www.ls-uk.info)
-- @version:	v3.0
-- @date:		2012-03-18
--
--
autosteer = {};

function autosteer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function autosteer:load(xmlFile)
	self.setAutoSteer = SpecializationUtil.callSpecializationsFunction("setAutoSteer");
	
	self.oldAutoRotateBackSpeed = self.autoRotateBackSpeed;
	self.oldMaxRotatedTimeSpeed = self.maxRotatedTimeSpeed;
	self.haveAutoSteer = true;
	
	self.steer = {};
	self.steer.invertAxis = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.autoSteer#invertAxis"), false);
	self.steer.speed = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.autoSteer#steeringSpeed"), 1000);
	
	local input = getXMLString(xmlFile,"vehicle.autoSteer#inputBinding");
	if InputBinding[input] ~= nil then self.steer.input = input; end;
	
	local activated = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.autoSteer#activated"), false);
	if activated then
		self.steeringLocked = false;
	else
		self.steeringLocked = true;
	end;
	if self.steeringLocked then
		self.autoRotateBackSpeed = 0;
		self.maxRotatedTimeSpeed = 0;
	end;
	
	local autoSteerImage = getXMLString(xmlFile,"vehicle.autoSteerHud#released");
	local autoSteerLockImage = getXMLString(xmlFile,"vehicle.autoSteerHud#locked");
	if autoSteerImage ~= nil and autoSteerLockImage ~= nil then
		self.autoSteerHudX = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.autoSteerHud#posX"), 0.93);
		self.autoSteerHudY = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.autoSteerHud#posY"), 0.8);
		self.autoSteerHudWidth = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.autoSteerHud#width"), 0.065);
		self.autoSteerHudHeight = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.autoSteerHud#height"), 0.095);
		self.autoSteerReleasedOverlay = Overlay:new("autoSteerImageOverlay", Utils.getFilename(autoSteerImage, self.baseDirectory), self.autoSteerHudX, self.autoSteerHudY, self.autoSteerHudWidth, self.autoSteerHudHeight);
		self.autoSteerLockOverlay = Overlay:new("autoSteerLockImageOverlay", Utils.getFilename(autoSteerLockImage, self.baseDirectory), self.autoSteerHudX, self.autoSteerHudY, self.autoSteerHudWidth, self.autoSteerHudHeight);
		self.showAutoSteerHud = true;
	end;
end;

function autosteer:delete()
	if self.autoSteerReleasedOverlay ~= nil and self.autoSteerLockOverlay ~= nil then
		self.autoSteerReleasedOverlay:delete();
		self.autoSteerLockOverlay:delete();
	end;
end;

function autosteer:readStream(streamId, connection)
    self:setAutoSteer(streamReadBool(streamId), true);
end;

function autosteer:writeStream(streamId, connection)
    streamWriteBool(streamId, self.steeringLocked);
end;

function autosteer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function autosteer:keyEvent(unicode, sym, modifier, isDown)
end;

function autosteer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local steeringLocked = Utils.getNoNil(getXMLBool(xmlFile, key.."#steeringLocked"), true);
		self:setAutoSteer(steeringLocked);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function autosteer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'steeringLocked="'..tostring(self.steeringLocked)..'"';
	return attributes, nil;
end;

function autosteer:update(dt)
	if self:getIsActive() then
		if self.steer.input ~= nil then
			if self:getIsActiveForInput() and self.isClient then
				if InputBinding.hasEvent(InputBinding[self.steer.input]) then
					self:setAutoSteer(not self.steeringLocked);
				end;
			end;
		end;
	end;
end;

function autosteer:updateTick(dt)
end;

function autosteer:draw()
	if self.isClient then
		if self.autoSteerReleasedOverlay ~= nil and self.autoSteerLockOverlay ~= nil then
			if self.showAutoSteerHud then
				if not self.steeringLocked then
					self.autoSteerLockOverlay:render();
				else
					self.autoSteerReleasedOverlay:render();
				end;
			end;
		end;  
	end;  
end;

function autosteer:setAutoSteer(lockedsteer, noEventSend)
	if lockedsteer ~= nil then
		SetAutoSteerEvent.sendEvent(self, lockedsteer, noEventSend)
		self.steeringLocked = lockedsteer;
		
		if not lockedsteer then
			self.autoRotateBackSpeed = 0;
			self.maxRotatedTimeSpeed = 0;
		else
			self.autoRotateBackSpeed = self.oldAutoRotateBackSpeed;
			self.maxRotatedTimeSpeed = self.oldMaxRotatedTimeSpeed;
		end;
	end;
end;

-- Event --
SetAutoSteerEvent = {};
SetAutoSteerEvent_mt = Class(SetAutoSteerEvent, Event);
  
InitEventClass(SetAutoSteerEvent, "SetAutoSteerEvent");
  
function SetAutoSteerEvent:emptyNew()
	local self = Event:new(SetAutoSteerEvent_mt);
	self.className="SetAutoSteerEvent";
	return self;
end;
  
function SetAutoSteerEvent:new(object, lockedsteer)
	local self = SetAutoSteerEvent:emptyNew()
	self.object = object;
	self.lockedsteer = lockedsteer;
	return self;
end;
  
function SetAutoSteerEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.lockedsteer = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;
  
function SetAutoSteerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.lockedsteer);
end;
  
function SetAutoSteerEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	self.object:setAutoSteer(self.lockedsteer, true);
end;
  
function SetAutoSteerEvent.sendEvent(vehicle, lockedsteer, noEventSend)
	if lockedsteer ~= vehicle.steeringLocked then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetAutoSteerEvent:new(vehicle, lockedsteer), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetAutoSteerEvent:new(vehicle, lockedsteer));
			end;
		end;
	end;
end;