Spiegel = {};

function Spiegel.prerequisitesPresent(specializations)
    return true;
end;
function Spiegel:load(xmlFile)

	self.setblends1aVisibility = SpecializationUtil.callSpecializationsFunction("setblends1aVisibility");
	self.setblends2aVisibility = SpecializationUtil.callSpecializationsFunction("setblends2aVisibility");

    self.blends1a = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends1a.blend1a(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
             break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends1a, {node=node});
        end;
        i = i + 1;
        end;
    self.blends1aActive = false;

    self.blends2a = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends2a.blend2a(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
            break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends2a, {node=node});
        end;
        i = i + 1;
    end;
	self.blends2aActive = false;
end;
function Spiegel:delete()
end;
function Spiegel:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1aVisibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends2aVisibility(visibility, true);
end;

function Spiegel:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1aActive);
	streamWriteBool(streamId, self.blends2aActive);
end;
function Spiegel:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Spiegel:keyEvent(unicode, sym, modifier, isDown)
end;
function Spiegel:update(dt)

    if self:getIsActiveForInput() and self.isClient then
        if InputBinding.hasEvent(InputBinding.Spiegelglas) then
              self:setblends1aVisibility(not self.blends1aActive);
        end;
	end;
end;
function Spiegel:onLeave()
end;
function Spiegel:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Spiegelglas"),  InputBinding.Spiegelglas);

end;
function Spiegel:setblends1aVisibility(visibility, noEventSend)
    if visibility ~= self.blends1aActive then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends1aEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends1aEvent:new(self, visibility));
            end;
        end;

        self.blends1aActive = visibility;

        for _, blend1a in pairs(self.blends1a) do
            setVisibility(blend1a.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend1aVisibility ~= nil then
                v.setblend1aVisibility(self, visibility);
            end;
        end;
    end;
end;
function Spiegel:setblends2aVisibility(visibility, noEventSend)
    if visibility ~= self.blends2aActive then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends2aEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends2aEvent:new(self, visibility));
            end;
        end;

        self.blends2aActive = visibility;

        for _, blend2a in pairs(self.blends2a) do
            setVisibility(blend2a.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend2aVisibility ~= nil then
                v.setblend2aVisibility(self, visibility);
            end;
        end;
    end;
end;