--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		setTextColor(00,33,00,1);
		renderText(0.64, 0.96, 0.015, "|  JD 7930 AutoQuad Plus v1  |");
		setTextColor(00,66,00,1);
		renderText(0.64, 0.95, 0.01, "Show Menu - Press Numpad 0  ");
	 else
		setTextColor(00,33,00,1);
		renderText(0.64, 0.96, 0.015, "|  JD 7930 AutoQuad Plus v1  |");
		setTextColor(99,00,00,1);
		renderText(0.64, 0.95, 0.01, "Hide Menu - Press Numpad 0  ");	
		setTextColor(99,99,99,1);
		renderText(0.82, 0.54, 0.0125, "Pos1            :  Rundumleuchte");
		renderText(0.82, 0.52, 0.0125, "Taste 0        :  Hupe");
		renderText(0.82, 0.50, 0.0125, "Numpad 1     :  Blinker Links");
		renderText(0.82, 0.48, 0.0125, "Numpad 2     :  Warnblinker");			
		renderText(0.82, 0.46, 0.0125, "Numpad 3     :  Blinker Rechts");
		renderText(0.82, 0.44, 0.0125, "Numpad 4     :  Arbeitslicht Vorne");
		renderText(0.82, 0.42, 0.0125, "Numpad 5     :  Arbeitslicht Hinten");
		renderText(0.82, 0.40, 0.0125, "Numpad 6     :  Spiegel");
		renderText(0.82, 0.38, 0.0125, "Numpad 7     :  Zwillingsreifen");
		renderText(0.82, 0.36, 0.0125, "Numpad 8     :  Bullfang");
		renderText(0.82, 0.34, 0.0125, "Numpad -     :  ESLimiter -");
		renderText(0.82, 0.32, 0.0125, "Numpad +     :  ESLimiter +");
		renderText(0.82, 0.30, 0.0125, "Numpad Enter :  Motor Starten");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




