Bull = {};

function Bull.prerequisitesPresent(specializations)
    return true;
end;
function Bull:load(xmlFile)

	self.setblends1bVisibility = SpecializationUtil.callSpecializationsFunction("setblends1bVisibility");
	self.setblends2bVisibility = SpecializationUtil.callSpecializationsFunction("setblends2bVisibility");

    self.blends1b = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends1b.blend1b(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
             break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends1b, {node=node});
        end;
        i = i + 1;
        end;
    self.blends1bActive = false;

    self.blends2b = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.blends2b.blend2b(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
            break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.blends2b, {node=node});
        end;
        i = i + 1;
    end;
	self.blends2bActive = false;
end;
function Bull:delete()
end;
function Bull:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1bVisibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends2bVisibility(visibility, true);
end;

function Bull:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1bActive);
	streamWriteBool(streamId, self.blends2bActive);
end;
function Bull:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Bull:keyEvent(unicode, sym, modifier, isDown)
end;
function Bull:update(dt)

    if self:getIsActiveForInput() and self.isClient then
        if InputBinding.hasEvent(InputBinding.Bullfang) then
              self:setblends1bVisibility(not self.blends1bActive);
        end;
	end;
end;
function Bull:onLeave()
end;
function Bull:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Bullfang"),  InputBinding.Bullfang);

end;
function Bull:setblends1bVisibility(visibility, noEventSend)
    if visibility ~= self.blends1bActive then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends1bEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends1bEvent:new(self, visibility));
            end;
        end;

        self.blends1bActive = visibility;

        for _, blend1b in pairs(self.blends1b) do
            setVisibility(blend1b.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend1bVisibility ~= nil then
                v.setblend1bVisibility(self, visibility);
            end;
        end;
    end;
end;
function Bull:setblends2bVisibility(visibility, noEventSend)
    if visibility ~= self.blends2bActive then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends2bEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends2bEvent:new(self, visibility));
            end;
        end;

        self.blends2bActive = visibility;

        for _, blend2b in pairs(self.blends2b) do
            setVisibility(blend2b.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend2bVisibility ~= nil then
                v.setblend2bVisibility(self, visibility);
            end;
        end;
    end;
end;