--
-- Customizations for JD9030h
-- uses parts of other scripts in own combination
-- thanks Templaer, Headshot XXL
-- 
-- main scripting: BoneCrusherXes 
-- additional scripting: Assassin
--
-- > Copyright (C) BoneCrusherXes & Assassin  14.06.09  ---


JD9030h = {}

function JD9030h.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD9030h:load(xmlFile)
	

      self.exhaustParticleSystems = {};
      local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.exhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
      	local namei = string.format("vehicle.exhaustParticleSystems.exhaustParticleSystem%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
      	Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems, namei, nodei, false, nil, self.baseDirectory);
	end;	

	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
	local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;
	local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;

	local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation5#index"));
        self.rotation5 = {};
          self.rotation5.node = rotationNode5;

	local rotationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation6#index"));
        self.rotation6 = {};
          self.rotation6.node = rotationNode6;	

	local rotationNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation7#index"));
        self.rotation7 = {};
          self.rotation7.node = rotationNode7;	

	local rotationNode8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation8#index"));
        self.rotation8 = {};
          self.rotation8.node = rotationNode8;

	local rotationNode9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation9#index"));
        self.rotation9 = {};
          self.rotation9.node = rotationNode9;

	local rotationNode10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation10#index"));
        self.rotation10 = {};
          self.rotation10.node = rotationNode10;

	local rotationNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation11#index"));
        self.rotation11 = {};
          self.rotation11.node = rotationNode11;

	local rotationNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation12#index"));
        self.rotation12 = {};
          self.rotation12.node = rotationNode12;

	local rotationNode13 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation13#index"));
        self.bottomArm2 = {};
          self.bottomArm2.node = rotationNode13;

	local BottomArmNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
        self.bottomArm = {};
          self.bottomArm.node = BottomArmNode;

      local translationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation1#index"));
      if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
        self.translation1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#touchTransLimit"), 10);
    end; 


    hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("JD9030_horn");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;

    steerHydSoundFile = Utils.getFilename("JD9030_steerHyd.wav", self.baseDirectory);
    self.steerHydSoundId = createSample("JD9030_steerSound");
    loadSample(self.steerHydSoundId, steerHydSoundFile, false);
    self.steerHydPlaying = false;

	local needleTempNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.needleTemp#index"));
     if needleTempNode ~= nil then
        self.needleTemp = {};
        self.needleTemp.node = needleTempNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needleTemp#minRot"));
        self.needleTemp.minRot = {};
        self.needleTemp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.needleTemp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.needleTemp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needleTemp#maxRot"));
        self.needleTemp.maxRot = {};
        self.needleTemp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.needleTemp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.needleTemp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.needleTemp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needleTemp#rotTime"), 2)*3000;
        self.needleTemp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.needleTemp#touchRotLimit"), 10));
    end;

	self.needleRPM = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.needleRPM#index"));
	self.needleSpeed = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.needleSpeed#index"));
	self.needleGas = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.needleGas#index"));
	self.needleBattery = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.needleBattery#index"));

	tempRot1 = 0;
	tempRot = 0;
	tempCount = 0;

	--worklight
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.worklights.worklight%d", i);
        self.worklights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;
	self.worklightsActive = false;


	numLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lights#count"), 0);
	self.lights = {};
    for i=1, numLights do
        local lightnamei = string.format("vehicle.lights.light%d", i);
        self.lights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#index"));
        setVisibility(self.lights[i], false);
    end;
	self.lightsActive = false;
	self.backLight = true;

	
	
	numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = false;
	
	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = false;
	
	numparts3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts3#count"), 0);
	self.parts3 = {};
    for i=1, numparts3 do
        local partnamei = string.format("vehicle.parts3.part%d", i);
        self.parts3[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts3[i], false);
    end;
	self.parts3Active = false;
	
	numparts4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts4#count"), 0);
	self.parts4 = {};
    for i=1, numparts4 do
        local partnamei = string.format("vehicle.parts4.part%d", i);
        self.parts4[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts4[i], false);
    end;
	self.parts4Active = true;
	
	numparts5 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts5#count"), 0);
	self.parts5 = {};
    for i=1, numparts5 do
        local partnamei = string.format("vehicle.parts5.part%d", i);
        self.parts5[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts5[i], false);
    end;
	self.parts5Active = true;
	
	numparts6 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts6#count"), 0);
	self.parts6 = {};
    for i=1, numparts6 do
        local partnamei = string.format("vehicle.parts6.part%d", i);
        self.parts6[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts6[i], false);
    end;
	self.parts6Active = true;
    
    self.controlpath = Utils.getFilename("hud.png", self.baseDirectory);
    self.hudhelpPoxX = 0.0154;
    self.hudhelpPoxY = 1-0.9;
    self.hudhelpWidth = 0.2;
    self.hudhelpHeight = 0.699;
    self.hudhelpOverlay = Overlay:new("hudhelpControl", self.controlpath, self.hudhelpPoxX, self.hudhelpPoxY, self.hudhelpWidth, self.hudhelpHeight);
    self.help = false;
    
    local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
		
	end;
	
	local munkahengerNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger#index"));
    if munkahengerNode ~= nil then
        self.munkahenger = {};
        self.munkahenger.node = munkahengerNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#minTrans"));
        self.munkahenger.minTrans = {};
        self.munkahenger.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#maxTrans"));
        self.munkahenger.maxTrans = {};
        self.munkahenger.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahenger.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#transTime"), 2)*1000;
        self.munkahenger.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#touchTransLimit"), 10);
    end;
 	
    local munkahenger2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger2#index"));
    if munkahenger2Node ~= nil then
        self.munkahenger2 = {};
        self.munkahenger2.node = munkahenger2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger2#minTrans"));
        self.munkahenger2.minTrans = {};
        self.munkahenger2.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger2.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger2#maxTrans"));
        self.munkahenger2.maxTrans = {};
        self.munkahenger2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahenger2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger2#transTime"), 2)*1000;
        self.munkahenger2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger2#touchTransLimit"), 10);
    end;
end;
      
function JD9030h:delete()
    delete(self.hornSoundId);
    delete(self.steerHydSoundId);

end;

function JD9030h:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function JD9030h:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_KP_6 then
		self.rotation3Min = isDown;
		self.rotation4Min = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.rotation3Max = isDown;
		self.rotation4Max = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.translation1Max = isDown;
	end;
	if sym == Input.KEY_KP_1 then
		self.translation1Min = isDown;
	end;

	self.needleTempMin = isDown;

	if sym == Input.KEY_f then
		if self.worklightsActive == true then
			self.worklightsActive = false;
			self.backLight = false;
		end;
	end;
	if isDown and sym == Input.KEY_5 then
	self.rotation1Max = not self.rotation1Max;
	self.rotation2Max = not self.rotation2Max;
	  
	self.partsActive = not self.partsActive;
	end;
	
	if isDown and sym == Input.KEY_6 then
	  
	self.parts2Active = not self.parts2Active;
	end;	
	
	if isDown and sym == Input.KEY_7 then
	  
	self.parts3Active = not self.parts3Active;
	end;		
    
    if isDown and sym == Input.KEY_4 then
	  
	self.parts4Active = not self.parts4Active;
	end;
	
	if isDown and sym == Input.KEY_8 then
	  
	self.parts5Active = not self.parts5Active;
	end;
	
	if isDown and sym == Input.KEY_9 then
	  
	self.parts6Active = not self.parts6Active;
	end;
	
    if isDown and sym == Input.KEY_0 then
		self.help = not self.help;
	end;
end;


function JD9030h:update(dt)
	
	
  for i=1, table.getn(self.wheels) do
	twx,twy,twz = getTranslation(self.wheels[i].repr);
	wrx,wry,wrz = getRotation(self.wheels[i].repr);
	wNrx,wNry,wNrz = getRotation(self.wheels[i].driveNode);

  end;

	
	local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation3.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation4.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;

	if self.rotation5.node ~= nil and wry ~= nil then
        setRotation(self.rotation5.node, 0, -wry, 0);
    end;
	if self.rotation6.node ~= nil and wry ~= nil then
        setRotation(self.rotation6.node, 0, -wry, 0);
    end;
	if self.rotation7.node ~= nil and wry ~= nil then
        setRotation(self.rotation7.node, 0, 0, wNrx*2);
    end;
	if self.rotation8.node ~= nil and wry ~= nil then
        setRotation(self.rotation8.node, 0, 0, wNrx*2);
    end;
	if self.rotation9.node ~= nil and self.bottomArm.node ~= nil then
	  rBFArmX, rBFArmY, rBFArmZ = getRotation(self.bottomArm.node);
        setRotation(self.rotation9.node, rBFArmX*1.1, 0, 0);
    end;
	if self.rotation10.node ~= nil and self.bottomArm.node ~= nil then
        setRotation(self.rotation10.node, rBFArmX/7, 0, 0);
    end;

	if self.rotation11.node ~= nil and self.bottomArm2.node ~= nil then
	  rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
        setRotation(self.rotation11.node, rBBArmX*1.5-0.35, 0, 0);
    end;
	if self.rotation12.node ~= nil and self.bottomArm2.node ~= nil then
        setRotation(self.rotation12.node, 0.278-rBBArmX*1.4, 0, 0);
    end;

	local doTranslate = self.translation1Max or self.translation1Min 
	if self.translation1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end; 

    if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.JD9030_HORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
    if  self.isMotorStarted and wry ~= 0 and math.abs(wry) < 0.226 then
        if not self.steerHydPlaying then
            playSample(self.steerHydSoundId, 0, 1, 0);
            self.steerHydPlaying = true;
        end;
    else
        if self.steerHydPlaying then
            stopSample(self.steerHydSoundId);
            self.steerHydPlaying = false;
        end;
    end;

	-- worklight
	
	
	if self.isEntered then
	if self.rotation1 ~= nil then
        local x,y,z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	if self.rotation2 ~= nil then
        local x,y,z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
		
	else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	end;
	self.rotation1Min = isDown;
		self.rotation2Min = isDown;
	end;
	
	if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	end;
	end;
	
	if self.parts3Active then
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active);
		end;
	else
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active, false);
	end;
	end;
	
	if self.parts6Active then
		for i=1, numparts6 do
			setVisibility(self.parts6[i], self.parts6Active);
		end;
	else
		for i=1, numparts6 do
			setVisibility(self.parts6[i], self.parts6Active, false);
	end;
	end;
	
	if self.parts4Active then
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active);
		end;
	else
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active, false);
	end;
	end;
	
	if self.parts5Active then
		for i=1, numparts5 do
			setVisibility(self.parts5[i], self.parts5Active);
		end;
	else
		for i=1, numparts5 do
			setVisibility(self.parts5[i], self.parts5Active, false);
	end;
	end;
	
	
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) or self.backLight == false then
			self.worklightsActive = not self.worklightsActive;
			self.tempActive = not self.worklightsActive;
			self.backLight = true;


			if self.lightsActive == true and self.worklightsActive == true then

				for i=1, numLights do
					if i>1 then
					setVisibility(self.lights[i], self.tempActive);
					end;
				end;
			else
			if self.worklightsActive == true then
				for i=1, numLights do
					if i>1 then
					setVisibility(self.lights[i], false);
					end;
				end;
			else
				if self.lightsActive == true then
					for i=1, numLights do
					if i>1 then
					setVisibility(self.lights[i], self.lightsActive);
					end;
				end;
			end;			
			end;
			end;
	
		end;
	
		for k, worklight in pairs(self.worklights) do
			setVisibility(worklight, self.worklightsActive);
		end;
	end;

	if InputBinding.isPressed(InputBinding.stxEMEL) then
             
        if self.munkahenger ~= nil then
		local x, y, z = getTranslation(self.munkahenger.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger.maxTrans, self.munkahenger.minTrans, 3, self.munkahenger.transTime, dt, true); 
		setTranslation(self.munkahenger.node, unpack(newTrans)); 
        end;
        if self.munkahenger2 ~= nil then
		local x, y, z = getTranslation(self.munkahenger2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger2.maxTrans, self.munkahenger2.minTrans, 3, self.munkahenger2.transTime, dt, true); 
		setTranslation(self.munkahenger2.node, unpack(newTrans)); 
        end;
            
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart5;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart6;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
	    end;	
		
		if InputBinding.isPressed(InputBinding.stxLEENGED) then
		     
        if self.munkahenger ~= nil then
		local x, y, z = getTranslation(self.munkahenger.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger.maxTrans, self.munkahenger.minTrans, 3, self.munkahenger.transTime, dt, false); 
		setTranslation(self.munkahenger.node, unpack(newTrans)); 
        end;
        if self.munkahenger2 ~= nil then
		local x, y, z = getTranslation(self.munkahenger2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger2.maxTrans, self.munkahenger2.minTrans, 3, self.munkahenger2.transTime, dt, false); 
		setTranslation(self.munkahenger2.node, unpack(newTrans)); 
        end;
           
		    local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart5;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
			local rotationPart = self.rotationParts.rotationPart6;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  	
	

end;

function JD9030h:onLeave()
	for k, worklight in pairs(self.worklights) do
		setVisibility(worklight, false);
	end;
	self.worklightsActive = false;
end;

function JD9030h:draw()
    if self.hudhelpOverlay ~= nil then
  	 if self.help then
    	self.hudhelpOverlay:render();
  	 end;
    end;
if self.help then	
	g_currentMission:addExtraPrintText("Klavesa 0: Info panel vypnout");
    else
	g_currentMission:addExtraPrintText("Klavesa 0: Info panel zapnout");
    end;


end;

function JD9030h:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
function JD9030h:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_FRONTLOADERJOINT then
        self.parts5Active = false;
        self.parts6Active = false;
    end;
end;
