--
-- FMCMapTrigger
-- this script can play animations, play sound onEnter of trigger, play sound on animation movement, turn light on/off and save/load animation time
--
--
-- based on MapDoorTrigger by Tobias F. (John Deere 6930)
-- author:    	Xentro (www.ls-uk.info)
-- @version:    v1.0
-- @date:       2011-12-20
-- @history:    v1.0 - inital implementation
-- 

FMCMapTrigger = {};
FMCMapTrigger.FMCMapTriggerLoaded = false;
FMCMapTrigger.FMCTriggers = {};
FMCMapTrigger.saveTable = {};

addModEventListener(FMCMapTrigger);

function FMCMapTrigger:loadMap(name)
    if not FMCMapTrigger.FMCMapTriggerLoaded then    
        self.oldPlayerCount = 0;
        self:loadFMCTriggerStates();
        FMCMapTrigger.FMCMapTriggerLoaded = true;
    end;
end;

function FMCMapTrigger:deleteMap()
    FMCMapTrigger.FMCMapTriggerLoaded = false;
end;

function FMCMapTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FMCMapTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function FMCMapTrigger:update(dt)
    if g_server then
        local playerCount = 0;
        for _,_ in pairs(g_currentMission.players) do
            playerCount = playerCount + 1;
        end;
        if playerCount ~= self.oldPlayerCount then
            self.oldPlayerCount = playerCount;
            for _,trigger in pairs(self.FMCTriggers) do
                g_server:broadcastEvent(setAnimationEvent:new(trigger, trigger.objActivated), nil, nil, nil);
            end;
        end;
    end;
end;

function FMCMapTrigger:draw()
end;

function FMCMapTrigger:addFMCTrigger(name)
    table.insert(self.FMCTriggers, name)
end;

function FMCMapTrigger:loadFMCTriggerStates()
    if g_currentMission.missionInfo.isValid then
        local savegamePath = getUserProfileAppPath() .. "savegame".. g_currentMission.missionInfo.savegameIndex .. "/FMCMapTriggers.xml";
        local xmlFile = loadXMLFile(nil, savegamePath);
        local i = 0;
        while true do
            local triggerName = string.format("FMCMapTriggers.trigger(%d)", i);
            local name = getXMLString(xmlFile, triggerName.."#name");
            local animationTime = getXMLFloat(xmlFile, triggerName.."#animationTime");
            local bool = getXMLBool(xmlFile, triggerName.."#bool");
            if name == nil or bool == nil then
                break;
            end;
            local entry = {};
            entry.name = name;
            entry.bool = bool;
			if animationTime ~= nil then
				entry.animationTime = animationTime;
			end;
            self.saveTable[i] = entry;
            i = i + 1;
        end;
        delete(xmlFile);
		
        for _, v in pairs(self.FMCTriggers) do
            for _,save in pairs(self.saveTable) do
                if v.name == save.name then
                    v.objActivated = save.bool;
                    v.animationTime = save.animationTime;
                end;
            end;
        end;
    end;
end;

function FMCMapTrigger:saveFMCTriggerStates()
  local rootTag = "FMCMapTriggers";
  local xmlFile = createXMLFile(nil, self.savegames[self.selectedIndex].savegameDirectory.."/FMCMapTriggers.XML", rootTag);
  local i=0;
  for _,v in pairs(FMCMapTrigger.FMCTriggers) do
    local tag = string.format(rootTag..".trigger(%d)", i);
    setXMLString(xmlFile, tag.."#name", v.name);
    setXMLFloat( xmlFile, tag.."#animationTime", v.animationTime);
    setXMLBool( xmlFile, tag.."#bool", v.objActivated);
    i = i + 1;
  end;
  saveXMLFile(xmlFile);
  delete(xmlFile);
end;

CareerScreen.saveSelectedGame = Utils.appendedFunction(CareerScreen.saveSelectedGame, FMCMapTrigger.saveFMCTriggerStates);

FMCTrigger = {};

local FMCTrigger_mt = Class(FMCTrigger, Object);

function onCreate(self, name)
    local instance = FMCTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(name);
    instance:register(true);
end;

function FMCTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, FMCTrigger_mt);
    self.className = "FMCTrigger";
    
    return self;
end;

function FMCTrigger:load(name)
    print("FMCMapTrigger: load("..name..")");
    
    self.triggerId = name;
    addTrigger(name, "triggerCallback", self);
    self.isEnabled = true;
    for i=0, getNumOfChildren(name)-1 do
        local child = getChildAt(name, i);
        setCollisionMask(child, 0);
    end;
    self.assignRigidType = true;
    self.assignRigidTypeTimeOut = g_currentMission.time+4000;
    self.count = 0;
	
    local inputKey = getUserAttribute(name, "animInputKey");
    
    local animTextNamePos = getUserAttribute(name, "animTextNamePos");
    local animTextNameNeg = getUserAttribute(name, "animTextNameNeg");
    
    if InputBinding[inputKey] ~= nil and g_i18n:hasText(animTextNamePos) and g_i18n:hasText(animTextNameNeg) then
        self.buttonActivated = true;

		self.inputKey = InputBinding[inputKey];
        self.animTextNamePos = animTextNamePos;
        self.animTextNameNeg = animTextNameNeg;

		self.lastanimationTime = 0;        
		self.track = false;
		local animNode = getUserAttribute(name, "animNode");
		if animNode ~= nil and string.len(animNode) >= 1 then
			local rootNode = getChild(name, animNode)
			self.animCharSet = 0;
			if rootNode ~= nil then
				self.animCharSet = getAnimCharacterSet(rootNode);
				if self.animCharSet ~= 0 then                    
					local animClip = getUserAttribute(name, "animClip");
					self.clip = getAnimClipIndex(self.animCharSet, animClip);
					if self.clip ~= nil then
						if self.clip >= 0 then
							assignAnimTrackClip(self.animCharSet, 0, self.clip);
							setAnimTrackLoopState(self.animCharSet, 0, false);
							self.speedScale = Utils.getNoNil(getUserAttribute(name, "animSpeed"), 1.0);
							self.animDuration = getAnimClipDuration(self.animCharSet, self.clip);
						end;
					else
						print("Error: Can't load animation clip, possible reason can be wrong animClip or wrong animNode");
					end;
				end;
			end;
			if self.isClient then
				local animSound = getUserAttribute(name, "animSoundPath");
				if animSound ~= nil and string.len(animSound) >= 1 then
					self.animSoundPath = g_modsDirectory.."/"..animSound;
					self.animSoundVolume = Utils.getNoNil(getUserAttribute(name, "animSoundVolume"), 1);
					self.animSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "animSoundRadius"), 50);
					self.animSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "animSoundInnerRadius"), 10);
					self.clientAnimationSound = createAudioSource("clientAnimationSound", self.animSoundPath, self.animSoundRadius, self.animSoundInnerRadius, self.animSoundVolume, 0);
					
					link(rootNode, self.clientAnimationSound);
					setVisibility(self.clientAnimationSound, false);
					
					self.playAnimationSoundEnabled = false;
					self.animSound = true;
				else
					self.animSound = false;
				end;
			end;
		end;
		
    else
        self.buttonActivated = false;
    end;
    --[[
	local lightNode = getUserAttribute(name, "lightNode");
	if lightNode ~= nil and string.len(lightNode) >= 1 then
		local rootNode = getChild(name, lightNode)
		if rootNode ~= nil then
			self.light = rootNode;
			setVisibility(self.light, false)
			
			self.lightButtonActivated = Utils.getNoNil(getUserAttribute(name, "lightButtonActivated"), false);
			if not self.buttonActivated then self.lightButtonActivated = false; end;
			
			local maxTime = Utils.getNoNil(getUserAttribute(name, "lightTime"), 5);
			self.lightMaxTime = (1000 * maxTime);
			self.lightTimer = self.lightMaxTime;
		end;
	end;
	]]--
	if self.isClient then
		local soundPath = getUserAttribute(name, "langSoundPath");
		if soundPath ~= nil and string.len(soundPath) >= 1 then
			if getUserAttribute(name, "langSwitch") == true then
				local soundPathForLanguage = string.gsub(soundPath, "{lang}", getLanguageName(getSystemLanguage()));
				self.path = g_modsDirectory.."/"..soundPathForLanguage;
			else
				local soundPath2 = string.gsub(soundPath, "{lang}", "English");
				self.path = g_modsDirectory.."/"..soundPath2;
			end;
			self.playSound = createSample("playSound");
			if loadSample(self.playSound, self.path, false) then
				self.langSound = true;
			else
				if getUserAttribute(name, "langSwitch") == true then
					local soundPathForLanguage2 = string.gsub(soundPath, "{lang}", "English");
					local path = g_modsDirectory.."/"..soundPathForLanguage2;
					print("Changed sound path to Default (English)");
					if loadSample(self.playSound, path, false) then
						self.langSound = true;
					else
						print("Error: Sound file for onEnter couldn't be loaded.");
						self.langSound = false;
					end;
				else
					print("Error: Sound file for onEnter couldn't be loaded.");
					self.langSound = false;
				end;
			end;
			self.playSoundEnabled = false;
			self.playSoundVolume = Utils.getNoNil(getUserAttribute(name, "langSoundVolume"), 1);
			
			self.playOnLeave = Utils.getNoNil(getUserAttribute(name, "langPlayOnLeave"), false);
		else
			self.langSound = false;
		end;
    end;
	
	self.name = getUserAttribute(name, "name");
	if self.name ~= nil and string.len(self.name) <= 0 then self.name = "noNameForTrigger"; end;
	
	self.animationTime = 0;                
	self.objActivated = false;
		
	FMCMapTrigger:addFMCTrigger(self)
end;

function FMCTrigger:delete()
    if self.isServer then
        removeTrigger(self.triggerId);
    end;
    
    if self.playSound ~= nil then delete(self.playSound); end;
end;

function FMCTrigger:update(dt)
    if self.playerInRange or self.vehicleInRange ~= nil and self.vehicleInRange:getIsActive() then
        if self.isClient then
            if not self.playSoundEnabled and self.langSound then
                playSample(self.playSound, 1, self.playSoundVolume, 0);
                self.playSoundEnabled = true;
            end;
        end;
		if self.buttonActivated then
            if self.clip ~= nil then--or self.light ~= nil and self.lightButtonActivated then
				if not self.objActivated then
					g_currentMission:addHelpButtonText(g_i18n:getText(self.animTextNamePos), self.inputKey);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText(self.animTextNameNeg), self.inputKey);
				end;                
				if InputBinding.hasEvent(self.inputKey) then
					self:setAnimation(not self.objActivated);
				end;
            end;
        end;
    else
        if not self.playOnLeave then
            if self.playSoundEnabled and self.langSound then
                stopSample(self.playSound);
                self.playSoundEnabled = false;
            end;
        end;
    end;
    
    if self.clip ~= nil and self.animDuration ~= nil then
		local animationEnabled = isAnimTrackEnabled(self.animCharSet, self.clip);
		if animationEnabled then
			if self.isClient then
				if not self.playAnimationSoundEnabled and self.animSound then
					setVisibility(self.clientAnimationSound, true);
					self.playAnimationSoundEnabled = true;
				end;
			end;
		else
			if self.playAnimationSoundEnabled and self.animSound then
				setVisibility(self.clientAnimationSound, false);
				self.playAnimationSoundEnabled = false;
			end;
		end;
    
        if self.animationTime <= 1 then 
            self.animationTime = 0;
            disableAnimTrack(self.animCharSet, self.clip);
            self.track = false;
        end;
        if self.animationTime >= self.animDuration then
            self.animationTime = self.animDuration;
            disableAnimTrack(self.animCharSet, self.clip);
            self.track = false;
        end;
        if self.objActivated then
            if self.animationTime < self.animDuration then
                self.animationTime = self.animationTime +self.speedScale;
            end;
        else
            if self.animationTime > 0 then
                self.animationTime = self.animationTime -self.speedScale;
            end;
        end;    
        if self.lastanimationTime ~= self.animationTime then
            if not self.track then
                enableAnimTrack(self.animCharSet, self.clip);
                self.track = true;
            end;
            setAnimTrackTime(self.animCharSet, self.clip, self.animationTime, false);
            self.lastanimationTime = self.animationTime;
        end;
    end;
	
    if self.assignRigidType and self.assignRigidTypeTimeOut <= g_currentMission.time then
        for i=0, getNumOfChildren(self.triggerId)-1 do
            local child = getChildAt(self.triggerId, i)
            setCollisionMask(child, 2102);
        end;
        self.assignRigidType = false;
    end;
end;

function FMCTrigger:updateTick(dt)
	--[[
	if self.light ~= nil then
		if self.lightButtonActivated then
			if self.objActivated then
				setVisibility(self.light, true)
			else
				setVisibility(self.light, false)
			end;
		else
			if self.playerInRange or self.vehicleInRange ~= nil and self.vehicleInRange:getIsActive() then
				setVisibility(self.light, true)
				self.lightTimer = self.lightMaxTime;
			else
				self.lightTimer = self.lightTimer - dt;
				if self.lightTimer < 0 then
					setVisibility(self.light, false)
				end;
			end;
		end;
	end;
	]]--
end;

function FMCTrigger:setAnimation(state, noEventSend)
    self.objActivated = state;
    setAnimationEvent.sendEvent(self, state, noEventSend);
end;

function FMCTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if self.isEnabled then
        if (onEnter or onLeave) then
            local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
            if vehicle ~= nil then
                self.playerInRange = false;
                if onLeave then
                    if self.vehicleInRange == vehicle then
                        self.vehicleInRange = nil;
                    end;
                else
                    if vehicle ~= nil then
                        self.vehicleInRange = vehicle;
                    end;
                end;
            else
                if g_currentMission.controlPlayer and g_currentMission.player ~= nil then
                    if otherId == g_currentMission.player.rootNode then
                        if onEnter then
                            self.playerInRange = true;
                        else
                            self.playerInRange = false;
                        end;
                    end;
                else
                    self.playerInRange = false;
                end;
            end;
        end;
    else
        self.playerInRange = false;
        self.vehicleInRange = nil;
    end;
end;

-- Event --
setAnimationEvent = {};
setAnimationEvent_mt = Class(setAnimationEvent, Event);

InitEventClass(setAnimationEvent, "setAnimationEvent");

function setAnimationEvent:emptyNew()
    local self = Event:new(setAnimationEvent_mt);
    self.className="setAnimationEvent";
    return self;
end;

function setAnimationEvent:new(object, state)
	local self = setAnimationEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function setAnimationEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setAnimationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function setAnimationEvent:run(connection)
	self.object:setAnimation(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setAnimationEvent:new(self.object, self.state), nil, connection, self.object);
	end;	
end;

function setAnimationEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setAnimationEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setAnimationEvent:new(vehicle, state));
		end;
	end;
end;