--
--jelczPrzyczepa
-- Do jelczPrzyczepa By Maciusboss1
--
--@ by Blade
--@ date 9/12/2010
-- Edit Scrypt: maciusboss1 15/03/2011


jelczPrzyczepa = {};

function jelczPrzyczepa.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function jelczPrzyczepa:load(xmlFile)
	self.zakladki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zakladki#index"));
	self.plandeka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plandeka#index"));
	
	self.zakladkiActive = false;
	self.plandekaActive = false;
	
	local rotationNodeburtalewa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.burtalewa#index"));
    if rotationNodeburtalewa ~= nil then
        self.burtalewa = {};
        self.burtalewa.node = rotationNodeburtalewa;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.burtalewa#minRot"));
        self.burtalewa.minRot = {};
        self.burtalewa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.burtalewa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.burtalewa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.burtalewa#maxRot"));
        self.burtalewa.maxRot = {};
        self.burtalewa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.burtalewa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.burtalewa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.burtalewa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.burtalewa#rotTime"), 2)*1000;
        self.burtalewa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.burtalewa#touchRotLimit"), 10));
    end;
	local rotationNodeburtaprawa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.burtaprawa#index"));
    if rotationNodeburtaprawa ~= nil then
        self.burtaprawa = {};
        self.burtaprawa.node = rotationNodeburtaprawa;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.burtaprawa#minRot"));
        self.burtaprawa.minRot = {};
        self.burtaprawa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.burtaprawa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.burtaprawa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.burtaprawa#maxRot"));
        self.burtaprawa.maxRot = {};
        self.burtaprawa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.burtaprawa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.burtaprawa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.burtaprawa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.burtaprawa#rotTime"), 2)*1000;
        self.burtaprawa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.burtaprawa#touchRotLimit"), 10));
    end;


    
--Plandeka--
	
	local translationPartNodePlandeka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartPlandeka#index"));
    if translationPartNodePlandeka ~= nil then
        self.translationPartPlandeka = {};
        self.translationPartPlandeka.node = translationPartNodePlandeka;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPlandeka#minTrans"));
        self.translationPartPlandeka.minTrans = {};
        self.translationPartPlandeka.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPlandeka.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPlandeka.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPlandeka#maxTrans"));
        self.translationPartPlandeka.maxTrans = {};
        self.translationPartPlandeka.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPlandeka.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPlandeka.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartPlandeka.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPlandeka#transTime"), 2)*1000;
        self.translationPartPlandeka.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPlandeka#touchTransLimit"), 10);
    end;
end;

function jelczPrzyczepa:delete()
end;

function jelczPrzyczepa:mouseEvent(posX, posY, isDown, isUp, button)
end;

function jelczPrzyczepa:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_8 then
		self.helpPanel = not self.helpPanel;
	
	end;
	if sym == Input.KEY_n then
		self.burtalewaMax = isDown;
	end;
	if sym == Input.KEY_j then
		self.burtalewaMin = isDown;
	end;
	if sym == Input.KEY_m then
		self.burtaprawaMax = isDown;
	end;
	if sym == Input.KEY_k then
		self.burtaprawaMin = isDown;
	end;
	if isDown and sym == Input.KEY_KP_0 then
		self.zakladkiActive = not self.zakladkiActive;
		self.translationPartNodePlandeka = not self.translationPartNodePlandeka;
	end;
	if isDown and sym == Input.KEY_v then
		self.plandekaActive = not self.plandekaActive;
	end;
end;

function jelczPrzyczepa:update(dt)
	
	self.isExpanded = false;
	setVisibility(self.zakladki, self.zakladkiActive);
	setVisibility(self.plandeka, self.plandekaActive);
	if self.rotationPart ~= nil then
		local x, y, z = getRotation(self.rotationPart.node);
		local maxRot = self.rotationPart.maxRot;
		local eps = self.rotationPart.touchRotLimit
			
		if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpanded = true;
        end;
	end;
	local doRotate = self.burtalewaMax or self.burtalewaMin 
	if self.burtalewa ~= nil and doRotate then
        local x, y, z = getRotation(self.burtalewa.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.burtalewa.maxRot, self.burtalewa.minRot, 3, self.burtalewa.rotTime, dt, not self.burtalewaMax);
        setRotation(self.burtalewa.node, unpack(newRot));
    end;
	local doRotate = self.burtaprawaMax or self.burtaprawaMin 
	if self.burtaprawa ~= nil and doRotate then
        local x, y, z = getRotation(self.burtaprawa.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.burtaprawa.maxRot, self.burtaprawa.minRot, 3, self.burtaprawa.rotTime, dt, not self.burtaprawaMax);
        setRotation(self.burtaprawa.node, unpack(newRot));
    end;


	---------------------------Plandeka----------------------------
	if self.translationPartPlandeka ~= nil then
		local x, y, z = getTranslation(self.translationPartPlandeka.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartPlandeka.maxTrans, self.translationPartPlandeka.minTrans, 3, self.translationPartPlandeka.transTime, dt, not self.translationPartNodePlandeka);
		setTranslation(self.translationPartPlandeka.node, unpack(newTrans));
	end;
end;

function jelczPrzyczepa:draw()
        
			if self.helpPanel then
           g_currentMission:addExtraPrintText("Wcisnij 8: Wlacz Info Przyczepa Jelcz");
    else
          g_currentMission:addExtraPrintText("Wcisnij 8: Wylacz Info Przyczepa Jelcz");
    end;
	if self.helpPanel then
			renderText(0.65, 0.67, 0.022, "-Przyczepa Jelcz- By Maciusboss1 & Blade");
			renderText(0.65, 0.645, 0.02, "Wcisnij: N/J: otworz/zamknij butre lewa");
			renderText(0.65, 0.63, 0.02, "Wcisnij: M/K: otworz/zamknij burte prawa");
			renderText(0.65, 0.615, 0.02, "Wcisnij NUM 1|3/2: Kierunkowskazy/awaryjne");
			renderText(0.65, 0.6, 0.02, "Wcisnij V: zaloz/sciagnij plandeke");
			renderText(0.65, 0.585, 0.02, "Wcisnij NUM 0: wlacz/wylacz zakladki");
		end;


end;


function jelczPrzyczepa:onAttach()
	
end;

function jelczPrzyczepa:onDetach()
end;

function jelczPrzyczepa:onLeave()
end;