--mantrailer
--powered by hz888
--hz888@freemail.hu

mantrailer = {};

function mantrailer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function mantrailer:load(xmlFile)

	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;

	self.numbacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights = {};
    for i=1, self.numbacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;
	self.backlightsActive = false;


end;

function mantrailer:delete()
end;

function mantrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mantrailer:keyEvent(unicode, sym, modifier, isDown)

end;

function mantrailer:update(dt)


    if self:getIsActive() then

            self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

            if InputBinding.isAxisZero(self.input) then
                self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
            end;

		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;


		if self.backlightsActive then
			for i=1, self.numbacklights do
				local backlight = self.backlights[i];
				setVisibility(backlight, self.backlightsActive);
			end;
		else
			for i=1, self.numbacklights do
				local backlight = self.backlights[i];
				setVisibility(backlight, self.backlightsActive, false);
			end;
		end;


		if -self.input < -0.001 and self.movingDirection > 0 then
			self.brakelightsActive = true;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakelightsActive = true;
		else
			self.brakelightsActive = false;
		end;
		if self.movingDirection < 0 then
    			self.backlightsActive = true;
		else
		    	self.backlightsActive = false;
		end;

   end;

 

end;

function mantrailer:draw()

end;

function mantrailer:onAttach(attacherVehicle)
    self:setLightsVisibility(attacherVehicle.lightsActive);
end;

function mantrailer:onDetach()
	self.brakelightsActive = false;
	self.backlightsActive = false;
	for i=1, self.numbrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
	for i=1, self.numbacklights do
		local backlight = self.backlights[i];
		setVisibility(backlight, self.backlightsActive, false);
	end;
end;