--
-- Geringhoff8
-- www.landwirtschafts.eu
--
-- @author  MySQly
-- @date  15/01/10
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

Geringhoff8 = {};

function Geringhoff8.prerequisitesPresent(specializations)
    return true;
end;

function Geringhoff8:load(xmlFile)
	self.reelSpeedOwn = 0.003;
	self.hederNisko = false;
	self.percentArea = 0;
	self.cutterIsOpening = false;
	self.cutterIsOpen = true;
	self.cutterOpenStage = 0;
	self.cutterOpenTimer = 0;
	self.rightSideOpen = true;
	self.rightSideDividerOpen = true;
	self.leftSideOpen = true;
	self.leftSideDividerOpen = true;
	self.vehicleAttacher = nil;
	self.cutterOpen = true;
	
	
	--AI Markers
    self.aiLeftMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index2"));
    self.aiRightMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index2"));
	
    self.aiLeftMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index3"));
    self.aiRightMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index3"));
	
    self.aiLeftMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index4"));
    self.aiRightMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index4"));
	--AI Markers
	
	
	self.particleSystemsKukurydza = {};
    local particleSystemsKukurydzaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsKukurydza#count"), 0);
    for i=1, particleSystemsKukurydzaCount do
        local namei = string.format("vehicle.particleSystemsKukurydza.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsKukurydza, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    self.schneckeMitte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeMitte"));
	self.schneckeLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeLinks"));
	self.schneckeRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeRechts"));	
	
	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;  
	local rotationPartNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight2#index"));
    if rotationPartNodeRight2 ~= nil then
        self.rotationPartRight2 = {};
        self.rotationPartRight2.node = rotationPartNodeRight2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#minRot"));
        self.rotationPartRight2.minRot = {};
        self.rotationPartRight2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#maxRot"));
        self.rotationPartRight2.maxRot = {};
        self.rotationPartRight2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#rotTime"), 2)*1000;
        self.rotationPartRight2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#touchRotLimit"), 10));
    end;
	local rotationPartNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight3#index"));
    if rotationPartNodeRight3 ~= nil then
        self.rotationPartRight3 = {};
        self.rotationPartRight3.node = rotationPartNodeRight3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight3#minRot"));
        self.rotationPartRight3.minRot = {};
        self.rotationPartRight3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight3#maxRot"));
        self.rotationPartRight3.maxRot = {};
        self.rotationPartRight3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight3#rotTime"), 2)*1000;
        self.rotationPartRight3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight3#touchRotLimit"), 10));
    end;
	local rotationPartNodeRight4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight4#index"));
    if rotationPartNodeRight4 ~= nil then
        self.rotationPartRight4 = {};
        self.rotationPartRight4.node = rotationPartNodeRight4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight4#minRot"));
        self.rotationPartRight4.minRot = {};
        self.rotationPartRight4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight4#maxRot"));
        self.rotationPartRight4.maxRot = {};
        self.rotationPartRight4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight4#rotTime"), 2)*1000;
        self.rotationPartRight4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight4#touchRotLimit"), 10));
    end;
	    
	
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;    
	local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;

	self.hydraulic = {};
	self.hydraulic.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
	self.hydraulic.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
	self.hydraulic.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
	local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
    self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.hydraulic2 = {};
	self.hydraulic2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#indexHydraulic"));
	self.hydraulic2.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#indexPunch"));
	self.hydraulic2.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#translationPunch"));
	local ax, ay, az = getWorldTranslation(self.hydraulic2.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic2.translationPunch);
    self.hydraulic2.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.hydraulicPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
	self.hydraulicPoint2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#hydraulicPoint2"));	
	
    self.setReelSpeed = SpecializationUtil.callSpecializationsFunction("setReelSpeed");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = Geringhoff8.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");

    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));

    self.rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));

    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);

    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);

    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)

    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;

    self.preferedCombineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.preferedCombineSize"), 1);

    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.reelStarted = false;

    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;

    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;


    self.lastArea = 0;

end;

function Geringhoff8:delete()
    Utils.deleteParticleSystem(self.threshingParticleSystems);
end;

function Geringhoff8:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Geringhoff8:keyEvent(unicode, sym, modifier, isDown)

    if InputBinding.isPressed(InputBinding.OPEN_HEADER) then
		if not self.cutterIsOpening then
			self.cutterOpen = not self.cutterOpen;
			self.cutterIsOpening = true;
			self.cutterOpenStage = 1;
			if self.cutterOpen then
				self.cutterOpenTimer = 6000;
				self.leftSideOpen = true;
			else
				self.cutterOpenTimer = 3000;
				self.rightSideDividerOpen = false;
			end;
		else
			self.attacherVehicle.cutterOpeningWarning = true;
		end;
		self.vehicleAttacher.cutterOpened = (self.cutterOpen and not self.cutterIsOpening);
	end;
	
end;

function Geringhoff8:update(dt)
	if self.cutterIsOpening then
		self.cutterOpenTimer = self.cutterOpenTimer - dt;
		if self.cutterOpenTimer < 0 then
			if self.cutterOpen then
				if self.cutterOpenStage == 1 then
					self.cutterOpenTimer = 3000;
					self.leftSideDividerOpen = true;
					self.cutterOpenStage = 2;
				elseif self.cutterOpenStage == 2 then
					self.cutterOpenTimer = 6000;
					self.rightSideOpen = true;
					self.cutterOpenStage = 3;
				elseif self.cutterOpenStage == 3 then
					self.cutterOpenTimer = 3000;
					self.rightSideDividerOpen = true;
					self.cutterOpenStage = 4;
				elseif self.cutterOpenStage == 4 then
					self.cutterOpenStage = 0;
					self.cutterIsOpening = false;
				end;
			else
				if self.cutterOpenStage == 1 then
					self.cutterOpenTimer = 6000;
					self.rightSideOpen = false;
					self.cutterOpenStage = 2;
				elseif self.cutterOpenStage == 2 then
					self.cutterOpenTimer = 3000;
					self.leftSideDividerOpen = false;
					self.cutterOpenStage = 3;
				elseif self.cutterOpenStage == 3 then
					self.cutterOpenTimer = 6000;
					self.leftSideOpen = false;
					self.cutterOpenStage = 4;
				elseif self.cutterOpenStage == 4 then
					self.cutterOpenStage = 0;
					self.cutterIsOpening = false;
				end;
			end;
		end;
		self.vehicleAttacher.cutterOpened = (self.cutterOpen and not self.cutterIsOpening);
	end;
	
    if self.attacherVehicle ~= nil and self.attacherVehicle.deactivateCutter then
        Geringhoff8.onDeactivate(self);
		self.attacherVehicle.deactivateCutter = false;
    end;
	self.percentArea = 0;
	if self.attacherVehicle ~= nil then
		self.hederNisko = self.attacherVehicle.cutterLowPosition;
	end;
	
    self.lastArea = 0;
    if self.reelStarted and self.movingDirection < 0 then

        local speedLimit = self.speedLimit;
        if Geringhoff8.getUseLowSpeedLimit(self) then
            speedLimit = self.speedLimitLow;
        end;

        if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
            self.speedViolationTimer = self.speedViolationTimer - dt;
        else
            self.speedViolationTimer = self.speedViolationMaxTime;
        end;

        if self.speedViolationTimer > 0 then

                -- during low fill level new fruit types are allowed to "take over"
                local lowFillLevel = false;
                if self.attacherVehicle ~= nil then
                    if self.attacherVehicle.grainTankFillLevel > 0 and self.attacherVehicle.grainTankFillLevel / self.attacherVehicle.grainTankCapacity <= self.attacherVehicle.minThreshold then
                        lowFillLevel = true;
                    end;
                end;

                local foundFruitType = false;
                local oldFruitType = self.currentFruitType;
                
                local allowsThreshing = true;
                if self.attacherVehicle ~= nil then
                    allowsThreshing = self.attacherVehicle.allowsThreshing;
                end;

                if allowsThreshing then
                    if self.currentFruitType == FruitUtil.FRUITTYPE_UNKNOWN or lowFillLevel then
                        for fruitType,v in pairs(self.fruitTypes) do
                            local isOk = true;
                            if self.attacherVehicle ~= nil then
                                if self.attacherVehicle.allowGrainTankFruitType ~= nil then
                                    isOk = self.attacherVehicle:allowGrainTankFruitType(fruitType);
                                end;
                            end;
                            if isOk then
                                for k,area in pairs(self.cuttingAreas) do
                                    local x,y,z = getWorldTranslation(area.start);
                                    local x1,y1,z1 = getWorldTranslation(area.width);
                                    local x2,y2,z2 = getWorldTranslation(area.height);
                                    local area = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
                                    if area > 0 then
                                        self.currentFruitType = fruitType;
                                        if self.currentFruitType ~= oldFruitType then
                                            Geringhoff8.updateExtraObjects(self)
                                            if self.attacherVehicle ~= nil then
                                                self.attacherVehicle:emptyGrainTankIfLowFillLevel();
                                            end;
                                        end;
                                        foundFruitType = true;
                                        break;
                                    end;
                                end;

                                if foundFruitType then
                                    break;
                                end;
                            end;
                        end;
                    end;
                    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN and self.hederNisko and not self.attacherVehicle.speedWarning then
                        local realArea = 0;
                        for k,area in pairs(self.cuttingAreas) do
                            local x,y,z = getWorldTranslation(area.start);
                            local x1,y1,z1 = getWorldTranslation(area.width);
                            local x2,y2,z2 = getWorldTranslation(area.height);
                            Utils.updateFruitCutShortArea(self.currentFruitType, x, z, x1, z1, x2, z2, 1);
                            local area = Utils.cutFruitArea(self.currentFruitType, x, z, x1, z1, x2, z2);
                            if area > 0 then
                                local spray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x, z, x1, z1, x2, z2);
								local multi = 0;
                                if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
									multi = 0.5;
									if spray > 0 then
										multi = 1;
									end;
								else
									multi = 0.2;
									if spray > 0 then
										multi = 0.4;
									end;
								end;
                                self.lastArea = self.lastArea + area*multi;
                                realArea = realArea + area/g_currentMission.maxFruitValue;
								self.percentArea = realArea;
                            end;
                        end;
                        local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
                        local qm = realArea*pixelToQm;
                        local ha = qm/10000;

                        g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
                        g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

                        g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
                        g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
                    end;
                end;
        end;
    else
        self.speedViolationTimer = self.speedViolationMaxTime;
    end;

    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastArea > 0.0));
	Utils.setEmittingState(self.particleSystemsKukurydza, (self.reelStarted and self.lastArea > 0.0));
	
	if self.reelStarted then
	    rotate(self.schneckeMitte, dt*self.reelSpeedOwn*6, 0, 0);
	    rotate(self.schneckeLinks, dt*self.reelSpeedOwn*6, 0, 0);
	    rotate(self.schneckeRechts, dt*self.reelSpeedOwn*6, 0, 0);
	end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^RIGHT^^^^^^^^^^^^^^^^^^^^^SIDE^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;
	if self.rotationPartRight2 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight2.maxRot, self.rotationPartRight2.minRot, 3, self.rotationPartRight2.rotTime, dt, self.rightSideDividerOpen);
        setRotation(self.rotationPartRight2.node, unpack(newRot));
    end;
	if self.rotationPartRight3 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight3.maxRot, self.rotationPartRight3.minRot, 3, self.rotationPartRight3.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight3.node, unpack(newRot));
    end;
    if self.rotationPartRight4 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight4.maxRot, self.rotationPartRight4.minRot, 3, self.rotationPartRight4.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight4.node, unpack(newRot));
    end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^LEFT^^^^^^^^^^^^^^^^^^^^^SIDE^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    
    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;
    if self.rotationPartLeft2 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, self.leftSideDividerOpen);
        setRotation(self.rotationPartLeft2.node, unpack(newRot));
    end;    
	if self.rotationPartLeft3 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft3.node, unpack(newRot));
    end;
	if self.rotationPartLeft4 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft4.node, unpack(newRot));
    end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^HYDRAULIC^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if self.hydraulic ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
		end;
	end;
	
	if self.hydraulic2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic2.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint2);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic2.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic2.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic2.punch, 0, 0, (distance-self.hydraulic2.punchDistance)*-1);
		end;
	end;	
end;

function Geringhoff8:draw()
	--[[if self.attacherVehicle ~= nil then
		if self.attacherVehicle.help then
			setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.8, 0.7, 0.022, "KP 1 - Hillmaster left");
			renderText(0.8, 0.674, 0.022, "KP 3 - Hillmaster right");
			renderText(0.8, 0.648, 0.022, "KP 8 - Reel up");
			renderText(0.8, 0.622, 0.022, "KP 2 - Reel down");
			renderText(0.8, 0.596, 0.022, "KP 4 - Reel forward");
			renderText(0.8, 0.57, 0.022, "KP 6 - Reel backward");
			renderText(0.8, 0.544, 0.022, "KP 7 - Reel speed -");
			renderText(0.8, 0.518, 0.022, "KP 9 - Reek speed +");
			renderText(0.8, 0.492, 0.022, "KP 5 - Rape table");
			renderText(0.8, 0.466, 0.022, string.format("Reel speed: %.0f", self.reelSpeedOwn*1000));
			renderText(0.8, 0.44, 0.022, " ");
			renderText(0.8, 0.414, 0.022, " ");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			self.attacherVehicle.hudjohndeere625ROverlay:render();
		end;
	end;]]
end;

function Geringhoff8:onAttach()
	self.hederNisko = false;
	self.vehicleAttacher = self.attacherVehicle;
	self.vehicleAttacher.cutterName = "geringhoff8";
	self.vehicleAttacher.changeAttacherMaxRotation = true;
end;

function Geringhoff8:onDetach()
    if self.deactivateOnDetach then
        Geringhoff8.onDeactivate(self);
    end;
	self.hederNisko = false;
	self.vehicleAttacher.cutterName = "nil";
end;

function Geringhoff8:onLeave()

end;

function Geringhoff8:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function Geringhoff8:setReelSpeed(speed)
    self.reelSpeed = speed;
end;

function Geringhoff8:onStartReel()
    self.reelStarted = true;
end;

function Geringhoff8:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function Geringhoff8:isReelStarted()
    return self.reelStarted;
end;

function Geringhoff8:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;

function Geringhoff8:setFruitType(fruitType)
    if self.currentFruitType ~= fruitType then
        self.currentFruitType = fruitType;
        self.lastArea = 0;

        Geringhoff8.updateExtraObjects(self)
    end;
end;

function Geringhoff8.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;

function Geringhoff8.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;

function Geringhoff8.allowThreshing(earlyWarning)
    return true;
end;
