--
-- Specialization for Blinker mod
--
-- @autor Sebastian B. (Blancker, www.landwirtschaftssimualtor-2009.de)
--
-- @update 15/09/09
--

StVO = {};

function StVO.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function StVO:load(xmlFile)
--[[Blinker start]]--
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	
--[[Blinker ende]]--
--[[Bremslicht start]]--
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;	
--[[Bremslicht ende]]--
end;

function StVO:delete()
end;

function StVO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StVO:keyEvent(unicode, sym, modifier, isDown)
----[[Blinker start]]----
--[[Blinker Rechts]]--
	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_1 then 
			self.flashLeft = not self.flashLeft;
			self.delayOnLeft = 10;
			self.flashRight = false;
			self.flash = false;
			self.flashlightsRightActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsRight2Active = false;
			self.turnlightsActive2 = false;
			self.flashWarner = false;
		end;
	end;
--[[Warnblinker]]--
	if isDown and sym == Input.KEY_KP_2 then 
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]--
	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_3 then 
			self.flashRight = not self.flashRight;
			self.delayOnRight = 10;
			self.flashLeft = false;
			self.flash = false;
			self.flashlightsLeftActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsLeft2Active = false;
			self.turnlightsActive = false;
			self.flashWarner = false;
		end;
	end;	
----[[Blinker ende]]----
end;

function StVO:update(dt)
--[[Blinker start]]--
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.turnlightsActive2 = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.turnlightsActive2 = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive2 = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;
		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
--[[Blinker ende]]--
--[[Bremslicht start]]--
    inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;	
	end;
--[[Bremslicht ende]]--
end;

function StVO:draw()
end;

function StVO:onLeave()
end;