--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info

Johndeereautosteer = {};

function Johndeereautosteer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Johndeereautosteer:load(xmlFile)

	self.setAutoSteer = SpecializationUtil.callSpecializationsFunction("setAutoSteer");
	
    self.maxRotatedTimeSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheels.maxRotatedTimeSpeed#value"), 2)*0.001;

	self.maxRotatedTimeSpeed = 0;
	self.steeringLocked = true;	
	
	self.controlpath = Utils.getFilename("AutosteerLocked.png", self.baseDirectory);
    self.button1PoxX = 0.93;
    self.button1PoxY = 0.8;
    self.button1Width = 0.065;
    self.button1Height = 0.095;
    self.button1Overlay = Overlay:new("button1", self.controlpath, self.button1PoxX, self.button1PoxY, self.button1Width, self.button1Height);
    self.button1Active = true;

	self.controlpath = Utils.getFilename("AutosteerReleased.png", self.baseDirectory);
    self.button2PoxX = 0.93;
    self.button2PoxY = 0.8;
    self.button2Width = 0.065;
    self.button2Height = 0.095;
    self.button2Overlay = Overlay:new("button2", self.controlpath, self.button2PoxX, self.button2PoxY, self.button2Width, self.button2Height);
    self.button2Active = true;
	
end;

function Johndeereautosteer:readStream(streamId, connection)
      local lockedsteer = streamReadBool(streamId);
      self:setAutoSteer(lockedsteer, true);
end;

function Johndeereautosteer:writeStream(streamId, connection)
      streamWriteBool(streamId, self.steeringLocked);
end;

function Johndeereautosteer:keyEvent(unicode, sym, modifier, isDown)

end;

function Johndeereautosteer:update(dt)

      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.JOHNDEEREAUTOSTEER) then
                  self:setAutoSteer(not self.steeringLocked);
              end;
      end;

end;

function Johndeereautosteer:updateTick(dt)

		if self.steeringLocked then
		   self.autoRotateBackSpeed	= 2.5
		   self.maxRotatedTimeSpeed = 2*0.001;
		else
		   self.autoRotateBackSpeed = 0.0
		   self.maxRotatedTimeSpeed = 0;
		end;
end;

function Johndeereautosteer:draw()

	if self:getIsActive() then
		if self.steeringLocked then
			 if self.button2Overlay ~= nil then
				if self.button2Active then
				self.button2Overlay:render();
				end;
			end;
			else
			 if self.button1Overlay ~= nil then
				if self.button1Active then
				self.button1Overlay:render();
				end;
			end;
		end;
	end;
  
end;


function Johndeereautosteer:onEnter()
  
end;

function Johndeereautosteer:onLeave()
 
end;

function Johndeereautosteer:delete()

end;

function Johndeereautosteer:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Johndeereautosteer:setAutoSteer(lockedsteer, noEventSend)
      SetAutoSteerEvent.sendEvent(self, lockedsteer, noEventSend)
      self.steeringLocked = lockedsteer;
end;

SetAutoSteerEvent = {};
SetAutoSteerEvent_mt = Class(SetAutoSteerEvent, Event);
  
InitEventClass(SetAutoSteerEvent, "SetAutoSteerEvent");
  
function SetAutoSteerEvent:emptyNew()
     local self = Event:new(SetAutoSteerEvent_mt);
      self.className="SetAutoSteerEvent";
      return self;
end;
  
function SetAutoSteerEvent:new(object, lockedsteer)
      local self = SetAutoSteerEvent:emptyNew()
      self.object = object;
      self.lockedsteer = lockedsteer;
      return self;
end;
  
function SetAutoSteerEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.lockedsteer = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetAutoSteerEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.lockedsteer);
end;
  
function SetAutoSteerEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setAutoSteer(self.lockedsteer, true);
end;
  
function SetAutoSteerEvent.sendEvent(vehicle, lockedsteer, noEventSend)
      if lockedsteer ~= vehicle.steeringLocked then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetAutoSteerEvent:new(vehicle, lockedsteer), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetAutoSteerEvent:new(vehicle, lockedsteer));
              end;
          end;
      end;
end;