--
-- IGNITION1
-- version 1.1
--
-- a specialization that allows the player to manually start and stop the vehicle's motor
--
-- @author  Templaer
-- @date  19/11/09
--

IGNITION1 = {};

function IGNITION1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function IGNITION1:load(xmlFile)
	self.applyBrakes = SpecializationUtil.callSpecializationsFunction("applyBrakes");
	self.startMotorManually = SpecializationUtil.callSpecializationsFunction("startMotorManually");
	self.stopMotorManually = SpecializationUtil.callSpecializationsFunction("stopMotorManually");

    self.IGNITION1Key = false;
	self.IGNITION1Allowed = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;	
	
	self.backupStopVolume = self.motorStopSoundVolume;
	self.motorStopSoundVolume = 0;
	self.steeringEnabled = false;
end;

function IGNITION1:delete()
end;

function IGNITION1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IGNITION1:keyEvent(unicode, sym, modifier, isDown)
end;

function IGNITION1:update(dt)
	if self.isEntered then
		if not self.isAITractorActivated then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.IGNITION1) then
					self.IGNITION1Key = not self.IGNITION1Key;
					self.IGNITION1Allowed = true;
				end;
				
				if math.abs(self.acceleration) > 0 and self.isMotorStarted == false then
					self.IGNITION1Key = true;
					self.IGNITION1Allowed = true;
				end;	
			end;
			
			if self.IGNITION1Allowed then
				self.IGNITION1Allowed = false;
				if self.IGNITION1Key then	
					self:startMotorManually();
				elseif not self.IGNITION1Key then
					self:stopMotorManually();
				end;
			end;
		elseif not self.IGNITION1Key and not self.deactivateOnLeave then
			self:stopAITractor();
		end;
	end;
end;

function IGNITION1:onEnter()
	if not self.IGNITION1Key then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	end;
    setVisibility(self.aiMotorSound, false);
end;

function IGNITION1:onLeave()
    if self.IGNITION1Key then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.isMotorStarted = true;
	end;	
	setVisibility(self.aiMotorSound, self.IGNITION1Key);
end;

function IGNITION1:draw()
end;

-- Additional function(s)
function IGNITION1:applyBrakes()
	for k,wheel in pairs(self.wheels) do
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
	end;
end;

function IGNITION1:startMotorManually()
	if self.powershiftLevel ~= nil then
		self.powershiftLevel = 1;
	end; 
	self:startMotor();
	self.steeringEnabled = true;
end;

function IGNITION1:stopMotorManually()
	self.motorStopSoundVolume = self.backupStopVolume;
	self.steeringEnabled = false;
	self.cruiseControlActive = false;
	self:applyBrakes();
	self:onDeactivateAttachements();
	self:stopMotor();
	self.motorStopSoundVolume = 0;
end;

