--
-- Acceleration
-- Specialization for obtaining and updating the acceleration of a vehicle
--
-- @author  Templaer
-- @date  03/12/09

Acceleration = {};

function Acceleration.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Acceleration:load(xmlFile)
	self.setAcceleration = SpecializationUtil.callSpecializationsFunction("setAcceleration");
	self.getAcceleration = SpecializationUtil.callSpecializationsFunction("getAcceleration");
	
	self.accelerationDirection = 1;
	self.cruiseControlActive = false;
	self.acceleration = 0;
end;

function Acceleration:delete()
end;

function Acceleration:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Acceleration:keyEvent(unicode, sym, modifier, isDown)
end;

function Acceleration:update(dt)
	if self.isEntered then
		if not self.isAITractorActivated then
			self.motor.speedLevel = 1;
			
			self:getAcceleration();
			self:setAcceleration(dt);
		else
			self.cruiseControlActive = false;
		end;
	end;
end;

function Acceleration:onLeave()
	self.cruiseControlActive = false;
end;

function Acceleration:draw()
	self:addInfoText(InputBinding.POWERSHUTTLE, g_i18n:getText("PowerShuttle3"));			
	self:addInfoText(InputBinding.CRUISECONTROL, g_i18n:getText("CruiseControl3"));
end;

-- Additional functions
function Acceleration:getAcceleration()
	self.acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
	if InputBinding.isAxisZero(self.acceleration) then
		self.acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
	end;
	
	if math.abs(self.acceleration) > 0.8 then
		self.cruiseControlActive = false;
	end;
	self.acceleration = math.max(self.acceleration, 0);
end;

function Acceleration:setAcceleration(dt)
	if InputBinding.hasEvent(InputBinding.POWERSHUTTLE3) then
		self.accelerationDirection = -self.accelerationDirection;
	end;
	if InputBinding.hasEvent(InputBinding.CRUISECONTROL3) then
		self.cruiseControlActive = not self.cruiseControlActive;
	end
	
	if g_currentMission.allowSteerableMoving and not self.playMotorSound and self.isMotorStarted then			
		self.acceleration = self.accelerationDirection * self.acceleration;
		if self.cruiseControlActive then
			self.acceleration = self.accelerationDirection;
		end;
		WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, self.acceleration, false, self.requiredDriveMode)
	end;
end;