SetDoorLeftRotationEvent = {};
SetDoorLeftRotationEvent_mt = Class(SetDoorLeftRotationEvent, Event);
  
InitEventClass(SetDoorLeftRotationEvent, "SetDoorLeftRotationEvent");
  
function SetDoorLeftRotationEvent:emptyNew()
      local self = Event:new(SetDoorLeftRotationEvent_mt);
      self.className="SetDoorLeftRotationEvent";
      return self;
 end;

function SetDoorLeftRotationEvent:new(object, rotationDoorLeftActive)
      local self = SetDoorLeftRotationEvent:emptyNew()
      self.object = object;
      self.rotationDoorLeftActive = rotationDoorLeftActive;
      return self;
end;
 
function SetDoorLeftRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationDoorLeftActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorLeftRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationDoorLeftActive);
end;
 
function SetDoorLeftRotationEvent:run(connection)
      self.object:setRotationDoorLeftActive(self.rotationDoorLeftActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self.object, self.rotationDoorLeftActive), nil, connection, self.object);
      end;
end;