--
-- Henly20 (Ls_uk Modteam)
-- 23.11.2010
--
-- > www.LS-UK.info

manDoors = {};

function manDoors.prerequisitesPresent(specializations)

    return true;
end;

function manDoors:load(xmlFile)
     self.setRotationDoorLeftActive = SpecializationUtil.callSpecializationsFunction("setRotationDoorLeftActive");
     self.setRotationDoorRightActive = SpecializationUtil.callSpecializationsFunction("setRotationDoorRightActive");
	 
	
	local rotationNodeDoorLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationDoorLeft#index"));
    if rotationNodeDoorLeft ~= nil then
        self.rotationDoorLeft = {};
        self.rotationDoorLeft.node = rotationNodeDoorLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDoorLeft#minRot"));
        self.rotationDoorLeft.minRot = {};
        self.rotationDoorLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDoorLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDoorLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDoorLeft#maxRot"));
        self.rotationDoorLeft.maxRot = {};
        self.rotationDoorLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDoorLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDoorLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationDoorLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDoorLeft#rotTime"), 2)*1000;
        self.rotationDoorLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDoorLeft#touchRotLimit"), 10));
    end;
	local rotationNodeDoorRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationDoorRight#index"));
    if rotationNodeDoorRight ~= nil then
        self.rotationDoorRight = {};
        self.rotationDoorRight.node = rotationNodeDoorRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDoorRight#minRot"));
        self.rotationDoorRight.minRot = {};
        self.rotationDoorRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDoorRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDoorRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDoorRight#maxRot"));
        self.rotationDoorRight.maxRot = {};
        self.rotationDoorRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDoorRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDoorRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationDoorRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDoorRight#rotTime"), 2)*1000;
        self.rotationDoorRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDoorRight#touchRotLimit"), 10));
    end;

		self.rotationDoorLeftActive = false;
		self.rotationDoorRightActive = false;
end;

function manDoors:readStream(streamId, connection)
     self.rotateDoorLeftActive = streamReadBool(streamId);
     if self.rotationDoorLeft ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationDoorLeft.node, x, y, z);
      end;
     if self.rotationDoorRight ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationDoorRight.node, x, y, z);
      end;
end;
  
function manDoors:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateDoorLeftActive);
		if self.rotationDoorLeft ~= nil then
          local x, y, z = getRotation(self.rotationDoorLeft.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationDoorRight ~= nil then
          local x, y, z = getRotation(self.rotationDoorRight.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function manDoors:delete()

end;

function manDoors:keyEvent(unicode, sym, modifier, isDown)


end;

function manDoors:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.MANDOORLEFT) then
				self:setRotationDoorLeftActive(not self.rotationDoorLeftActive);
          end;
          if InputBinding.hasEvent(InputBinding.MANDOORRIGHT) then
				self:setRotationDoorRightActive(not self.rotationDoorRightActive);
          end;
		  
     end;
end;

function manDoors:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationDoorLeft ~= nil then
				local x, y, z = getRotation(self.rotationDoorLeft.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationDoorLeft.maxRot, self.rotationDoorLeft.minRot, 3, self.rotationDoorLeft.rotTime, dt, not self.rotationDoorLeftActive);
				setRotation(self.rotationDoorLeft.node, unpack(newRot));
			end;
			if self.rotationDoorRight ~= nil then
				local x, y, z = getRotation(self.rotationDoorRight.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationDoorRight.maxRot, self.rotationDoorRight.minRot, 3, self.rotationDoorRight.rotTime, dt, not self.rotationDoorRightActive);
				setRotation(self.rotationDoorRight.node, unpack(newRot));
			end;
		
	end;		
end;

function manDoors:draw()

  
end;


function manDoors:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manDoors:setRotationDoorLeftActive(rotationDoorLeftActive, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self, rotationDoorLeftActive), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorLeftRotationEvent:new(self, rotationDoorLeftActive));
          end;
      end;
      self.rotationDoorLeftActive = rotationDoorLeftActive;
end;

function manDoors:setRotationDoorRightActive(rotationDoorRightActive, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationDoorRightActive), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationDoorRightActive));
          end;
      end;
      self.rotationDoorRightActive = rotationDoorRightActive;
end;



