--
-- JD9880iSTS
--
-- @author  MySQly
-- @Combine Spezialisation Stefan Geiger
-- @Internal Sound Script Templaer edit MySQly
-- @date  15/08/11
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

JD9880iSTS = {};
source("dataS/scripts/vehicles/specializations/CombineSetPipeStateEvent.lua");
source("dataS/scripts/vehicles/specializations/CombineSetThreshingEnabledEvent.lua");
source("dataS/scripts/vehicles/specializations/CombinePipeParticleActivatedEvent.lua");
source("dataS/scripts/vehicles/specializations/CombineAreaEvent.lua");
source("dataS/scripts/vehicles/specializations/CombineSetStrawEnableEvent.lua");
source("dataS/scripts/vehicles/specializations/CombineSetChopperEnableEvent.lua");
  
function JD9880iSTS.initSpecialization()
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
end;


function JD9880iSTS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD9880iSTS:load(xmlFile)
	self.switchSounds = SpecializationUtil.callSpecializationsFunction("switchSounds");
	
	self.maxRpmBackup = self.motor.maxRpm[2];
	self.repair = false;
	self.repairModeChange = false;
	self.repairT = 0;
	self.repairModeStage = 0;
	self.input = nil;
	self.motorRun = false;
	self.deactivateCutter = false;
	self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	self.allowIgnition = false;
	self.help = false;
	self.transport = true;
	self.sieczkarnia = false;
	self.kominek = false;
	self.KominekT = 0;
	self.heder = true;
	self.gasMode = 1;
	self.insideCamera = true;
	self.timerSita = 100;
	self.zbiornikOtwieranie = false;
	self.zbiornikTimer = 0;
	self.zbiornikTimerEnd = 0;
	self.zbiornikOtwieranie = false;
	self.specialDriveMode = false;
	self.maxSpeed = 0;
	self.TreshedTotalNumber = 0;
	self.TreshedNumber = 0;
	self.LitersPerHectar = 0;
	self.DrivenDiesel = 0;
	self.kontrolkaTimer = 0;
	self.warningTimer = 0;
	self.rpmWarning = false;
	self.thresherWarning = false;
	self.grainTankWarning = false;
	self.pipeLightWarning = false;
	self.thresherOffWarning = false;
	self.speedWarning = false;
	self.grainWarning = false;
	self.AIwarning = false;
	self.cutterOpeningWarning = false;
	self.DrivenDieselThreshing = 0;
	self.percent = 0.0;
	self.percentMaschine = 0.0;
	self.cutterName = "nil";
	self.cutterOpened = true;
	
	self.driveHandle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.driveHandle#index"));
	self.slimak = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
	self.podajnik = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podajnik#index"));
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
    self.numWorklights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights2#count"), 0);
    self.worklights2 = {};
    for i=1, self.numWorklights2 do
        local worklightnamei2 = string.format("vehicle.worklights2.worklight" .. "%d", i);
        self.worklights2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei2 .. "#index"));
        setVisibility(self.worklights2[i], false);
    end;	
	self.worklightsActive2 = false;
	
	turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
--^^^^^^^^^^^^ BY Teamplaer edit MySQly^^^^^^^^^^^^^^
	-- External Sounds
    local externalStartSound = getXMLString(xmlFile, "vehicle.motorStartSound#file");

    if externalStartSound ~= nil and externalStartSound ~= "" then
        externalStartSound = Utils.getFilename(externalStartSound, self.baseDirectory);
        self.externalStartSound = createSample("externalStartSound");
        loadSample(self.externalStartSound, externalStartSound, false);
    end;

    local externalStopSound = getXMLString(xmlFile, "vehicle.motorStopSound#file");
    if externalStopSound ~= nil and externalStopSound ~= "" then
        externalStopSound = Utils.getFilename(externalStopSound, self.baseDirectory);
        self.externalStopSound = createSample("externalStopSound");
        loadSample(self.externalStopSound, externalStopSound, false);
    end;

    local externalSound = getXMLString(xmlFile, "vehicle.motorSound#file");
    if externalSound ~= nil and externalSound ~= "" then
        externalSound = Utils.getFilename(externalSound, self.baseDirectory);
        self.externalSound = createSample("externalSound");
        loadSample(self.externalSound, externalSound, false);
    end;

    local externalCutterSound = getXMLString(xmlFile, "vehicle.cutterSound#file");
    if externalCutterSound ~= nil and externalCutterSound ~= "" then
        externalCutterSound = Utils.getFilename(externalCutterSound, self.baseDirectory);
        self.externalCutterSound = createSample("externalCutterSound");
        loadSample(self.externalCutterSound, externalCutterSound, false);
    end;
	
    local externalThreshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if externalThreshingSound ~= nil and externalThreshingSound ~= "" then
        externalThreshingSound = Utils.getFilename(externalThreshingSound, self.baseDirectory);
        self.externalThreshingSound = createSample("externalThreshingSound");
        loadSample(self.externalThreshingSound, externalThreshingSound, false);
    end;
	
    local externalThreshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if externalThreshingStartSound ~= nil and externalThreshingStartSound ~= "" then
        externalThreshingStartSound = Utils.getFilename(externalThreshingStartSound, self.baseDirectory);
        self.externalThreshingStartSound = createSample("externalThreshingStartSound");
        loadSample(self.externalThreshingStartSound, externalThreshingStartSound, false);
    end;
	
    local externalThreshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if externalThreshingStopSound ~= nil and externalThreshingStopSound ~= "" then
        externalThreshingStopSound = Utils.getFilename(externalThreshingStopSound, self.baseDirectory);
        self.externalThreshingStopSound = createSample("externalThreshingStopSound");
        loadSample(self.externalThreshingStopSound, externalThreshingStopSound, false);
    end;
	
	-- Internal Sounds
    local internalStartSound = getXMLString(xmlFile, "vehicle.internalStartSound#file");

    if internalStartSound ~= nil and internalStartSound ~= "" then
        internalStartSound = Utils.getFilename(internalStartSound, self.baseDirectory);
        self.internalStartSound = createSample("internalStartSound");
        loadSample(self.internalStartSound, internalStartSound, false);
    end;

    local internalStopSound = getXMLString(xmlFile, "vehicle.internalStopSound#file");
    if internalStopSound ~= nil and internalStopSound ~= "" then
        internalStopSound = Utils.getFilename(internalStopSound, self.baseDirectory);
        self.internalStopSound = createSample("internalStopSound");
        loadSample(self.internalStopSound, internalStopSound, false);
    end;

    local internalSound = getXMLString(xmlFile, "vehicle.internalSound#file");
    if internalSound ~= nil and internalSound ~= "" then
        internalSound = Utils.getFilename(internalSound, self.baseDirectory);
        self.internalSound = createSample("internalSound");
        loadSample(self.internalSound, internalSound, false);
    end;
	
    local internalCutterSound = getXMLString(xmlFile, "vehicle.internalCutterSound#file");
    if internalCutterSound ~= nil and internalCutterSound ~= "" then
        internalCutterSound = Utils.getFilename(internalCutterSound, self.baseDirectory);
        self.internalCutterSound = createSample("internalCutterSound");
        loadSample(self.internalCutterSound, internalCutterSound, false);
    end;
	
    local internalThreshingSound = getXMLString(xmlFile, "vehicle.internalThreshingSound#file");
    if internalThreshingSound ~= nil and internalThreshingSound ~= "" then
        internalThreshingSound = Utils.getFilename(internalThreshingSound, self.baseDirectory);
        self.internalThreshingSound = createSample("internalThreshingSound");
        loadSample(self.internalThreshingSound, internalThreshingSound, false);
    end;

    local internalThreshingStartSound = getXMLString(xmlFile, "vehicle.internalThreshingStartSound#file");
    if internalThreshingStartSound ~= nil and internalThreshingStartSound ~= "" then
        internalThreshingStartSound = Utils.getFilename(internalThreshingStartSound, self.baseDirectory);
        self.internalThreshingStartSound = createSample("internalThreshingStartSound");
        loadSample(self.internalThreshingStartSound, internalThreshingStartSound, false);
    end;
	
    local internalThreshingStopSound = getXMLString(xmlFile, "vehicle.internalThreshingStopSound#file");
    if internalThreshingStopSound ~= nil and internalThreshingStopSound ~= "" then
        internalThreshingStopSound = Utils.getFilename(internalThreshingStopSound, self.baseDirectory);
        self.internalThreshingStopSound = createSample("internalThreshingStopSound");
        loadSample(self.internalThreshingStopSound, internalThreshingStopSound, false);
    end;
	
	--^^^^^^^^^^^^ BY Teamplaer edit MySQly ^^^^^^^^^^^^^^
	
	local translationPartNodePrawaDrabina = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartPrawaDrabina#index"));
    if translationPartNodePrawaDrabina ~= nil then
        self.translationPartPrawaDrabina = {};
        self.translationPartPrawaDrabina.node = translationPartNodePrawaDrabina;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPrawaDrabina#minTrans"));
        self.translationPartPrawaDrabina.minTrans = {};
        self.translationPartPrawaDrabina.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPrawaDrabina.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPrawaDrabina.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPrawaDrabina#maxTrans"));
        self.translationPartPrawaDrabina.maxTrans = {};
        self.translationPartPrawaDrabina.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPrawaDrabina.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPrawaDrabina.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartPrawaDrabina.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPrawaDrabina#transTime"), 2)*1000;
        self.translationPartPrawaDrabina.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPrawaDrabina#touchTransLimit"), 10);
    end;
	
    local rotationPartNodePrawaDrabina = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPrawaDrabina#index"));
    if rotationPartNodePrawaDrabina ~= nil then
        self.rotationPartPrawaDrabina = {};
        self.rotationPartPrawaDrabina.node = rotationPartNodePrawaDrabina;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPrawaDrabina#minRot"));
        self.rotationPartPrawaDrabina.minRot = {};
        self.rotationPartPrawaDrabina.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawaDrabina.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawaDrabina.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPrawaDrabina#maxRot"));
        self.rotationPartPrawaDrabina.maxRot = {};
        self.rotationPartPrawaDrabina.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawaDrabina.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawaDrabina.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPrawaDrabina.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPrawaDrabina#rotTime"), 2)*1000;
        self.rotationPartPrawaDrabina.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPrawaDrabina#touchRotLimit"), 10));
    end;
	
    local rotationPartNodePraweDrzwi = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPraweDrzwi#index"));
    if rotationPartNodePraweDrzwi ~= nil then
        self.rotationPartPraweDrzwi = {};
        self.rotationPartPraweDrzwi.node = rotationPartNodePraweDrzwi;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPraweDrzwi#minRot"));
        self.rotationPartPraweDrzwi.minRot = {};
        self.rotationPartPraweDrzwi.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPraweDrzwi.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPraweDrzwi.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPraweDrzwi#maxRot"));
        self.rotationPartPraweDrzwi.maxRot = {};
        self.rotationPartPraweDrzwi.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPraweDrzwi.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPraweDrzwi.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPraweDrzwi.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPraweDrzwi#rotTime"), 2)*1000;
        self.rotationPartPraweDrzwi.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPraweDrzwi#touchRotLimit"), 10));
    end;
	
    local rotationPartNodePrawaKlapa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPrawaKlapa#index"));
    if rotationPartNodePrawaKlapa ~= nil then
        self.rotationPartPrawaKlapa = {};
        self.rotationPartPrawaKlapa.node = rotationPartNodePrawaKlapa;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPrawaKlapa#minRot"));
        self.rotationPartPrawaKlapa.minRot = {};
        self.rotationPartPrawaKlapa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawaKlapa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawaKlapa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPrawaKlapa#maxRot"));
        self.rotationPartPrawaKlapa.maxRot = {};
        self.rotationPartPrawaKlapa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawaKlapa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawaKlapa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPrawaKlapa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPrawaKlapa#rotTime"), 2)*1000;
        self.rotationPartPrawaKlapa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPrawaKlapa#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLewaKlapa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa#index"));
    if rotationPartNodeLewaKlapa ~= nil then
        self.rotationPartLewaKlapa = {};
        self.rotationPartLewaKlapa.node = rotationPartNodeLewaKlapa;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa#minRot"));
        self.rotationPartLewaKlapa.minRot = {};
        self.rotationPartLewaKlapa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewaKlapa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewaKlapa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa#maxRot"));
        self.rotationPartLewaKlapa.maxRot = {};
        self.rotationPartLewaKlapa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewaKlapa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewaKlapa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLewaKlapa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa#rotTime"), 2)*1000;
        self.rotationPartLewaKlapa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLewaKlapa2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa2#index"));
    if rotationPartNodeLewaKlapa2 ~= nil then
        self.rotationPartLewaKlapa2 = {};
        self.rotationPartLewaKlapa2.node = rotationPartNodeLewaKlapa2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa2#minRot"));
        self.rotationPartLewaKlapa2.minRot = {};
        self.rotationPartLewaKlapa2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewaKlapa2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewaKlapa2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa2#maxRot"));
        self.rotationPartLewaKlapa2.maxRot = {};
        self.rotationPartLewaKlapa2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewaKlapa2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewaKlapa2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLewaKlapa2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa2#rotTime"), 2)*1000;
        self.rotationPartLewaKlapa2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLewaKlapa2#touchRotLimit"), 10));
    end;
	
	local translationPartNodeSita = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartSita#index"));
    if translationPartNodeSita ~= nil then
        self.translationPartSita = {};
        self.translationPartSita.node = translationPartNodeSita;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartSita#minTrans"));
        self.translationPartSita.minTrans = {};
        self.translationPartSita.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartSita#maxTrans"));
        self.translationPartSita.maxTrans = {};
        self.translationPartSita.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartSita.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartSita#transTime"), 2)*1000;
        self.translationPartSita.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartSita#touchTransLimit"), 10);
    end;
	
    local rotationPartNodeKombajn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKombajn#index"));
    if rotationPartNodeKombajn ~= nil then
        self.rotationPartKombajn = {};
        self.rotationPartKombajn.node = rotationPartNodeKombajn;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKombajn#minRot"));
        self.rotationPartKombajn.minRot = {};
        self.rotationPartKombajn.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKombajn.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKombajn.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKombajn#maxRot"));
        self.rotationPartKombajn.maxRot = {};
        self.rotationPartKombajn.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKombajn.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKombajn.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKombajn.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKombajn#rotTime"), 2)*1000;
        self.rotationPartKombajn.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKombajn#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeKominek1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKominek1#index"));
    if rotationPartNodeKominek1 ~= nil then
        self.rotationPartKominek1 = {};
        self.rotationPartKominek1.node = rotationPartNodeKominek1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek1#minRot"));
        self.rotationPartKominek1.minRot = {};
        self.rotationPartKominek1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek1#maxRot"));
        self.rotationPartKominek1.maxRot = {};
        self.rotationPartKominek1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKominek1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek1#rotTime"), 2)*1000;
        self.rotationPartKominek1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeKominek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKominek2#index"));
    if rotationPartNodeKominek2 ~= nil then
        self.rotationPartKominek2 = {};
        self.rotationPartKominek2.node = rotationPartNodeKominek2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek2#minRot"));
        self.rotationPartKominek2.minRot = {};
        self.rotationPartKominek2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek2#maxRot"));
        self.rotationPartKominek2.maxRot = {};
        self.rotationPartKominek2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKominek2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek2#rotTime"), 2)*1000;
        self.rotationPartKominek2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek2#touchRotLimit"), 10));
    end;
	
	local translationPartNodeCamera = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartCamera#index"));
    if translationPartNodeCamera ~= nil then
        self.translationPartCamera = {};
        self.translationPartCamera.node = translationPartNodeCamera;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartCamera#minTrans"));
        self.translationPartCamera.minTrans = {};
        self.translationPartCamera.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartCamera.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartCamera.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartCamera#maxTrans"));
        self.translationPartCamera.maxTrans = {};
        self.translationPartCamera.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartCamera.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartCamera.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartCamera.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartCamera#transTime"), 2)*1000;
        self.translationPartCamera.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartCamera#touchTransLimit"), 10);
    end;
	
    local rotationPartNodeKierownica = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKierownica#index"));
    if rotationPartNodeKierownica ~= nil then
        self.rotationPartKierownica = {};
        self.rotationPartKierownica.node = rotationPartNodeKierownica;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKierownica#minRot"));
        self.rotationPartKierownica.minRot = {};
        self.rotationPartKierownica.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKierownica.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKierownica.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKierownica#maxRot"));
        self.rotationPartKierownica.maxRot = {};
        self.rotationPartKierownica.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKierownica.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKierownica.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKierownica.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKierownica#rotTime"), 2)*1000;
        self.rotationPartKierownica.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKierownica#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeHillmaster = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartHillmaster#index"));
    if rotationPartNodeHillmaster ~= nil then
        self.rotationPartHillmaster = {};
        self.rotationPartHillmaster.node = rotationPartNodeHillmaster;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#minRot"));
        self.rotationPartHillmaster.minRot = {};
        self.rotationPartHillmaster.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHillmaster.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHillmaster.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#maxRot"));
        self.rotationPartHillmaster.maxRot = {};
        self.rotationPartHillmaster.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHillmaster.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHillmaster.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartHillmaster.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#rotTime"), 2)*1000;
        self.rotationPartHillmaster.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#touchRotLimit"), 10));
    end;
	
	self.hydraulic4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index"));
	self.hydraulic2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index2"));
	self.hydraulic3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index3"));
	
    local rotationPartNodeAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAttacher#index"));
    if rotationPartNodeAttacher ~= nil then
        self.rotationPartAttacher = {};
        self.rotationPartAttacher.node = rotationPartNodeAttacher;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacher#minRot"));
        self.rotationPartAttacher.minRot = {};
        self.rotationPartAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacher#maxRot"));
        self.rotationPartAttacher.maxRot = {};
        self.rotationPartAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAttacher.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacher#rotTime"), 2)*1000;
        self.rotationPartAttacher.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacher#touchRotLimit"), 10));
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.kabina = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kabina#index"));
	
    self.robocze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.robocze#index"));
	self.roboczeSwiatla = false;
    setVisibility(self.robocze, self.roboczeSwiatla);
	
    self.tylnie = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tylnie#index"));
	self.tylnieSwiatla = false;
    setVisibility(self.tylnie, self.tylnieSwiatla);
	
    self.rura = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rura#index"));
	self.ruraSwiatla = false;
    setVisibility(self.rura, self.ruraSwiatla);
	
	self.controlpathWTS = Utils.getFilename("Scripts/menuWTS.png", self.baseDirectory);
    self.hudjohndeereWTSWidth = 0.8;
    self.hudjohndeereWTSHeight = 0.3;
	self.hudjohndeereWTSPoxX = 0.01;
    self.hudjohndeereWTSPoxY = 0.01;
    self.hudjohndeereWTSOverlay = Overlay:new("hudjohndeereWTSControl", self.controlpathWTS, self.hudjohndeereWTSPoxX, self.hudjohndeereWTSPoxY, self.hudjohndeereWTSWidth, self.hudjohndeereWTSHeight);
	
	self.controlpath625R = Utils.getFilename("Scripts/menu625R.png", self.baseDirectory);
    self.hudjohndeere625RWidth = 0.2;
    self.hudjohndeere625RHeight = 0.5;
	self.hudjohndeere625RPoxX = 0.79;
    self.hudjohndeere625RPoxY = 0.4;
    self.hudjohndeere625ROverlay = Overlay:new("hudjohndeere625RControl", self.controlpath625R, self.hudjohndeere625RPoxX, self.hudjohndeere625RPoxY, self.hudjohndeere625RWidth, self.hudjohndeere625RHeight);
	
	self.particleSystemsSieczkaRzepak = {};
    local particleSystemsSieczkaRzepakCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSieczkaRzepak#count"), 0);
    for i=1, particleSystemsSieczkaRzepakCount do
        local namei = string.format("vehicle.particleSystemsSieczkaRzepak.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSieczkaRzepak, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsMlocarniaRzepak = {};
    local particleSystemsMlocarniaRzepakCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsMlocarniaRzepak#count"), 0);
    for i=1, particleSystemsMlocarniaRzepakCount do
        local namei = string.format("vehicle.particleSystemsMlocarniaRzepak.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsMlocarniaRzepak, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsKurz = {};
    local particleSystemsKurzCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsKurz#count"), 0);
    for i=1, particleSystemsKurzCount do
        local namei = string.format("vehicle.particleSystemsKurz.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsKurz, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsSloma = {};
    local particleSystemsSlomaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSloma#count"), 0);
    for i=1, particleSystemsSlomaCount do
        local namei = string.format("vehicle.particleSystemsSloma.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSloma, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsSieczka = {};
    local particleSystemsSieczkaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSieczka#count"), 0);
    for i=1, particleSystemsSieczkaCount do
        local namei = string.format("vehicle.particleSystemsSieczka.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSieczka, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsMlocarnia = {};
    local particleSystemsMlocarniaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsMlocarnia#count"), 0);
    for i=1, particleSystemsMlocarniaCount do
        local namei = string.format("vehicle.particleSystemsMlocarnia.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsMlocarnia, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    local rotationPartNodeSieczkarnia = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#index"));
    if rotationPartNodeSieczkarnia ~= nil then
        self.rotationPartSieczkarnia = {};
        self.rotationPartSieczkarnia.node = rotationPartNodeSieczkarnia;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#minRot"));
        self.rotationPartSieczkarnia.minRot = {};
        self.rotationPartSieczkarnia.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#maxRot"));
        self.rotationPartSieczkarnia.maxRot = {};
        self.rotationPartSieczkarnia.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSieczkarnia.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#rotTime"), 2)*1000;
        self.rotationPartSieczkarnia.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeSieczkarnia2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia2#index"));
    if rotationPartNodeSieczkarnia2 ~= nil then
        self.rotationPartSieczkarnia2 = {};
        self.rotationPartSieczkarnia2.node = rotationPartNodeSieczkarnia2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia2#minRot"));
        self.rotationPartSieczkarnia2.minRot = {};
        self.rotationPartSieczkarnia2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia2#maxRot"));
        self.rotationPartSieczkarnia2.maxRot = {};
        self.rotationPartSieczkarnia2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSieczkarnia2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia2#rotTime"), 2)*1000;
        self.rotationPartSieczkarnia2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#index"));
    if rotationPartNodeZbiornik1 ~= nil then
        self.rotationPartZbiornik1 = {};
        self.rotationPartZbiornik1.node = rotationPartNodeZbiornik1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#minRot"));
        self.rotationPartZbiornik1.minRot = {};
        self.rotationPartZbiornik1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#maxRot"));
        self.rotationPartZbiornik1.maxRot = {};
        self.rotationPartZbiornik1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#rotTime"), 2)*1000;
        self.rotationPartZbiornik1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#index"));
    if rotationPartNodeZbiornik2 ~= nil then
        self.rotationPartZbiornik2 = {};
        self.rotationPartZbiornik2.node = rotationPartNodeZbiornik2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#minRot"));
        self.rotationPartZbiornik2.minRot = {};
        self.rotationPartZbiornik2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#maxRot"));
        self.rotationPartZbiornik2.maxRot = {};
        self.rotationPartZbiornik2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#rotTime"), 2)*1000;
        self.rotationPartZbiornik2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#index"));
    if rotationPartNodeZbiornik3 ~= nil then
        self.rotationPartZbiornik3 = {};
        self.rotationPartZbiornik3.node = rotationPartNodeZbiornik3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#minRot"));
        self.rotationPartZbiornik3.minRot = {};
        self.rotationPartZbiornik3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#maxRot"));
        self.rotationPartZbiornik3.maxRot = {};
        self.rotationPartZbiornik3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#rotTime"), 2)*1000;
        self.rotationPartZbiornik3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#index"));
    if rotationPartNodeZbiornik4 ~= nil then
        self.rotationPartZbiornik4 = {};
        self.rotationPartZbiornik4.node = rotationPartNodeZbiornik4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#minRot"));
        self.rotationPartZbiornik4.minRot = {};
        self.rotationPartZbiornik4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#maxRot"));
        self.rotationPartZbiornik4.maxRot = {};
        self.rotationPartZbiornik4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#rotTime"), 2)*1000;
        self.rotationPartZbiornik4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#index"));
    if rotationPartNodeZbiornik5 ~= nil then
        self.rotationPartZbiornik5 = {};
        self.rotationPartZbiornik5.node = rotationPartNodeZbiornik5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#minRot"));
        self.rotationPartZbiornik5.minRot = {};
        self.rotationPartZbiornik5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#maxRot"));
        self.rotationPartZbiornik5.maxRot = {};
        self.rotationPartZbiornik5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#rotTime"), 2)*1000;
        self.rotationPartZbiornik5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#index"));
    if rotationPartNodeZbiornik6 ~= nil then
        self.rotationPartZbiornik6 = {};
        self.rotationPartZbiornik6.node = rotationPartNodeZbiornik6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#minRot"));
        self.rotationPartZbiornik6.minRot = {};
        self.rotationPartZbiornik6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#maxRot"));
        self.rotationPartZbiornik6.maxRot = {};
        self.rotationPartZbiornik6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#rotTime"), 2)*1000;
        self.rotationPartZbiornik6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#index"));
    if rotationPartNodeZbiornik7 ~= nil then
        self.rotationPartZbiornik7 = {};
        self.rotationPartZbiornik7.node = rotationPartNodeZbiornik7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#minRot"));
        self.rotationPartZbiornik7.minRot = {};
        self.rotationPartZbiornik7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#maxRot"));
        self.rotationPartZbiornik7.maxRot = {};
        self.rotationPartZbiornik7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#rotTime"), 2)*1000;
        self.rotationPartZbiornik7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#index"));
    if rotationPartNodeZbiornik8 ~= nil then
        self.rotationPartZbiornik8 = {};
        self.rotationPartZbiornik8.node = rotationPartNodeZbiornik8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#minRot"));
        self.rotationPartZbiornik8.minRot = {};
        self.rotationPartZbiornik8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#maxRot"));
        self.rotationPartZbiornik8.maxRot = {};
        self.rotationPartZbiornik8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#rotTime"), 2)*1000;
        self.rotationPartZbiornik8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#index"));
    if rotationPartNodeZbiornik9 ~= nil then
        self.rotationPartZbiornik9 = {};
        self.rotationPartZbiornik9.node = rotationPartNodeZbiornik9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#minRot"));
        self.rotationPartZbiornik9.minRot = {};
        self.rotationPartZbiornik9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#maxRot"));
        self.rotationPartZbiornik9.maxRot = {};
        self.rotationPartZbiornik9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#rotTime"), 2)*1000;
        self.rotationPartZbiornik9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeDrabina = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrabina#index"));
    if rotationPartNodeDrabina ~= nil then
        self.rotationPartDrabina = {};
        self.rotationPartDrabina.node = rotationPartNodeDrabina;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrabina#minRot"));
        self.rotationPartDrabina.minRot = {};
        self.rotationPartDrabina.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrabina.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrabina.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrabina#maxRot"));
        self.rotationPartDrabina.maxRot = {};
        self.rotationPartDrabina.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrabina.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrabina.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrabina.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrabina#rotTime"), 2)*1000;
        self.rotationPartDrabina.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrabina#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeRura = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRura#index"));
    if rotationPartNodeRura ~= nil then
        self.rotationPartRura = {};
        self.rotationPartRura.node = rotationPartNodeRura;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRura#minRot"));
        self.rotationPartRura.minRot = {};
        self.rotationPartRura.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRura.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRura.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRura#maxRot"));
        self.rotationPartRura.maxRot = {};
        self.rotationPartRura.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRura.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRura.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRura.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRura#rotTime"), 2)*1000;
        self.rotationPartRura.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRura#touchRotLimit"), 10));
    end;
	
    local cutterSound = getXMLString(xmlFile, "vehicle.cutterSound#file");
    if cutterSound ~= nil and cutterSound ~= "" then
        cutterSound = Utils.getFilename(cutterSound, self.baseDirectory); 
        self.cutterSound = createSample("cutterSound");
        loadSample(self.cutterSound, cutterSound, false);
    end;
	
    local warnSound = getXMLString(xmlFile, "vehicle.warnSound#file");
    if warnSound ~= nil and warnSound ~= "" then
        warnSound = Utils.getFilename(warnSound, self.baseDirectory); 
        self.warnSound = createSample("warnSound");
        loadSample(self.warnSound, warnSound, false);
    end;
	
    local unloadingSound = getXMLString(xmlFile, "vehicle.unloadingSound#file");
    if unloadingSound ~= nil and unloadingSound ~= "" then
        unloadingSound = Utils.getFilename(unloadingSound, self.baseDirectory); 
        self.unloadingSound = createSample("unloadingSound");
        loadSample(self.unloadingSound, unloadingSound, false);
    end;
	
	self.warnSoundInternal = self.warnSound;
	self.unloadingSoundExternal = self.unloadingSound;
	
    local hydraulicSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if hydraulicSound ~= nil and hydraulicSound ~= "" then
        hydraulicSound = Utils.getFilename(hydraulicSound, self.baseDirectory); 
        self.hydraulicSound = createSample("hydraulicSound");
        loadSample(self.hydraulicSound, hydraulicSound, false);
    end;
	
	self.hydraulicSoundExternal = self.hydraulicSound;
	self.pipeSoundExternal = self.pipeSound;
	
--**********************************************************************
	self.allowGrainTankFruitType = JD9880iSTS.allowGrainTankFruitType;
    self.emptyGrainTankIfLowFillLevel = JD9880iSTS.emptyGrainTankIfLowFillLevel;
    self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
    self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
    self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
    self.setIsThreshing = SpecializationUtil.callSpecializationsFunction("setIsThreshing");
    self.setPipeOpening = SpecializationUtil.callSpecializationsFunction("setPipeOpening");
    self.setPipeState = SpecializationUtil.callSpecializationsFunction("setPipeState");
    self.getFruitTypeAndFillLevelToUnload = JD9880iSTS.getFruitTypeAndFillLevelToUnload;
    self.findAutoAimTrailerToUnload = JD9880iSTS.findAutoAimTrailerToUnload;
    self.findTrailerToUnload = JD9880iSTS.findTrailerToUnload;
    self.findTrailerRaycastCallback = JD9880iSTS.findTrailerRaycastCallback;
    self.getIshreshingAllowed = JD9880iSTS.getIshreshingAllowed;
 
    if self.isClient then
        local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
        if threshingStartSound ~= nil and threshingStartSound ~= "" then
            threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory);
            self.threshingStartSound = createSample("threshingStartSound");
            loadSample(self.threshingStartSound, threshingStartSound, false);
            self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);
            self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
            self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
        end;
        self.threshingSoundActive = false;
  
        local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
        if threshingSound ~= nil and threshingSound ~= "" then
            threshingSound = Utils.getFilename(threshingSound, self.baseDirectory);
            self.threshingSound = createSample("threshingSound");
            loadSample(self.threshingSound, threshingSound, false);
            self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
            self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
            self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
        end;
  
        local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
        if threshingStopSound ~= nil and threshingStopSound ~= "" then
            threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory);
            self.threshingStopSound = createSample("threshingStopSound");
            loadSample(self.threshingStopSound, threshingStopSound, false);
            self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
            self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
            self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
        end;
  
        local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
        if pipeSound ~= nil and pipeSound ~= "" then
            pipeSound = Utils.getFilename(pipeSound, self.baseDirectory);
            self.pipeSound = createSample("pipeSound");
            loadSample(self.pipeSound, pipeSound, false);
            self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
            self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
            self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
        end;
    end;
	
    self.chopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));
  
    self.pipeParticleSystems = {};
   
    self.pipeNodes = {};
    self.numPipeStates = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pipe#numStates"), 0);
    self.currentPipeState = 1;
    self.targetPipeState = 1;
    self.pipeStateIsUnloading = {};
    self.pipeStateIsAutoAiming = {};
    local unloadingPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#unloadingStates"));
    if unloadingPipeStates ~= nil then
        for i=1, table.getn(unloadingPipeStates) do
            if unloadingPipeStates[i] ~= nil then
                self.pipeStateIsUnloading[unloadingPipeStates[i] ] = true;
            end;
        end;
    end;
    local autoAimPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#autoAimStates"));
    if autoAimPipeStates ~= nil then
        for i=1, table.getn(autoAimPipeStates) do
            if autoAimPipeStates[i] ~= nil then
                self.pipeStateIsAutoAiming[autoAimPipeStates[i] ] = true;
            end;
        end;
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.pipe.node(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node ~= nil then
            local entry = {};
            entry.node = node;
            entry.autoAimXRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimXRotation"), false);
            entry.autoAimYRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimYRotation"), false);
            entry.autoAimInvertZ = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimInvertZ"), false);
            entry.states = {};
            for state=1,self.numPipeStates do
                local stateKey = key..string.format(".state%d", state);
                entry.states[state] = {};
                local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#translation"));
                if x == nil or y == nil or z == nil then
                    x,y,z = getTranslation(node);
                end;
                entry.states[state].translation = {x,y,z};
                local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#rotation"));
                if x == nil or y == nil or z == nil then
                    x,y,z = getRotation(node);
                else
                    x,y,z = math.rad(x),math.rad(y),math.rad(z);
                end;
                entry.states[state].rotation = {x,y,z};
            end;
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translationSpeeds"));
            if x ~= nil and y ~= nil and z ~= nil then
                x,y,z = x*0.001,y*0.001,z*0.001;
                if x ~= 0 or y ~= 0 or z ~= 0 then
                    entry.translationSpeeds = {x,y,z};
                end;
            end;
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotationSpeeds"));
            if x ~= nil and y ~= nil and z ~= nil then
                x,y,z = math.rad(x)*0.001,math.rad(y)*0.001,math.rad(z)*0.001;
                if x ~= 0 or y ~= 0 or z ~= 0 then
                    entry.rotationSpeeds = {x,y,z};
                end;
            end;
  
            local x,y,z = getTranslation(node);
            entry.curTranslation = {x,y,z};
            local x,y,z = getRotation(node);
            entry.curRotation = {x,y,z};
            table.insert(self.pipeNodes, entry);
        end;
        i = i + 1;
    end;
    if table.getn(self.pipeNodes) == 0 then
        -- use the old format
  
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
        if node ~= nil then
            self.numPipeStates = 2;
  
            local entry = {};
            entry.node = node;
            entry.states = {};
            entry.states[1] = {};
            entry.states[2] = {};
  
            local x,y,z = getRotation(node);
            entry.states[1].rotation = {0,0,z};
            entry.states[2].rotation = {math.rad(10),math.rad(-90),z};
  
            entry.rotationSpeeds = {0.00006, 0.0006, 0};
  
            local x,y,z = getRotation(node);
            entry.curRotation = {x,y,z};
  
            table.insert(self.pipeNodes, entry);
  
            self.pipeStateIsUnloading[2] = true;
        end;
    end;
  
    local pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));
    if pipeFlapLid ~= nil then
        if self.numPipeStates ~= 2 then
            print("Error: pipeFlapLid is only support with 2 pipe states in '"..self.configFileName.."'.");
        else
            local entry = {};
            entry.node = pipeFlapLid;
            entry.states = {};
            entry.states[1] = {};
            entry.states[2] = {};
  
            entry.states[1].rotation = {0,0,0};
            entry.states[2].rotation = {0,math.rad(-90),0};
  
            entry.rotationSpeeds = {0, 0.0006, 0};
  
            local x,y,z = getRotation(pipeFlapLid);
            entry.curRotation = {x,y,z};
  
            table.insert(self.pipeNodes, entry);
        end;
    end;
  
    if table.getn(self.pipeNodes) > 0 then
  
        self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));
  
        -- load the pipe particle system for each fruit type
        local i = 0;
        while true do
            local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;
  
            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};
  
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory, self.pipeNodes[1].node);
                self.pipeParticleSystems[desc.index] = currentPS;
                if self.defaultPipeParticleSystem == nil then
                    self.defaultPipeParticleSystem = currentPS;
                end;
  
                if self.pipeRaycastNode == nil then
                    self.pipeRaycastNode = particleNode;
                end;
            end;
            i = i + 1;
        end;
  
        if self.pipeRaycastNode == nil then
            self.pipeRaycastNode = self.components[1].node;
        end;
    end;
    self.pipeRaycastDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);
  
    self.convertedFruits = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.convertedFruits.convertedFruit(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local inputType = getXMLString(xmlFile, key .. "#input");
        local outputType = getXMLString(xmlFile, key .. "#output");
  
        if inputType ~= nil and outputType ~= nil then
            local inputDesc = FruitUtil.fruitTypes[inputType];
            local outputDesc = FruitUtil.fruitTypes[outputType];
            if inputDesc ~= nil and outputDesc ~= nil then
                self.convertedFruits[inputDesc.index] = outputDesc.index;
            end;
        end;
  
        i = i + 1;
    end;
  
    self.allowsThreshing = true;
  
	self.grainScale = {};
	local j = 1;
	while j <= 6 do
		self.grainScale[j] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainScale#index"..j..""));
		j = j +1
	end;
  
    self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));
 
    self.grainTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 200);
    self.grainTankUnloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankUnloadingCapacity"), 10);
    self.grainTankCrowded = false;
  
    self.allowThreshingDuringRain = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowThreshingDuringRain"), false);
  
  
    if self.isClient then
        -- grain planes
        self.grainTankPlanes = {};
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlanes.grainTankPlane(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end;
            local grainTankPlane = {};
            grainTankPlane.nodes = {};
            local fruitType = getXMLString(xmlFile, key.."#type");
            if fruitType ~= nil then
                local nodeI = 0;
                while true do
                    local nodeKey = key..string.format(".node(%d)", nodeI);
                    if not hasXMLProperty(xmlFile, nodeKey) then
                        break;
                    end;
                    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, nodeKey.."#index"));
                    if node ~= nil then
                        local defaultX, defaultY, defaultZ = getTranslation(node);
                        local defaultRX, defaultRY, defaultRZ = getRotation(node);
                        setVisibility(node, false);
  
                        local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
                        local keyI = 0;
                        while true do
                            local animKey = nodeKey..string.format(".key(%d)", keyI);
                            local keyTime = getXMLFloat(xmlFile, animKey.."#time");
                            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
                            if y == nil then
                                y = getXMLFloat(xmlFile, animKey.."#y");
                            end;
                            local rx,ry,rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
                            local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
                            if keyTime == nil then
                                break;
                            end;
                            local x = Utils.getNoNil(x, defaultX);
                            local y = Utils.getNoNil(y, defaultY);
                            local z = Utils.getNoNil(z, defaultZ);
                            local rx = Utils.getNoNil(rx, defaultRX);
                            local ry = Utils.getNoNil(ry, defaultRY);
                            local rz = Utils.getNoNil(rz, defaultRZ);
                            local sx = Utils.getNoNil(sx, 1);
                            local sy = Utils.getNoNil(sy, 1);
                            local sz = Utils.getNoNil(sz, 1);
                            animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
                            keyI = keyI +1;
                        end;
                        if keyI == 0 then
                            local minY, maxY = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxY"));
                            local minY = Utils.getNoNil(minY, defaultY);
                            local maxY = Utils.getNoNil(maxY, defaultY);
                            animCurve:addKeyframe({x=defaultX, y=minY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
                            animCurve:addKeyframe({x=defaultX, y=maxY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
                        end;
                        table.insert(grainTankPlane.nodes, {node=node, animCurve = animCurve});
                    end;
                    nodeI = nodeI +1;
                end;
                if table.getn(grainTankPlane.nodes) > 0 then
                    if self.defaultGrainTankPlane == nil then
                        self.defaultGrainTankPlane = grainTankPlane;
                    end;
					self.grainTankPlanes[fruitType] = grainTankPlane;
                end;
            end;
            i = i +1;
        end;
        if self.defaultGrainTankPlane==nil then
            self.grainTankPlanes = nil;
        end;
  
        if self.grainTankPlanes == nil then
            if hasXMLProperty(xmlFile, "vehicle.grainTankPlane.node") then
                print("Warning: '"..self.configFileName.. "' uses old grainTankPlane format, which is not supported anymore.");
            end;
        end;
  
        -- chopper particle system
        self.chopperParticleSystems = {};
        local i = 0;
        while true do
            local key = string.format("vehicle.chopperParticleSystems.chopperParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;
            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};
  
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
                self.chopperParticleSystems[desc.index] = currentPS;
                if self.defaultChopperParticleSystem == nil then
                    self.defaultChopperParticleSystem = currentPS;
                end;
            end;
            i = i + 1;
        end;
  
        self.chopperToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperParticleSystems#toggleTime"), 6000);
        self.chopperEnableTime = nil;
        self.chopperDisableTime = nil;
  
        -- start particle system
        self.strawParticleSystems = {};
        local i = 0;
        while true do
            local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;
            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};
  
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
                self.strawParticleSystems[desc.index] = currentPS;
                if self.defaultStrawParticleSystem == nil then
                    self.defaultStrawParticleSystem = currentPS;
                end;
            end;
            i = i + 1;
        end;
    end;
  
    self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 6000);
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
  
    self.strawEmitState = false;
  
 
    self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);
 
    local numStrawAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawAreas#count"), 0);
    self.strawAreas = {}
    for i=1, numStrawAreas do
        local area = {};
        local areanamei = string.format("vehicle.strawAreas.strawArea%d", i);
        area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
        table.insert(self.strawAreas, area);
    end;
 
    self.isThreshing = false;
    self.chopperActivated = false;
    self.defaultChopperState = false;
    --self.pipeOpening = false;
    --self.pipeOpen = false;
    --self.pipeClose = true;
    self.pipeIsUnloading = false;
    self.pipeParticleActivated = false;
    self.pipeParticleDeactivateTime = 0;
  
    --[[if self.isServer then
        self.sentPipeOpening = self.pipeOpening;
    end;]]
  
    self.threshingScale = 1;
  
    self.grainTankFruitTypes = {};
    self.grainTankFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
  
    local fruitTypes = getXMLString(xmlFile, "vehicle.grainTankFruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.grainTankFruitTypes[desc.index] = true;
            end;
        end;
    end;
 
    self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.grainTankFillLevel = 0;
 
    self.grainTankTempFillLevel = 0;
    self.grainTankTempFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 
    self.minThreshold = 0.05;
 
    self.speedDisplayScale = 1.0;
    self.drawFillLevel = true;
 
    self.attachedCutters = {};
    self.numAttachedCutters = 0;
 
    self.lastArea = 0;
    self.lastInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastValidInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastValidFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastValidOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.combineDirtyFlag = self:getNextDirtyFlag();

    self:setGrainTankFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN);
	
	self.reverseDriveSoundExternal = self.reverseDriveSound;
end;

function JD9880iSTS:delete()
    for k,v in pairs(self.pipeParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;

    if self.threshingStartSound ~= nil then
        delete(self.threshingStartSound);
    end;
    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;
    if self.threshingStopSound ~= nil then
        delete(self.threshingStopSound);
    end;
    if self.pipeSound ~= nil then
        delete(self.pipeSound);
    end;
	
    if self.cutterSound ~= nil then
        delete(self.cutterSound);
    end;
	
    if self.warnSound ~= nil then
        delete(self.warnSound);
    end;
	
    if self.hydraulicSound ~= nil then
        delete(self.hydraulicSound);
    end;
end;

--[[function JD9880iSTS:readStream(streamId, connection)
    local fillLevel = streamReadFloat32(streamId);
    local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
    self.pipeParticleActived = streamReadBool(streamId);
    self.pipeIsUnloading = streamReadBool(streamId);
    local pipeState = streamReadUIntN(streamId, 3);
    local isThreshing = streamReadBool(streamId);
    self:setGrainTankFillLevel(fillLevel, fillType);
    self:setPipeState(pipeState, true);
    self:setIsThreshing(isThreshing, true);
  
    local chopperPSenabled = streamReadBool(streamId);
    local chopperPSFruitType streamReadUIntN(streamId, FruitUtil.sendNumBits);
    local strawPSenabled = streamReadBool(streamId);
    local strawPSFruitType streamReadUIntN(streamId, FruitUtil.sendNumBits);
  
    CombineSetChopperEnableEvent.execute(self, chopperPSenabled, chopperPSFruitType);
    CombineSetStrawEnableEvent.execute(self, strawPSenabled, strawPSFruitType);
  
 
    self.lastValidFruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
    self.lastValidOutputFruitType = self.lastValidFruitType;
    if self.convertedFruits[self.lastValidFruitType] ~= nil then
        self.lastValidOutputFruitType = self.convertedFruits[self.lastValidFruitType];
    end;
  
    if self.lastValidFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidFruitType];
        if fruitDesc.hasStraw then
            self.chopperActivated = false;
        else
            self.chopperActivated = true;
        end;
    else
        self.chopperActivated = self.defaultChopperState;
    end;
end;

function JD9880iSTS:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.grainTankFillLevel);
    streamWriteUIntN(streamId, self.currentGrainTankFruitType, FruitUtil.sendNumBits);
    streamWriteBool(streamId, self.pipeParticleActived);
    streamWriteBool(streamId, self.pipeIsUnloading);
    streamWriteUIntN(streamId, self.targetPipeState, 3);
    streamWriteBool(streamId, self.isThreshing);
  
    streamWriteBool(streamId, self.chopperPSenabled);
    streamWriteUIntN(streamId, self.chopperPSFruitType, FruitUtil.sendNumBits);
    streamWriteBool(streamId, self.strawPSenabled);
    streamWriteUIntN(streamId, self.strawPSFruitType, FruitUtil.sendNumBits);
  
    streamWriteUIntN(streamId, self.lastValidFruitType, FruitUtil.sendNumBits);
end;
  
function JD9880iSTS:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        if streamReadBool(streamId) then
            local fillLevel = streamReadFloat32(streamId);
            local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
  
            self:setGrainTankFillLevel(fillLevel, fillType);
  
            self.lastValidFruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
            self.lastValidOutputFruitType = self.lastValidFruitType;
            if self.convertedFruits[self.lastValidFruitType] ~= nil then
                self.lastValidOutputFruitType = self.convertedFruits[self.lastValidFruitType];
            end;
  
            if self.lastValidFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidFruitType];
                if fruitDesc.hasStraw then
                    self.chopperActivated = false;
                else
                    self.chopperActivated = true;
                end;
            else
                self.chopperActivated = self.defaultChopperState;
            end;
        end;
    end;
end;
 
function JD9880iSTS:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        if streamWriteBool(streamId, bitAND(dirtyMask, self.combineDirtyFlag) ~= 0) then
            streamWriteFloat32(streamId, self.grainTankFillLevel);
            streamWriteUIntN(streamId, self.currentGrainTankFruitType, FruitUtil.sendNumBits);
            streamWriteUIntN(streamId, self.lastValidFruitType, FruitUtil.sendNumBits);
        end;
    end;
end;]]

function JD9880iSTS:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local fillLevel = getXMLFloat(xmlFile, key.."#grainTankFillLevel");
    local fruitType = getXMLString(xmlFile, key.."#grainTankFruitType");
    if fillLevel ~= nil and fruitType ~= nil then
        local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
        if fruitTypeDesc ~= nil then
            self:setGrainTankFillLevel(fillLevel, fruitTypeDesc.index);
        end;
    end;
	
	local DrivenDiesel = Utils.getNoNil(getXMLFloat(xmlFile, key.."#DrivenDiesel"), 0);
	self.DrivenDiesel = DrivenDiesel;
	local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
	self.TreshedTotalNumber = TreshedTotalNumber;
    return BaseMission.VEHICLE_LOAD_OK;
end;
  
function JD9880iSTS:getSaveAttributesAndNodes(nodeIdent)
    local fruitType = "unknown";
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
    end;
	local DrivenDiesel = Utils.getNoNil(self.DrivenDiesel, 10);
	local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
    local attributes = 'grainTankFillLevel="'..self.grainTankFillLevel..'" grainTankFruitType="'..fruitType..'"'..' TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"'..' DrivenDiesel="'..string.format("%f", DrivenDiesel)..'"';
    return attributes, nil;
end;
  
function JD9880iSTS:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function JD9880iSTS:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_m  then
		self.help = not self.help;
	end;
	
	if isDown and sym == Input.KEY_k then
		if self.zbiornikOtwarty then
			if self.isThreshing then 
				if self.gasMode == 3 then
					if self.cutterName == "jd625r" or (self.cutterName == "geringhoff8" and self.cutterOpened) then
						self.hederActive = not self.hederActive;
						for cutter,implement in pairs(self.attachedCutters) do
							local jointDesc = self.attacherJoints[implement.jointDescIndex];
							if self.hederActive then
								cutter:onStartReel();
							else
								cutter:onStopReel();
							end;
							if self.warnSound ~= nil then
								playSample(self.warnSound, 1, 1, 0);
							end;
						end;
					end;
				else
					self.rpmWarning = true;
				end;
			else
				self.thresherWarning = true;
			end;
		else
			self.grainTankWarning = true;
		end;
	end;
	
    if isDown and sym == Input.KEY_g then
        if self.grainTankFillLevel < self.grainTankCapacity then
            if self.isThreshing then
                self:stopThreshing();
				if self.warnSound ~= nil then
					playSample(self.warnSound, 1, 1, 0);
				end;
            else
				if self.zbiornikOtwarty then
					if self.warnSound ~= nil then
						playSample(self.warnSound, 1, 1, 0);
					end;
					self:startThreshing();
				else
					self.grainTankWarning = true;
				end;
            end;
        else
			self.grainWarning = true;
		end;
    end;
	
	if isDown and sym == Input.KEY_KP_period then
		self.motorRun = not self.motorRun;
		self.allowIgnition = true;
		self.gasMode = 1;
	end;
	
	if isDown and sym == Input.KEY_0 then
		self.gasMode = self.gasMode + 1;
	end;
	
	if isDown and sym == Input.KEY_9 then
		self.gasMode = self.gasMode - 1;
		if self.hederActive then
			for cutter,implement in pairs(self.attachedCutters) do
				local jointDesc = self.attacherJoints[implement.jointDescIndex];
				cutter:onStopReel();
			end;
			self.hederActive = false;
		end;
	end;
	
	if isDown and sym == Input.KEY_r then
        self.rundumleuchtenAn = not self.rundumleuchtenAn;
        for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
        end;
    end;
	
    if isDown and sym == Input.KEY_5 then
		self.roboczeSwiatla = not self.roboczeSwiatla;
	end;
	
    if isDown and sym == Input.KEY_u then
		if not self.isThreshing then
			if not self.zbiornikOtwieranie then
				self.zbiornikOtwieranie = true;
				if self.warnSound ~= nil then
					playSample(self.warnSound, 1, 1, 0);
				end;
				self.step = 1;
				if self.transport then
					self.rotationMaxDrabina = true;
					self.rotationMaxRura = true;
					self.zbiornikTimerEnd = 3000;
				else
					self.rotationMaxZbiornik3 = false;
					self.rotationMaxZbiornik4 = false;
					self.rotationMaxZbiornik5 = false;
					self.rotationMaxZbiornik6 = false;
					self.rotationMaxZbiornik7 = false;
					self.rotationMaxZbiornik8 = false;
					self.rotationMaxZbiornik9 = false;
					self.zbiornikTimerEnd = 5000;
					self.zbiornikOtwarty = false;
				end;
				self.transport = not self.transport;
			end;
		else
			self.thresherOffWarning = true;
		end;
	end;
	
    if isDown and sym == Input.KEY_j then
		if not self.isThreshing then
			self.sieczkarnia = not self.sieczkarnia;
			if self.warnSound ~= nil then
				playSample(self.warnSound, 1, 1, 0);
			end;
		else
			self.thresherOffWarning = true;
		end;
	end;
	
	if isDown and sym == Input.KEY_6 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.worklightsActive2 = false;
		self.flashWarner = false;
		self.warnLightActive = false;
	end;
	
	if isDown and sym == Input.KEY_7 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
		self.warnLightActive = false;
	end;
	
	if isDown and sym == Input.KEY_8 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.worklightsActive = false;
		self.flashWarner = false;
		self.warnLightActive = false;
	end;
	
	if sym == Input.KEY_c and isDown then
		self.insideCamera = not self.insideCamera;
		self:switchSounds();
	end;
	
	--[[if isDown and sym == Input.KEY_return then
		self.specialDriveMode = not self.specialDriveMode;
	end;]]
	
	if sym == Input.KEY_pagedown then
		self.rotationMaxAttacher = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_pageup then
		self.rotationMinAttacher = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_home then
		self.translationMaxCamera = isDown;
	end;
	
	if sym == Input.KEY_end then
		self.translationMinCamera = isDown;
	end;
	
	if sym == Input.KEY_KP_1 then
		self.rotationMinHillmaster = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_KP_3 then
		self.rotationMaxHillmaster = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if isDown and sym == Input.KEY_y and not self.repairModeChange then
		self.repair = not self.repair;
		if self.repair then
			self.rotationMaxPraweDrzwi = true;
		else
			self.rotationMaxPrawaDrabina = false;
		end;
		self.rotationMaxPrawaKlapa = not self.rotationMaxPrawaKlapa;
		self.rotationMaxLewaKlapa = not self.rotationMaxLewaKlapa;
		self.rotationMaxLewaKlapa2 = not self.rotationMaxLewaKlapa2;
		self.repairModeChange = true;
		self.repairModeStage = 1;
		self.repairT = 2000;
	end;
end;
  
function JD9880iSTS:update(dt)
	if self.hederActive and self.isEntered and  self.cutterName == "jd625r" then
		if not self.cutterSoundPlaying then
			playSample(self.cutterSound, 0, 1, 0);
			self.cutterSoundPlaying = true;
		end;
	else
		stopSample(self.cutterSound);
		self.cutterSoundPlaying = false;
	end;
	
	if self.changeAttacherMaxRotation then
		local x,y,z;
		if self.cutterName == "jd625r" then
			x, y, z = Utils.getVectorFromString("30 0 0");
		elseif self.cutterName == "geringhoff8" then
			x, y, z = Utils.getVectorFromString("22 0 0");
		end;
		self.rotationPartAttacher.maxRot = {};
		self.rotationPartAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.rotationPartAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.rotationPartAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));		
		self.changeAttacherMaxRotation = false;
	end;
	
	if self.sieczkarnia then
		self.rotationMaxSieczkarnia = true;
		self.rotationMaxSieczkarnia2 = true;
	else
		self.rotationMaxSieczkarnia = false;
		self.rotationMaxSieczkarnia2 = false;
	end;
	
	if self.repairModeChange then
		self.repairT = self.repairT - dt;
		if self.repairT <= 0 then
			if self.repairModeStage == 1 then
				self.translationMaxPrawaDrabina = self.repair;
				self.repairModeStage = 2;
				self.repairT = 1000;
			elseif self.repairModeStage == 2 then
				if self.repair then
					self.rotationMaxPrawaDrabina = true;
				else
					self.rotationMaxPraweDrzwi = false;
				end;
				self.repairModeStage = 3;
				self.repairT = 2000;
			else
				self.repairModeChange = false;
			end;
		end;
	end;
	
	if self.translationPartPrawaDrabina ~= nil then
		local x, y, z = getTranslation(self.translationPartPrawaDrabina.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartPrawaDrabina.maxTrans, self.translationPartPrawaDrabina.minTrans, 3, self.translationPartPrawaDrabina.transTime, dt, not self.translationMaxPrawaDrabina);
		setTranslation(self.translationPartPrawaDrabina.node, unpack(newTrans));
	end;
	
	if self.rotationPartLewaKlapa ~= nil then
		local x, y, z = getRotation(self.rotationPartLewaKlapa.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLewaKlapa.maxRot, self.rotationPartLewaKlapa.minRot, 3, self.rotationPartLewaKlapa.rotTime, dt, not self.rotationMaxLewaKlapa);
		setRotation(self.rotationPartLewaKlapa.node, unpack(newRot));
	end;
	
	if self.rotationPartLewaKlapa2 ~= nil then
		local x, y, z = getRotation(self.rotationPartLewaKlapa2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLewaKlapa2.maxRot, self.rotationPartLewaKlapa2.minRot, 3, self.rotationPartLewaKlapa2.rotTime, dt, not self.rotationMaxLewaKlapa2);
		setRotation(self.rotationPartLewaKlapa2.node, unpack(newRot));
	end;
	
	if self.rotationPartPrawaKlapa ~= nil then
		local x, y, z = getRotation(self.rotationPartPrawaKlapa.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPrawaKlapa.maxRot, self.rotationPartPrawaKlapa.minRot, 3, self.rotationPartPrawaKlapa.rotTime, dt, not self.rotationMaxPrawaKlapa);
		setRotation(self.rotationPartPrawaKlapa.node, unpack(newRot));
	end;
	
	if self.rotationPartPraweDrzwi ~= nil then
		local x, y, z = getRotation(self.rotationPartPraweDrzwi.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPraweDrzwi.maxRot, self.rotationPartPraweDrzwi.minRot, 3, self.rotationPartPraweDrzwi.rotTime, dt, not self.rotationMaxPraweDrzwi);
		setRotation(self.rotationPartPraweDrzwi.node, unpack(newRot));
	end;
	
	if self.rotationPartPrawaDrabina ~= nil then
		local x, y, z = getRotation(self.rotationPartPrawaDrabina.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPrawaDrabina.maxRot, self.rotationPartPrawaDrabina.minRot, 3, self.rotationPartPrawaDrabina.rotTime, dt, not self.rotationMaxPrawaDrabina);
		setRotation(self.rotationPartPrawaDrabina.node, unpack(newRot));
	end;
		
	if self.rotationPartSieczkarnia ~= nil then
		local x, y, z = getRotation(self.rotationPartSieczkarnia.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSieczkarnia.maxRot, self.rotationPartSieczkarnia.minRot, 3, self.rotationPartSieczkarnia.rotTime, dt, not self.rotationMaxSieczkarnia);
		setRotation(self.rotationPartSieczkarnia.node, unpack(newRot));
	end;
	
	if self.rotationPartSieczkarnia2 ~= nil then
		local x, y, z = getRotation(self.rotationPartSieczkarnia2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSieczkarnia2.maxRot, self.rotationPartSieczkarnia2.minRot, 3, self.rotationPartSieczkarnia2.rotTime, dt, not self.rotationMaxSieczkarnia2);
		setRotation(self.rotationPartSieczkarnia2.node, unpack(newRot));
	end;
		
	if self.rotationPartDrabina ~= nil then
		local x, y, z = getRotation(self.rotationPartDrabina.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDrabina.maxRot, self.rotationPartDrabina.minRot, 3, self.rotationPartDrabina.rotTime, dt, not self.rotationMaxDrabina);
		setRotation(self.rotationPartDrabina.node, unpack(newRot));
	end;
	
	if self.rotationPartRura ~= nil then
		local x, y, z = getRotation(self.rotationPartRura.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRura.maxRot, self.rotationPartRura.minRot, 3, self.rotationPartRura.rotTime, dt, not self.rotationMaxRura);
		setRotation(self.rotationPartRura.node, unpack(newRot));
	end;
	
	if self.rotationPartZbiornik1 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik1.maxRot, self.rotationPartZbiornik1.minRot, 3, self.rotationPartZbiornik1.rotTime, dt, not self.rotationMaxZbiornik1);
		setRotation(self.rotationPartZbiornik1.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik2 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik2.maxRot, self.rotationPartZbiornik2.minRot, 3, self.rotationPartZbiornik2.rotTime, dt, not self.rotationMaxZbiornik2);
		setRotation(self.rotationPartZbiornik2.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik3 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik3.maxRot, self.rotationPartZbiornik3.minRot, 3, self.rotationPartZbiornik3.rotTime, dt, not self.rotationMaxZbiornik3);
		setRotation(self.rotationPartZbiornik3.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik4 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik4.maxRot, self.rotationPartZbiornik4.minRot, 3, self.rotationPartZbiornik4.rotTime, dt, not self.rotationMaxZbiornik4);
		setRotation(self.rotationPartZbiornik4.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik5 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik5.maxRot, self.rotationPartZbiornik5.minRot, 3, self.rotationPartZbiornik5.rotTime, dt, not self.rotationMaxZbiornik5);
		setRotation(self.rotationPartZbiornik5.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik6 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik6.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik6.maxRot, self.rotationPartZbiornik6.minRot, 3, self.rotationPartZbiornik6.rotTime, dt, not self.rotationMaxZbiornik6);
		setRotation(self.rotationPartZbiornik6.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik7 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik7.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik7.maxRot, self.rotationPartZbiornik7.minRot, 3, self.rotationPartZbiornik7.rotTime, dt, not self.rotationMaxZbiornik7);
		setRotation(self.rotationPartZbiornik7.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik8 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik8.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik8.maxRot, self.rotationPartZbiornik8.minRot, 3, self.rotationPartZbiornik8.rotTime, dt, not self.rotationMaxZbiornik8);
		setRotation(self.rotationPartZbiornik8.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik9 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik9.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik9.maxRot, self.rotationPartZbiornik9.minRot, 3, self.rotationPartZbiornik9.rotTime, dt, not self.rotationMaxZbiornik9);
		setRotation(self.rotationPartZbiornik9.node, unpack(newRot));
	end;
	
	if self.zbiornikOtwieranie then
		self.zbiornikTimer = self.zbiornikTimer + dt;
		if self.zbiornikTimer > self.zbiornikTimerEnd then
			if not self.transport then
				if self.step == 1 then
					self.rotationMaxZbiornik1 = true;
					self.rotationMaxZbiornik2 = true;
					self.zbiornikTimerEnd = 5000;
					self.step = 2;
				elseif self.step == 2 then
					self.rotationMaxZbiornik3 = true;
					self.rotationMaxZbiornik4 = true;
					self.rotationMaxZbiornik5 = true;
					self.rotationMaxZbiornik6 = true;
					self.rotationMaxZbiornik7 = true;
					self.rotationMaxZbiornik8 = true;
					self.rotationMaxZbiornik9 = true;
					self.zbiornikTimerEnd = 6000;
					self.step = 3;
				else
					self.zbiornikOtwieranie = false;
					self.step = 0;
					self.zbiornikOtwarty = true
				end;
			else
				if self.step == 1 then
					self.rotationMaxZbiornik1 = false;
					self.rotationMaxZbiornik2 = false;
					self.zbiornikTimerEnd = 6000;
					self.step = 2;
				elseif self.step == 2 then
					self.rotationMaxDrabina = false;
					self.rotationMaxRura = false;
					self.zbiornikTimerEnd = 3000;
					self.step = 3;
				else
					self.zbiornikOtwieranie = false;
					self.step = 0;
				end;
			end;
			self.zbiornikTimer = 0;
		end;
	end;
	
	if self.gasMode == 1 then
		self.motor.minRpm = 200;
		self.timerSita = 200;
	elseif self.gasMode == 2 then
		self.motor.minRpm = -400;
		self.timerSita = 150;
	elseif self.gasMode == 3 then
		self.motor.minRpm = -1900;
		self.timerSita = 100;
	end;
	
	self.translationPartSita.transTime = self.timerSita;
	self.rotationPartKombajn.rotTime = self.timerSita;
	self.rotationPartKominek2.rotTime = self.timerSita;
	
	if self.gasMode > 3 then
		self.gasMode = 3;
	elseif self.gasMode < 1 then
		self.gasMode = 1;
	end;
	
	if self.isThreshing and self.slimak ~= nil and self.podajnik ~= nil then
		rotate(self.slimak, 0, dt*0.015, 0);
		rotate(self.podajnik, dt*0.015, 0, 0);
	end;
	
	if self.specialDriveMode then
		if self.isEntered then
			if self.driveHandle ~= nil then --middle 3.22 for 3.28 back 3.18
				local xHandle, yHandle, zHandle = getTranslation(self.driveHandle);
				local move = self.maxSpeed;
					if self.maxSpeed > 0 then
						zHandle = 2.68875 + (move/50000);
						if zHandle > 2.74184 then
							zHandle = 2.74184;
						end;
						xHandle = -0.4255;
					end;
					if self.maxSpeed == 0 then
						zHandle = 2.68875;
						xHandle = -0.41486;
					end;
					if self.maxSpeed < 0 then
						zHandle = 2.68875 - (move/50000)*-1;
						if zHandle < 2.64107 then
							zHandle = 2.64107;
						end;
						xHandle = -0.44258;
					end;
					setTranslation(self.driveHandle, xHandle, yHandle, zHandle);
			end;
			--[[
			self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			if InputBinding.isAxisZero(self.input) then
				self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			end;
			self.motor.speedLevel = 3;
			if self.input == -1 then
				if self.maxSpeed < 200 then
					self.maxSpeed = self.maxSpeed + 15
				elseif self.maxSpeed >= 200 and self.maxSpeed < 400 then
					self.maxSpeed = self.maxSpeed + 25
				elseif self.maxSpeed >= 400 and self.maxSpeed < 1900 then
					self.maxSpeed = self.maxSpeed + 45;
				elseif self.maxSpeed >= 1900 then
					self.maxSpeed = self.maxSpeed;
				end;
			elseif self.input == 1 then
				if self.maxSpeed > -200 then
					self.maxSpeed = self.maxSpeed - 15
				elseif self.maxSpeed <= -200 and self.maxSpeed > -400 then
					self.maxSpeed = self.maxSpeed - 25
				elseif self.maxSpeed <= -400 and self.maxSpeed > -1900 then
					self.maxSpeed = self.maxSpeed - 45;
				elseif self.maxSpeed <= -1900 then
					self.maxSpeed = self.maxSpeed;
				end;
			end;
				
			if InputBinding.isPressed(InputBinding.DRIVEMODESTOP) then
				self.maxSpeed = 0.0;
			end;

			local acceleration = 0;
			if g_currentMission.allowSteerableMoving and not self.playMotorSound then
				acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
				if InputBinding.isAxisZero(acceleration) then
					acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
				end;
				if math.abs(acceleration) > 0.8 then
					self.motor:setSpeedLevel(0, true)
				end;
				--self.motor.speedLevel = 3;
				if self.maxSpeed > 0 then
					acceleration = 1.0;
					self.motor.maxRpm[3] = self.maxSpeed;
				elseif self.maxSpeed < 0 then
					acceleration = -1.0;
					self.motor.maxRpm[3] = self.maxSpeed*-1;
				end;
			end;
				
			if self.steeringEnabled then		
				--if self.firstTimeRun then
					WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
				--end;	
			end;]]
		end;
	else
		if self.isEntered then
			--[[self.maxSpeed = 0;
			self.motor.maxRpm[2] = self.maxRpmBackup;
			local acceleration = 0.0;
			if g_currentMission.allowSteerableMoving and not self.playMotorSound then
				acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
				if InputBinding.isAxisZero(acceleration) then
					acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
				end;
				if math.abs(acceleration) > 0.8 then
					self.motor:setSpeedLevel(0, true)
				end;
				if self.motor.speedLevel ~= 0 then
					acceleration = 1.0;
				end;
			end;
			if self.steeringEnabled then		
				--if self.firstTimeRun then
					WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode);
				--end;	
			end;]]
			local xHandle, yHandle, zHandle = getTranslation(self.driveHandle);
			local move = (self.lastSpeed*self.speedDisplayScale*3600)/400;
			if self.motor.lastMotorRpm > self.motor.minRpm then
				if self.movingDirection == -1 then
					zHandle = 2.68875 + move*-1;
					if zHandle < 2.64107 then
						zHandle = 2.64107;
					end;
					xHandle = -0.44258;
				else
					zHandle = 2.68875 + move;
					if zHandle > 2.74184 then
						zHandle = 2.74184;
					end;
					xHandle = -0.4255;
				end;
			end;
			
			if self.motor.lastMotorRpm == self.motor.minRpm then
				zHandle = 2.68875;
				xHandle = -0.41486;
			end;
			setTranslation(self.driveHandle, xHandle, yHandle, zHandle);
		end;
	end;
	
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.worklightsActive2 = true;
				self.worklightsActive = true;
				self.warnLightActive = true;
				if self.attachedTrailer then
					self.blinkerleftActive = true;
					self.blinkerrightActive = true;
				end
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.worklightsActive2 = false;
				self.worklightsActive = false;
				self.warnLightActive = false;
				if self.attachedTrailer then
					self.blinkerleftActive = false;
					self.blinkerrightActive = false;
				end
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.worklightsActive2 = true;
				if self.attachedTrailer then
					self.blinkerrightActive = true;
				end
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.worklightsActive2 = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
		self.rotationMaxBlinkerLinks = false;
		self.rotationMaxBlinkerRechts = true;
	else
		if not self.flashWarner then
			self.worklightsActive2 = false;
			self.blinkerrightActive = false;
		end;
		self.rotationMaxBlinkerRechts = false;
	end;
		
		
	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashlightsLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 500;
				self.flashlightsLeftActive = true;
				self.worklightsActive = true;
				if self.attachedTrailer then
					self.blinkerleftActive = true;
				end
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashlightsLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 500;
				self.flashlightsLeftActive = false;
				self.worklightsActive = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
		self.rotationMaxBlinkerLinks = true;
		self.rotationMaxBlinkerRechts = false;
	else
		if not self.flashWarner then
			self.worklightsActive = false;
			self.blinkerleftActive = false;
		end;
		self.rotationMaxBlinkerLinks = false;
	end;
	
	if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
		
	if self.worklightsActive2 then
		for i=1, self.numWorklights2 do
			local worklight2 = self.worklights2[i];
			setVisibility(worklight2, self.worklightsActive2);
		end;
	else
		for i=1, self.numWorklights2 do
			local worklight2 = self.worklights2[i];
			setVisibility(worklight2, self.worklightsActive2, false);
		end;
	end;
	
	if not self.isAIThreshing then
		if self.motorRun then
			if self.allowIgnition then
				self.allowIgnition = false;
				self:startMotor();
			end;
			self.motorStopSoundVolume = 0;
			self.isMotorStarted = true;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true)
			
		else
			if self.allowIgnition then
				self.motorStopSoundVolume = self.motorStopSoundVolume2;
				self:stopMotor();
				JD9880iSTS.onDeactivate(self);
				self.allowIgnition = false;
				self.deactivateCutter = true;
			end;
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
			self.motorStopSoundVolume = 0;
			self:onDeactivateAttachements();
			self.isMotorStarted = false;
			Motorized.stopSounds(self);
			self.steeringEnabled = false;
			Utils.setEmittingState(self.exhaustParticleSystems, false)
		end;
	elseif not self.motorRun then
		self:stopAIThreshing();
	end;
	
	if self.isMotorStarted then
		self.DrivenDiesel = self.DrivenDiesel + self.lastMovedDistance*self.fuelUsage;
		if self.TreshedNumber ~= 0 and self.isThreshing and self.hederActive then
			if self.lastArea > 0 then
				self.DrivenDieselThreshing = self.DrivenDieselThreshing + self.lastMovedDistance*self.fuelUsage;
			end;
			self.LitersPerHectar = self.DrivenDieselThreshing / self.TreshedNumber;
		else
			self.LitersPerHectar = 0.0;
		end;
	end;
	
	if self.rpmWarning or self.thresherWarning or self.grainTankWarning or self.pipeLightWarning or self.speedWarning or self.thresherOffWarning or self.AIwarning or self.cutterOpeningWarning then
		self.warningTimer = self.warningTimer + dt;
		if self.warningTimer > 2000 then
			self.warningTimer = 0;
			self.rpmWarning = false;
			self.thresherWarning = false;
			self.grainTankWarning = false;
			self.pipeLightWarning = false;
			self.thresherOffWarning = false;
			self.speedWarning = false;
			self.grainWarning = false;
			self.AIwarning = false;
			self.cutterOpeningWarning = false;
		end;
		if self.rpmWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Too low RPM!\nUse NUM + to add more RPM.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Too low RPM!\nUse 0 to add more RPM.", 0.018, 0.033);
		elseif self.thresherWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Activate thresher!\nUse G to activate the thresher.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Activate thresher!\nUse G to activate the thresher.", 0.018, 0.033);
		elseif self.grainTankWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Open grain tank!\nUse U to open the grain tank.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Open grain tank!\nUse U to open the grain tank.", 0.018, 0.033);
		elseif self.pipeLightWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Turn work lights on!\nUse 4 to turn on work lights.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Turn work lights on!\nUse 4 to turn on work lights.", 0.018, 0.033);
		elseif self.thresherOffWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Deactivate thresher!\nUse G to deactivate thresher.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Deactivate thresher!\nUse G to deactivate thresher.", 0.018, 0.033);
		elseif self.grainWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Dump corn to continue threshing!");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Dump corn to continue threshing!", 0.018, 0.033);
		elseif self.speedWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Thresher overloaded!\n4-7 km/h is the optimal threshing speed.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Thresher overloaded!\n4-7 km/h is the optimal threshing speed.", 0.018, 0.033);
		elseif self.AIwarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "Deactivate AutoTrac!\nUse H to deactivate AutoTrac.");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("Deactivate AutoTrac!\nUse H to deactivate AutoTrac.", 0.018, 0.033);
		elseif self.cutterOpeningWarning then
			--setTextColor(1.0, 0.0, 0.0, 1.0);
			--renderText(0.28, 0.51, 0.04, "The cutter is opening!");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("The cutter is opening!", 0.018, 0.033);
		end;
	end;
	
	if self.roboczeSwiatla and self.targetPipeState == 2 then
		self.ruraSwiatla = true;
	else
		self.ruraSwiatla = false;
	end;	
	
	setVisibility(self.kabina, (self.insideCamera and self.roboczeSwiatla));
	setVisibility(self.robocze, self.roboczeSwiatla);
	setVisibility(self.tylnie, self.tylnieSwiatla);
	setVisibility(self.rura, self.ruraSwiatla);
	
	if self.roboczeSwiatla and self.movingDirection < 0 and not self.insideCamera then
		self.tylnieSwiatla = true;
	else
		self.tylnieSwiatla = false;
	end;

	if self.rotationPartHillmaster ~= nil and (self.rotationMaxHillmaster or self.rotationMinHillmaster) then
		local x, y, z = getRotation(self.rotationPartHillmaster.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartHillmaster.maxRot, self.rotationPartHillmaster.minRot, 3, self.rotationPartHillmaster.rotTime, dt, not self.rotationMaxHillmaster);
		setRotation(self.rotationPartHillmaster.node, unpack(newRot));
	end;
	
	if self.translationPartSita ~= nil then
		local x, y, z = getTranslation(self.translationPartSita.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartSita.maxTrans, self.translationPartSita.minTrans, 3, self.translationPartSita.transTime, dt, not self.translationMaxSita);
		setTranslation(self.translationPartSita.node, unpack(newTrans));
	end;
	
	if self.rotationPartKierownica ~= nil then
		local x, y, z = getRotation(self.rotationPartKierownica.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKierownica.maxRot, self.rotationPartKierownica.minRot, 3, self.rotationPartKierownica.rotTime, dt, not self.rotationMaxKierownica);
		setRotation(self.rotationPartKierownica.node, unpack(newRot));
	end;
	
	if self.rotationPartKombajn ~= nil then
		local x, y, z = getRotation(self.rotationPartKombajn.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKombajn.maxRot, self.rotationPartKombajn.minRot, 3, self.rotationPartKombajn.rotTime, dt, not self.rotationMaxKombajn);
		setRotation(self.rotationPartKombajn.node, unpack(newRot));
	end;
	
	local doTranslate = self.translationMaxCamera or self.translationMinCamera
	if self.translationPartCamera ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPartCamera.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartCamera.maxTrans, self.translationPartCamera.minTrans, 3, self.translationPartCamera.transTime, dt, not self.translationMaxCamera);
		setTranslation(self.translationPartCamera.node, unpack(newTrans));
	end;
	
	if self.kominek then
		if self.rotationPartKominek2 ~= nil then
			local x, y, z = getRotation(self.rotationPartKominek2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKominek2.maxRot, self.rotationPartKominek2.minRot, 3, self.rotationPartKominek2.rotTime, dt, not self.rotationMaxKominek2);
			setRotation(self.rotationPartKominek2.node, unpack(newRot));
		end;
		self.KominekT = self.KominekT + dt;
		if self.KominekT > self.timerSita then
			self.rotationMaxKominek2 = not self.rotationMaxKominek2;
			self.KominekT = 0;
			if self.isThreshing then
				self.rotationMaxKombajn = not self.rotationMaxKombajn;
				self.translationMaxSita = not self.translationMaxSita;
			end;
		end;
	end;
	if self.rotationPartKominek1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKominek1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKominek1.maxRot, self.rotationPartKominek1.minRot, 3, self.rotationPartKominek1.rotTime, dt, not self.rotationMaxKominek1);
		setRotation(self.rotationPartKominek1.node, unpack(newRot));
	end;

	if self.isThreshing then
		local pixelToQm = 2048 / 4096 * 2048 / 4096;
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
	end;
	
	if self.rotationPartAttacher ~= nil and (self.rotationMaxAttacher or self.rotationMinAttacher) then
		local x, y, z = getRotation(self.rotationPartAttacher.node);
		self.cutterLowPosition = (x > 0.35);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartAttacher.maxRot, self.rotationPartAttacher.minRot, 3, self.rotationPartAttacher.rotTime, dt, not self.rotationMaxAttacher);
		setRotation(self.rotationPartAttacher.node, unpack(newRot));
	end;
	
	local HydraulicX, HydraulicZ;
	local RotX, RotY, RotZ = getRotation(self.hydraulic2);
	HydraulicX = ((0.85 - (RotX/0.52360)*0.5)*-1);
	HydraulicZ = HydraulicX * 0.24;
	setTranslation(self.hydraulic4, HydraulicX, 0.0, HydraulicZ);
	setRotation(self.hydraulic3, RotX, RotY, RotZ);

 	if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	end;
		
	if self.rundumleuchtenAnz > 0 then
	  if self.rundumleuchtenAn then
		for i=1, self.rundumleuchtenAnz do
		  rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
		end;
	  end;
	end;
  
  	Utils.setEmittingState(self.particleSystemsKurz, (self.isThreshing and self.gasMode == 3));
	
    for cutter,implement in pairs(self.attachedCutters) do
        local jointDesc = self.attacherJoints[implement.jointDescIndex];
        jointDesc.moveDown = true;
	end;
	
--******************************************************************************
    if self:getIsActive() then
  
        if self.isClient then
            if self.isThreshing and self:getIsActiveForSound() then
                if not self.threshingSoundActive and self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                    playSample(self.threshingSound, 0, 1, 0);
                    self.threshingSoundActive = true;
                end;
            end;
        end;
  
        if self.isClient and self:getIsActiveForInput() then
  
            --[[if self.grainTankFillLevel < self.grainTankCapacity or self.grainTankCapacity <= 0 then
				if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
                    self:setIsThreshing(not self.isThreshing);
                end;
            end;]]
  
            if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
                local nextState = self.targetPipeState+1;
                if nextState > self.numPipeStates then
                    nextState = 1;
                end;
                self:setPipeState(nextState);
            end;
        end;
  
        if self.isServer then
            if self.grainTankFillLevel >= self.grainTankCapacity and self.grainTankCapacity > 0 then
                self:setIsThreshing(false);
            end;
        end;
  
  		if self.isThreshing and self.rotorFan ~= nil then
  			rotate(self.rotorFan, dt*0.01, 0, 0);
  		end;
  
  
        local chopperBlindRotationSpeed = 0.001;
        local minRotX = -83*3.1415/180.0;
        if self.chopperBlind ~= nil then
            local x,y,z = getRotation(self.chopperBlind);
            if self.chopperActivated then
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
            else
                x = x+dt*chopperBlindRotationSpeed;
                if x > 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.chopperBlind, x, y, z);
        end;
		
        local doAutoAiming = self.pipeStateIsAutoAiming[self.currentPipeState];
        local targetTrailer = nil;
        if doAutoAiming then
            targetTrailer = self:findAutoAimTrailerToUnload(self.lastValidOutputFruitType);
  
            if targetTrailer == nil then
                doAutoAiming = false;
            end;
        end;
        if (self.currentPipeState ~= self.targetPipeState or doAutoAiming) and self.targetPipeState <= self.numPipeStates then
            local autoAimX, autoAimY, autoAimZ;
            if doAutoAiming then
                autoAimX, autoAimY, autoAimZ = getWorldTranslation(targetTrailer.fillAutoAimTargetNode);
            end;
  
            local moved = false;
            for i=1, table.getn(self.pipeNodes) do
                local nodeMoved = false;
                local pipeNode = self.pipeNodes[i];
  
                local state = pipeNode.states[self.targetPipeState];
                if pipeNode.translationSpeeds ~= nil then
                    for i=1, 3 do
                        if pipeNode.curTranslation[i] ~= state.translation[i] then
                            nodeMoved = true;
                            if pipeNode.curTranslation[i] < state.translation[i] then
                                pipeNode.curTranslation[i] = math.min(pipeNode.curTranslation[i] + dt*pipeNode.translationSpeeds[i], state.translation[i]);
                            else
                                pipeNode.curTranslation[i] = math.max(pipeNode.curTranslation[i] - dt*pipeNode.translationSpeeds[i], state.translation[i]);
                            end;
                        end;
                    end;
                    setTranslation(pipeNode.node, pipeNode.curTranslation[1],pipeNode.curTranslation[2],pipeNode.curTranslation[3])
                end;
                if pipeNode.rotationSpeeds ~= nil then
                    for i=1, 3 do
                        local targetRotation = state.rotation[i];
                        if doAutoAiming then
                            if pipeNode.autoAimXRotation and i == 1 then
                                local x,y,z = getWorldTranslation(pipeNode.node);
                                local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
                                targetRotation = -math.atan2(y,z);
                                if pipeNode.autoAimInvertZ then
                                    targetRotation = targetRotation+math.pi;
                                end;
                                targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
                            elseif pipeNode.autoAimYRotation and i == 2 then
                                local x,y,z = getWorldTranslation(pipeNode.node);
                                local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
                                targetRotation = math.atan2(x,z);
                                if pipeNode.autoAimInvertZ then
                                    targetRotation = targetRotation+math.pi;
                                end;
                                targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
                            end;
                        end;
                        if pipeNode.curRotation[i] ~= targetRotation then
                            nodeMoved = true;
                            if pipeNode.curRotation[i] < targetRotation then
                                pipeNode.curRotation[i] = math.min(pipeNode.curRotation[i] + dt*pipeNode.rotationSpeeds[i], targetRotation);
                            else
                                pipeNode.curRotation[i] = math.max(pipeNode.curRotation[i] - dt*pipeNode.rotationSpeeds[i], targetRotation);
                            end;
                        end;
                    end;
                    setRotation(pipeNode.node, pipeNode.curRotation[1],pipeNode.curRotation[2],pipeNode.curRotation[3])
                end;
                moved = moved or nodeMoved;
  
                if nodeMoved and self.setMovingToolDirty ~= nil then
                    self:setMovingToolDirty(pipeNode.node);
                end;
            end;
            if not moved then
                self.currentPipeState = self.targetPipeState;
            end;
        end;
  
        if self.isClient then
            if self.motor ~= nil then
                if self.motor.speedLevel == 1 then
                    self.speedDisplayScale = 0.7;
                elseif self.motor.speedLevel == 2 or self.motor.speedLevel == 4 then
                    self.speedDisplayScale = 0.75;
                else
                    self.speedDisplayScale = 1.0;
                end;
            end;
  
            if self.currentPipeState ~= self.targetPipeState then
                if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                    if self:getIsActiveForSound() then
                        setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                        playSample(self.pipeSound, 0, 1, 0);
                        self.pipeSoundEnabled = true;
                    end;
                end;
            else
                if self.pipeSound ~= nil and self.pipeSoundEnabled then
                    stopSample(self.pipeSound);
                    self.pipeSoundEnabled = false;
                end;
            end;
        end;
  
    end;
  
end;
  
function JD9880iSTS:updateTick(dt)
    if self.isServer then
        if self.lastInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
            self.lastValidInputFruitType = self.lastInputFruitType;
        end;
        if self.lastFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
            self.lastValidFruitType = self.lastFruitType;
        end;
        if self.lastOutputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
            self.lastValidOutputFruitType = self.lastOutputFruitType;
        end;
        self.lastArea = 0;
        self.lastInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        self.lastFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        self.lastOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        self.grainTankTempFillLevel = 0;
  
        local disableChopperEmit = true;
        local disableStrawEmit = true;
  
        if self.isThreshing then
            local lastArea = 0;
			local percentArea = 0;
            local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            local inputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
                    if cutter.lastArea > 0 then
                        for cutter1,implement in pairs(self.attachedCutters) do
                            cutter1:setFruitType(cutter.currentInputFruitType);
                        end;
                        self.currentGrainTankFruitType = cutter.currentFruitType;
                        fruitType = cutter.currentFruitType;
                        inputFruitType = cutter.currentInputFruitType;
                        lastArea = lastArea + cutter.lastArea;
						percentArea = percentArea + cutter.percentArea;
                    end;
                end;
            end;
            self.lastArea = lastArea;
            self.lastFruitType = fruitType;
            self.lastInputFruitType = inputFruitType;
            local outputFruitType = fruitType;
            if self.convertedFruits[fruitType] ~= nil then
                outputFruitType = self.convertedFruits[fruitType];
            end;
            self.lastOutputFruitType = outputFruitType;
            if self.lastArea > 0 then
                local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
                if fruitDesc.hasStraw then
                    self.chopperActivated = false;
                else
                    self.chopperActivated = true;
                end;
  
                if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    self.chopperPSFruitType = fruitType;
                    disableChopperEmit = false;
                else
                    if self.strawEnableTime == nil then
                        self.strawEnableTime = self.time + self.strawToggleTime;
                    else
                        self.strawDisableTime = nil;
                    end;
                    self.strawPSFruitType = fruitType;
                    disableStrawEmit = false;
                end;
  
                -- 8000/1200 = 6.66 liter/meter
                -- 8000/1200 / 6 = 1.111 liter/m^2
                -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
                local pixelToSqm = g_currentMission:getFruitPixelsToSqm()  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
                local literPerSqm = 1;
                if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                    literPerSqm = FruitUtil.fruitIndexToDesc[fruitType].literPerSqm; -- * (1 + 0.5 * (3 - g_currentMission.missionStats.difficulty));
                    if (outputFruitType ~= fruitType and outputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                        literPerSqm = literPerSqm * FruitUtil.fruitIndexToDesc[outputFruitType].literPerSqm;
                    end;
					self.percent = percentArea * 8.2 + FruitUtil.fruitIndexToDesc[fruitType].literPerSqm * 15;
                end;
  
                --local literPerPixel = 8000/1200 / 6 / (2*2);
  
                --literPerPixel = literPerPixel*1.5;
                local sqm = self.lastArea*pixelToSqm;
  
                local deltaFillLevel = sqm*literPerSqm*self.threshingScale;
  
                if self.grainTankCapacity > 0 then
                    local newFillLevel = self.grainTankFillLevel+deltaFillLevel;
                    self:setGrainTankFillLevel(newFillLevel, outputFruitType);
                else
                    self.grainTankTempFillLevel = deltaFillLevel;
                    self.grainTankTempFruitType = outputFruitType;
                end;
            else
				self.percent = 0.0;
			end;
        end;
		
		if self.percent ~= 0 then
			if self.percentMaschine > self.percent then
				self.percentMaschine = self.percentMaschine-0.025*dt;
			end;
			if self.percentMaschine < self.percent then
				self.percentMaschine = self.percentMaschine+0.015*dt;
			end;
		else
			self.percentMaschine = self.percentMaschine-0.025*dt;
		end;
		
		local kmh = self.lastSpeed*self.speedDisplayScale*3600;
		if kmh > 8 and self.isThreshing and self.hederActive and self.lastArea ~= 0 then
			self.percentMaschine = self.percentMaschine + 5;
		end;
		
		if self.percentMaschine > 100 then
			self.percentMaschine = 100;
		elseif self.percentMaschine < 0 then
			self.percentMaschine = 0
		end;
		
		self.speedWarning = (self.percentMaschine > 80);
		
        if disableChopperEmit and self.chopperDisableTime == nil then
            self.chopperDisableTime = self.time + self.chopperToggleTime;
        end;
        if disableStrawEmit and self.strawDisableTime == nil then
            self.strawDisableTime = self.time + self.strawToggleTime;
        end;
  
        if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
            self.chopperPSenabled = true;
            self.chopperEnableTime = nil;
			Utils.setEmittingState(self.particleSystemsSieczkaRzepak, true);
			Utils.setEmittingState(self.particleSystemsMlocarniaRzepak, true);
			self.sieczkarnia = true;
        end;
        if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
            
            self.strawEnableTime = nil;
            self.strawEmitState = true;
			Utils.setEmittingState(self.particleSystemsMlocarnia, true);
			if self.sieczkarnia then
				Utils.setEmittingState(self.particleSystemsSieczka, true);
				self.strawPSenabled = false;
				Utils.setEmittingState(self.particleSystemsSloma, false);
			else
				Utils.setEmittingState(self.particleSystemsSloma, true);
				self.strawPSenabled = true;
				Utils.setEmittingState(self.particleSystemsSieczka, false);
			end;
        end;
        if self.strawEmitState and not self.sieczkarnia then
            local cuttingAreasSend = {};
            for k, strawArea in pairs(self.strawAreas) do
                local x,y,z = getWorldTranslation(strawArea.start);
                local x1,y1,z1 = getWorldTranslation(strawArea.width);
                local x2,y2,z2 = getWorldTranslation(strawArea.height);
                local old, total = Utils.getFruitWindrowArea(self.strawPSFruitType, x, z, x1, z1, x2, z2);
                local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
                value = math.min(value, g_currentMission.maxWindrowValue);
                --Utils.updateFruitWindrowArea(self.strawPSFruitType, x, z, x1, z1, x2, z2, value, true);
                table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2,value});
            end;
  
            if (table.getn(cuttingAreasSend) > 0) then
                CombineAreaEvent.runLocally(cuttingAreasSend, self.strawPSFruitType);
                g_server:broadcastEvent(CombineAreaEvent:new(cuttingAreasSend, self.strawPSFruitType));
            end;
        end;
  
  
        self.pipeIsUnloading = false;
        self.pipeParticleActivated = false;
        if self.pipeStateIsUnloading[self.currentPipeState] then
            local fruitType, fillLevel, useGrainTank = self:getFruitTypeAndFillLevelToUnload();
            if fillLevel > 0 then
                self.pipeParticleActivated = true;
                self.pipeIsUnloading = true;
  
                -- test if we should drain the grain tank
                local trailer = self:findTrailerToUnload(fruitType);
                if trailer == nil then
                    self.pipeIsUnloading = false;
                else
                    trailer:resetFillLevelIfNeeded(FruitUtil.fruitTypeToFillType[fruitType]);
 
                    local deltaLevel = fillLevel;
                    if useGrainTank then
                        deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
                    end;
                    deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
  
                    fillLevel = fillLevel-deltaLevel;
                    if fillLevel <= 0.0 then
                        deltaLevel = deltaLevel+fillLevel;
                        fillLevel = 0.0;
                        self.pipeIsUnloading = false;
                    elseif deltaLevel == 0 then
                        self.pipeIsUnloading = false;
                    end;
                    if useGrainTank then
                        self:setGrainTankFillLevel(fillLevel, fruitType);
                    end;
                    trailer:setFillLevel(trailer.fillLevel+deltaLevel, FruitUtil.fruitTypeToFillType[fruitType]);
                end;
                if not self.pipeIsUnloading and useGrainTank then
                    self.pipeParticleActivated = false;
                end;
            end;
        end;
  
  
        if self.grainTankFillLevel ~= self.sentGrainTankFillLevel or self.currentGrainTankFruitType ~= self.sentGrainTankFruitType or self.lastValidFruitType ~= self.sentLastValidFruitType then
            --g_server:broadcastEvent(CombineFillEvent:new(self, self.grainTankFillLevel, self.currentGrainTankFruitType), nil, nil, self);
            self:raiseDirtyFlags(self.combineDirtyFlag);
            self.sentGrainTankFillLevel = self.grainTankFillLevel;
            self.sentGrainTankFruitType = self.currentGrainTankFruitType;
            self.sentLastValidFruitType = self.lastValidFruitType;
        end;
        if self.pipeParticleActivated ~= self.sentPipeParticleActivated or self.pipeIsUnloading ~= self.sentPipeIsUnloading then
            g_server:broadcastEvent(CombinePipeParticleActivatedEvent:new(self, self.pipeParticleActivated, self.pipeIsUnloading), nil, nil, self);
            self.sentPipeParticleActivated = self.pipeParticleActivated;
            self.sentPipeIsUnloading = self.pipeIsUnloading;
        end;
        if self.chopperPSenabled~= self.sentChopperPSenabled or (self.chopperPSenabled and self.chopperPSFruitType ~= self.sentChopperPSFruitType) then
            g_server:broadcastEvent(CombineSetChopperEnableEvent:new(self, self.chopperPSenabled, self.chopperPSFruitType), true, nil, self);
            self.sentChopperPSFruitType = self.chopperPSFruitType;
            self.sentChopperPSenabled = self.chopperPSenabled;
        end
        if self.strawPSenabled ~= self.sentStrawPSenabled or (self.strawPSenabled and self.strawPSFruitType ~= self.sentStrawPSFruitType) then
            g_server:broadcastEvent(CombineSetStrawEnableEvent:new(self, self.strawPSenabled, self.strawPSFruitType), true, nil, self);
            self.sentStrawPSFruitType = self.strawPSFruitType;
            self.sentStrawPSenabled = self.strawPSenabled;
        end;
  
        if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
            self.chopperPSenabled = false;
			Utils.setEmittingState(self.particleSystemsSieczkaRzepak, false);
			Utils.setEmittingState(self.particleSystemsMlocarniaRzepak, false);
            self.chopperDisableTime = nil;
        end;
        if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
            self.strawPSenabled = false;
            self.strawDisableTime = nil;
            self.strawEmitState = false;
			Utils.setEmittingState(self.particleSystemsMlocarnia, false);
			Utils.setEmittingState(self.particleSystemsSloma, false);
			Utils.setEmittingState(self.particleSystemsSieczka, false);
        end;
    end;
  
    if self.pipeParticleActivated then
        self.pipeParticleDeactivateTime = self.time + 100;
        local currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
        if currentPipeParticleSystem == nil then
            currentPipeParticleSystem = self.defaultPipeParticleSystem;
        end;
        if currentPipeParticleSystem ~= self.currentPipeParticleSystem then
            if self.currentPipeParticleSystem ~= nil then
                Utils.setEmittingState(self.currentPipeParticleSystem, false);
            end;
        end;
        self.currentPipeParticleSystem = currentPipeParticleSystem;
        Utils.setEmittingState(self.currentPipeParticleSystem, true);
    else
        if self.pipeParticleDeactivateTime <= self.time and self.currentPipeParticleSystem ~= nil then
            Utils.setEmittingState(self.currentPipeParticleSystem, false);
            self.currentPipeParticleSystem = nil;
        end;
    end;
end;
  
function JD9880iSTS:draw()
	if self.help then
		if self.hudjohndeereWTSOverlay ~= nil then
			self.hudjohndeereWTSOverlay:render();
			-- FIRST COLUMN
			setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.015, 0.1, 0.022, string.format("Today threshed hectares: %.1f",self.TreshedNumber));
			renderText(0.015, 0.074, 0.022, string.format("Total hectares Threshed: %.1f",self.TreshedTotalNumber));
			renderText(0.015, 0.048, 0.022, string.format("Liters per hectar %.1fl/ha",self.LitersPerHectar));
			renderText(0.015, 0.022, 0.022, string.format("Driven diesel: %.0fl ",self.DrivenDiesel));
			
			-- SECOND COLUMN
			renderText(0.25, 0.178, 0.022, "F - Light");
			renderText(0.25, 0.152, 0.022, "Y - Reapair mode");
			renderText(0.25, 0.126, 0.022, "5 - Work/Pipe light");
			renderText(0.25, 0.1, 0.022, "R - Beacon");
			renderText(0.25, 0.072, 0.022, "6 - Trafficators");
			renderText(0.25, 0.048, 0.022, "8 - Trafficators");
			renderText(0.25, 0.022, 0.022, "7 - Emergency lights");
			
			-- THIRD COLUMN
			local green = 1.0;
			local red = 1.0;
			green = green - self.percentMaschine/100;
			red = self.percentMaschine/100;
			setTextColor(red, green, 0.0, 1.0);
			renderText(0.42, 0.178, 0.022, string.format("Grain tonnage: %.0f",self.percentMaschine).."%");
			setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.42, 0.152, 0.022, "U - Grain Tank");
			renderText(0.42, 0.126, 0.022, "G - Activate thresher");
			renderText(0.42, 0.1, 0.022, "K - Activate cutter");
			renderText(0.42, 0.072, 0.022, "J - Chaff-cutter");
			renderText(0.42, 0.048, 0.022, "0 - Gassing");
			renderText(0.42, 0.022, 0.022, "9 - Gassing");
			
			-- FOURTH COLUMN
			renderText(0.58, 0.178, 0.022, "PAGE UP - Cutter lifting");
			renderText(0.58, 0.152, 0.022, "PAGE DOWN - Cutter lifting");
			renderText(0.58, 0.126, 0.022, "END - Move interior camera");
			renderText(0.58, 0.1, 0.022, "HOME - Move interior camera");
			renderText(0.58, 0.072, 0.022, "KP DEL - Ignition");
			renderText(0.58, 0.048, 0.022, "Available in v2.0");
			renderText(0.58, 0.022, 0.022, "Available in v2.0");
			--if self.specialDriveMode then
				--renderText(0.58, 0.048, 0.022, "ENTER - Hydrostatique");
			--else
			--	renderText(0.58, 0.048, 0.022, "ENTER - Normal");
			--end;
			--renderText(0.58, 0.022, 0.022, "SPACE - Stop hydrostatique");
			setTextColor(1.0, 1.0, 1.0, 1.0);
		end;
		g_currentMission:addExtraPrintText("M    -    Hide HUD");
	else
		g_currentMission:addExtraPrintText("M    -    Show HUD");
	end;
	
    local percent = self.grainTankFillLevel/self.grainTankCapacity*100;
    if self.drawFillLevel then
        self:drawGrainLevel(self.grainTankFillLevel, self.grainTankCapacity, 95);
    end;
    if self.targetPipeState == 2 and not self.pipeParticleActivated and self.grainTankFillLevel > 0 then
        g_currentMission:addExtraPrintText(g_i18n:getText("Move_the_pipe_over_a_trailer"));
    elseif self.grainTankFillLevel == self.grainTankCapacity then
        g_currentMission:addExtraPrintText(g_i18n:getText("Dump_corn_to_continue_threshing"));
    end;
	if self.numPipeStates == 2 then
        if self.targetPipeState == 2 then
            g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
        else
            if percent > 80 then
                g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
            end;
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        g_currentMission.fruitOverlays[self.currentGrainTankFruitType]:render();
    end;
  
end;
  
function JD9880iSTS:onEnter(isControlling)
	if self.motorRun then
		self.isMotorStarted = true;
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, true)
	else
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
		self:onDeactivateAttachements();
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false);
	end;
	
    if self.isThreshingStarted then
        self.playThreshingSound = true;
    end;
	self.kominek = true;
	self.rotationMaxKierownica = true;
	self.insideCamera = true;
	self:switchSounds();
	self.maxSpeed = 0;
end;
  
function JD9880iSTS:onLeave()
	if self.motorRun then
		self.isMotorStarted = true;
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, true);
		if self.hederActive then
			for cutter,implement in pairs(self.attachedCutters) do
				local jointDesc = self.attacherJoints[implement.jointDescIndex];
				cutter:onStartReel();
			end;
		end;
	else
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
		self:onDeactivateAttachements();
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	end;
	
    --[[if self.deactivateOnLeave then
        JD9880iSTS.onDeactivate(self);
	end;]]
    JD9880iSTS.onDeactivateSounds(self)
	self.kominek = false;
	self.rotationMaxKominek1 = false;
	self.rotationMaxKierownica = false;
    --[[if self.deactivateOnLeave then
        JD9880iSTS.onDeactivate(self);
    else
        JD9880iSTS.onDeactivateSounds(self)
    end;]]
end;
  
function JD9880iSTS:onDeactivate()

    self:stopThreshing();
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
  
    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
    self.strawEmitState = false;
    JD9880iSTS.onDeactivateSounds(self)
end;
  
function JD9880iSTS:onDeactivateSounds()
    if self.pipeSound ~= nil and self.pipeSoundEnabled then
        stopSample(self.pipeSound);
        self.pipeSoundEnabled = false;
    end;
    if self.threshingSoundActive then
        stopSample(self.threshingSound);
        self.threshingSoundActive = false;
    end;
end;
  
function JD9880iSTS:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
        -- cutter assumes the thresher's loaded fruit type
        object:setFruitType(self.currentGrainTankFruitType);
    end;
end;
  
function JD9880iSTS:detachImplement(implementIndex)
    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
        end;
        self.attachedCutters[object] = nil;
    end;
end;
  
function JD9880iSTS:allowGrainTankFruitType(fruitType)
    local allowed = false;
  
    if self.grainTankFruitTypes[fruitType] then -- is fruit type accepted by combine?
        if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then -- is combine currently not empty?
            if self.currentGrainTankFruitType ~= fruitType then -- is there another fill type in the tank?
                if self.grainTankCapacity == 0 or self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
                    allowed = true; -- fill level is low enough to be overridden
                end;
            else
                allowed = true; -- fill type is the same as the combine's current fill type
            end;
        else
            allowed = true; -- combine is empty --> FruitUtil.FRUITTYPE_UNKNOWN
        end;
    end;
  
    return allowed;
end;
  
function JD9880iSTS:emptyGrainTankIfLowFillLevel()
    if self.grainTankCapacity == 0 or self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
        self.grainTankFillLevel = 0; -- empty the combine
        --return true;
    end;
    --return false;
end;
  
function JD9880iSTS:setGrainTankFillLevel(fillLevel, fruitType)

    if not self:allowGrainTankFruitType(fruitType) then
        return;
    end;
 
    --self:emptyGrainTankIfLowFillLevel();
  
    self.grainTankFillLevel = Utils.clamp(fillLevel, 0, self.grainTankCapacity);
  
    self.currentGrainTankFruitType = fruitType;
 
    if self.isClient then
        if self.currentGrainTankPlane ~= nil then
            for _, node in ipairs(self.currentGrainTankPlane.nodes) do
                setVisibility(node.node, false);
            end;
            self.currentGrainTankPlane = nil;
        end;
        if self.grainTankPlanes ~= nil and self.defaultGrainTankPlane ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
            local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
            local grainPlane = self.grainTankPlanes[fruitTypeName];
            if grainPlane == nil then
                grainPlane = self.defaultGrainTankPlane;
            end;
            local t = self.grainTankFillLevel/self.grainTankCapacity
            for _, node in ipairs(grainPlane.nodes) do
                local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
				local yTranslation = 0;
				local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
				setVisibility(grainPlane.nodePipe, procent > 65);
				local ScaleY = 1.0;
				local ScaleZ = 1.0;
				ScaleY = ScaleY + (0.198 * (procent/100));
				if procent > 70 then
					local transX, transY, transZ = getTranslation(node.node);
					ScaleZ = 1.0 + (transY/0.47041*0.36);
				end;
				local j = 1;
				while j <= 6 do
					setScale(self.grainScale[j], 1.0, ScaleY,ScaleZ);
					j = j + 1;
				end;
				--setScale(node.node, 1.0, 1.0,ScaleZ);
                setTranslation(node.node, x, y, z);
                setRotation(node.node, rx, ry, rz);
                --setScale(node.node, sx, sy, sz);
                setVisibility(node.node, self.grainTankFillLevel > 0);
            end;
            self.currentGrainTankPlane = grainPlane;
        end;
    end;
  
    if self.grainTankFillLevel <= 0 then
        for cutter,implement in pairs(self.attachedCutters) do
            cutter:resetFruitType();
        end;
        self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    else
        for cutter,implement in pairs(self.attachedCutters) do
            cutter:setFruitType(self.currentGrainTankFruitType);
        end;
    end;
end;
  
function JD9880iSTS:startThreshing()
  
    if not self.isThreshing then
        if self.numAttachedCutters > 0 then
            self.chopperActivated = self.defaultChopperState;
            self.isThreshing = true;
            --[[for cutter,implement in pairs(self.attachedCutters) do
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                --jointDesc.moveDown = true;

                cutter:setReelSpeed(0.003);
                cutter:onStartReel();
            end;]]
            --if self.threshingSound ~= nil then
            --    setSamplePitch(self.threshingSound, math.min(self.threshingSoundPitchOffset + self.threshingSoundPitchScale*math.abs(self.lastSoundSpeed), self.threshingSoundPitchMax));
            --   playSample(self.threshingSound, 0, 1, 0);
            --end;


            if not self.isThreshingStarted then

                self.isThreshingStarted = true;

                local threshingSoundOffset = 0;
                if self.threshingStartSound ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
                    playSample(self.threshingStartSound, 1, 1, 0);
                    threshingSoundOffset = getSampleDuration(self.threshingStartSound);
                end;

                self.playThreshingSound = true;
                self.playThreshingSoundTime = self.time+threshingSoundOffset;

            end;
        end;
    end;
end;
  
function JD9880iSTS:stopThreshing()
    if self.isThreshing then
        self.isThreshingStarted = false;
        self.playThreshingSound = false;

        if self.threshingSound ~= nil then
            stopSample(self.threshingSound);
        end;
		
		self.motor.motorMaxRpm = nil;
		self.motor:setSpeedLevel(0, false);
		
        if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
            setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
            playSample(self.threshingStopSound, 1, 1, 0);
            self.threshingSoundActive = false;
        end;

        self.chopperActivated = false;
        self.isThreshing = false;
        for cutter,implement in pairs(self.attachedCutters) do
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            --jointDesc.moveDown = false;

            cutter:onStopReel();
        end;
    end;
end;
  
function JD9880iSTS:setPipeOpening(pipeOpening, noEventSend)
    if pipeOpening then
        self:setPipeState(2, noEventSend);
    else
        self:setPipeState(1, noEventSend);
    end;
end;
  
function JD9880iSTS:setPipeState(pipeState, noEventSend)
    if self.targetPipeState ~= pipeState then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(CombineSetPipeStateEvent:new(self, pipeState));
            else
                g_client:getServerConnection():sendEvent(CombineSetPipeStateEvent:new(self, pipeState), nil, nil, self);
            end;
        end;
        self.targetPipeState = pipeState;
        self.currentPipeState = 0;
    end;
end;
  
function JD9880iSTS:setIsThreshing(isThreshing, noEventSend)
    if isThreshing ~= self.isThreshing then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(CombineSetThreshingEnabledEvent:new(self, isThreshing), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(CombineSetThreshingEnabledEvent:new(self, isThreshing));
            end;
        end;
        if isThreshing then
            self:startThreshing();
        else
            self:stopThreshing();
        end;
    end;
end;
  
function JD9880iSTS:getIshreshingAllowed(earlyWarning)
    if self.allowThreshingDuringRain then
        return true;
    end;
    if earlyWarning ~= nil and earlyWarning == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
			return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;
  
function JD9880iSTS:getFruitTypeAndFillLevelToUnload()
    local fillLevel = self.grainTankFillLevel;
    local fruitType = self.currentGrainTankFruitType;
    local useGrainTank = self.grainTankCapacity > 0;
    if not useGrainTank then
        fillLevel = self.grainTankTempFillLevel;
        fruitType = self.grainTankTempFruitType;
    end;
    return fruitType, fillLevel, useGrainTank;
end;
  
function JD9880iSTS:findAutoAimTrailerToUnload(fruitType)
    local trailer = nil;
    local smallestTrailerId = nil;
    if self.trailersInRange ~= nil then
        for trailerInRange, pipeStage in pairs(self.trailersInRange) do
            if trailerInRange:allowFillType(FruitUtil.fruitTypeToFillType[fruitType]) and trailerInRange.allowFillFromAir and trailerInRange.fillLevel < trailerInRange.capacity then
                local id = networkGetObjectId(trailerInRange);
                -- always take the trailer with the smalles network id. This is deterministic and is the same on the client
                if trailer == nil or id < smallestTrailerId then
                    trailer = trailerInRange;
                    smallestTrailerId = id;
                end;
            end;
        end;
    end;
    return trailer;
end;
  
function JD9880iSTS:findTrailerToUnload(fruitType)
  
    local x,y,z = getWorldTranslation(self.pipeRaycastNode);
    local dx,dy,dz = localDirectionToWorld(self.pipeRaycastNode, 0,-1,0);
  
    self.trailerFound = 0;
    raycastAll(x, y, z, dx,dy,dz, "findTrailerRaycastCallback", self.pipeRaycastDistance, self);

    local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
    if trailer == nil or not trailer:allowFillType(FruitUtil.fruitTypeToFillType[fruitType]) or not trailer.allowFillFromAir or trailer.fillLevel >= trailer.capacity then
        return nil;
    end;
    return trailer;
end;
  
function JD9880iSTS:findTrailerRaycastCallback(transformId, x, y, z, distance)
    local vehicle = g_currentMission.nodeToVehicle[transformId];
    if vehicle ~= nil then
        if vehicle.exactFillRootNode == transformId then
            self.trailerFound = transformId;
            return false;
        end;
    end;
    return true;
end;

function JD9880iSTS:switchSounds()
	if self.isMotorStarted then	
		stopSample(self.motorSound);
		stopSample(self.cutterSound);
		if self.isThreshing then
			stopSample(self.threshingSound);
		end;
		stopSample(self.hydraulicSound);
		stopSample(self.pipeSound);
		stopSample(self.reverseDriveSound);
		stopSample(self.unloadingSound);
		self.unloadingSoundPlaying = false;
		self.hydrualicSoundPlaying = false;
	end;
	
	if not self.insideCamera then
		self.motorStartSound = self.externalStartSound;
		self.motorStopSound = self.externalStopSound;
		self.motorSound = self.externalSound;
		self.cutterSound = self.externalCutterSound;
		self.threshingSound = self.externalThreshingSound;
		self.threshingStartSound = self.externalThreshingStartSound;
		self.threshingStopSound = self.externalThreshingStopSound;
		self.pipeSound = self.pipeSoundExternal;
		self.pipeSound = self.pipeSoundExternal;
		self.hydraulicSound = self.hydraulicSoundExternal;
		self.reverseDriveSound = self.reverseDriveSoundExternal;
		self.warnSound = nil;
		self.unloadingSound = self.unloadingSoundExternal
	else
		self.motorStartSound = self.internalStartSound;
		self.motorStopSound = self.internalStopSound;
		self.motorSound = self.internalSound;
		self.cutterSound = self.internalCutterSound;
		self.threshingSound = self.internalThreshingSound;
		self.threshingStartSound = self.internalThreshingStartSound;
		self.threshingStopSound = self.internalThreshingStopSound;
		self.pipeSound = nil;
		self.hydraulicSound = nil;
		self.reverseDriveSound = nil;
		self.warnSound = self.warnSoundInternal;
		self.unloadingSound = nil;
	end;
	
	if self.isMotorStarted then	
		playSample(self.motorSound, 0, 1, 0);
		if self.isThreshing then
			playSample(self.threshingSound, 0, 1, 0);
			if self.hederActive and self.cutterName == "jd625r" then
				playSample(self.cutterSound, 0, 1, 0);
			end;
		end;
		self.playMotorSound = true;
	end;
end;