--
-- JD9680WTS
-- www.landwirtschafts.eu
--
-- @author  MySQly
-- @Combine Spezialisation Stefan Geiger
-- @Internal Sound Script Templaer edit MySQly
-- @date  15/01/10
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

JD9680WTS = {};

function JD9680WTS.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD9680WTS:load(xmlFile)
	self.switchSounds = SpecializationUtil.callSpecializationsFunction("switchSounds");
	
	self.motorRun = false;
	self.deactivateCutter = false;
	self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	self.allowIgnition = false;
	self.help = false;
	self.transport = true;
	self.sieczkarnia = false;
	self.kominek = false;
	self.KominekT = 0;
	self.heder = true;
	self.gasMode = 1;
	self.insideCamera = true;
	self.timerSita = 100;
	self.zbiornikOtwieranie = false;
	self.zbiornikTimer = 0;
	self.zbiornikTimerEnd = 0;
	self.zbiornikOtwieranie = false;
	self.specialDriveMode = false;
	self.maxSpeed = 0;
	self.TreshedTotalNumber = 0;
	self.TreshedNumber = 0;
	self.LitersPerHectar = 0;
	self.DrivenDiesel = 0;
	self.Productivity = 0;
	self.kontrolkaTimer = 0;
	self.warningTimer = 0;
	self.rpmWarning = false;
	self.thresherWarning = false;
	self.grainTankWarning = false;
	self.pipeLightWarning = false;
	self.thresherOffWarning = false;
	self.speedWarning = false;
	self.grainWarning = false;
	self.AIwarning = false;
	self.cutterOpeningWarning = false;
	self.DrivenDiesel = 0;
	self.DrivenDieselThreshing = 0;
	self.percent = 0.0;
	self.percentMaschine = 0.0;
	self.cutterName = "nil";
	self.cutterOpened = true;
	
	self.hydraulic = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index"));
	self.hydraulic2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index2"));
	self.hydraulic3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#index3"));
	
    local rotationPartNodeAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAttacher#index"));
    if rotationPartNodeAttacher ~= nil then
        self.rotationPartAttacher = {};
        self.rotationPartAttacher.node = rotationPartNodeAttacher;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacher#minRot"));
        self.rotationPartAttacher.minRot = {};
        self.rotationPartAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacher#maxRot"));
        self.rotationPartAttacher.maxRot = {};
        self.rotationPartAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAttacher.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacher#rotTime"), 2)*1000;
        self.rotationPartAttacher.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacher#touchRotLimit"), 10));
    end;
	
	--^^^^^^^^^^^^ BY Teamplaer edit MySQly^^^^^^^^^^^^^^
	-- External Sounds
    local externalStartSound = getXMLString(xmlFile, "vehicle.motorStartSound#file");

    if externalStartSound ~= nil and externalStartSound ~= "" then
        externalStartSound = Utils.getFilename(externalStartSound, self.baseDirectory);
        self.externalStartSound = createSample("externalStartSound");
        loadSample(self.externalStartSound, externalStartSound, false);
    end;

    local externalStopSound = getXMLString(xmlFile, "vehicle.motorStopSound#file");
    if externalStopSound ~= nil and externalStopSound ~= "" then
        externalStopSound = Utils.getFilename(externalStopSound, self.baseDirectory);
        self.externalStopSound = createSample("externalStopSound");
        loadSample(self.externalStopSound, externalStopSound, false);
    end;

    local externalSound = getXMLString(xmlFile, "vehicle.motorSound#file");
    if externalSound ~= nil and externalSound ~= "" then
        externalSound = Utils.getFilename(externalSound, self.baseDirectory);
        self.externalSound = createSample("externalSound");
        loadSample(self.externalSound, externalSound, false);
    end;

    local externalCutterSound = getXMLString(xmlFile, "vehicle.cutterSound#file");
    if externalCutterSound ~= nil and externalCutterSound ~= "" then
        externalCutterSound = Utils.getFilename(externalCutterSound, self.baseDirectory);
        self.externalCutterSound = createSample("externalCutterSound");
        loadSample(self.externalCutterSound, externalCutterSound, false);
    end;
	
    local externalThreshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if externalThreshingSound ~= nil and externalThreshingSound ~= "" then
        externalThreshingSound = Utils.getFilename(externalThreshingSound, self.baseDirectory);
        self.externalThreshingSound = createSample("externalThreshingSound");
        loadSample(self.externalThreshingSound, externalThreshingSound, false);
    end;
	
    local externalThreshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if externalThreshingStartSound ~= nil and externalThreshingStartSound ~= "" then
        externalThreshingStartSound = Utils.getFilename(externalThreshingStartSound, self.baseDirectory);
        self.externalThreshingStartSound = createSample("externalThreshingStartSound");
        loadSample(self.externalThreshingStartSound, externalThreshingStartSound, false);
    end;
	
    local externalThreshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if externalThreshingStopSound ~= nil and externalThreshingStopSound ~= "" then
        externalThreshingStopSound = Utils.getFilename(externalThreshingStopSound, self.baseDirectory);
        self.externalThreshingStopSound = createSample("externalThreshingStopSound");
        loadSample(self.externalThreshingStopSound, externalThreshingStopSound, false);
    end;
	
	-- Internal Sounds
    local internalStartSound = getXMLString(xmlFile, "vehicle.internalStartSound#file");

    if internalStartSound ~= nil and internalStartSound ~= "" then
        internalStartSound = Utils.getFilename(internalStartSound, self.baseDirectory);
        self.internalStartSound = createSample("internalStartSound");
        loadSample(self.internalStartSound, internalStartSound, false);
    end;

    local internalStopSound = getXMLString(xmlFile, "vehicle.internalStopSound#file");
    if internalStopSound ~= nil and internalStopSound ~= "" then
        internalStopSound = Utils.getFilename(internalStopSound, self.baseDirectory);
        self.internalStopSound = createSample("internalStopSound");
        loadSample(self.internalStopSound, internalStopSound, false);
    end;

    local internalSound = getXMLString(xmlFile, "vehicle.internalSound#file");
    if internalSound ~= nil and internalSound ~= "" then
        internalSound = Utils.getFilename(internalSound, self.baseDirectory);
        self.internalSound = createSample("internalSound");
        loadSample(self.internalSound, internalSound, false);
    end;
	
    local internalCutterSound = getXMLString(xmlFile, "vehicle.internalCutterSound#file");
    if internalCutterSound ~= nil and internalCutterSound ~= "" then
        internalCutterSound = Utils.getFilename(internalCutterSound, self.baseDirectory);
        self.internalCutterSound = createSample("internalCutterSound");
        loadSample(self.internalCutterSound, internalCutterSound, false);
    end;
	
    local internalThreshingSound = getXMLString(xmlFile, "vehicle.internalThreshingSound#file");
    if internalThreshingSound ~= nil and internalThreshingSound ~= "" then
        internalThreshingSound = Utils.getFilename(internalThreshingSound, self.baseDirectory);
        self.internalThreshingSound = createSample("internalThreshingSound");
        loadSample(self.internalThreshingSound, internalThreshingSound, false);
    end;

    local internalThreshingStartSound = getXMLString(xmlFile, "vehicle.internalThreshingStartSound#file");
    if internalThreshingStartSound ~= nil and internalThreshingStartSound ~= "" then
        internalThreshingStartSound = Utils.getFilename(internalThreshingStartSound, self.baseDirectory);
        self.internalThreshingStartSound = createSample("internalThreshingStartSound");
        loadSample(self.internalThreshingStartSound, internalThreshingStartSound, false);
    end;
	
    local internalThreshingStopSound = getXMLString(xmlFile, "vehicle.internalThreshingStopSound#file");
    if internalThreshingStopSound ~= nil and internalThreshingStopSound ~= "" then
        internalThreshingStopSound = Utils.getFilename(internalThreshingStopSound, self.baseDirectory);
        self.internalThreshingStopSound = createSample("internalThreshingStopSound");
        loadSample(self.internalThreshingStopSound, internalThreshingStopSound, false);
    end;
	
	--^^^^^^^^^^^^ BY Teamplaer edit MySQly ^^^^^^^^^^^^^^
	

	
	self.driveHandle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.driveHandle#index"));
	self.slimak = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
	self.podajnik = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podajnik#index"));
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
    self.numWorklights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights2#count"), 0);
    self.worklights2 = {};
    for i=1, self.numWorklights2 do
        local worklightnamei2 = string.format("vehicle.worklights2.worklight" .. "%d", i);
        self.worklights2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei2 .. "#index"));
        setVisibility(self.worklights2[i], false);
    end;	
	self.worklightsActive2 = false;
	
	turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
	local translationPartNodeCamera = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartCamera#index"));
    if translationPartNodeCamera ~= nil then
        self.translationPartCamera = {};
        self.translationPartCamera.node = translationPartNodeCamera;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartCamera#minTrans"));
        self.translationPartCamera.minTrans = {};
        self.translationPartCamera.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartCamera.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartCamera.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartCamera#maxTrans"));
        self.translationPartCamera.maxTrans = {};
        self.translationPartCamera.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartCamera.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartCamera.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartCamera.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartCamera#transTime"), 2)*1000;
        self.translationPartCamera.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartCamera#touchTransLimit"), 10);
    end;
	
    local rotationPartNodeKierownica = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKierownica#index"));
    if rotationPartNodeKierownica ~= nil then
        self.rotationPartKierownica = {};
        self.rotationPartKierownica.node = rotationPartNodeKierownica;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKierownica#minRot"));
        self.rotationPartKierownica.minRot = {};
        self.rotationPartKierownica.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKierownica.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKierownica.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKierownica#maxRot"));
        self.rotationPartKierownica.maxRot = {};
        self.rotationPartKierownica.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKierownica.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKierownica.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKierownica.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKierownica#rotTime"), 2)*1000;
        self.rotationPartKierownica.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKierownica#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeHillmaster = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartHillmaster#index"));
    if rotationPartNodeHillmaster ~= nil then
        self.rotationPartHillmaster = {};
        self.rotationPartHillmaster.node = rotationPartNodeHillmaster;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#minRot"));
        self.rotationPartHillmaster.minRot = {};
        self.rotationPartHillmaster.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHillmaster.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHillmaster.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#maxRot"));
        self.rotationPartHillmaster.maxRot = {};
        self.rotationPartHillmaster.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHillmaster.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHillmaster.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartHillmaster.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#rotTime"), 2)*1000;
        self.rotationPartHillmaster.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartHillmaster#touchRotLimit"), 10));
    end;
	
	self.kabina = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kabina#index"));
	
    self.robocze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.robocze#index"));
	self.roboczeSwiatla = false;
    setVisibility(self.robocze, self.roboczeSwiatla);
	
    self.tylnie = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tylnie#index"));
	self.tylnieSwiatla = false;
    setVisibility(self.tylnie, self.tylnieSwiatla);
	
    self.rura = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rura#index"));
	self.ruraSwiatla = false;
    setVisibility(self.rura, self.ruraSwiatla);
	
	self.controlpathWTS = Utils.getFilename("Scripts/menuWTS.png", self.baseDirectory);
    self.hudjohndeereWTSWidth = 0.8;
    self.hudjohndeereWTSHeight = 0.3;
	self.hudjohndeereWTSPoxX = 0.01;
    self.hudjohndeereWTSPoxY = 0.01;
    self.hudjohndeereWTSOverlay = Overlay:new("hudjohndeereWTSControl", self.controlpathWTS, self.hudjohndeereWTSPoxX, self.hudjohndeereWTSPoxY, self.hudjohndeereWTSWidth, self.hudjohndeereWTSHeight);
	
	self.controlpath625R = Utils.getFilename("Scripts/menu625R.png", self.baseDirectory);
    self.hudjohndeere625RWidth = 0.2;
    self.hudjohndeere625RHeight = 0.5;
	self.hudjohndeere625RPoxX = 0.79;
    self.hudjohndeere625RPoxY = 0.4;
    self.hudjohndeere625ROverlay = Overlay:new("hudjohndeere625RControl", self.controlpath625R, self.hudjohndeere625RPoxX, self.hudjohndeere625RPoxY, self.hudjohndeere625RWidth, self.hudjohndeere625RHeight);
	
	self.particleSystemsZbiornikRzepak = {};
    local particleSystemsZbiornikRzepakCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsZbiornikRzepak#count"), 0);
    for i=1, particleSystemsZbiornikRzepakCount do
        local namei = string.format("vehicle.particleSystemsZbiornikRzepak.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsZbiornikRzepak, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsSieczkaRzepak = {};
    local particleSystemsSieczkaRzepakCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSieczkaRzepak#count"), 0);
    for i=1, particleSystemsSieczkaRzepakCount do
        local namei = string.format("vehicle.particleSystemsSieczkaRzepak.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSieczkaRzepak, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsKurz = {};
    local particleSystemsKurzCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsKurz#count"), 0);
    for i=1, particleSystemsKurzCount do
        local namei = string.format("vehicle.particleSystemsKurz.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsKurz, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsZbiornik = {};
    local particleSystemsZbiornikCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsZbiornik#count"), 0);
    for i=1, particleSystemsZbiornikCount do
        local namei = string.format("vehicle.particleSystemsZbiornik.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsZbiornik, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsSloma = {};
    local particleSystemsSlomaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSloma#count"), 0);
    for i=1, particleSystemsSlomaCount do
        local namei = string.format("vehicle.particleSystemsSloma.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSloma, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.particleSystemsSieczka = {};
    local particleSystemsSieczkaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSieczka#count"), 0);
    for i=1, particleSystemsSieczkaCount do
        local namei = string.format("vehicle.particleSystemsSieczka.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSieczka, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	local translationPartNodeSita = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartSita#index"));
    if translationPartNodeSita ~= nil then
        self.translationPartSita = {};
        self.translationPartSita.node = translationPartNodeSita;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartSita#minTrans"));
        self.translationPartSita.minTrans = {};
        self.translationPartSita.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartSita#maxTrans"));
        self.translationPartSita.maxTrans = {};
        self.translationPartSita.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartSita.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartSita#transTime"), 2)*1000;
        self.translationPartSita.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartSita#touchTransLimit"), 10);
    end;
	
    local rotationPartNodeKombajn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKombajn#index"));
    if rotationPartNodeKombajn ~= nil then
        self.rotationPartKombajn = {};
        self.rotationPartKombajn.node = rotationPartNodeKombajn;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKombajn#minRot"));
        self.rotationPartKombajn.minRot = {};
        self.rotationPartKombajn.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKombajn.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKombajn.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKombajn#maxRot"));
        self.rotationPartKombajn.maxRot = {};
        self.rotationPartKombajn.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKombajn.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKombajn.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKombajn.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKombajn#rotTime"), 2)*1000;
        self.rotationPartKombajn.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKombajn#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeKominek1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKominek1#index"));
    if rotationPartNodeKominek1 ~= nil then
        self.rotationPartKominek1 = {};
        self.rotationPartKominek1.node = rotationPartNodeKominek1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek1#minRot"));
        self.rotationPartKominek1.minRot = {};
        self.rotationPartKominek1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek1#maxRot"));
        self.rotationPartKominek1.maxRot = {};
        self.rotationPartKominek1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKominek1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek1#rotTime"), 2)*1000;
        self.rotationPartKominek1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeKominek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKominek2#index"));
    if rotationPartNodeKominek2 ~= nil then
        self.rotationPartKominek2 = {};
        self.rotationPartKominek2.node = rotationPartNodeKominek2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek2#minRot"));
        self.rotationPartKominek2.minRot = {};
        self.rotationPartKominek2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKominek2#maxRot"));
        self.rotationPartKominek2.maxRot = {};
        self.rotationPartKominek2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKominek2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKominek2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKominek2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek2#rotTime"), 2)*1000;
        self.rotationPartKominek2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKominek2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeSieczkarnia = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#index"));
    if rotationPartNodeSieczkarnia ~= nil then
        self.rotationPartSieczkarnia = {};
        self.rotationPartSieczkarnia.node = rotationPartNodeSieczkarnia;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#minRot"));
        self.rotationPartSieczkarnia.minRot = {};
        self.rotationPartSieczkarnia.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#maxRot"));
        self.rotationPartSieczkarnia.maxRot = {};
        self.rotationPartSieczkarnia.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSieczkarnia.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSieczkarnia.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSieczkarnia.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#rotTime"), 2)*1000;
        self.rotationPartSieczkarnia.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSieczkarnia#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#index"));
    if rotationPartNodeZbiornik1 ~= nil then
        self.rotationPartZbiornik1 = {};
        self.rotationPartZbiornik1.node = rotationPartNodeZbiornik1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#minRot"));
        self.rotationPartZbiornik1.minRot = {};
        self.rotationPartZbiornik1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#maxRot"));
        self.rotationPartZbiornik1.maxRot = {};
        self.rotationPartZbiornik1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#rotTime"), 2)*1000;
        self.rotationPartZbiornik1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#index"));
    if rotationPartNodeZbiornik2 ~= nil then
        self.rotationPartZbiornik2 = {};
        self.rotationPartZbiornik2.node = rotationPartNodeZbiornik2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#minRot"));
        self.rotationPartZbiornik2.minRot = {};
        self.rotationPartZbiornik2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#maxRot"));
        self.rotationPartZbiornik2.maxRot = {};
        self.rotationPartZbiornik2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#rotTime"), 2)*1000;
        self.rotationPartZbiornik2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#index"));
    if rotationPartNodeZbiornik3 ~= nil then
        self.rotationPartZbiornik3 = {};
        self.rotationPartZbiornik3.node = rotationPartNodeZbiornik3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#minRot"));
        self.rotationPartZbiornik3.minRot = {};
        self.rotationPartZbiornik3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#maxRot"));
        self.rotationPartZbiornik3.maxRot = {};
        self.rotationPartZbiornik3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#rotTime"), 2)*1000;
        self.rotationPartZbiornik3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik3#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#index"));
    if rotationPartNodeZbiornik4 ~= nil then
        self.rotationPartZbiornik4 = {};
        self.rotationPartZbiornik4.node = rotationPartNodeZbiornik4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#minRot"));
        self.rotationPartZbiornik4.minRot = {};
        self.rotationPartZbiornik4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#maxRot"));
        self.rotationPartZbiornik4.maxRot = {};
        self.rotationPartZbiornik4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#rotTime"), 2)*1000;
        self.rotationPartZbiornik4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik4#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#index"));
    if rotationPartNodeZbiornik5 ~= nil then
        self.rotationPartZbiornik5 = {};
        self.rotationPartZbiornik5.node = rotationPartNodeZbiornik5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#minRot"));
        self.rotationPartZbiornik5.minRot = {};
        self.rotationPartZbiornik5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#maxRot"));
        self.rotationPartZbiornik5.maxRot = {};
        self.rotationPartZbiornik5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#rotTime"), 2)*1000;
        self.rotationPartZbiornik5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik5#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#index"));
    if rotationPartNodeZbiornik6 ~= nil then
        self.rotationPartZbiornik6 = {};
        self.rotationPartZbiornik6.node = rotationPartNodeZbiornik6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#minRot"));
        self.rotationPartZbiornik6.minRot = {};
        self.rotationPartZbiornik6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#maxRot"));
        self.rotationPartZbiornik6.maxRot = {};
        self.rotationPartZbiornik6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#rotTime"), 2)*1000;
        self.rotationPartZbiornik6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik6#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#index"));
    if rotationPartNodeZbiornik7 ~= nil then
        self.rotationPartZbiornik7 = {};
        self.rotationPartZbiornik7.node = rotationPartNodeZbiornik7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#minRot"));
        self.rotationPartZbiornik7.minRot = {};
        self.rotationPartZbiornik7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#maxRot"));
        self.rotationPartZbiornik7.maxRot = {};
        self.rotationPartZbiornik7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#rotTime"), 2)*1000;
        self.rotationPartZbiornik7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik7#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#index"));
    if rotationPartNodeZbiornik8 ~= nil then
        self.rotationPartZbiornik8 = {};
        self.rotationPartZbiornik8.node = rotationPartNodeZbiornik8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#minRot"));
        self.rotationPartZbiornik8.minRot = {};
        self.rotationPartZbiornik8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#maxRot"));
        self.rotationPartZbiornik8.maxRot = {};
        self.rotationPartZbiornik8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#rotTime"), 2)*1000;
        self.rotationPartZbiornik8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik8#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeZbiornik9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#index"));
    if rotationPartNodeZbiornik9 ~= nil then
        self.rotationPartZbiornik9 = {};
        self.rotationPartZbiornik9.node = rotationPartNodeZbiornik9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#minRot"));
        self.rotationPartZbiornik9.minRot = {};
        self.rotationPartZbiornik9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#maxRot"));
        self.rotationPartZbiornik9.maxRot = {};
        self.rotationPartZbiornik9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartZbiornik9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartZbiornik9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartZbiornik9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#rotTime"), 2)*1000;
        self.rotationPartZbiornik9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartZbiornik9#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeDrabina = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrabina#index"));
    if rotationPartNodeDrabina ~= nil then
        self.rotationPartDrabina = {};
        self.rotationPartDrabina.node = rotationPartNodeDrabina;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrabina#minRot"));
        self.rotationPartDrabina.minRot = {};
        self.rotationPartDrabina.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrabina.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrabina.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrabina#maxRot"));
        self.rotationPartDrabina.maxRot = {};
        self.rotationPartDrabina.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrabina.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrabina.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrabina.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrabina#rotTime"), 2)*1000;
        self.rotationPartDrabina.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrabina#touchRotLimit"), 10));
    end;

    self.allowGrainTankFruitType = JD9680WTS.allowGrainTankFruitType;
    self.emptyGrainTankIfLowFillLevel = JD9680WTS.emptyGrainTankIfLowFillLevel;
    self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
    self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
    self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
    self.openPipe = SpecializationUtil.callSpecializationsFunction("openPipe");
    self.closePipe = SpecializationUtil.callSpecializationsFunction("closePipe");
    self.findTrailerRaycastCallback = JD9680WTS.findTrailerRaycastCallback;

    local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if threshingStartSound ~= nil and threshingStartSound ~= "" then
        threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory); 
        self.threshingStartSound = createSample("threshingStartSound");
        loadSample(self.threshingStartSound, threshingStartSound, false);
        self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);
        self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
        self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
    end;

    local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if threshingSound ~= nil and threshingSound ~= "" then
        threshingSound = Utils.getFilename(threshingSound, self.baseDirectory); 
        self.threshingSound = createSample("threshingSound");
        loadSample(self.threshingSound, threshingSound, false);
        self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
        self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
        self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
    end;

    local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if threshingStopSound ~= nil and threshingStopSound ~= "" then
        threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory); 
        self.threshingStopSound = createSample("threshingStopSound");
        loadSample(self.threshingStopSound, threshingStopSound, false);
        self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
        self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
        self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
    end;

    local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if pipeSound ~= nil and pipeSound ~= "" then
        pipeSound = Utils.getFilename(pipeSound, self.baseDirectory); 
        self.pipeSound = createSample("pipeSound");
        loadSample(self.pipeSound, pipeSound, false);
        self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
        self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
        self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
    end;
	
    local cutterSound = getXMLString(xmlFile, "vehicle.cutterSound#file");
    if cutterSound ~= nil and cutterSound ~= "" then
        cutterSound = Utils.getFilename(cutterSound, self.baseDirectory); 
        self.cutterSound = createSample("cutterSound");
        loadSample(self.cutterSound, cutterSound, false);
    end;
	
    local warnSound = getXMLString(xmlFile, "vehicle.warnSound#file");
    if warnSound ~= nil and warnSound ~= "" then
        warnSound = Utils.getFilename(warnSound, self.baseDirectory); 
        self.warnSound = createSample("warnSound");
        loadSample(self.warnSound, warnSound, false);
    end;
	
    local unloadingSound = getXMLString(xmlFile, "vehicle.unloadingSound#file");
    if unloadingSound ~= nil and unloadingSound ~= "" then
        unloadingSound = Utils.getFilename(unloadingSound, self.baseDirectory); 
        self.unloadingSound = createSample("unloadingSound");
        loadSample(self.unloadingSound, unloadingSound, false);
    end;
	
	self.warnSoundInternal = self.warnSound;
	self.unloadingSoundExternal = self.unloadingSound;
	
    local hydraulicSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if hydraulicSound ~= nil and hydraulicSound ~= "" then
        hydraulicSound = Utils.getFilename(hydraulicSound, self.baseDirectory); 
        self.hydraulicSound = createSample("hydraulicSound");
        loadSample(self.hydraulicSound, hydraulicSound, false);
    end;
	
	self.hydraulicSoundExternal = self.hydraulicSound;
	self.pipeSoundExternal = self.pipeSound;
	
    self.chopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    self.pipeParticleSystems = {};
    self.pipe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
    if self.pipe ~= nil then

        self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));

        -- load the pipe particle system for each fruit type
        local i = 0;
        while true do
            local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;

            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};

                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.pipe, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
                self.pipeParticleSystems[desc.index] = currentPS;
                if self.defaultPipeParticleSystem == nil then
                    self.defaultPipeParticleSystem = currentPS;
                end;

                if self.pipeRaycastNode == nil then
                    self.pipeRaycastNode = particleNode;
                end;
            end;
            i = i + 1;
        end;

        if self.pipeRaycastNode == nil then
            self.pipeRaycastNode = self.components[1].node;
        end;

    end;

    self.allowsThreshing = true;

    self.isThreshingStarted = false;

    self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));

    self.pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));

    self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));

    self.grainTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 200);
    self.grainTankUnloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankUnloadingCapacity"), 10);
    self.grainTankCrowded = false;

    self.grainTankPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainTankPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        local nodePipe = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#indexPipe"));
        local nodeScale = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#indexScale"));
        if node ~= nil then
            setVisibility(node, false);

            local entry = {};
            entry.node = node;
            entry.nodePipe = nodePipe;
            entry.nodeScale = nodeScale;
            local windowNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#windowIndex"));
            if windowNode ~= nil then
                entry.windowNode = windowNode;
                setVisibility(windowNode, false);
            end;

            if self.defaultGrainTankPlane == nil then
                self.defaultGrainTankPlane = entry;
            end;
            self.grainTankPlanes[t] = entry;
        end;
        i = i +1;
    end;
    if self.defaultGrainTankPlane==nil then
        self.grainTankPlanes = nil;
    end;

    --self.grainPlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainPlane#index"));
    --self.grainPlaneWindow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainTankPlane#windowIndex"));

    self.grainTankPlaneMinY, self.grainTankPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#minMaxY"));
    if self.grainTankPlaneMinY == nil or self.grainTankPlaneMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolator4);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.key(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            animCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneAnimCurve = animCurve;
        end;
        self.grainTankPlaneMinY = 0;
        self.grainTankPlaneMaxY = 0;
    end;


    self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#windowMinMaxY"));
    if self.grainTankPlaneWindowMinY == nil or self.grainTankPlaneWindowMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolatorN);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.windowKey(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local visibility = getXMLBool(xmlFile, key.."#visibility");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil or visibility == nil then
                break;
            end;
            animCurve:addKeyframe({v={scaleX, scaleY, scaleZ, yValue, }, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneWindowAnimCurve = animCurve;
        end;
        self.grainTankPlaneWindowMinY = 0;
        self.grainTankPlaneWindowMaxY = 0;
    end;
    self.grainTankPlaneWindowStartY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankPlane#windowStartY"), 0.0);


    self.chopperParticleSystems = {};
    --Utils.loadParticleSystem(xmlFile, self.chopperParticleSystems, "vehicle.chopperParticleSystem", self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
    local i = 0;
    while true do
        local key = string.format("vehicle.chopperParticleSystems.chopperParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
            self.chopperParticleSystems[desc.index] = currentPS;
            if self.defaultChopperParticleSystem == nil then
                self.defaultChopperParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.chopperToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperParticleSystems#toggleTime"), 6000);
    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;


    self.strawParticleSystems = {};
    --Utils.loadParticleSystem(xmlFile, self.strawParticleSystems, "vehicle.strawParticleSystem", self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
    local i = 0;
    while true do
        local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
            self.strawParticleSystems[desc.index] = currentPS;
            if self.defaultStrawParticleSystem == nil then
                self.defaultStrawParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 6000);
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;

    self.strawEmitState = false;


    self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);

    local numStrawAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawAreas#count"), 0);
    self.strawAreas = {}
    for i=1, numStrawAreas do
        local area = {};
        local areanamei = string.format("vehicle.strawAreas.strawArea%d", i);
        area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
        table.insert(self.strawAreas, area);
    end;

    self.isThreshing = false;
    self.chopperActivated = false;
    self.defaultChopperState = false;
    self.pipeOpening = false;
    self.pipeOpen = false;
    self.pipeClose = true;
    self.pipeParticleActivated = false;

    self.threshingScale = 1;

    self.grainTankFruitTypes = {};
    self.grainTankFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;

    local fruitTypes = getXMLString(xmlFile, "vehicle.grainTankFruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.grainTankFruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.grainTankFillLevel = 0;
    self:setGrainTankFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN);

    self.minThreshold = 0.05;

    self.speedDisplayScale = 1.0;
    self.drawFillLevel = true;

    self.attachedCutters = {};
    self.numAttachedCutters = 0;

    self.lastLastArea = 0;
    self.lastArea = 0;
	
	self.reverseDriveSoundExternal = self.reverseDriveSound;
end;

function JD9680WTS:delete()

    for k,v in pairs(self.pipeParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;

    if self.threshingStartSound ~= nil then
        delete(self.threshingStartSound);
    end;
    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;
    if self.threshingStopSound ~= nil then
        delete(self.threshingStopSound);
    end;
    if self.pipeSound ~= nil then
        delete(self.pipeSound);
    end;
	
    if self.cutterSound ~= nil then
        delete(self.cutterSound);
    end;
	
    if self.warnSound ~= nil then
        delete(self.warnSound);
    end;
	
    if self.hydraulicSound ~= nil then
        delete(self.hydraulicSound);
    end;

end;

function JD9680WTS:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local fillLevel = getXMLFloat(xmlFile, key.."#grainTankFillLevel");
    local fruitType = getXMLString(xmlFile, key.."#grainTankFruitType");
    if fillLevel ~= nil and fruitType ~= nil then
        local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
        if fruitTypeDesc ~= nil then
            self:setGrainTankFillLevel(fillLevel, fruitTypeDesc.index);
        end;
    end;
	
	local DrivenDiesel = Utils.getNoNil(getXMLFloat(xmlFile, key.."#DrivenDiesel"), 0);
	self.DrivenDiesel = DrivenDiesel;

	local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
	self.TreshedTotalNumber = TreshedTotalNumber;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function JD9680WTS:getSaveAttributesAndNodes(nodeIdent)
    local fruitType = "unknown";
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
    end;
	local DrivenDiesel = Utils.getNoNil(self.DrivenDiesel, 10);
	local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
    local attributes = 'grainTankFillLevel="'..self.grainTankFillLevel..'" grainTankFruitType="'..fruitType..'"'..' TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"'..' DrivenDiesel="'..string.format("%f", DrivenDiesel)..'"';
    return attributes, nil;
end;

function JD9680WTS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD9680WTS:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_m  then
		self.help = not self.help;
	end;
	if isDown and sym == Input.KEY_KP_period then
		self.motorRun = not self.motorRun;
		self.allowIgnition = true;
		self.gasMode = 1;
	end;

	if isDown and sym == Input.KEY_return then
		self.specialDriveMode = not self.specialDriveMode;
	end;
		
	if isDown and sym == Input.KEY_0 then
		self.gasMode = self.gasMode + 1;
	end;
	
	if isDown and sym == Input.KEY_9 then
		self.gasMode = self.gasMode - 1;
		if self.hederActive then
			for cutter,implement in pairs(self.attachedCutters) do
				local jointDesc = self.attacherJoints[implement.jointDescIndex];
				cutter:onStopReel();
			end;
			self.hederActive = false;
		end;
	end;
	
    if isDown and sym == Input.KEY_g then
        if self.grainTankFillLevel < self.grainTankCapacity then
            if self.isThreshing then
                self:stopThreshing();
				if self.warnSound ~= nil then
					playSample(self.warnSound, 1, 1, 0);
				end;
            else
				if self.zbiornikOtwarty then
					if self.warnSound ~= nil then
						playSample(self.warnSound, 1, 1, 0);
					end;
					self:startThreshing();
				else
					self.grainTankWarning = true;
				end;
            end;
        else
			self.grainWarning = true;
		end;
    end;
	
	if isDown and sym == Input.KEY_k then
		if self.zbiornikOtwarty then
			if self.isThreshing then 
				if self.gasMode == 3 then
					--if self.cutterName == "jd625r" or (self.cutterName == "geringhoff8" and self.cutterOpened) then
						self.hederActive = not self.hederActive;
						for cutter,implement in pairs(self.attachedCutters) do
							local jointDesc = self.attacherJoints[implement.jointDescIndex];
							if self.hederActive then
								cutter:onStartReel();
							else
								cutter:onStopReel();
							end;
							if self.warnSound ~= nil then
								playSample(self.warnSound, 1, 1, 0);
							end;
						end;
					--end;
				else
					self.rpmWarning = true;
				end;
			else
				self.thresherWarning = true;
			end;
		else
			self.grainTankWarning = true;
		end;
	end;
	

	
	if isDown and sym == Input.KEY_6 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.worklightsActive2 = false;
		self.flashWarner = false;
		self.warnLightActive = false;
	end;
	
	if isDown and sym == Input.KEY_7 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
		self.warnLightActive = false;
	end;
	
	if isDown and sym == Input.KEY_8 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.worklightsActive = false;
		self.flashWarner = false;
		self.warnLightActive = false;
	end;
	
    if isDown and sym == Input.KEY_u then
		if not self.isThreshing then
			if not self.zbiornikOtwieranie then
				self.zbiornikOtwieranie = true;
				if self.warnSound ~= nil then
					playSample(self.warnSound, 1, 1, 0);
				end;
				self.step = 1;
				if self.transport then
					self.rotationMaxDrabina = true;
					self.zbiornikTimerEnd = 3000;
				else
					self.rotationMaxZbiornik3 = false;
					self.rotationMaxZbiornik4 = false;
					self.rotationMaxZbiornik5 = false;
					self.rotationMaxZbiornik6 = false;
					self.rotationMaxZbiornik7 = false;
					self.rotationMaxZbiornik8 = false;
					self.rotationMaxZbiornik9 = false;
					self.zbiornikTimerEnd = 1000;
					self.zbiornikOtwarty = false;
				end;
				self.transport = not self.transport;
			end;
		else
			self.thresherOffWarning = true;
		end;
	end;
	
    if isDown and sym == Input.KEY_j then
		if not self.isThreshing then
			self.sieczkarnia = not self.sieczkarnia;
			if self.warnSound ~= nil then
				playSample(self.warnSound, 1, 1, 0);
			end;
		else
			self.thresherOffWarning = true;
		end;
	end;
	
    if isDown and sym == Input.KEY_4 then
		self.roboczeSwiatla = not self.roboczeSwiatla;
	end;
	
    if isDown and sym == Input.KEY_5 then
		if self.roboczeSwiatla then
			self.ruraSwiatlaA = not self.ruraSwiatlaA;
		else
			self.pipeLightWarning = true;
		end;
	end;
	
	if isDown and sym == Input.KEY_r then
        self.rundumleuchtenAn = not self.rundumleuchtenAn;
        for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
        end;
    end;
	
	if sym == Input.KEY_c and isDown then
		self.insideCamera = not self.insideCamera;
		self:switchSounds();
	end;
	
	if sym == Input.KEY_home then
		self.translationMaxCamera = isDown;
	end;
	
	if sym == Input.KEY_end then
		self.translationMinCamera = isDown;
	end;
	
	if sym == Input.KEY_KP_1 then
		self.rotationMinHillmaster = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_KP_3 then
		self.rotationMaxHillmaster = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_pagedown then
		self.rotationMaxAttacher = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;
	
	if sym == Input.KEY_pageup then
		self.rotationMinAttacher = isDown;
		self.jointUpdate = isDown;
		self.hydraulicSoundPlay = isDown;
	end;

end;

function JD9680WTS:update(dt)

	if self.changeAttacherMaxRotation then
		local x,y,z;
		--if self.cutterName == "jd625r" then
		--	x, y, z = Utils.getVectorFromString("30 0 0");
		--elseif self.cutterName == "geringhoff8" then
		--	x, y, z = Utils.getVectorFromString("22 0 0");
		--end;
		self.rotationPartAttacher.maxRot = {};
		self.rotationPartAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.rotationPartAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.rotationPartAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));		
		self.changeAttacherMaxRotation = false;
	end;
	if not self.isAIThreshing then
		if self.motorRun then
			if self.allowIgnition then
				self.allowIgnition = false;
				self:startMotor();
			end;
			self.motorStopSoundVolume = 0;
			self.isMotorStarted = true;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true)
			
		else
			if self.allowIgnition then
				self.motorStopSoundVolume = self.motorStopSoundVolume2;
				self:stopMotor();
				JD9680WTS.onDeactivate(self);
				self.allowIgnition = false;
				self.deactivateCutter = true;
			end;
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
			self.motorStopSoundVolume = 0;
			self:onDeactivateAttachements();
			self.isMotorStarted = false;
			Motorized.stopSounds(self);
			self.steeringEnabled = false;
			Utils.setEmittingState(self.exhaustParticleSystems, false)
		end;
	elseif not self.motorRun then
		self:stopAIThreshing();
	end;
		
    for cutter,implement in pairs(self.attachedCutters) do
        local jointDesc = self.attacherJoints[implement.jointDescIndex];
        jointDesc.moveDown = true;
	end;
	
	if self.isMotorStarted then
		self.DrivenDiesel = self.DrivenDiesel + self.lastMovedDistance*self.fuelUsage;
		if self.TreshedNumber ~= 0 and self.isThreshing and self.hederActive then
			if self.lastArea > 0 then
				self.DrivenDieselThreshing = self.DrivenDieselThreshing + self.lastMovedDistance*self.fuelUsage;
			end;
			self.LitersPerHectar = self.DrivenDieselThreshing / self.TreshedNumber;
		else
			self.LitersPerHectar = 0.0;
		end;
	end;
	
	if self.rpmWarning or self.thresherWarning or self.grainTankWarning or self.pipeLightWarning or self.speedWarning or self.thresherOffWarning or self.AIwarning or self.cutterOpeningWarning then
		self.warningTimer = self.warningTimer + dt;
		if self.warningTimer > 2000 then
			self.warningTimer = 0;
			self.rpmWarning = false;
			self.thresherWarning = false;
			self.grainTankWarning = false;
			self.pipeLightWarning = false;
			self.thresherOffWarning = false;
			self.speedWarning = false;
			self.grainWarning = false;
			self.AIwarning = false;
			self.cutterOpeningWarning = false;
		end;
		if self.rpmWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Too low RPM!\nUse NUM + to add more RPM.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.thresherWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Activate thresher!\nUse G to activate the thresher.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.grainTankWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Open grain tank!\nUse U to open the grain tank.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.pipeLightWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Turn work lights on!\nUse 4 to turn on work lights.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.thresherOffWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Deactivate thresher!\nUse G to deactivate thresher.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.grainWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Dump corn to continue threshing!");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.speedWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Thresher overloaded!\n4-7 km/h is the optimal threshing speed.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.AIwarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "Deactivate AutoTrac!\nUse H to deactivate AutoTrac.");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		elseif self.cutterOpeningWarning then
			setTextColor(1.0, 0.0, 0.0, 1.0);
			renderText(0.28, 0.51, 0.04, "The cutter is opening!");
			setTextColor(1.0, 1.0, 1.0, 1.0);
			g_currentMission:addWarning("", 0.018, 0.033);
		end;
	end;
	
	if self.isThreshing then
		local pixelToQm = 2048 / 4096 * 2048 / 4096;
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
	end;
	
	if self.rotationPartAttacher ~= nil and (self.rotationMaxAttacher or self.rotationMinAttacher) then
		local x, y, z = getRotation(self.rotationPartAttacher.node);
		self.cutterLowPosition = (x > 0.35);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartAttacher.maxRot, self.rotationPartAttacher.minRot, 3, self.rotationPartAttacher.rotTime, dt, not self.rotationMaxAttacher);
		setRotation(self.rotationPartAttacher.node, unpack(newRot));
	end;
	
	local HydraulicX, HydraulicY, HydraulicZ;
	local RotX, RotY, RotZ = getRotation(self.hydraulic2);
	HydraulicX = ((0.85 - (RotX/0.52360)*0.5)*-1);
	HydraulicZ = HydraulicX * 0.24;
	setTranslation(self.hydraulic, HydraulicX, HydraulicY, HydraulicZ);
	setRotation(self.hydraulic3, RotX, RotY, RotZ);
	
	if not self.isThreshing then
		self.hederActive = false;
	end;
	if self.hederActive and self.isEntered then--and  self.cutterName == "jd625r" then
		if not self.cutterSoundPlaying then
			playSample(self.cutterSound, 0, 1, 0);
			self.cutterSoundPlaying = true;
		end;
	else
		stopSample(self.cutterSound);
		self.cutterSoundPlaying = false;
	end;
	
	if self.hydraulicSound ~= nil then
		if self.hydraulicSoundPlay and self.isEntered then
			if not self.hydraulicSoundPlaying then
				playSample(self.hydraulicSound, 0, 1, 0);
				self.hydraulicSoundPlaying = true;
			end;
		else
			stopSample(self.hydraulicSound);
			self.hydraulicSoundPlaying = false;
		end;
	end;
	
	if self.specialDriveMode then
		if self.isEntered then
			if self.driveHandle ~= nil then --middle 3.22 for 3.28 back 3.18
				local xHandle, yHandle, zHandle = getTranslation(self.driveHandle);
				local move = self.maxSpeed;
					if self.maxSpeed > 0 then
						zHandle = 2.68875 + (move/50000);
						if zHandle > 2.74184 then
							zHandle = 2.74184;
						end;
						xHandle = -0.4255;
					end;
					if self.maxSpeed == 0 then
						zHandle = 2.68875;
						xHandle = -0.41486;
					end;
					if self.maxSpeed < 0 then
						zHandle = 2.68875 - (move/50000)*-1;
						if zHandle < 2.64107 then
							zHandle = 2.64107;
						end;
						xHandle = -0.44258;
					end;
					setTranslation(self.driveHandle, xHandle, yHandle, zHandle);
			end;
			
			self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
			if InputBinding.isAxisZero(self.input) then
				self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
			end;
			
			if self.input == -1 then
				if self.maxSpeed < 200 then
					self.maxSpeed = self.maxSpeed + 15
				elseif self.maxSpeed >= 200 and self.maxSpeed < 400 then
					self.maxSpeed = self.maxSpeed + 25
				elseif self.maxSpeed >= 400 and self.maxSpeed < 1900 then
					self.maxSpeed = self.maxSpeed + 45;
				elseif self.maxSpeed >= 1900 then
					self.maxSpeed = self.maxSpeed;
				end;
			end;
			if self.input == 1 then
				if self.maxSpeed > -200 then
					self.maxSpeed = self.maxSpeed - 15
				elseif self.maxSpeed <= -200 and self.maxSpeed > -400 then
					self.maxSpeed = self.maxSpeed - 25
				elseif self.maxSpeed <= -400 and self.maxSpeed > -1900 then
					self.maxSpeed = self.maxSpeed - 45;
				elseif self.maxSpeed <= -1900 then
					self.maxSpeed = self.maxSpeed;
				end;
			end;
				
			if InputBinding.isPressed(InputBinding.DRIVEMODESTOP) then
				self.maxSpeed = 0.0;
			end;

			local acceleration = 0;
			if g_currentMission.allowSteerableMoving and not self.playMotorSound then
				acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
				if InputBinding.isAxisZero(acceleration) then
				acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
				end;
				if math.abs(acceleration) > 0.8 then
					self.motor:setSpeedLevel(0, true)
				end;
				if self.maxSpeed > 0 then
					acceleration = 1.0;
					self.motor.maxRpmOverride = self.maxSpeed;
				elseif self.maxSpeed < 0 then
					acceleration = -1.0;
					self.motor.maxRpmOverride = self.maxSpeed*-1;
				end;
			end;
				
			if self.steeringEnabled then		
				if self.firstTimeRun then
					WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
				end;	
			end;
		end;
	else
		if self.isEntered then
			self.maxSpeed = 0;
			self.motor.maxRpmOverride = self.motor.maxRpm[self.motor.speedLevel];
			local acceleration = 0.0;
			if g_currentMission.allowSteerableMoving and not self.playMotorSound then
				acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
				if InputBinding.isAxisZero(acceleration) then
					acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
				end;
				if math.abs(acceleration) > 0.8 then
					self.motor:setSpeedLevel(0, true)
				end;
				if self.motor.speedLevel ~= 0 then
					acceleration = 1.0;
				end;
			end;
			if self.steeringEnabled then		
				if self.firstTimeRun then
					WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode);
				end;	
			end;
			local xHandle, yHandle, zHandle = getTranslation(self.driveHandle);
			local move = (self.lastSpeed*self.speedDisplayScale*3600)/400;
			if self.motor.lastMotorRpm > self.motor.minRpm then
				if self.movingDirection == -1 then
					zHandle = 2.68875 + move*-1;
					if zHandle < 2.64107 then
						zHandle = 2.64107;
					end;
					xHandle = -0.44258;
				else
					zHandle = 2.68875 + move;
					if zHandle > 2.74184 then
						zHandle = 2.74184;
					end;
					xHandle = -0.4255;
				end;
			end;
			
			if self.motor.lastMotorRpm == self.motor.minRpm then
				zHandle = 2.68875;
				xHandle = -0.41486;
			end;
			setTranslation(self.driveHandle, xHandle, yHandle, zHandle);
		end;
	end;
	
	if self.zbiornikOtwieranie then
		self.zbiornikTimer = self.zbiornikTimer + dt;
		if self.zbiornikTimer > self.zbiornikTimerEnd then
			if not self.transport then
				if self.step == 1 then
					self.rotationMaxZbiornik1 = true;
					self.rotationMaxZbiornik2 = true;
					self.zbiornikTimerEnd = 1000;
					self.step = 2;
				elseif self.step == 2 then
					self.rotationMaxZbiornik3 = true;
					self.rotationMaxZbiornik4 = true;
					self.rotationMaxZbiornik5 = true;
					self.rotationMaxZbiornik6 = true;
					self.rotationMaxZbiornik7 = true;
					self.rotationMaxZbiornik8 = true;
					self.rotationMaxZbiornik9 = true;
					self.zbiornikTimerEnd = 6000;
					self.step = 3;
				else
					self.zbiornikOtwieranie = false;
					self.step = 0;
					self.zbiornikOtwarty = true
				end;
			else
				if self.step == 1 then
					self.rotationMaxZbiornik1 = false;
					self.rotationMaxZbiornik2 = false;
					self.zbiornikTimerEnd = 6000;
					self.step = 2;
				elseif self.step == 2 then
					self.rotationMaxDrabina = false;
					self.zbiornikTimerEnd = 3000;
					self.step = 3;
				else
					self.zbiornikOtwieranie = false;
					self.step = 0;
				end;
			end;
			self.zbiornikTimer = 0;
		end;
	end;
	if self.gasMode == 1 then
		self.motor.minRpm = 200;
		self.timerSita = 200;
	elseif self.gasMode == 2 then
		self.motor.minRpm = -400;
		self.timerSita = 150;
	elseif self.gasMode == 3 then
		self.motor.minRpm = -1900;
		self.timerSita = 100;
	end;
	
	self.translationPartSita.transTime = self.timerSita;
	self.rotationPartKombajn.rotTime = self.timerSita;
	self.rotationPartKominek2.rotTime = self.timerSita;
	
	if self.gasMode > 3 then
		self.gasMode = 3;
	elseif self.gasMode < 1 then
		self.gasMode = 1;
	end;
	
	Utils.setEmittingState(self.particleSystemsKurz, (self.isThreshing and self.gasMode == 3));
	
	setVisibility(self.kabina, (self.insideCamera and self.roboczeSwiatla));
	setVisibility(self.robocze, self.roboczeSwiatla);
	setVisibility(self.tylnie, self.tylnieSwiatla);
	setVisibility(self.rura, self.ruraSwiatla);
	
	if self.roboczeSwiatla and self.ruraOtwarta and self.ruraSwiatlaA then
		self.ruraSwiatla = true;
	else
		self.ruraSwiatla = false;
	end;
	
	if self.roboczeSwiatla and self.movingDirection < 0 and not self.insideCamera then
		self.tylnieSwiatla = true;
	else
		self.tylnieSwiatla = false;
	end;
	
	if self.rotationPartHillmaster ~= nil and (self.rotationMaxHillmaster or self.rotationMinHillmaster) then
		local x, y, z = getRotation(self.rotationPartHillmaster.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartHillmaster.maxRot, self.rotationPartHillmaster.minRot, 3, self.rotationPartHillmaster.rotTime, dt, not self.rotationMaxHillmaster);
		setRotation(self.rotationPartHillmaster.node, unpack(newRot));
	end;
	
	if self.translationPartSita ~= nil then
		local x, y, z = getTranslation(self.translationPartSita.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartSita.maxTrans, self.translationPartSita.minTrans, 3, self.translationPartSita.transTime, dt, not self.translationMaxSita);
		setTranslation(self.translationPartSita.node, unpack(newTrans));
	end;
	
	if self.rotationPartKierownica ~= nil then
		local x, y, z = getRotation(self.rotationPartKierownica.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKierownica.maxRot, self.rotationPartKierownica.minRot, 3, self.rotationPartKierownica.rotTime, dt, not self.rotationMaxKierownica);
		setRotation(self.rotationPartKierownica.node, unpack(newRot));
	end;
	
	if self.rotationPartKombajn ~= nil then
		local x, y, z = getRotation(self.rotationPartKombajn.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKombajn.maxRot, self.rotationPartKombajn.minRot, 3, self.rotationPartKombajn.rotTime, dt, not self.rotationMaxKombajn);
		setRotation(self.rotationPartKombajn.node, unpack(newRot));
	end;
	
	local doTranslate = self.translationMaxCamera or self.translationMinCamera
	if self.translationPartCamera ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPartCamera.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartCamera.maxTrans, self.translationPartCamera.minTrans, 3, self.translationPartCamera.transTime, dt, not self.translationMaxCamera);
		setTranslation(self.translationPartCamera.node, unpack(newTrans));
	end;
	
	if self.kominek then
		if self.rotationPartKominek2 ~= nil then
			local x, y, z = getRotation(self.rotationPartKominek2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKominek2.maxRot, self.rotationPartKominek2.minRot, 3, self.rotationPartKominek2.rotTime, dt, not self.rotationMaxKominek2);
			setRotation(self.rotationPartKominek2.node, unpack(newRot));
		end;
		self.KominekT = self.KominekT + dt;
		if self.KominekT > self.timerSita then
			self.rotationMaxKominek2 = not self.rotationMaxKominek2;
			self.KominekT = 0;
			if self.isThreshing then
				self.rotationMaxKombajn = not self.rotationMaxKombajn;
				self.translationMaxSita = not self.translationMaxSita;
			end;
		end;
	end;
	if self.rotationPartKominek1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKominek1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKominek1.maxRot, self.rotationPartKominek1.minRot, 3, self.rotationPartKominek1.rotTime, dt, not self.rotationMaxKominek1);
		setRotation(self.rotationPartKominek1.node, unpack(newRot));
	end;
		
	if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	end;
		
	if self.rundumleuchtenAnz > 0 then
	  if self.rundumleuchtenAn then
		for i=1, self.rundumleuchtenAnz do
		  rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
		end;
	  end;
	end;
		
	if self.isThreshing and self.slimak ~= nil and self.podajnik ~= nil then
		rotate(self.slimak, 0, dt*0.015, 0);
		rotate(self.podajnik, dt*0.015, 0, 0);
	end;
		
	if self.sieczkarnia then
		self.rotationMaxSieczkarnia = true;
	else
		self.rotationMaxSieczkarnia = false;
	end;
		

		
	if self.rotationPartSieczkarnia ~= nil then
		local x, y, z = getRotation(self.rotationPartSieczkarnia.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSieczkarnia.maxRot, self.rotationPartSieczkarnia.minRot, 3, self.rotationPartSieczkarnia.rotTime, dt, not self.rotationMaxSieczkarnia);
		setRotation(self.rotationPartSieczkarnia.node, unpack(newRot));
	end;
		
	if self.rotationPartDrabina ~= nil then
		local x, y, z = getRotation(self.rotationPartDrabina.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDrabina.maxRot, self.rotationPartDrabina.minRot, 3, self.rotationPartDrabina.rotTime, dt, not self.rotationMaxDrabina);
		setRotation(self.rotationPartDrabina.node, unpack(newRot));
	end;
	
	if self.rotationPartZbiornik1 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik1.maxRot, self.rotationPartZbiornik1.minRot, 3, self.rotationPartZbiornik1.rotTime, dt, not self.rotationMaxZbiornik1);
		setRotation(self.rotationPartZbiornik1.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik2 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik2.maxRot, self.rotationPartZbiornik2.minRot, 3, self.rotationPartZbiornik2.rotTime, dt, not self.rotationMaxZbiornik2);
		setRotation(self.rotationPartZbiornik2.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik3 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik3.maxRot, self.rotationPartZbiornik3.minRot, 3, self.rotationPartZbiornik3.rotTime, dt, not self.rotationMaxZbiornik3);
		setRotation(self.rotationPartZbiornik3.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik4 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik4.maxRot, self.rotationPartZbiornik4.minRot, 3, self.rotationPartZbiornik4.rotTime, dt, not self.rotationMaxZbiornik4);
		setRotation(self.rotationPartZbiornik4.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik5 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik5.maxRot, self.rotationPartZbiornik5.minRot, 3, self.rotationPartZbiornik5.rotTime, dt, not self.rotationMaxZbiornik5);
		setRotation(self.rotationPartZbiornik5.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik6 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik6.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik6.maxRot, self.rotationPartZbiornik6.minRot, 3, self.rotationPartZbiornik6.rotTime, dt, not self.rotationMaxZbiornik6);
		setRotation(self.rotationPartZbiornik6.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik7 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik7.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik7.maxRot, self.rotationPartZbiornik7.minRot, 3, self.rotationPartZbiornik7.rotTime, dt, not self.rotationMaxZbiornik7);
		setRotation(self.rotationPartZbiornik7.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik8 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik8.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik8.maxRot, self.rotationPartZbiornik8.minRot, 3, self.rotationPartZbiornik8.rotTime, dt, not self.rotationMaxZbiornik8);
		setRotation(self.rotationPartZbiornik8.node, unpack(newRot));
	end;
		
	if self.rotationPartZbiornik9 ~= nil then
		local x, y, z = getRotation(self.rotationPartZbiornik9.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartZbiornik9.maxRot, self.rotationPartZbiornik9.minRot, 3, self.rotationPartZbiornik9.rotTime, dt, not self.rotationMaxZbiornik9);
		setRotation(self.rotationPartZbiornik9.node, unpack(newRot));
	end;

	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.worklightsActive2 = true;
				self.worklightsActive = true;
				self.warnLightActive = true;
				if self.attachedTrailer then
					self.blinkerleftActive = true;
					self.blinkerrightActive = true;
				end
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.worklightsActive2 = false;
				self.worklightsActive = false;
				self.warnLightActive = false;
				if self.attachedTrailer then
					self.blinkerleftActive = false;
					self.blinkerrightActive = false;
				end
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.worklightsActive2 = true;
				if self.attachedTrailer then
					self.blinkerrightActive = true;
				end
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.worklightsActive2 = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
		self.rotationMaxBlinkerLinks = false;
		self.rotationMaxBlinkerRechts = true;
	else
		if not self.flashWarner then
			self.worklightsActive2 = false;
			self.blinkerrightActive = false;
		end;
		self.rotationMaxBlinkerRechts = false;
	end;
		
		
	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashlightsLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 500;
				self.flashlightsLeftActive = true;
				self.worklightsActive = true;
				if self.attachedTrailer then
					self.blinkerleftActive = true;
				end
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashlightsLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 500;
				self.flashlightsLeftActive = false;
				self.worklightsActive = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
		self.rotationMaxBlinkerLinks = true;
		self.rotationMaxBlinkerRechts = false;
	else
		if not self.flashWarner then
			self.worklightsActive = false;
			self.blinkerleftActive = false;
		end;
		self.rotationMaxBlinkerLinks = false;
	end;
	
	if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
		
	if self.worklightsActive2 then
		for i=1, self.numWorklights2 do
			local worklight2 = self.worklights2[i];
			setVisibility(worklight2, self.worklightsActive2);
		end;
	else
		for i=1, self.numWorklights2 do
			local worklight2 = self.worklights2[i];
			setVisibility(worklight2, self.worklightsActive2, false);
		end;
	end;
	
    if self:getIsActive() then

        if self.isThreshingStarted then
            if self.playThreshingSound then
                if self:getIsActiveForSound() then
                    if self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                        playSample(self.threshingSound, 0, 1, 0);
                        self.playThreshingSound = false;
                        self.threshingSoundActive = true;
                    end;
                end;
            end;
        end;

        if self:getIsActiveForInput() then



            if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
                if self.pipeOpening then
                    self:closePipe();
                else
                    self:openPipe();
                end;
            end;
        end;

        if self.grainTankFillLevel >= self.grainTankCapacity then
            self:stopThreshing();
        end;

		if self.isThreshing and self.rotorFan ~= nil then
			rotate(self.rotorFan, dt*0.005, 0, 0);
		end;

        local disableChopperEmit = true;
        local disableStrawEmit = true;

        if self.isThreshing then
            local lastArea = 0;
			local percentArea = 0;
            local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
                    if cutter.lastArea > 0 then
                        for cutter,implement in pairs(self.attachedCutters) do
                            cutter:setFruitType(cutter.currentFruitType);
                            self.currentGrainTankFruitType = cutter.currentFruitType;
                        end;
                        fruitType = cutter.currentFruitType;
                        lastArea = lastArea + cutter.lastArea;
						percentArea = percentArea + cutter.percentArea;
                    end;
                end;
            end;
            self.lastArea = lastArea;
            if lastArea > 0 then
                local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
                if fruitDesc.hasStraw then
                    self.chopperActivated = false;
                else
                    self.chopperActivated = true;
                end;

                if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
                else
                    if self.strawEnableTime == nil then
                        self.strawEnableTime = self.time + self.strawToggleTime;
                    else
                        self.strawDisableTime = nil;
                    end;
                    disableStrawEmit = false;
                end;
                -- 8000/1200 = 6.66 liter/meter
                -- 8000/1200 / 6 = 1.111 liter/m^2
                -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
                local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
                local literPerQm = 1;
				local multipli = 1;
				if self.sieczkarnia then
					local multipli = 0.8;
				end;
                if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                    literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerQm * (1 + 0.5 * (3 - g_currentMission.missionStats.difficulty));
					self.percent = ((percentArea*8.2)*multipli)+(FruitUtil.fruitIndexToDesc[fruitType].literPerQm*15);
                end;

                --local literPerPixel = 8000/1200 / 6 / (2*2);

                --literPerPixel = literPerPixel*1.5;
                local qm = lastArea*pixelToQm;

                local newFillLevel = self.grainTankFillLevel+qm*literPerQm*self.threshingScale;
                self:setGrainTankFillLevel(newFillLevel, fruitType);
            else
				self.percent = 0.0;
			end;
        end;

		if self.percent ~= 0 then
			if self.percentMaschine > self.percent then
				self.percentMaschine = self.percentMaschine-0.025*dt;
			end;
			if self.percentMaschine < self.percent then
				self.percentMaschine = self.percentMaschine+0.015*dt;
			end;
		else
			self.percentMaschine = self.percentMaschine-0.025*dt;
		end;
		
		local kmh = self.lastSpeed*self.speedDisplayScale*3600;
		if kmh > 8 and self.isThreshing and self.hederActive and self.lastArea ~= 0 then
			self.percentMaschine = self.percentMaschine + 5;
		end;
		
		if self.percentMaschine > 100 then
			self.percentMaschine = 100;
		elseif self.percentMaschine < 0 then
			self.percentMaschine = 0
		end;
		
		self.speedWarning = (self.percentMaschine > 80);
		
        if disableChopperEmit and self.chopperDisableTime == nil then
            self.chopperDisableTime = self.time + self.chopperToggleTime;
        end;
        if disableStrawEmit and self.strawDisableTime == nil then
            self.strawDisableTime = self.time + self.strawToggleTime;
        end;

        if self.grainTankFillLevel <= 0 then
            for cutter,implement in pairs(self.attachedCutters) do
                cutter:resetFruitType();
            end;
            self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        end;

        local chopperBlindRotationSpeed = 0.001;
        local minRotX = -83*3.1415/180.0;
        if self.chopperBlind ~= nil then
            local x,y,z = getRotation(self.chopperBlind);
            if self.chopperActivated then
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
            else
                x = x+dt*chopperBlindRotationSpeed;
                if x > 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.chopperBlind, x, y, z);
        end;

        local pipeRotationSpeed = 0.0006;
        local pipeMinRotY = -90*3.1415/180.0;
        local pipeMaxRotX = 10*3.1415/180.0;
        local pipeXRotationSpeed = 0.00006;
        if self.pipe ~= nil then
            local x,y,z = getRotation(self.pipe);

            if self.pipeOpening then
                y = y-dt*pipeRotationSpeed;
                if y < pipeMinRotY then
                    y = pipeMinRotY;
                end;
                x = x+dt*pipeXRotationSpeed;
                if x > pipeMaxRotX then
                    x = pipeMaxRotX;
                end;
            else
                y = y+dt*pipeRotationSpeed;
                if y > 0.0 then
                    y = 0.0;
                end;
                x = x-dt*pipeXRotationSpeed;
                if x < 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.pipe, x, y, z);
            setRotation(self.pipeFlapLid, 0, y, 0);

            self.pipeOpen = (math.abs(pipeMinRotY-y) < 0.01);
            self.pipeClose =  ((x == 0) and (y == 0) );

        end;

        --[[if self.pipeLight ~= nil then
            local pipeLightActive = self.lightsActive and self.pipeOpening;
            setVisibility(self.pipeLight, pipeLightActive);
        end;]]

        if self.motor ~= nil then
            if self.motor.speedLevel == 1 then
                self.speedDisplayScale = 0.5;
            elseif self.motor.speedLevel == 2 then
                self.speedDisplayScale = 0.6;
            else
                self.speedDisplayScale = 1.0;
            end;
        end;

        if not self.pipeOpen or not self.pipeClose then
            if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                    playSample(self.pipeSound, 0, 1, 0);
					if self.warnSound ~= nil then
						playSample(self.warnSound, 1, 1, 0);
					end;
                    self.pipeSoundEnabled = true;
                end;
            end;
        end;

        if self.pipeOpen then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;

        if self.pipeClose then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;

        if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
            if self.currentChopperParticleSystem ~= nil then
                Utils.setEmittingState(self.currentChopperParticleSystem, false);
				Utils.setEmittingState(self.particleSystemsSieczkaRzepak, false);
				Utils.setEmittingState(self.particleSystemsZbiornikRzepak, false);
            end;
            self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
            if self.currentChopperParticleSystem == nil then
                self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
            end;
            Utils.setEmittingState(self.currentChopperParticleSystem, true);
			Utils.setEmittingState(self.particleSystemsSieczkaRzepak, true);
			Utils.setEmittingState(self.particleSystemsZbiornikRzepak, true);
            self.chopperEnableTime = nil;
			self.sieczkarnia = true;
        end;
        if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
            if self.currentStrawParticleSystem ~= nil then
                Utils.setEmittingState(self.currentStrawParticleSystem, false);
            end;
            self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
            if self.currentStrawParticleSystem == nil then
                self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
            end;
            Utils.setEmittingState(self.currentStrawParticleSystem, true);
			Utils.setEmittingState(self.particleSystemsZbiornik, true);
			if self.sieczkarnia then
				Utils.setEmittingState(self.particleSystemsSieczka, true);
				Utils.setEmittingState(self.particleSystemsSloma, false);
			else
				Utils.setEmittingState(self.particleSystemsSloma, true);
				Utils.setEmittingState(self.particleSystemsSieczka, false);
			end;
            self.strawEnableTime = nil;
            self.strawEmitState = true;
        end;
        if self.strawEmitState then
            for k, strawArea in pairs(self.strawAreas) do
                local x,y,z = getWorldTranslation(strawArea.start);
                local x1,y1,z1 = getWorldTranslation(strawArea.width);
                local x2,y2,z2 = getWorldTranslation(strawArea.height);
                local old, total = Utils.getFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2);
                local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
                value = math.min(value, g_currentMission.maxWindrowValue);
				if not self.sieczkarnia then
					Utils.updateFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2, value, true);
				end;
            end;
        end;

    end;

    if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
        if self.currentChopperParticleSystem ~= nil then
            Utils.setEmittingState(self.currentChopperParticleSystem, false);
			Utils.setEmittingState(self.particleSystemsSieczkaRzepak, false);
			Utils.setEmittingState(self.particleSystemsZbiornikRzepak, false);
        end;
        self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
        if self.currentChopperParticleSystem == nil then
            self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
        end;
        Utils.setEmittingState(self.currentChopperParticleSystem, false);
		Utils.setEmittingState(self.particleSystemsSieczkaRzepak, false);
		Utils.setEmittingState(self.particleSystemsZbiornikRzepak, false);
        self.chopperDisableTime = nil;
    end;
    if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
        self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
        if self.currentStrawParticleSystem == nil then
            self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
        end;
        Utils.setEmittingState(self.currentStrawParticleSystem, false);
		Utils.setEmittingState(self.particleSystemsZbiornik, false);
		Utils.setEmittingState(self.particleSystemsSloma, false);
		Utils.setEmittingState(self.particleSystemsSieczka, false);
        self.strawDisableTime = nil;
        self.strawEmitState = false;
    end;

    self.lastUnloadingTrailer = nil;
    self.pipeParticleActivated = false;
    if self.pipeOpen then
        if self.grainTankFillLevel > 0 then
            self.pipeParticleActivated = true;

            -- test if we should drain the grain tank
            self.trailerFound = 0;
            local x,y,z = getWorldTranslation(self.pipeRaycastNode);
            raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);

            local trailer = g_currentMission.objectToTrailer[self.trailerFound];
            self.lastUnloadingTrailer = trailer;
            if self.trailerFound == 0 or trailer == nil or not trailer:allowFillType(self.currentGrainTankFruitType, true) or not trailer.allowFillFromAir then
                self.pipeParticleActivated = false;
            else
                local deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
                deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);

                self.grainTankFillLevel = self.grainTankFillLevel-deltaLevel;
                if self.grainTankFillLevel <= 0.0 then
                    deltaLevel = deltaLevel+self.grainTankFillLevel;
                    self.grainTankFillLevel = 0.0;
                    self.pipeParticleActivated = false;
                end;
                if deltaLevel == 0 then
                    self.pipeParticleActivated = false;
                end;
                self:setGrainTankFillLevel(self.grainTankFillLevel, self.currentGrainTankFruitType);
                trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentGrainTankFruitType);
            end;
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        if self.currentPipeParticleSystem ~= nil then
            Utils.setEmittingState(self.currentPipeParticleSystem, false);
        end;
        if self.pipeParticleActivated then
            self.currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
            if self.currentPipeParticleSystem == nil then
                self.currentPipeParticleSystem = self.defaultPipeParticleSystem;
            end;
            Utils.setEmittingState(self.currentPipeParticleSystem, true);
			self.kontrolkaTimer = self.kontrolkaTimer + dt;
			if self.warnSound ~= nil and self.isEntered then
				if self.kontrolkaTimer > 15000 then
					self.kontrolkaTimer = 0;
					playSample(self.warnSound, 1, 1, 0);
				end;
			end;
			if self.unloadingSound ~= nil and not self.unloadingSoundPlaying and self.isEntered then
				playSample(self.unloadingSound, 0, 1, 0);
				self.unloadingSoundPlaying = true;
			else
				self.unloadingSoundPlaying = false;
				stopSample(self.unloadingSound);
			end;
		end;
    end;
end;

function JD9680WTS:draw()

	if self.help then
		if self.hudjohndeereWTSOverlay ~= nil then
			self.hudjohndeereWTSOverlay:render();
			-- FIRST COLUMN
			setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.015, 0.1, 0.022, string.format("Today threshed hectares: %.1f",self.TreshedNumber));
			renderText(0.015, 0.074, 0.022, string.format("Total hectares Threshed: %.1f",self.TreshedTotalNumber));
			renderText(0.015, 0.048, 0.022, string.format("Liters per hectar %.1fl/ha",self.LitersPerHectar));
			renderText(0.015, 0.022, 0.022, string.format("Driven diesel: %.0fl ",self.DrivenDiesel));
			
			-- SECOND COLUMN
			renderText(0.25, 0.178, 0.022, "F - Light");
			renderText(0.25, 0.152, 0.022, "4 - Work lights");
			renderText(0.25, 0.126, 0.022, "5 - Pipe light");
			renderText(0.25, 0.1, 0.022, "R - Beacon");
			renderText(0.25, 0.072, 0.022, "6 - Trafficators");
			renderText(0.25, 0.048, 0.022, "8 - Trafficators");
			renderText(0.25, 0.022, 0.022, "7 - Emergency lights");
			
			-- THIRD COLUMN
			local green = 1.0;
			local red = 1.0;
			green = green - self.percentMaschine/100;
			red = self.percentMaschine/100;
			setTextColor(red, green, 0.0, 1.0);
			renderText(0.42, 0.178, 0.022, string.format("Grain tonnage: %.0f",self.percentMaschine).."%");
			setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.42, 0.152, 0.022, "U - Grain Tank");
			renderText(0.42, 0.126, 0.022, "G - Activate thresher");
			renderText(0.42, 0.1, 0.022, "K - Activate cutter");
			renderText(0.42, 0.072, 0.022, "J - Chaff-cutter");
			renderText(0.42, 0.048, 0.022, "NUM + - Gassing");
			renderText(0.42, 0.022, 0.022, "NUM - - Gassing");
			
			-- FOURTH COLUMN
			renderText(0.58, 0.178, 0.022, "PAGE UP - Cutter lifting");
			renderText(0.58, 0.152, 0.022, "PAGE DOWN - Cutter lifting");
			renderText(0.58, 0.126, 0.022, "END - Move interior camera");
			renderText(0.58, 0.1, 0.022, "HOME - Move interior camera");
			renderText(0.58, 0.072, 0.022, "KP DEL - Ignition");
			renderText(0.58, 0.048, 0.022, "ENTER - Change drive mode");
			renderText(0.58, 0.022, 0.022, "SPACE - Stop hydrostatique");
			setTextColor(1.0, 1.0, 1.0, 1.0);
		end;
		g_currentMission:addExtraPrintText("M    -    Hide HUD");
	else
		g_currentMission:addExtraPrintText("M    -    Show HUD");
	end;
	
    local percent = self.grainTankFillLevel/self.grainTankCapacity*100;
    if self.drawFillLevel then
        self:drawGrainLevel(self.grainTankFillLevel, self.grainTankCapacity, 95);
    end;
    if self.pipeOpen and not self.pipeParticleActivated and self.grainTankFillLevel > 0 then
        g_currentMission:addExtraPrintText(g_i18n:getText("Move_the_pipe_over_a_trailer"));
    elseif self.grainTankFillLevel == self.grainTankCapacity then
        g_currentMission:addExtraPrintText(g_i18n:getText("Dump_corn_to_continue_threshing"));
    end;
    if self.pipeOpening then
        g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
    else
        if percent > 80 then
            g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        g_currentMission.fruitOverlays[self.currentGrainTankFruitType]:render();
    end;

end;

function JD9680WTS:onEnter()

	if self.motorRun then
		self.isMotorStarted = true;
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, true)
	else
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
		self:onDeactivateAttachements();
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false);
	end;
	
    if self.isThreshingStarted then
        self.playThreshingSound = true;
    end;
	self.kominek = true;
	self.rotationMaxKierownica = true;
	self.insideCamera = true;
	self:switchSounds();
	self.maxSpeed = 0;
end;

function JD9680WTS:onLeave()

	if self.motorRun then
		self.isMotorStarted = true;
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, true);
		if self.hederActive then
			for cutter,implement in pairs(self.attachedCutters) do
				local jointDesc = self.attacherJoints[implement.jointDescIndex];
				cutter:onStartReel();
			end;
		end;
	else
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
		self:onDeactivateAttachements();
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	end;
	
    --[[if self.deactivateOnLeave then
        JD9680WTS.onDeactivate(self);
	end;]]
    JD9680WTS.onDeactivateSounds(self)
	self.kominek = false;
	self.rotationMaxKominek1 = false;
	self.rotationMaxKierownica = false;
end;

function JD9680WTS:onDeactivate()
    self:stopThreshing();
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.setEmittingState(v, false);
    end;

    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
    self.strawEmitState = false;
    JD9680WTS.onDeactivateSounds(self)
end;

function JD9680WTS:onDeactivateSounds()
    if self.pipeSound ~= nil and self.pipeSoundEnabled then
        stopSample(self.pipeSound);
        self.pipeSoundEnabled = false;
    end;
    if self.threshingSound ~= nil then
        stopSample(self.threshingSound);
    end;
end;

function JD9680WTS:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
        -- cutter assumes the thresher's loaded fruit type
        object:setFruitType(self.currentGrainTankFruitType);
    end;
end;

function JD9680WTS:detachImplement(implementIndex)
    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
        end;
        self.attachedCutters[object] = nil;
    end;
end;

function JD9680WTS:allowGrainTankFruitType(fruitType)
    local allowed = false;

    if self.grainTankFruitTypes[fruitType] then -- is fruit type accepted by combine?
        if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then -- is combine currently not empty?
            if self.currentGrainTankFruitType ~= fruitType then -- is there another fill type in the tank?
                if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
                    allowed = true; -- fill level is low enough to be overridden
                end;
            else
                allowed = true; -- fill type is the same as the combine's current fill type
            end;
        else
            allowed = true; -- combine is empty --> FruitUtil.FRUITTYPE_UNKNOWN
        end;
    end;

    return allowed;
end;

function JD9680WTS:emptyGrainTankIfLowFillLevel()
    if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
        self.grainTankFillLevel = 0; -- empty the combine
        --return true;
    end;
    --return false;
end;

function JD9680WTS:setGrainTankFillLevel(fillLevel, fruitType)
    if not self:allowGrainTankFruitType(fruitType) then
        return;
    end;

    --self:emptyGrainTankIfLowFillLevel();

    self.grainTankFillLevel = Utils.clamp(fillLevel, 0, self.grainTankCapacity);

    if self.currentGrainTankFruitType ~= fruitType then
        self.currentGrainTankFruitType = fruitType;
        if self.currentGrainTankPlane ~= nil then
            setVisibility(self.currentGrainTankPlane, false);
        end;
        if self.currentGrainTankPlaneWindow ~= nil then
            setVisibility(self.currentGrainTankPlaneWindow, false);
        end;
    end;

    if self.grainTankPlanes ~= nil and self.defaultGrainTankPlane ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
        local grainPlane = self.grainTankPlanes[fruitTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainTankPlane;
        end;
        if grainPlane.node ~= nil then
            local yTranslation = 0;
			local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
			setVisibility(grainPlane.nodePipe, procent > 65);
			local ScaleY = 1.0;
			local ScaleZ = 1.0;
			ScaleY = ScaleY + (0.198 * (procent/100));
			if procent > 70 then
				local transX, transY, transZ = getTranslation(grainPlane.node);
				ScaleZ = 1.0 + (transY/0.47041*0.36);
			end;
			setScale(grainPlane.nodeScale, 1.0, ScaleY, ScaleZ);
            local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
            yTranslation = m*self.grainTankFillLevel + self.grainTankPlaneMinY;
            local xPos, yPos, zPos = getTranslation(grainPlane.node);
            setTranslation(grainPlane.node, xPos, yTranslation, zPos);
            setVisibility(grainPlane.node, self.grainTankFillLevel > 0);
            self.currentGrainTankPlane = grainPlane.node;
        end;
        if grainPlane.windowNode ~= nil then
            local yTranslation = 0;
            if self.grainTankPlaneWindowAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans, visiblity = self.grainTankPlaneWindowAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(grainPlane.windowNode, scaleX, scaleY, scaleZ);
                setVisibility(self.grainPlaneWindow, visiblity);
            else
                local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
                local startFillLevel = (self.grainTankPlaneWindowStartY-self.grainTankPlaneMinY)/m;
                local yTranslation = math.min(m*(self.grainTankFillLevel-startFillLevel)+self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY);
                setVisibility(grainPlane.windowNode, self.grainTankFillLevel >= startFillLevel);
            end;
            local xPos, yPos, zPos = getTranslation(grainPlane.windowNode);
            setTranslation(grainPlane.windowNode, xPos, yTranslation, zPos);
            self.currentGrainTankPlaneWindow = grainPlane.windowNode;
        end;
    end;
end;

function JD9680WTS:startThreshing()

    if not self.isThreshing then
        if self.numAttachedCutters > 0 then
            self.chopperActivated = self.defaultChopperState;
            self.isThreshing = true;
            --[[for cutter,implement in pairs(self.attachedCutters) do
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                --jointDesc.moveDown = true;

                cutter:setReelSpeed(0.003);
                cutter:onStartReel();
            end;]]
            --if self.threshingSound ~= nil then
            --    setSamplePitch(self.threshingSound, math.min(self.threshingSoundPitchOffset + self.threshingSoundPitchScale*math.abs(self.lastSoundSpeed), self.threshingSoundPitchMax));
            --   playSample(self.threshingSound, 0, 1, 0);
            --end;


            if not self.isThreshingStarted then

                self.isThreshingStarted = true;

                local threshingSoundOffset = 0;
                if self.threshingStartSound ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
                    playSample(self.threshingStartSound, 1, 1, 0);
                    threshingSoundOffset = getSampleDuration(self.threshingStartSound);
                end;

                self.playThreshingSound = true;
                self.playThreshingSoundTime = self.time+threshingSoundOffset;

            end;
        end;
    end;
end;

function JD9680WTS:stopThreshing()

    if self.isThreshing then
        self.isThreshingStarted = false;
        self.playThreshingSound = false;

        if self.threshingSound ~= nil then
            stopSample(self.threshingSound);
        end;
		
		self.motor.maxRpmOverride = nil;
		self.motor:setSpeedLevel(0, false);
		
        if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
            setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
            playSample(self.threshingStopSound, 1, 1, 0);
            self.threshingSoundActive = false;
        end;

        self.chopperActivated = false;
        self.isThreshing = false;
        for cutter,implement in pairs(self.attachedCutters) do
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            --jointDesc.moveDown = false;

            cutter:onStopReel();
        end;
    end;

end;

function JD9680WTS:findTrailerRaycastCallback(transformId, x, y, z, distance)

    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;

    return false;

end;

function JD9680WTS:openPipe()
    self.pipeOpening = true;
	self.ruraOtwarta = true;
end;

function JD9680WTS:closePipe()
    self.pipeOpening = false;
	self.ruraOtwarta = false;
end;

function JD9680WTS:switchSounds()
	if self.isMotorStarted then	
		stopSample(self.motorSound);
		stopSample(self.cutterSound);
		if self.isThreshing then
			stopSample(self.threshingSound);
		end;
		stopSample(self.hydraulicSound);
		stopSample(self.pipeSound);
		stopSample(self.reverseDriveSound);
		stopSample(self.unloadingSound);
		self.unloadingSoundPlaying = false;
		self.hydrualicSoundPlaying = false;
	end;
	
	if not self.insideCamera then
		self.motorStartSound = self.externalStartSound;
		self.motorStopSound = self.externalStopSound;
		self.motorSound = self.externalSound;
		self.cutterSound = self.externalCutterSound;
		self.threshingSound = self.externalThreshingSound;
		self.threshingStartSound = self.externalThreshingStartSound;
		self.threshingStopSound = self.externalThreshingStopSound;
		self.pipeSound = self.pipeSoundExternal;
		self.pipeSound = self.pipeSoundExternal;
		self.hydraulicSound = self.hydraulicSoundExternal;
		self.reverseDriveSound = self.reverseDriveSoundExternal;
		self.warnSound = nil;
		self.unloadingSound = self.unloadingSoundExternal
	else
		self.motorStartSound = self.internalStartSound;
		self.motorStopSound = self.internalStopSound;
		self.motorSound = self.internalSound;
		self.cutterSound = self.internalCutterSound;
		self.threshingSound = self.internalThreshingSound;
		self.threshingStartSound = self.internalThreshingStartSound;
		self.threshingStopSound = self.internalThreshingStopSound;
		self.pipeSound = nil;
		self.hydraulicSound = nil;
		self.reverseDriveSound = nil;
		self.warnSound = self.warnSoundInternal;
		self.unloadingSound = nil;
	end;
	
	if self.isMotorStarted then	
		playSample(self.motorSound, 0, 1, 0);
		if self.isThreshing then
			playSample(self.threshingSound, 0, 1, 0);
			if self.hederActive then--and self.cutterName == "jd625r" then
				playSample(self.cutterSound, 0, 1, 0);
			end;
		end;
		self.playMotorSound = true;
	end;
end;