--
-- jd9630t

jd9630t = {};

function jd9630t.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function jd9630t:load(xmlFile)

	-- Defines attributes of backHydraulic
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#node"));
	self.backAttacherJoint.lowRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#lowRot"));
	self.backAttacherJoint.upRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upRot"));
	
	self.implementAdapter = {};
	self.implementAdapter.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#adapter"));
	self.implementAdapter.attacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#attacherJoint"));
	self.implementAdapter.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#topReferenceNode"));
	self.implementAdapter.backup = {};
	local x,y,z = getTranslation(self.implementAdapter.node);
	self.implementAdapter.backup.trans = {x,y,z};
	self.implementAdapter.backup.attacherJoint = nil;
    self.implementAdapter.backup.topReferenceNode = nil;	
	
	self.topArm = {};
	self.topArm.node = getChildAt(self.attacherJoints[1].topArm.rotationNode, 0);
	self.topArm.rotation = {getRotation(self.topArm.node)};
	
	self.updateJoint = false;
end;

function jd9630t:delete()
end;

function jd9630t:readStream(streamId, connection)
end;

function jd9630t:writeStream(streamId, connection)
end;

function jd9630t:mouseEvent(posX, posY, isDown, isUp, button)
end;

function jd9630t:keyEvent(unicode, sym, modifier, isDown)
end;

function jd9630t:update(dt)
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;
end;

function jd9630t:updateTick(dt)

	if self:getIsActive() then
	
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm			
			local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
			setRotation(self.backHydraulic.rootArm, x, y, z);	
		end;		
	end;
end;

function jd9630t:draw()	
end;


function jd9630t:attachImplement(implement)
	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setRotation(self.topArm.node, 0, 0, 0);
			setVisibility(getParent(self.backAttacherJoint.node), false);
			
			local attacherJoint = implement.object.attacherJoint;
			unlink(self.implementAdapter.node);
			link(attacherJoint.node, self.implementAdapter.node);
			setTranslation(self.implementAdapter.node, 0, 0, 0);
			
			if attacherJoint.topReferenceNode ~= nil then
				local x,y,z = getWorldTranslation(attacherJoint.topReferenceNode);
				local x1,y1,z1 = getWorldTranslation(self.implementAdapter.node);
				local xDir, yDir, zDir = worldDirectionToLocal(getParent(self.implementAdapter.node), x-x1, y-y1, z-z1);
				setDirection(self.implementAdapter.node, xDir, yDir, zDir, 0,1,-1);
				
				local x,y,z = getRotation(self.implementAdapter.node);
				setRotation(self.implementAdapter.node, x, math.rad(90), 0);
			else
				setRotation(self.implementAdapter.node, math.rad(-90), math.rad(90), 0);
			end;
			
			self.implementAdapter.backup.attacherJoint = attacherJoint.node;
			self.implementAdapter.backup.topReferenceNode = attacherJoint.topReferenceNode;			
			attacherJoint.node = self.implementAdapter.attacherJoint;
			attacherJoint.topReferenceNode = self.implementAdapter.topReferenceNode;
		
			setVisibility(self.implementAdapter.node, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setRotation(self.attacherJoints[1].bottomArm.rotationNode, self.backAttacherJoint.upRot, 0, 0);
			setRotation(self.backAttacherJoint.node, -self.backAttacherJoint.upRot, 0, 0);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setRotation(self.attacherJoints[1].bottomArm.rotationNode, self.backAttacherJoint.lowRot, 0, 0);
			setRotation(self.backAttacherJoint.node, -self.backAttacherJoint.lowRot, 0, 0);
		end;
	end;
	self.updateJoint = true;	
end;

function jd9630t:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 1 then
		local x,y,z = unpack(self.topArm.rotation);
		setRotation(self.topArm.node, x,y,z);
		setVisibility(getParent(self.backAttacherJoint.node), true);
		
		setVisibility(self.implementAdapter.node, false);
		local attacherJoint = implement.object.attacherJoint;
		
		attacherJoint.node = self.implementAdapter.backup.attacherJoint;
		attacherJoint.topReferenceNode = self.implementAdapter.backup.topReferenceNode;
		
		unlink(self.implementAdapter.node);
		link(self.components[1].node, self.implementAdapter.node);
		setTranslation(self.implementAdapter.node, unpack(self.implementAdapter.backup.trans));
		setRotation(self.implementAdapter.node, math.rad(-90), 0,0);
		
	elseif jointIndex == 2 or jointIndex == 3 then
		setRotation(self.attacherJoints[1].bottomArm.rotationNode, 0, 0, 0);
		setRotation(self.backAttacherJoint.node, 0, 0, 0);
	end;
end;

function jd9630t:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function jd9630t:onLeave()
	
end;

function jd9630t:onEnter()
	
end;