--
-- FrontloaderAttacher
-- Specialization for FrontloaderAttacher
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--
Vehicle.registerJointType("quickeFrontloaderCoupling");
FendtFrontloader = {};

function FendtFrontloader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function FendtFrontloader:load(xmlFile)	
	
	local x,y,z = getCenterOfMass(self.components[1].node);
	self.centerOfMassDetachedCollision = {x,y,z};
	
	local frontloader = {};
	local name = "vehicle.frontloader";
	frontloader.supportArms = Utils.indexToObject(self.components, getXMLString(xmlFile, name .. ".supportArms#index"));
	frontloader.attachingPipes = Utils.indexToObject(self.components, getXMLString(xmlFile, name .. ".attachingPipes#index"));
	
	local mainArm = {};
	mainArm.node = Utils.indexToObject(self.components, getXMLString(xmlFile, name .. ".mainArm#index"));
	mainArm.detachLimit = math.rad(getXMLFloat(xmlFile, name .. ".mainArm#detachLimit"));
	frontloader.mainArm = mainArm;
	
	self.parts = {};
	local i=0;
	while true do
		local baseName = string.format(name .. ".parts.part(%d)", i);
        if not hasXMLProperty(xmlFile, baseName) then
            break;
        end;
		local part = {};
		part.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#index"));
		part.rotMin = math.rad(getXMLFloat(xmlFile, baseName .. "#minRot"));
		part.rotMax = math.rad(getXMLFloat(xmlFile, baseName .. "#maxRot"));
		part.depTool = getXMLInt(xmlFile, baseName .. "#depMovingTool") + 1;	
		part.inverted = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#inverted"), false);
		table.insert(self.parts, part);	
		i = i + 1;
	end;	
	
	self.isImplementAttached = false;
	self.printWarningTime = 0;
	self.attacherVehicleImplCount = 0;
	self.frontloader = frontloader;
	self.runOnce = false;
end;

function FendtFrontloader:delete()
end;

function FendtFrontloader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FendtFrontloader:keyEvent(unicode, sym, modifier, isDown)
end;

function FendtFrontloader:update(dt)
	if self:getIsActive() then
		local newImplCount = 0;
		if self.attacherVehicle ~= nil then
			newImplCount = table.getn(self.attacherVehicle.attachedImplements);
		end;
		if not self.allowsDetaching and g_currentMission.attachableInMountRange == nil and self:getIsActiveForInput() then				
			if self.attacherVehicleImplCount == newImplCount then			
				if InputBinding.hasEvent(InputBinding.ATTACH) then
					if not self.isImplementAttached or (self.isImplementAttached and Input.isKeyPressed(Input.KEY_shift)) then
						self.printWarningTime = self.time + 1000;
					end;
					if not Input.isKeyPressed(Input.KEY_shift) then
						self.isImplementAttached = false;
					end;
				end;
			end;
		end;
		self.attacherVehicleImplCount = newImplCount;
	end;
end;

function FendtFrontloader:updateTick(dt)
	if self:getIsActive() then
		if self.runOnce then
			for _, part in pairs(self.movingParts) do
				part.isDirty = true;
			end;
			self.runOnce = false;
		end;
		local x,_,_ = getRotation(self.frontloader.mainArm.node);
		self.allowsDetaching = x > self.frontloader.mainArm.detachLimit;

		for _, part in pairs(self.parts) do	
			local depMovingTool = self.movingTools[part.depTool];
			local maxMovement = math.abs(depMovingTool.rotMin) + depMovingTool.rotMax;
			x,_,_ = getRotation(depMovingTool.node);
			percentage = (math.abs(depMovingTool.rotMax) - x) / maxMovement;
			maxMovement = math.abs(part.rotMin) + part.rotMax;
			if part.inverted then
				percentage = 1 - percentage;
			end;
			newRot = part.rotMin + (percentage * maxMovement);
			setRotation(part.node, newRot, 0, 0);			
		end;	
	end;
end;

function FendtFrontloader:draw()
	if self.printWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("detach_Error"), 0.018, 0.033);
	end;
end;

function FendtFrontloader:onAttach(attacherVehicle)
	self.attacherVehicleImplCount = table.getn(attacherVehicle.attachedImplements);
	setCenterOfMass(self.components[2].node, 0, 0, -1.58);
	local x,y,z = getCenterOfMass(attacherVehicle.rootNode);
	if x ~= nil then
		x,y,z = localToWorld(attacherVehicle.rootNode, x,y,z);
		x,y,z = worldToLocal(self.components[1].node, x,y,z);
		setCenterOfMass(self.components[1].node, x,y,z);
	end;
	setVisibility(self.frontloader.supportArms, false);	
	setVisibility(self.frontloader.attachingPipes, true);
	self.runOnce = true;
end;

function FendtFrontloader:onDetach()
	self.attacherVehicleImplCount = 0;
	local x,y,z = unpack(self.centerOfMassDetachedCollision);
	setCenterOfMass(self.components[1].node, x, y, z);
	setCenterOfMass(self.components[2].node, 0, 0, 0);
	setVisibility(self.frontloader.supportArms, true);
	setVisibility(self.frontloader.attachingPipes, false);
end;


function FendtFrontloader:attachImplement(implement)
	self.isImplementAttached = true;
end;