--
-- PowershaftT
-- This is the specialization for PowershaftT
--
-- M@D Author  Manuel Leithner & Headshot XXL
-- M@D date 09.08.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

PowershaftT = {};

function PowershaftT.prerequisitesPresent(specializations)
    return true;
end;

function PowershaftT:load(xmlFile)

	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount +1+i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;	
	
end;

function PowershaftT:delete()
end;

function PowershaftT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowershaftT:keyEvent(unicode, sym, modifier, isDown)
end;

function PowershaftT:update(dt)
end;

function PowershaftT:draw()
end;
