--
-- umschaltbare Bereifung
-- 
--
-- @author Schnulla-817
-- @date  21/06/09
--
-- 

Reifen = {};

function Reifen.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Reifen:load(xmlFile)

    self.numTwinTires = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twintires#count"), 0);
    self.twintires = {};
    for i=1, self.numTwinTires do
        local twintirenamei = string.format("vehicle.twintires.twintire%d", i);
        self.twintires[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, twintirenamei .. "#index"));
        setVisibility(self.twintires[i], false);
    end;

	self.twintiresActive = false;

end;

function Reifen:keyEvent(unicode, sym, modifier, isDown)

end;

function Reifen:update(dt)

    if self:getIsActiveForInput() then
	    if InputBinding.hasEvent(InputBinding.JD78102WD_Duals) then
		    self.twintiresActive = not self.twintiresActive;
        end;
	end;

	if self.isEntered then
		
    	    if self.twintiresActive then
			   	for i=1, self.numTwinTires do
		   			local twintire = self.twintires[i];
			   		setVisibility(twintire, self.twintiresActive);
				end;
		else 
		    if not self.twintiresActive then
				for i=1, self.numTwinTires do
					local twintire = self.twintires[i];
					setVisibility(twintire, self.twintiresActive, false);
				end;
		 	end;
		end;

	end;
end;



function Reifen:draw()
    -- Draws ignition mode and ignition text
    g_currentMission:addHelpButtonText(g_i18n:getText("Dual_Wheels"), InputBinding.JD78102WD_Duals);

end;

function Reifen:onEnter()
end;

function Reifen:onLeave()
end;

function Reifen:delete()
end;

function Reifen:mouseEvent(posX, posY, isDown, isUp, button)
end;