SetEngineFlapEvent = {};
SetEngineFlapEvent_mt = Class(SetEngineFlapEvent, Event);

InitEventClass(SetEngineFlapEvent, "SetEngineFlapEvent");

function SetEngineFlapEvent:emptyNew()
    local self = Event:new(SetEngineFlapEvent_mt);
    self.className="SetEngineFlapEvent";
    return self;
end;

function SetEngineFlapEvent:new(vehicle, engineFlapState)
    local self = SetEngineFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.engineFlapState = engineFlapState;
    return self;
end;

function SetEngineFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.engineFlapState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetEngineFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.engineFlapState);
end;

function SetEngineFlapEvent:run(connection)   
	self.vehicle:SetEngineFlap(self.engineFlapState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetEngineFlapEvent:new(self.vehicle, self.engineFlapState), nil, connection, self.vehicle);
    end;
end;

function SetEngineFlapEvent.sendEvent(vehicle, engineFlapState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetEngineFlapEvent:new(vehicle, engineFlapState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetEngineFlapEvent:new(vehicle, engineFlapState));
		end;
	end;
end;