--
-- Aircart
-- Specialization for aircart mod
--
-- @author  Knagsted
-- @date  13/12/09
--
-- Copyright (C)
-- @Script Modifcation by Tubman
-- @date 25/1/11

Aircart = {};

function Aircart.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function Aircart:load(xmlFile)
	self.setAugerModeTransport = SpecializationUtil.callSpecializationsFunction("setAugerModeTransport");
	self.setAugerModeFillFront = SpecializationUtil.callSpecializationsFunction("setAugerModeFillFront");
	self.setAugerModeFillRear = SpecializationUtil.callSpecializationsFunction("setAugerModeFillRear");
	self.setAugerModePre = SpecializationUtil.callSpecializationsFunction("setAugerModePre");
	self.setAugerModeEmptyFront = SpecializationUtil.callSpecializationsFunction("setAugerModeEmptyFront");
	self.setAugerModeEmptyRear = SpecializationUtil.callSpecializationsFunction("setAugerModeEmptyRear");
	self.setAugerModePost = SpecializationUtil.callSpecializationsFunction("setAugerModePost");
	self.setAugerModePre2 = SpecializationUtil.callSpecializationsFunction("setAugerModePre2");
	self.rotateAuger = SpecializationUtil.callSpecializationsFunction("rotateAuger");
    self.setFrontFillLevel = SpecializationUtil.callSpecializationsFunction("setFrontFillLevel");
	self.setRearFillLevel = SpecializationUtil.callSpecializationsFunction("setRearFillLevel");
	
	self.findTrailerRaycastCallback = Aircart.findTrailerRaycastCallback;
    self.augerLoadPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerLoadPosition#index"));
	self.augerUnloadPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerUnloadPosition#index"));
    self.grainUnloading = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.grainfillLitersPerSecond"), 500);

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));

    self.speedViolationMaxTime = 2500;
    self.speedViolationTimer = self.speedViolationMaxTime;

    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[fruitType.index] = fruitType.index;
        end;
    end;
	
	self.lastFillDeltaFront = 0;
	self.lastFillDeltaRear = 0;
	
    self.capacityFront = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacityFront"), 0.0);
	self.capacityRear = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacityRear"), 0.0);
    self.minThreshold = 0.05;
	
    self.fillTypes = {};
    local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fillTypes[desc.index] = true;
            end;
        end;
    end;

    self.frontGrainPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.frontGrainPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
			defaultX, defaultY, defaultZ = getTranslation(node);
			defaultRX, defaultRY, defaultRZ = getRotation(node);
			defaultSX, defaultSY, defaultSZ = getScale(node);
            setVisibility(node, false);
            if self.defaultFrontGrainPlane == nil then
                self.defaultFrontGrainPlane = node;
            end;
            self.frontGrainPlanes[t] = node;
        end;
        i = i +1;
    end;
    if self.defaultFrontGrainPlane==nil then
        self.frontGrainPlanes = nil;
    end;
	
	local grainAnimCurve = AnimCurve:new(linearInterpolatorTransRotScale);
	local keyI = 0;
	while true do
		local animKey = string.format("vehicle.frontGrainPlane.key(%d)", keyI);
		local keyTime = getXMLFloat(xmlFile, animKey.."#time");
		local y = getXMLFloat(xmlFile, animKey.."#y");
		local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
		if keyTime == nil then
			break;
		end;
		local x = Utils.getNoNil(x, defaultX);
		local y = Utils.getNoNil(y, defaultY);
		local z = Utils.getNoNil(z, defaultZ);
		local rx = Utils.getNoNil(rx, defaultRX);
		local ry = Utils.getNoNil(ry, defaultRY);
		local rz = Utils.getNoNil(rz, defaultRZ);
		local sx = Utils.getNoNil(sx, defaultSX);
		local sy = Utils.getNoNil(sy, defaultSY);
		local sz = Utils.getNoNil(sz, defaultSZ);
		grainAnimCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
		keyI = keyI +1;
	end;
	if keyI > 0 then
		self.frontGrainAnimCurve = grainAnimCurve;
	end;
	
	self.rearGrainPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rearGrainPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
			defaultX, defaultY, defaultZ = getTranslation(node);
			defaultRX, defaultRY, defaultRZ = getRotation(node);
			defaultSX, defaultSY, defaultSZ = getScale(node);
            setVisibility(node, false);
            if self.defaultRearGrainPlane == nil then
                self.defaultRearGrainPlane = node;
            end;
            self.rearGrainPlanes[t] = node;
        end;
        i = i +1;
    end;
    if self.defaultRearGrainPlane==nil then
        self.rearGrainPlanes = nil;
    end;

	local grainAnimCurve = AnimCurve:new(linearInterpolatorTransRotScale);
	local keyI = 0;
	while true do
		local animKey = string.format("vehicle.rearGrainPlane.key(%d)", keyI);
		local keyTime = getXMLFloat(xmlFile, animKey.."#time");
		local y = getXMLFloat(xmlFile, animKey.."#y");
		local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
		if keyTime == nil then
			break;
		end;
		local x = Utils.getNoNil(x, defaultX);
		local y = Utils.getNoNil(y, defaultY);
		local z = Utils.getNoNil(z, defaultZ);
		local rx = Utils.getNoNil(rx, defaultRX);
		local ry = Utils.getNoNil(ry, defaultRY);
		local rz = Utils.getNoNil(rz, defaultRZ);
		local sx = Utils.getNoNil(sx, defaultSX);
		local sy = Utils.getNoNil(sy, defaultSY);
		local sz = Utils.getNoNil(sz, defaultSZ);
		grainAnimCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
		keyI = keyI +1;
	end;
	if keyI > 0 then
		self.rearGrainAnimCurve = grainAnimCurve;
	end;
	
	self.chargeParticle = {};
    local i = 0;
    while true do
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeParticle#index"));
        local key = string.format("vehicle.chargeParticle.chargeParticle(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
		if t == nil then
            break;
        end
        local currentPS = {};
		local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, nodei, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
		self.chargeParticle[t] = currentPS;
		i = i +1;
    end;
--[[	
	self.chargeParticle2 = {};
    local i = 0;
    while true do
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeParticle2#index"));
        local key = string.format("vehicle.chargeParticle2.chargeParticle2(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
		if t == nil then
            break;
        end
        local currentPS = {};
		local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, nodei, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
		self.chargeParticle2[t] = currentPS;
		i = i +1;
    end;
--]]	
	local standNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.stand#index"));
    if standNode ~= nil then
        self.stand = {};
        self.stand.node = standNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stand#minTrans"));
        self.stand.minTrans = {};
        self.stand.minTrans[1] = Utils.getNoNil(x, 0);
        self.stand.minTrans[2] = Utils.getNoNil(y, 0);
        self.stand.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stand#maxTrans"));
        self.stand.maxTrans = {};
        self.stand.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stand.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stand.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stand.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stand#transTime"), 2)*1000;
        self.stand.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stand#touchTransLimit"), 10);
    end;
	
	local tankLid1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tankLid1#index"));
    if tankLid1Node ~= nil then
        self.tankLid1 = {};
        self.tankLid1.node = tankLid1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankLid1#minRot"));
        self.tankLid1.minRot = {};
        self.tankLid1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tankLid1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tankLid1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankLid1#maxRot"));
        self.tankLid1.maxRot = {};
        self.tankLid1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tankLid1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tankLid1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tankLid1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankLid1#rotTime"), 2)*1000;
        self.tankLid1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankLid1#touchRotLimit"), 10));
    end;
	
	local tankLid2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tankLid2#index"));
    if tankLid2Node ~= nil then
        self.tankLid2 = {};
        self.tankLid2.node = tankLid2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankLid2#minRot"));
        self.tankLid2.minRot = {};
        self.tankLid2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tankLid2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tankLid2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tankLid2#maxRot"));
        self.tankLid2.maxRot = {};
        self.tankLid2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tankLid2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tankLid2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tankLid2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankLid2#rotTime"), 2)*1000;
        self.tankLid2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tankLid2#touchRotLimit"), 10));
    end;
	
	-- auger sounds
	AugerSoundFile = Utils.getFilename("grainAuger.wav", self.baseDirectory);
    self.AugerSoundId = createSample("AugerSound");
    loadSample(self.AugerSoundId, AugerSoundFile, false);
    self.AugerPlaying = false;
	
    AugerStartSoundFile = Utils.getFilename("grainAugerStart.wav", self.baseDirectory);
    self.AugerStartSoundId = createSample("AugerStartSound");
    loadSample(self.AugerStartSoundId, AugerStartSoundFile, false);
    self.AugerStartPlaying = false;

    AugerStopSoundFile = Utils.getFilename("grainAugerStop.wav", self.baseDirectory);
    self.AugerStopSoundId = createSample("AugerStopSound");
    loadSample(self.AugerStopSoundId, AugerStopSoundFile, false);
    self.AugerStopPlaying = false;
	
	GrainSoundFile = Utils.getFilename("grain.wav", self.baseDirectory);
    self.GrainSoundId = createSample("GrainSound");
    loadSample(self.GrainSoundId, GrainSoundFile, false);
    self.GrainPlaying = false;
	
	self.augerSound = false;
	self.grainSound = false;
	self.fanSound = false;
	
	-- hydr. fan sound
	FanSoundFile = Utils.getFilename("fan.wav", self.baseDirectory);
    self.FanSoundId = createSample("FanSound");
    loadSample(self.FanSoundId, FanSoundFile, false);
    self.FanPlaying = false;
	
	FanStartSoundFile = Utils.getFilename("fanStart.wav", self.baseDirectory);
    self.FanStartSoundId = createSample("FanStartSound");
    loadSample(self.FanStartSoundId, FanStartSoundFile, false);
    self.FanStartPlaying = false;

    FanStopSoundFile = Utils.getFilename("fanStop.wav", self.baseDirectory);
    self.FanStopSoundId = createSample("FanStopSound");
    loadSample(self.FanStopSoundId, FanStopSoundFile, false);
    self.FanStopPlaying = false;
	
	-- External sounds
	ExternalAugerSound  = Utils.getFilename("grainAugerExternal.wav", self.baseDirectory);
	self.externalAugerSound = createAudioSource("ExternalAugerSound", ExternalAugerSound, 50, 10, 1, 0);
	link(self.components[1].node, self.externalAugerSound);
	setVisibility(self.externalAugerSound, false);
	
	ExternalGrainSound  = Utils.getFilename("grainExternal.wav", self.baseDirectory);
	self.externalGrainSound = createAudioSource("ExternalGrainSound", ExternalGrainSound, 50, 10, 1, 0);
	link(self.components[1].node, self.externalGrainSound);
	setVisibility(self.externalGrainSound, false);
	
	ExternalFanSound  = Utils.getFilename("fanExternal.wav", self.baseDirectory);
	self.externalFanSound = createAudioSource("ExternalFanSound", ExternalFanSound, 150, 10, 1, 0);
	link(self.components[1].node, self.externalFanSound);
	setVisibility(self.externalFanSound, false);
	
	-- HUD
	
	self.hudpath = Utils.getFilename("Images/seedStar.png", self.baseDirectory);
    self.hudOverlay = Overlay:new("hudControl", self.hudpath, 0.745, 0.72, 0.256, 0.180);
	
	self.overlay = Utils.getFilename("Images/overlay.png", self.baseDirectory);
    self.hudPDAOverlay = Overlay:new("hudPDAControl", self.overlay, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize, g_currentMission.fruitSymbolSize * (4 / 3)); 
		
	self.airCart = true;
	self.FanOn = false;
	
	self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;
	
	self.openTankLids = false;
	self.openLid2 = false;
	self.augerMode = 0;
		
	self.augerPivotPart1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerPivotPart1#index"));
    self.augerPivotPart2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerPivotPart2#index"));
	self.augerPivotPart3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerPivotPart3#index"));
	self.grainAuger = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.grainAuger#index"));
	self.auger = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.auger#index"));
	self.augerEnter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerEnter#index"));
	self.augerExit = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.augerExit#index"));
	self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
	
	self.frontFillLevel = 0;
	self.rearFillLevel = 0;
	self.lastFrontFillLevel = 0;
	self.lastRearFillLevel = 0;
	self.fillLevel = 0;
	self.augerRunning = false;
	self.currentFrontFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	self.currentRearFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	self.planesLoaded = false;
	self.hudOn = 1;
	self.loadTrailerFound = false;
	self.unloadTrailerFound = false;
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	tcftpricePerLiter = 0;
	self.lowerBooms = false;
end;

function Aircart:delete()
	if self.AugerPlaying ~= nil then
		stopSample(self.AugerSoundId);
	end;
	if self.GrainPlaying ~= nil then
		stopSample(self.GrainSoundId);
	end;
	if self.FanPlaying ~= nil then
		stopSample(self.FanSoundId);
	end;
	if self.hudOverlay ~= nil then
		self.hudOverlay:delete();
	end;
end;

function Aircart:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Aircart:keyEvent(unicode, sym, modifier, isDown)
end;

function Aircart:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local fillLevelFront = getXMLFloat(xmlFile, key.."#fillLevelFront");
    local fillTypeFront = getXMLString(xmlFile, key.."#fillTypeFront");
	local fillLevelRear = getXMLFloat(xmlFile, key.."#fillLevelRear");
    local fillTypeRear = getXMLString(xmlFile, key.."#fillTypeRear");
    if fillLevelFront ~= nil and fillTypeFront ~= nil then
        local fillTypeDesc = FruitUtil.fruitTypes[fillTypeFront];
        if fillTypeDesc ~= nil then
			self.frontFillLevel = fillLevelFront;
			self.currentFrontFillType = fillTypeDesc.index;
        end;
    end;
	if fillLevelRear ~= nil and fillTypeRear ~= nil then
        local fillTypeDesc = FruitUtil.fruitTypes[fillTypeRear];
        if fillTypeDesc ~= nil then
			self.rearFillLevel = fillLevelRear;
			self.currentRearFillType = fillTypeDesc.index;
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Aircart:getSaveAttributesAndNodes(nodeIdent)
    local fillTypeFront = "unknown";
    if self.currentFrontFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fillTypeFront = FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name;
    end;
	    local fillTypeRear = "unknown";
    if self.currentRearFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fillTypeRear = FruitUtil.fruitIndexToDesc[self.currentRearFillType].name;
    end;
    local attributes = 'fillLevelFront="'..self.frontFillLevel..'" fillTypeFront="'..fillTypeFront..'" fillLevelRear="'..self.rearFillLevel..'" fillTypeRear="'..fillTypeRear..'"';
    return attributes, nil;
end;

function Aircart:update(dt)
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;

	if self.frontFillLevel == 0 then
		self.currentFrontFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	end;
	
	if self.rearFillLevel == 0 then
		self.currentRearFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	end;
	
	--Setup the granplanes based on the persisted data loaded in loadFromAttributesAndNodes method. This is done once
	if not self.planesLoaded then
		self:setFrontFillLevel(self.frontFillLevel, self.currentFrontFillType);
		self:setRearFillLevel(self.rearFillLevel, self.currentRearFillType);
		self.planesLoaded = true;
	end;
	

	if self.attacherVehicle ~= nil then
		-- Stand
		self.standMax = true;
		-- Stand Done
		
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1910AUGER) then
				self.augerRunning = not self.augerRunning;
				self.augerSound = not self.augerSound;
				local AugerSoundOffset = 1070;
				self.playAugerSoundTime = self.attacherVehicle.time+AugerSoundOffset;
			end;
		end;
		
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1910STARTSEEDER) then
				self.FanOn = not self.FanOn;
				self.fanSound = not self.fanSound;
				local FanSoundOffset = 6852;
				self.playFanSoundTime = self.attacherVehicle.time+FanSoundOffset;
			end;
		end;
		
		-- Seeder booms
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1890LOWER) then
				self.lowerBooms = not self.lowerBooms;
			end;
		end;
		
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1910HUD) then
				self.hudOn = self.hudOn + 1;
			end;
			
			if self.hudOn == 3 then
				self.hudOn = 0;
			end;
		end;
		
		if self.auger ~= nil then
			if self.augerRunning then
				rotate(self.auger, 0, 0, dt*0.02);
			end;
		end;
		
		if self.fan ~= nil then
			if self.FanOn then
				rotate(self.fan, dt*0.05, 0, 0);
			end;
		end;
	
		self.loadTrailerFound = false;
		self.unloadTrailerFound = false;
		self.trailerFound = 0;
		tcft = FruitUtil.FRUITTYPE_UNKNOWN;
		local x,y,z = getWorldTranslation(self.augerLoadPosition);
    	raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 15, self);
		--Tank fill
		--if self.attacherVehicle.isEntered then
			if trailer ~= nil and self.trailerFound ~= 0 and self.fillTypes[tcft] then
				--Front tank fill
				if self.augerMode == 2 then
					if self.currentFrontFillType == tcft or self.frontFillLevel == 0 then
						self.loadTrailerFound = true;
						if self.augerRunning and self.openTankLids and self.frontFillLevel < self.capacityFront then
							if tcft == self.currentRearFillType or tcft == FruitUtil.FRUITTYPE_FERTILIZER or self.currentRearFillType == FruitUtil.FRUITTYPE_UNKNOWN or self.currentRearFillType == FruitUtil.FRUITTYPE_FERTILIZER then
								local deltaLevel = self.grainUnloading*dt*0.001;
								if self.trailerFound ~= "FillTrigger" then
									deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
								end;
								if deltaLevel == 0 then
									deltaLevel = self.grainUnloading*dt*0.001;
								end;
								self.currentFrontFillType = tcft;
								self.frontFillLevel = self.frontFillLevel+deltaLevel;
								if self.frontFillLevel > self.capacityFront then
									self.frontFillLevel = self.capacityFront;
								end;
								if self.trailerFound ~= "FillTrigger" then
									if trailer.fillLevel <= 0.0 then
										trailer.fillLevel = 0.0;
										trailer.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
									end;
									trailer:setFillLevel(trailer.fillLevel-deltaLevel, trailer.currentFillType);
									self:setFrontFillLevel(self.frontFillLevel, tcft);
								else
									if tcftpricePerLiter == "liquidManure" then
										local silo = g_currentMission:getSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE);
										g_currentMission:setSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE, silo-deltaLevel);
										self:setFrontFillLevel(self.frontFillLevel, tcft);
									else
										local price = deltaLevel*tcftpricePerLiter
										g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
										g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;
										g_currentMission:addSharedMoney(-price);
										self:setFrontFillLevel(self.frontFillLevel, tcft);
									end;
								end;
							else
								setTextColor(0.8, 0.2, 0.2, 1.0);
								renderText(0.2, 0.5, 0.030, string.format("Only one Seed type (+Optional Fertilizer) is allowed at any time"))
							end;
						end;
					end;
				end;
				-- Rear tank fill
				if self.augerMode == 1 then
					if self.currentRearFillType == tcft or self.rearFillLevel == 0 then
						self.loadTrailerFound = true;
						if self.augerRunning and self.openTankLids and self.rearFillLevel < self.capacityRear then
							if tcft == self.currentFrontFillType or tcft == FruitUtil.FRUITTYPE_FERTILIZER or self.currentFrontFillType == FruitUtil.FRUITTYPE_UNKNOWN or self.currentFrontFillType == FruitUtil.FRUITTYPE_FERTILIZER then
								local deltaLevel = self.grainUnloading*dt*0.001;
								if self.trailerFound ~= "FillTrigger" then
									deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
								end;
								if deltaLevel == 0 then
									deltaLevel = self.grainUnloading*dt*0.001;
								end;
								self.currentRearFillType = tcft;
								self.rearFillLevel = self.rearFillLevel+deltaLevel;
								if self.rearFillLevel > self.capacityRear then
									self.rearFillLevel = self.capacityRear;
								end;
								if self.trailerFound ~= "FillTrigger" then
									if trailer.fillLevel <= 0.0 then
										trailer.fillLevel = 0.0;
										trailer.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
									end;
									trailer:setFillLevel(trailer.fillLevel-deltaLevel, trailer.currentFillType);
									self:setRearFillLevel(self.rearFillLevel, tcft);
								else
									if tcftpricePerLiter == "liquidManure" then
										local silo = g_currentMission:getSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE);
										g_currentMission:setSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE, silo-deltaLevel);
										self:setRearFillLevel(self.rearFillLevel, tcft);
									else
										local price = deltaLevel*tcftpricePerLiter
										g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
										g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;
										g_currentMission:addSharedMoney(-price);
										self:setRearFillLevel(self.rearFillLevel, tcft);
									end;
								end;
							else
								--g_currentMission:addWarning("Only one Seed type (+Optional Fertilizer) is allowed at any time", 0.07, 0.07);
								setTextColor(0.8, 0.2, 0.2, 1.0);
								renderText(0.2, 0.5, 0.030, string.format("Only one Seed type (+Optional Fertilizer) is allowed at any time"))
							end;
						end;
					end;
				end;
			end;
		--end;
		
		self.trailerFound = 0;
		local x,y,z = getWorldTranslation(self.augerUnloadPosition);
    	raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
		
		--Tank Empty
		--if self.attacherVehicle.isEntered then
			if trailer ~= nil and self.trailerFound ~= 0 and self.trailerFound ~= "FillTrigger" then --and trailer.fillTypes[trailer.currentFillType] 
				-- Front tank empty
				if self.augerMode == 4 then
					-- renderText(0.5, 0.5, 0.02, string.format("Found Trailer front"));
					if self.currentFrontFillType == tcft or trailer.fillLevel <= 0 then
						self.unloadTrailerFound = true;
						if self.augerRunning and trailer.fillLevel < trailer.capacity then
							local deltaLevel = self.grainUnloading*dt*0.001;
							deltaLevel = math.min(deltaLevel, self.capacityFront - self.frontFillLevel);
							if deltaLevel == 0 then
								deltaLevel = self.grainUnloading*dt*0.001;
							end;
							trailer.currentFillType = FruitUtil.fruitTypeToFillType[self.currentFrontFillType];

							trailer.fillLevel = trailer.fillLevel+deltaLevel;
							if trailer.fillLevel > trailer.capacity then
								trailer.fillLevel = trailer.capacity;
							end;
							if self.frontFillLevel <= 0.0 then
								self.frontFillLevel = 0.0;
								self.currentFrontFillType = FruitUtil.FRUITTYPE_UNKNOWN;
							end;
							if self.currentFrontFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
								trailer:setFillLevel(trailer.fillLevel, FruitUtil.fruitTypeToFillType[self.currentFrontFillType]);
							end;
							self:setFrontFillLevel(self.frontFillLevel - deltaLevel, self.currentFrontFillType);
						end;
					end;
				end;
				-- Rear tank empty
				if self.augerMode == 5 then
					-- renderText(0.5, 0.5, 0.02, string.format("Found Trailer rear"))
					if self.currentRearFillType == tcft or trailer.fillLevel <= 0 then
						self.unloadTrailerFound = true;
						if self.augerRunning and trailer.fillLevel < trailer.capacity then
							local deltaLevel = self.grainUnloading*dt*0.001;
							deltaLevel = math.min(deltaLevel, self.capacityRear - self.rearFillLevel);
							if deltaLevel == 0 then
								deltaLevel = self.grainUnloading*dt*0.001;
							end;
							trailer.currentFillType = FruitUtil.fruitTypeToFillType[self.currentRearFillType];

							trailer.fillLevel = trailer.fillLevel+deltaLevel;
							if trailer.fillLevel > trailer.capacity then
								trailer.fillLevel = trailer.capacity;
							end;
							if self.rearFillLevel <= 0.0 then
								self.rearFillLevel = 0.0;
								self.currentRearFillType = FruitUtil.FRUITTYPE_UNKNOWN;
							end;
							if self.currentRearFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
								trailer:setFillLevel(trailer.fillLevel, FruitUtil.fruitTypeToFillType[self.currentRearFillType]);
							end;
							self:setRearFillLevel(self.rearFillLevel - deltaLevel, self.currentRearFillType);
						end;
					end;
				end;
			end;
		--end;
	self.fillLevel = self.frontFillLevel + self.rearFillLevel;
		
		-- Tank lids
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1910OPENLIDS) then
				self.openTankLids = not self.openTankLids;
			end;
		end;
		
		self.tankLid1Open = false;
		if self.tankLid1 ~= nil then
			local x, y, z = getRotation(self.tankLid1.node);
			local minRot = self.tankLid1.minRot;
			local eps = self.tankLid1.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.tankLid1Open = true;
            end;
		end;
		
		if self.tankLid1 ~= nil then
			local x, y, z = getRotation(self.tankLid1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.tankLid1.maxRot, self.tankLid1.minRot, 3, self.tankLid1.rotTime, dt, not self.openTankLids);
			setRotation(self.tankLid1.node, unpack(newRot));
		end;
		if self.tankLid2 ~= nil then
			local x, y, z = getRotation(self.tankLid2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.tankLid2.maxRot, self.tankLid2.minRot, 3, self.tankLid2.rotTime, dt, self.tankLid1Open);
			setRotation(self.tankLid2.node, unpack(newRot));
		end;
		-- Tank lids done
		
		-- Grain auger
		if self.attacherVehicle.isEntered then
			if InputBinding.hasEvent(InputBinding.JD1910MOVEAUGER) then
				self.augerMode = self.augerMode + 1;
				self.augerRunning = false;
				self.augerSound = false;
			end;
		end;
		
		if self.augerMode >= 8 then
			self.augerMode = 0;
		end;
		
		if self.augerMode == 1 then 
			self:setAugerModeFillRear(dt);
		elseif self.augerMode == 2 then
			self:setAugerModeFillFront(dt);
		elseif self.augerMode == 3 then
			self:setAugerModePre(dt);
		elseif self.augerMode == 4 then
			self:setAugerModeEmptyFront(dt);
		elseif self.augerMode == 5 then
			self:setAugerModeEmptyRear(dt);
		elseif self.augerMode == 6 then
			self:setAugerModePost(dt);
		elseif self.augerMode == 7 then
			self:setAugerModePre2(dt);
		elseif self.augerMode == 0 then
			self:setAugerModeTransport(dt);
		end;
		
	else
		self.standMax = false;
	end;
	
	if self.standMax ~= nil then
		local x, y, z = getTranslation(self.stand.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.stand.maxTrans, self.stand.minTrans, 3, self.stand.transTime, dt, not self.standMax);
        setTranslation(self.stand.node, unpack(newTrans));
	end;
	
	-- Weight
	if self.emptyMass == nil then
		self.emptyMass = getMass(self.components[1].node);
		if self.emptyMass <= 1 then
			self.emptyMass = 10.3;
		end;
		self.currentMass = self.emptyMass;
	end;
	self.currentWeight = (self.rearFillLevel + self.frontFillLevel)/1300;
	local newMass = self.emptyMass + self.currentWeight;
	if newMass ~= self.currentMass then
		setMass(self.components[1].node, newMass);
		self.currentMass = newMass;
		for k,v in pairs(self.components) do
			if v.node == self.components[1].node then
				if v.centerOfMass ~= nil then
					setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
				end;
				break;
			end;
		end;
	end;

	-- particles
	if self.frontFillLevel > self.lastFrontFillLevel or self.rearFillLevel > self.lastRearFillLevel then
		if self.augerMode == 1 then
			if self.augerRunning then
					self.savePS = self.chargeParticle[FruitUtil.fruitIndexToDesc[self.currentRearFillType].name]; 
					Utils.setEmittingState(self.savePS, true);
					self.grainSound = true;
			else
				Utils.setEmittingState(self.savePS, false);
				self.grainSound = false;
			end;
		elseif self.augerMode == 2 then
			if self.augerRunning then
					self.savePS = self.chargeParticle[FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name]; 
					Utils.setEmittingState(self.savePS, true);
					self.grainSound = true;
			else
				Utils.setEmittingState(self.savePS, false);
				self.grainSound = false;
			end;
		else
			Utils.setEmittingState(self.savePS, false);
			self.grainSound = false;
		end;
	elseif self.frontFillLevel < self.lastFrontFillLevel or self.rearFillLevel < self.lastRearFillLevel then
		self.trailerFound = 0;
		local x,y,z = getWorldTranslation(self.augerUnloadPosition);
    	raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
		
		local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
		if self.trailerFound ~= 0 then
			if self.augerMode == 4 then
				if self.augerRunning then
					self.savePS = self.chargeParticle[FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name]; 
					Utils.setEmittingState(self.savePS, true);
					-- self.saveUnloadPS = self.chargeParticle2[FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name]; 
					-- Utils.setEmittingState(self.saveUnloadPS, true);
					-- self.grainSound = true;
				else
					Utils.setEmittingState(self.savePS, false);
					-- Utils.setEmittingState(self.saveUnloadPS, false);
					self.grainSound = false;
				end;
			elseif self.augerMode == 5 then
				if self.augerRunning then
					self.savePS = self.chargeParticle[FruitUtil.fruitIndexToDesc[self.currentRearFillType].name]; 
					Utils.setEmittingState(self.savePS, true);
					-- self.saveUnloadPS = self.chargeParticle2[FruitUtil.fruitIndexToDesc[self.currentRearFillType].name]; 
					-- Utils.setEmittingState(self.saveUnloadPS, true);
					self.grainSound = true;
				else
					Utils.setEmittingState(self.savePS, false);
					-- Utils.setEmittingState(self.saveUnloadPS, false);
					self.grainSound = false;
				end;
			else
				Utils.setEmittingState(self.savePS, false);
				-- Utils.setEmittingState(self.saveUnloadPS, false);
				self.grainSound = false;
			end;
		else
			Utils.setEmittingState(self.savePS, false);
			-- Utils.setEmittingState(self.saveUnloadPS, false);
			self.grainSound = false;
		end;
	elseif self.frontFillLevel == self.lastFrontFillLevel and self.rearFillLevel == self.lastRearFillLevel then
		Utils.setEmittingState(self.savePS, false);
		-- Utils.setEmittingState(self.saveUnloadPS, false);
		self.grainSound = false;
	end;
	
	self.lastFrontFillLevel = self.frontFillLevel;
	self.lastRearFillLevel = self.rearFillLevel;
	
	
	-- auger sound
	if self.augerSound and self:getIsActiveForSound() then
        if not self.AugerStartPlaying then
			playSample(self.AugerStartSoundId, 1, 1, 0);
			self.AugerStartPlaying = true;
			stopSample(self.AugerStopSoundId);
			self.AugerStopPlaying = false;
		end;
	else
        if self.AugerStartPlaying then
			stopSample(self.AugerStartSoundId);
			self.AugerStartPlaying = false;
			playSample(self.AugerStopSoundId, 1, 1, 0);
			self.AugerStopPlaying = true;	
		end;
	end;
	
	if self.augerSound and self:getIsActiveForSound() then
		if self.playAugerSoundTime <= self.attacherVehicle.time then
			if not self.AugerPlaying then
				playSample(self.AugerSoundId, 0, 1, 0);
				self.AugerPlaying = true;
			end;
		end;
	else
			if self.AugerPlaying then
				stopSample(self.AugerSoundId);
				self.AugerPlaying = false;
			end;
	end;
	
	-- Grain sound
	if self.grainSound and self:getIsActiveForSound() then
			if not self.GrainPlaying then
				playSample(self.GrainSoundId, 0, 1, 0);
				self.GrainPlaying = true;
			end;
	else
			if self.GrainPlaying then
				stopSample(self.GrainSoundId);
				self.GrainPlaying = false;
			end;
	end;
	
	-- fan sound
	if self.fanSound and self:getIsActiveForSound() then
        if not self.FanStartPlaying then
			playSample(self.FanStartSoundId, 1, 1, 0);
			self.FanStartPlaying = true;
			stopSample(self.FanStopSoundId);
			self.FanStopPlaying = false;
		end;
	else
        if self.FanStartPlaying then
			stopSample(self.FanStartSoundId);
			self.FanStartPlaying = false;
			playSample(self.FanStopSoundId, 1, 1, 0);
			self.FanStopPlaying = true;	
		end;
	end;
	
	if self.fanSound and self:getIsActiveForSound() then
		if self.playFanSoundTime <= self.attacherVehicle.time then
			if not self.FanPlaying then
				playSample(self.FanSoundId, 0, 1, 0);
				self.FanPlaying = true;
			end;
		end;
	else
			if self.FanPlaying then
				stopSample(self.FanSoundId);
				self.FanPlaying = false;
			end;
	end;
	
	if self.attacherVehicle == nil then
		self.augerSound = false;
		self.grainSound = false;
		self.fanSound = false;
	    self.AugerStartPlaying = false;
	    self.AugerStopPlaying = false;
	    self.AugerPlaying = false;
		self.GrainPlaying = false;
		self.FanStartPlaying = false;
	    self.FanStopPlaying = false;
	    self.FanPlaying = false;
		if self.AugerPlaying ~= nil then
			stopSample(self.AugerSoundId);
		end;
		if self.GrainPlaying ~= nil then
			stopSample(self.GrainSoundId);
		end;
		if self.FanPlaying ~= nil then
			stopSample(self.FanSoundId);
		end;
	end	

	if self.attacherVehicle ~= nil and not self.attacherVehicle.isEntered then
	    self.AugerStartPlaying = false;
	    self.AugerStopPlaying = false;
	    self.AugerPlaying = false;
	    self.GrainPlaying = false;
	    self.FanStartPlaying = false;
	    self.FanStopPlaying = false;
	    self.FanPlaying = false;
	end;
	
	if self.attacherVehicle ~= nil and not self.attacherVehicle.isEntered and self.augerRunning then
		setVisibility(self.externalAugerSound, true);
		if self.grainSound then
			setVisibility(self.externalGrainSound, true);
		else
			setVisibility(self.externalGrainSound, false);
		end;
	else
		setVisibility(self.externalAugerSound, false);
		setVisibility(self.externalGrainSound, false);
	end;
	
	if self.attacherVehicle ~= nil and not self.attacherVehicle.isEntered and self.FanOn then
		setVisibility(self.externalFanSound, true);
	else
		setVisibility(self.externalFanSound, false);
	end;
	
	-- AI
	self.stopAI = false;
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isAITractorActivated then
			self.attacherVehicle.turnStage3Timeout = 0;
			if self.currentFrontFillType == FruitUtil.FRUITTYPE_UNKNOWN and self.currentRearFillType == FruitUtil.FRUITTYPE_UNKNOWN then
				self.stopAI = true;
			elseif self.currentFrontFillType == FruitUtil.FRUITTYPE_UNKNOWN and self.currentRearFillType == FruitUtil.FRUITTYPE_FERTILIZER then
				self.stopAI = true;
			elseif self.currentRearFillType == FruitUtil.FRUITTYPE_UNKNOWN and self.currentFrontFillType == FruitUtil.FRUITTYPE_FERTILIZER then
				self.stopAI = true;
			end;
			
			if self.stopAI then
				AITractor.stopAITractor(self.attacherVehicle);
				self.FanOn = false;
				self.lowerBooms = false;
			end;
			if self.attacherVehicle.turnStage == 0 then
				self.lowerBooms = true;
			else
				self.lowerBooms = false;
			end;
		else
			if self.attacherVehicle.isAITractorActivated ~= nil then
				self.attacherVehicle.turnStage3Timeout = 10000;
			end; 	
		end;
	end;
	-- AI end
end;

function Aircart:draw()
	-- renderText(0.5, 0.5, 0.02, string.format("%d", self.augerMode));
	if self.hudOn >= 1 then
		-- Weight and fill Display
		self.hudOverlay:render();
		setTextColor(0, 0, 0, 1.0);
		setTextBold(true);
		renderText(0.799, 0.84, 0.015, string.format("FRONT:"))
		renderText(0.835, 0.84, 0.015, string.format("%d", self.frontFillLevel));
		renderText(0.799, 0.825, 0.015, string.format("LOAD:"));
		if self.currentFrontFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			renderText(0.835, 0.825, 0.015, string.format(FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name));
		else
			renderText(0.835, 0.825, 0.015, string.format("-"));
		end;
		
		
		renderText(0.799, 0.80, 0.015, string.format("REAR:"))
		renderText(0.835, 0.80, 0.015, string.format("%d", self.rearFillLevel));
		renderText(0.799, 0.785, 0.015, string.format("LOAD:"));
		if self.currentRearFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			renderText(0.835, 0.785, 0.015, string.format(FruitUtil.fruitIndexToDesc[self.currentRearFillType].name));
		else
			renderText(0.835, 0.785, 0.015, string.format("-"));
		end;
	end;
	if self.hudOn >= 2 then
		-- Status texts
		setTextBold(false);
		setTextColor(1, 1, 1, 1.0);
		
		if self.FanOn then
			renderText(0.76, 0.69, 0.020, string.format("Turn Airflow OFF ["..self.keyType(InputBinding.JD1910STARTSEEDER).."]"));
		else
			renderText(0.76, 0.69, 0.020, string.format("Turn Airflow ON ["..self.keyType(InputBinding.JD1910STARTSEEDER).."]"));
		end;
		
		if self.openTankLids then
			renderText(0.76, 0.67, 0.020, string.format("Close tank lids ["..self.keyType(InputBinding.JD1910OPENLIDS).."]"));
		else
			renderText(0.76, 0.67, 0.020, string.format("Open tank lids ["..self.keyType(InputBinding.JD1910OPENLIDS).."]"));
		end;
		
		if self.augerRunning then
			renderText(0.76, 0.65, 0.020, string.format("Stop grain auger ["..self.keyType(InputBinding.JD1910AUGER).."]"));
		else
			renderText(0.76, 0.65, 0.020, string.format("Start grain auger ["..self.keyType(InputBinding.JD1910AUGER).."]"));
		end;
		
		renderText(0.76, 0.63, 0.020, string.format("Move auger to next position ["..self.keyType(InputBinding.JD1910MOVEAUGER).."]"));
		
		if self.augerMode == 0 then
			renderText(0.76, 0.61, 0.020, string.format("Current position:  Transport"));
			renderText(0.76, 0.59, 0.020, string.format("Next position:     Fill Rear"));
		elseif self.augerMode == 1 then
			renderText(0.76, 0.61, 0.020, string.format("Current position:  Fill Rear"));
			renderText(0.76, 0.59, 0.020, string.format("Next position:     Fill Front"));
		elseif self.augerMode == 2 then
			renderText(0.76, 0.61, 0.020, string.format("Current position:  Fill Front"));
			renderText(0.76, 0.59, 0.020, string.format("Next position:     Empty Front"));
		elseif self.augerMode == 4 then
			renderText(0.76, 0.61, 0.020, string.format("Current position:  Empty Front"));
			renderText(0.76, 0.59, 0.020, string.format("Next position:     Empty Rear"));
		elseif self.augerMode == 5 then
			renderText(0.76, 0.61, 0.020, string.format("Current position:  Empty Rear"));
			renderText(0.76, 0.59, 0.020, string.format("Next position:     Transport"));
		end;
	end;
	if self.hudOn >= 0 then
		setTextBold(false);
		setTextColor(1, 1, 1, 1.0);
		renderText(0.76, 0.71, 0.020, string.format("Change HUD mode ["..self.keyType(InputBinding.JD1910HUD).."]"));
	end;
	if self.loadTrailerFound or self.unloadTrailerFound then
		self.hudPDAOverlay:render();
	end;

end;

function Aircart:onDetach()
	self.augerRunning = false;
	self.FanOn = false;
end;

function Aircart:onLeave()
end;

function Aircart:onDeactivate()
end;

function Aircart:onDeactivateSounds()
end;

function Aircart:setAugerModeTransport(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 3500;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(90);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 2000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(0);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(20);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 1000;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-100);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 2000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(0);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, true, true, true, true);
end;

function Aircart:setAugerModeFillRear(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 500;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(80);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 2000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(0);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(25);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 2000;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-30);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 2000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(0);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, false, false, false);
end;

function Aircart:setAugerModeFillFront(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 2000;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(80);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 2000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(0);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(80);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 2000;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-50);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 2000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(0);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, false, false, false);
end;

function Aircart:setAugerModeEmptyFront(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 3000;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(330);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 3000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(265);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(80);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 4000;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-63);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 4000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(-132);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, true, false, false);
end;

function Aircart:setAugerModeEmptyRear(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 1500;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(265);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 1500;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(180);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(118);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 1500;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(80);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-63);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 1500;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(-123);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, true, false, false);
	
	--self.augerStep1Done = false;
	--if self.grainAuger ~= nil then
	--	local x, y, z = getRotation(self.grainAuger);
	--	local eps = 1;
		
	--	if math.abs(augerMaxX1-x) < eps and math.abs(augerMaxY1-y) < eps and math.abs(augerMaxZ1-z) < eps then
	--		self.augerStep1Done = true;
	--	end;
	--end;
end;

function Aircart:setAugerModePre(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 4000;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(330);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 4000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(80);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(80);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 1500;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-50);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 1500;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(-132);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, false, true, true);
	
		if self.augerPivotPart3 ~= nil then
			local x, y, z = getRotation(self.augerPivotPart3);
			local eps = 0.01;
			
			if math.abs(pivot3Max[2]-y) < eps then
				self.augerMode = self.augerMode + 1;
				--renderText(0.5, 0.5, 0.02, string.format("Extended"))
            end;
		end;
	
end;

function Aircart:setAugerModePre2(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 2000;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(330);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 2000;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(90);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(30);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 2000;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-123);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 2000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(-132);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, true, false, false);
	
	if self.augerPivotPart1 ~= nil then
		local x, y, z = getRotation(self.augerPivotPart1);
		local eps = 0.005;
		
		if math.abs(y-pivot1Max[2]) < eps then
			self.augerMode = self.augerMode + 1;
		end;
	end;
end;

function Aircart:setAugerModePost(dt)
	local augerMax = {};
	augerMax[1] = Utils.degToRad(46);
	augerMax[2] = Utils.degToRad(0);
	augerMax[3] = Utils.degToRad(0);
	local augerRotationTime = 4000;
	
	local augerMin = {};
	augerMin[1] = Utils.degToRad(13);
	augerMin[2] = Utils.degToRad(0);
	augerMin[3] = Utils.degToRad(0);
	
	local pivot3Max = {};
	pivot3Max[1] = Utils.degToRad(0);
	pivot3Max[2] = Utils.degToRad(330);
	pivot3Max[3] = Utils.degToRad(0);
	local pivot3RotationTime = 1500;
	
	local pivot3Min = {};
	pivot3Min[1] = Utils.degToRad(0);
	pivot3Min[2] = Utils.degToRad(180);
	pivot3Min[3] = Utils.degToRad(0);
	
	local pivot2Max = {};
	pivot2Max[1] = Utils.degToRad(0);
	pivot2Max[2] = Utils.degToRad(118);
	pivot2Max[3] = Utils.degToRad(0);
	local pivot2RotationTime = 1500;
	
	local pivot2Min = {};
	pivot2Min[1] = Utils.degToRad(0);
	pivot2Min[2] = Utils.degToRad(0);
	pivot2Min[3] = Utils.degToRad(0);
	
	local pivot1Max = {};
	pivot1Max[1] = Utils.degToRad(0);
	pivot1Max[2] = Utils.degToRad(-63);
	pivot1Max[3] = Utils.degToRad(0);
	local pivot1RotationTime = 4000;
	
	local pivot1Min = {};
	pivot1Min[1] = Utils.degToRad(0);
	pivot1Min[2] = Utils.degToRad(-132);
	pivot1Min[3] = Utils.degToRad(0);
	
	self:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, 
	pivot1Min, augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, false, false, true, true);
	
		if self.augerPivotPart1 ~= nil then
			local x, y, z = getRotation(self.augerPivotPart1);
			local eps = 0.01;
			
			if math.abs(y-pivot1Min[2]) < eps then
				self.augerMode = self.augerMode + 1;
            end;
		end;
	
end;

function Aircart:rotateAuger(dt, augerMax, augerMin, pivot3Max, pivot3Min, pivot2Max, pivot2Min, pivot1Max, pivot1Min, 
				augerRotationTime, pivot3RotationTime, pivot2RotationTime, pivot1RotationTime, augerExtending, pivot3Extending, 
				pivot2Extending, pivot1Extending)
    --renderText(0.5, 0.5, 0.02, string.format("In method"))
	if self.grainAuger ~= nil then
		local x, y, z = getRotation(self.grainAuger);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, augerMax, augerMin, 3, augerRotationTime, dt, augerExtending);
		setRotation(self.grainAuger, unpack(newRot));
		--renderText(0.5, 0.4, 0.070, string.format(dt));
	end;
	
	if self.augerPivotPart3 ~= nil then
		local x, y, z = getRotation(self.augerPivotPart3);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, pivot3Max, pivot3Min, 3, pivot3RotationTime, dt, pivot3Extending);
		setRotation(self.augerPivotPart3, unpack(newRot));
		--renderText(0.5, 0.3, 0.070, string.format(dt));
	end;
	
	if self.augerPivotPart2 ~= nil then
		local x, y, z = getRotation(self.augerPivotPart2);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, pivot2Max, pivot2Min, 3, pivot2RotationTime, dt, pivot2Extending);
		setRotation(self.augerPivotPart2, unpack(newRot));
		--renderText(0.5, 0.3, 0.070, string.format(dt));
	end;
	
	if self.augerPivotPart1 ~= nil then
		local x, y, z = getRotation(self.augerPivotPart1);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, pivot1Max, pivot1Min, 3, pivot1RotationTime, dt, pivot1Extending);
		setRotation(self.augerPivotPart1, unpack(newRot));
		--renderText(0.5, 0.3, 0.070, string.format(dt));
	end;
end;

function Aircart:setFrontFillLevel(fillLevel, fillType)

    --self.frontFillLevel = fillLevel;
    if fillLevel > self.capacityFront then
        self.frontFillLevel = self.capacityFront;
	else
		self.frontFillLevel = fillLevel;
    end;
    if self.frontFillLevel < 0 then
        self.frontFillLevel = 0;
    end;
    if self.currentFrontGrainPlane ~= nil then
        setVisibility(self.currentFrontGrainPlane, false);
    end;
    if self.frontGrainPlanes ~= nil and self.defaultFrontGrainPlane ~= nil and self.currentFrontFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fillTypeName = FruitUtil.fruitIndexToDesc[self.currentFrontFillType].name;
        local grainPlane = self.frontGrainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultFrontGrainPlane;
        end;
        if self.frontGrainAnimCurve then
            local x,y,z, rx,ry,rz, sx,sy,sz = self.frontGrainAnimCurve:get(self.frontFillLevel/self.capacityFront);
			setTranslation(grainPlane, x, y, z);			
			setScale(grainPlane, sx, sy, sz);
        end;
        setVisibility(grainPlane, self.frontFillLevel > 0);
        self.currentFrontGrainPlane = grainPlane;
    end;
end;

function Aircart:setRearFillLevel(fillLevel, fillType)

    --self.frontFillLevel = fillLevel;
    if fillLevel > self.capacityRear then
        self.rearFillLevel = self.capacityRear;
		-- renderText(0.5, 0.5, 0.02, string.format("setFrontFillLevel"))
	else
		self.rearFillLevel = fillLevel;
    end;
    if self.rearFillLevel < 0 then
        self.rearFillLevel = 0;
    end;
    if self.currentRearGrainPlane ~= nil then
        setVisibility(self.currentRearGrainPlane, false);
    end;
    if self.rearGrainPlanes ~= nil and self.defaultRearGrainPlane ~= nil and self.currentRearFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fillTypeName = FruitUtil.fruitIndexToDesc[self.currentRearFillType].name;
        local grainPlane = self.rearGrainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultRearGrainPlane;
        end;
        if self.rearGrainAnimCurve then
            local x,y,z, rx,ry,rz, sx,sy,sz = self.rearGrainAnimCurve:get(self.rearFillLevel/self.capacityRear);
			setTranslation(grainPlane, x, y, z);			
			setScale(grainPlane, sx, sy, sz);
        end;
        setVisibility(grainPlane, self.rearFillLevel > 0);
        self.currentRearGrainPlane = grainPlane;
    end;
end;

function Aircart:findTrailerRaycastCallback(transformId, x, y, z, distance)
    local vehicle = g_currentMission.nodeToVehicle[transformId];
    if vehicle ~= nil then
        if vehicle.exactFillRootNode == transformId then
            self.trailerFound = transformId;
			trailer = g_currentMission.nodeToVehicle[self.trailerFound];
			if trailer ~= nil then
				tcft = FruitUtil.fillTypeToFruitType[trailer.currentFillType];
			end;
            return false;
        end;
    end;
    if getUserAttribute(transformId, "onCreate") == "SprayerFillTrigger.onCreate" then 
		if getUserAttribute(transformId, "sprayType") == "fertilizer" or getUserAttribute(transformId, "sprayType") == "liquidManure" then 
				self.trailerFound = "FillTrigger";
				trailer = self.trailerFound;
			    local sprayTypeStr = "fertilizer";
				if sprayTypeStr ~= nil then
					self.sprayTypeDesc = Sprayer.sprayTypes[sprayTypeStr];
					if self.sprayTypeDesc ~= nil then
						local sfillType = Sprayer.sprayTypeToFillType[self.sprayTypeDesc.index];
						if sfillType ~= nil then
							local sprayType = Sprayer.fillTypeToSprayType[self.sprayTypeDesc.index];
							tcft =  FruitUtil.fillTypeToFruitType[sfillType];
							if sprayType ~= nil then
								local sprayTypeDesc = Sprayer.sprayTypeIndexToDesc[sprayType];
								if getUserAttribute(transformId, "sprayType") ~= "liquidManure" then
									tcftpricePerLiter = sprayTypeDesc.pricePerLiter;
								else
									tcftpricePerLiter = "liquidManure";
									if g_currentMission:getSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE) <= 0 then
										tcft = FruitUtil.FRUITTYPE_UNKNOWN;
										g_currentMission:setSiloAmount(Fillable.FILLTYPE_LIQUIDMANURE, 0);
									end;
								end;
							end;
						end;
					end;
				end;
			return false;
		end;
    end;

    return true;

end;
