-- cre par @poc@lypse


jcb = {}

function jcb.prerequisitesPresent(specializations)
 Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function jcb:load(xmlFile)

 
    
	local rotationPartNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
        self.rotationPart1.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart1#pivotverin"));
    end;
	
    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

	local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;

    local translationPartNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart1#index"));
    if translationPartNode1 ~= nil then
        self.translationPart1 = {};
        self.translationPart1.node = translationPartNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#minTrans"));
        self.translationPart1.minTrans = {};
        self.translationPart1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart1#maxTrans"));
        self.translationPart1.maxTrans = {};
        self.translationPart1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#transTime"), 2)*1000;
        self.translationPart1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart1#touchTransLimit"), 10);
    end;
	
	    local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;

	
	    local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
	 
	 
        
   
end;

function jcb:delete()  
end;


function jcb:mouseEvent(posX, posY, isDown, isUp, button)                   
end;

function jcb:keyEvent(unicode, sym, modifier, isDown)   
           
   
  
      
            
	if sym == Input.KEY_KP_7 then
        self.rotationMax1 = isDown;      
       	end;
	if sym == Input.KEY_KP_4 then
		self.rotationMin1 = isDown;
	end;	
	
	if sym == Input.KEY_KP_6 then
        self.rotationMax2 = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.rotationMin2 = isDown;
	end;
	
    if sym == Input.KEY_KP_8 then
		self.translationMax = isDown;      
	end;
	if sym == Input.KEY_KP_5 then
		self.translationMin = isDown;
	end;
	
    
   
end;

function jcb:update(dt)  
  

       
         
	if self.rotationPart1 ~= nil and (self.rotationMax1 or self.rotationMin1) then
          local x, y, z = getRotation(self.rotationPart1.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
          setRotation(self.rotationPart1.node, unpack(newRot));        
    end;
	
	if self.rotationPart2 ~= nil and (self.rotationMax2 or self.rotationMin2) then
          local x, y, z = getRotation(self.rotationPart2.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
          setRotation(self.rotationPart2.node, unpack(newRot));
    end;

    if self.translationPart1 ~= nil and (self.translationMax or self.translationMin) then
        local x, y, z = getTranslation(self.translationPart1.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart1.maxTrans, self.translationPart1.minTrans, 3, self.translationPart1.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart1.node, unpack(newTrans));
        
    end;	
	
	if self.translationPart2 ~= nil and (self.translationMax or self.translationMin) then
        local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart2.node, unpack(newTrans));
    end;	
	
	if self.translationPart3 ~= nil and (self.translationMax or self.translationMin) then
        local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart3.node, unpack(newTrans));
    end;
    
    if self.verin1 ~= nil and self.rotationPart1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, 0, (distance-self.verin1.tigeDistance)*-1);
		end;
	end;

  

end;

function jcb:draw()  
end;


function jcb:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;