--
-- BackhoeHandThrottle
-- Specialization for hand throttle on steerables
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

BackhoeHandThrottle = {};

function BackhoeHandThrottle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BackhoeHandThrottle:load(xmlFile)
    self.handThrottleMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    self.handThrottleMaxRpm = self.motor.maxRpm[3];
	self.handThrottleEnabled = false;
    self.handThrottlePercentage = 0.05;
end;

function BackhoeHandThrottle:delete()
end;

function BackhoeHandThrottle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BackhoeHandThrottle:keyEvent(unicode, sym, modifier, isDown)
end;

function BackhoeHandThrottle:update(dt)
    if self.isEntered then

	    local roundPerMinute = self.lastRoundPerMinute*1 + (1-1)*(self.motor.lastMotorRpm-self.motor.minRpm);
        local rpmDiff = math.abs(roundPerMinute - ((self.handThrottleMaxRpm * 0.9) * self.handThrottlePercentage));
	
        if self:getIsActiveForInput() then
		
            if InputBinding.isPressed(InputBinding.Backhoe_INCREASE_RPM) and self.handThrottlePercentage < 1 then
		        self.handThrottlePercentage = self.handThrottlePercentage + 0.005; 
		    	self.handThrottleEnabled = true;
			end;
		    
			if InputBinding.isPressed(InputBinding.Backhoe_DECREASE_RPM) and self.handThrottlePercentage > 0.05 then
		        self.handThrottlePercentage = self.handThrottlePercentage - 0.005; 
			    self.handThrottleEnabled = true;
	        end;
			
		    if InputBinding.hasEvent(InputBinding.Backhoe_IDLE_RPM) then
		        self.handThrottleEnabled = false;
				self.motor.minRpm = self.handThrottleMinRpm;
				self.handThrottlePercentage = 0.05;
		    end;
        end;
	
	    if self.handThrottleEnabled then
		
            if roundPerMinute < ((self.handThrottleMaxRpm * self.handThrottlePercentage) - 50) then
                self.motor.minRpm = self.motor.minRpm - (rpmDiff / 10);
            elseif roundPerMinute > ((self.handThrottleMaxRpm * self.handThrottlePercentage) + 50) then
			    if self.motor.minRpm <= (self.handThrottleMinRpm - (rpmDiff/10)) then
                    self.motor.minRpm = self.motor.minRpm + (rpmDiff / 10);
		        end;
            end;
			
		end;
	end;
end;

function BackhoeHandThrottle:stopMotor()
    self.motor.minRpm = self.handThrottleMinRpm;
end;
	
function BackhoeHandThrottle:onLeave()
    self.motor.minRpm = self.handThrottleMinRpm;
end;

function BackhoeHandThrottle:draw()
    if self.isMotorStarted then
       g_currentMission:addExtraPrintText(string.format("RPM: %s,%s,%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_INCREASE_RPM), InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_DECREASE_RPM), InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_IDLE_RPM)));
    end;
end;

