--
-- BackhoeRpmLimiter
-- Specialization for a rpm limiter
--
-- @author  Templaer
-- @date  01/05/09
--

BackhoeRpmLimiter = {};

function BackhoeRpmLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BackhoeRpmLimiter:load(xmlFile)
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 500);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 900);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1400);
    motorMaxRpm4 = Utils.getNoNil(motorMaxRpm4, 1900);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3, motorMaxRpm4};
    self.motorMaxRpmLimit = motorMaxRpm;
end;

function BackhoeRpmLimiter:delete()
end;

function BackhoeRpmLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BackhoeRpmLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function BackhoeRpmLimiter:update(dt)
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.Backhoe_ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[4] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.Backhoe_DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.Backhoe_ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[4] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.Backhoe_DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
			
	    end;
		
	end;
end;

function BackhoeRpmLimiter:draw()
        if self.isEntered and self.isMotorStarted then
            if self.motor.speedLevel ~= 0 then
               g_currentMission:addExtraPrintText(string.format("Speed: %s,%s, %d", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_ACCELERATE), InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_DECELERATE), self.motor.maxRpm[self.motor.speedLevel]));
	    else
               g_currentMission:addExtraPrintText(string.format("Speed: %s,%s, %d", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_ACCELERATE), InputBinding.getKeyNamesOfDigitalAction(InputBinding.Backhoe_DECELERATE), self.motor.maxRpm[3]));
	    end;
	end;
end;

