--
-- Options
-- Specialization for seperate Options
--
-- @author @poc@lypse
-- 
--

Options = {};

function Options.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Options:load(xmlFile)
--Fenetre et porte
self.doRotate = SpecializationUtil.callSpecializationsFunction("doRotate");

    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;	
--
-- Type de roues
 self.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    self.jumWheels = {};
    for i=1, self.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        self.jumWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(self.jumWheels[i], false);        
    end;
    self.jumelagesActive = false;	


    self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);        
    end;
	self.twinWheelsActive = false;  
 
	self.numSmallWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.smallWheels#count"), 0);
    self.smallWheels = {};
    for i=1, self.numSmallWheels do
        local smallWheelnamei = string.format("vehicle.smallWheels.smallWheel" .. "%d", i);
        self.smallWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, smallWheelnamei .. "#index"));
        setVisibility(self.smallWheels[i], true);       
    end; 
        self.smallWheelsActive = true;
--

--Phare
     self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);        
    end;
        self.worklightsActive = false;
    self.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.travails#count"), 0);
    self.travails = {};
    for i=1, self.numtravails do
        local travailnamei = string.format("vehicle.travails.travail" .. "%d", i);
        self.travails[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(self.travails[i], false);        
    end;
        self.travailsActive = false;
--

--Girophare

    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
--
    
end;
function Options:delete()
end;

function Options:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Options:keyEvent(unicode, sym, modifier, isDown)
end;

function Options:update(dt)
	if self.isEntered then
                 --Fenetre et porte
                    if self.rotatingParts[1] ~= nil then
			if InputBinding.hasEvent(InputBinding.DOOR) then
				self.isLeftDoorOpen = not self.isLeftDoorOpen;
			end;
			
			self:doRotate(1, self.isLeftDoorOpen, dt);	
		    end;		  
		
		     if self.rotatingParts[2] ~= nil then		
			if InputBinding.hasEvent(InputBinding.WINDOW) then	
				self.isRearWindowOpen = not self.isRearWindowOpen;
			end;
		
			self:doRotate(2, self.isRearWindowOpen, dt);
		      end;
                 --

                 --type de roue
                        for k, jumWheel in pairs(self.jumWheels) do
				setVisibility(jumWheel, self.jumelagesActive);
			end;
           
                        for i, twinWheel in pairs(self.twinWheels) do
				setVisibility(twinWheel, self.twinWheelsActive);
			end;
  
                        for j, smallWheel in pairs(self.smallWheels) do
				setVisibility(smallWheel, self.smallWheelsActive);
			end;
		
                    if InputBinding.hasEvent(InputBinding.JUMELAGES) then
                        if self.smallWheelsActive == true then                 
                          self.jumelagesActive = true;
                          self.smallWheelsActive = false;                 
                        elseif self.jumelagesActive == true then           
                          self.jumelagesActive = false;
                          self.smallWheelsActive = false;          
                          self.twinWheelsActive = true;  
                        elseif self.twinWheelsActive == true then
                          self.twinWheelsActive = false;
	                  self.smallWheelsActive = true; 
                        end;      
		    end;
                --
                 
                --Feux de travail                   
                    if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.worklightsActive = not self.worklightsActive;                        
			for k, worklight in pairs(self.worklights) do
				setVisibility(worklight, self.worklightsActive);
			end;
                        
		    end;
                    if InputBinding.hasEvent(InputBinding.WORKLIGHTS1) then
			self.travailsActive = not self.travailsActive;
			for k, travail in pairs(self.travails) do
				setVisibility(travail, self.travailsActive);
			end;
		    end;
                --

                --Girophare
                    if self.isEntered and not self.worklightsActive and not self.travailsActive then
                      if self.rundumleuchtenKey ~= nil then
                         if InputBinding.hasEvent(InputBinding.GIROPHARE) then
                           self.rundumleuchtenAn = not self.rundumleuchtenAn;
                           for i=1, self.rundumleuchtenAnz do
                             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
                           end;
                         end;
                      end;
                    end;

                     if self.rundumleuchtenAnz > 0 then
                       if self.rundumleuchtenAn then
                          for i=1, self.rundumleuchtenAnz do
                              rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
                          end;
                        end;
                      end;
                  --

	end;
end;

function Options:onLeave()
 self.worklightsActive = false;
 self.travailsActive = false;
 self.rundumleuchtenAn = false;
     for i=1, self.rundumleuchtenAnz do
      setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
     end;	
end;

function Options:draw()
	self:addInfoText(InputBinding.JUMELAGES, g_i18n:getText("Typeroue"));
        self:addInfoText(InputBinding.GIROPHARE, g_i18n:getText("Girophare"));
        self:addStats(g_i18n:getText("Key").." ".."4, 5:", "Allumer feux de travail");
     if self.rotatingParts[i] ~= nil then
        self:addStats(g_i18n:getText("Key").." ".."7, 8:", "Ouvrir fenetres et portes");
     end;
end;

function Options:doRotate(index, boolean, dt)
	local x, y, z = getRotation(self.rotatingParts[index].node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[index].maxRot, self.rotatingParts[index].minRot, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	setRotation(self.rotatingParts[index].node, unpack(newRot));
end;