--
-- Ignition
-- version 1.1
--
-- a specialization that allows the player to manually start and stop the vehicle's motor
--
-- @author  Templaer
-- @date  19/11/09
--

Ignition = {};

function Ignition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ignition:load(xmlFile)
	self.applyBrakes = SpecializationUtil.callSpecializationsFunction("applyBrakes");
	self.startMotorManually = SpecializationUtil.callSpecializationsFunction("startMotorManually");
	self.stopMotorManually = SpecializationUtil.callSpecializationsFunction("stopMotorManually");

    self.ignitionKey = false;
	self.ignitionAllowed = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;	
	
	self.backupStopVolume = self.motorStopSoundVolume;
	self.motorStopSoundVolume = 0;
	self.steeringEnabled = false;
end;

function Ignition:delete()
end;

function Ignition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ignition:keyEvent(unicode, sym, modifier, isDown)
end;

function Ignition:update(dt)
	if self.isEntered then
		if not self.isAITractorActivated then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.IGNITION) then
					self.ignitionKey = not self.ignitionKey;
					self.ignitionAllowed = true;
				end;
				
				if math.abs(self.acceleration) > 0 and self.isMotorStarted == false then
					self.ignitionKey = true;
					self.ignitionAllowed = true;
				end;	
			end;
			
			if self.ignitionAllowed then
				self.ignitionAllowed = false;
				if self.ignitionKey then	
					self:startMotorManually();
				elseif not self.ignitionKey then
					self:stopMotorManually();
				end;
			end;
		elseif not self.ignitionKey and not self.deactivateOnLeave then
			self:stopAITractor();
		end;
	end;
end;

function Ignition:onEnter()
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	end;
    setVisibility(self.aiMotorSound, false);
end;

function Ignition:onLeave()
    if self.ignitionKey then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.isMotorStarted = true;
	end;	
	setVisibility(self.aiMotorSound, self.ignitionKey);
end;

function Ignition:draw()
	if not self.isMotorStarted then
		self:addInfoText(InputBinding.IGNITION, g_i18n:getText("Starts"));
	elseif not self.statisticsMode then
		self:addInfoText(InputBinding.IGNITION, g_i18n:getText("Stops"));
	end;
end;

-- Additional function(s)
function Ignition:applyBrakes()
	for k,wheel in pairs(self.wheels) do
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
	end;
end;

function Ignition:startMotorManually()
	if self.powershiftLevel ~= nil then
		self.powershiftLevel = 1;
	end; 
	self:startMotor();
	self.steeringEnabled = true;
end;

function Ignition:stopMotorManually()
	self.motorStopSoundVolume = self.backupStopVolume;
	self.steeringEnabled = false;
	self.cruiseControlActive = false;
	self:applyBrakes();
	self:onDeactivateAttachements();
	self:stopMotor();
	self.motorStopSoundVolume = 0;
end;

