-- www.schwabenmodding.bplaced.net 


walkInTriggerSwitch = {};

  
local walkInTriggerSwitch_mt = Class(walkInTriggerSwitch);
  
function walkInTriggerSwitch.onCreate(id)
    g_currentMission:addUpdateable(walkInTriggerSwitch:new(id));
    print("walkInTriggerSwitch: walkInTriggerSwitch onCreate aufgerufen  OnCreate Id: "..id.." .")	
end;
  
function walkInTriggerSwitch:new(id, customMt) 
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, walkInTriggerSwitch_mt);
    end;
	 	
	local walkInTriggerId = getChildAt(id, getUserAttribute(id, "walkInTriggerIndex"));
	if walkInTriggerId ~= nil then
		instance.triggerId = walkInTriggerId;
		addTrigger(walkInTriggerId, "triggerCallback", instance);
		instance.walkInTriggerSwitch = {};
		local triggerTS = {};
		triggerTS.triggerToSwitch = getChildAt(id, getUserAttribute(id, "triggerToSwitchIndex"));
		local x, y, z = getTranslation(triggerTS.triggerToSwitch);
		triggerTS.startPositionX = x;
		triggerTS.startPositionY = y;
		triggerTS.startPositionZ = z;
		triggerTS.hasRotPart = getUserAttribute(id, "hasRotPart");
		if triggerTS.hasRotPart ~= nil or triggerTS.hasRotPart ~= false then
			triggerTS.rotPartIndex = getUserAttribute(id, getUserAttribute(id, "rotPartIndex"));
			if triggerTS.rotPartIndex ~= nil then
				triggerTS.rotValues = {};
				local startRotValues = Utils.getNoNil(getUserAttribute(id, "startRotValues"), "0 0 0");
				local endRotValues = Utils.getNoNil(getUserAttribute(id, "endRotValues"), "0 0 0");
				local rotTime = Utils.getNoNil(getUserAttribute(id, "rotTime"), 2);
				local rW = {};
				local x, y, z = Utils.getVectorFromString(startRotValues);
				rW.minRot = {};
				rW.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
				rW.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));		
				rW.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
				x, y, z = Utils.getVectorFromString(endRotValues);
				rW.maxRot = {};
				rW.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
				rW.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
				rW.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
				rW.rotTime = rotTime *1000;
				table.insert(triggerTS.rotValues, rW);
			else
				triggerTS.hasRotPart = false;
			end;
		end;
		triggerTS.isOn = false;
		self.count = 0;
		table.insert(instance.walkInTriggerSwitch, triggerTS);
	end;
    return instance;
end;
  
function walkInTriggerSwitch:delete()
    removeTrigger(self.triggerId);
end;
  
function walkInTriggerSwitch:update(dt) 
    for i=1, table.getn(self.walkInTriggerSwitch) do
		if self.count > 0 then
			self.walkInTriggerSwitch[i].isOn = true;
			renderText(0.4, 0.5, 0.033, "## Trigger aktiviert ##" );
		else
			self.walkInTriggerSwitch[i].isOn = false;	
		end;
		
		if self.walkInTriggerSwitch[i].isOn == true then
			if self.walkInTriggerSwitch[i].triggerToSwitch ~= nil then			
				setTranslation(self.walkInTriggerSwitch[i].triggerToSwitch, self.walkInTriggerSwitch[i].startPositionX, self.walkInTriggerSwitch[i].startPositionY, self.walkInTriggerSwitch[i].startPositionZ);
			end;
	    else
			if self.walkInTriggerSwitch[i].triggerToSwitch ~= nil then
				setTranslation(self.walkInTriggerSwitch[i].triggerToSwitch, self.walkInTriggerSwitch[i].startPositionX, self.walkInTriggerSwitch[i].startPositionY -100, self.walkInTriggerSwitch[i].startPositionZ);
			end;
        end;
		if self.walkInTriggerSwitch[i].hasRotPart == true then
			local x, y, z = getRotation(self.walkInTriggerSwitch[i].rotPartIndex);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.walkInTriggerSwitch[i].rotValues.maxRot, self.walkInTriggerSwitch[i].rotValues.minRot, 3, self.walkInTriggerSwitch[i].rotValues.rotTime, dt, not self.walkInTriggerSwitch[i].isOn);
			setRotation(self.cutterAnimations.mainIndex.rotNode, unpack(newRot));
		end;
	end;
end;
  
function walkInTriggerSwitch:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter then
        self.count = self.count + 1;
    elseif onLeave then
        self.count = self.count - 1;
    end; 
end;
    
g_onCreateUtil.addOnCreateFunction("walkInTriggerSwitchOnCreate", walkInTriggerSwitch.onCreate);
