-- www.schwabenmodding.bplaced.net 
-- die LUA ermglicht beliebig viele Tore auf der Map.
-- Ausserdem kann man die Richtung und den Weg des Tors bei jedem Trigger einzeln einstellen.
-- Version 2:
-- .. Im Singleplayer ist es nun mglich die Tore per Tastendruck offen zu halten bis erneutem Tastendruck. 
--    Im MP nimmt alles seinen gewohnten Gang wie bisher

translationDoors = {};

  
local translationDoors_mt = Class(translationDoors);
  
function translationDoors.onCreate(id)
    g_currentMission:addUpdateable(translationDoors:new(id));
    print("translationDoors: translationDoors onCreate aufgerufen  OnCreate Id: "..id.." .")	
end;
  
function translationDoors:new(id, customMt) 
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, translationDoors_mt);
    end;
  
    instance.triggerId = id;
    addTrigger(id, "triggerCallback", instance);
  	instance.translationDoors = {};	  	
	local door = {};
	local index = getUserAttribute(id, "doorIndex");
	door.index = getChildAt(id, index);
	door.minTrans = getUserAttribute(id, "minTrans");
	door.maxTrans = getUserAttribute(id, "maxTrans");
	door.transDirection = string.lower(Utils.getNoNil(getUserAttribute(id, "transDirection"), "x"));
	local speed = Utils.getNoNil(getUserAttribute(id, "transSpeed"), 1);
	door.speed = speed/1000
	door.trans = 0;
	door.isOpen = false;
	door.stayOpen = false;
	self.count = 0;
	if door.index ~= nil then
		table.insert(instance.translationDoors, door);
	else
		print("Error translationDoors: No doorIndex specified at Trigger, insert a doorIndex Attribute.");
	end;
	
	
    return instance;
end;
  
function translationDoors:delete()
    removeTrigger(self.triggerId);
end;
  
function translationDoors:update(dt) 
    for i=1, table.getn(self.translationDoors) do
		if self.count > 0 then
			self.translationDoors[i].isOpen = true;
			if g_currentMission.missionDynamicInfo.isMultiplayer == false then
				if InputBinding.hasEvent(InputBinding.TOGGLE_DOOR) then
					self.translationDoors[i].stayOpen = not self.translationDoors[i].stayOpen;
				end;	
			end;
		else
			if self.translationDoors[i].stayOpen == false then
				self.translationDoors[i].isOpen = false;
			else
				self.translationDoors[i].isOpen = true;
			end;
		end;
		
		if self.translationDoors[i].isOpen == true then
			if self.translationDoors[i].maxTrans > self.translationDoors[i].minTrans then
				if self.translationDoors[i].trans < self.translationDoors[i].maxTrans then
					self.translationDoors[i].trans = self.translationDoors[i].trans + dt*self.translationDoors[i].speed;
				end;
			elseif self.translationDoors[i].maxTrans < self.translationDoors[i].minTrans then
				if self.translationDoors[i].trans > self.translationDoors[i].maxTrans then
					self.translationDoors[i].trans = self.translationDoors[i].trans - dt*self.translationDoors[i].speed;
				end;
			end;
	    else
			if self.translationDoors[i].maxTrans > self.translationDoors[i].minTrans then
				if self.translationDoors[i].trans > self.translationDoors[i].minTrans then
					self.translationDoors[i].trans = self.translationDoors[i].trans - dt*self.translationDoors[i].speed;
				end;
			elseif self.translationDoors[i].maxTrans < self.translationDoors[i].minTrans then
				if self.translationDoors[i].trans < self.translationDoors[i].minTrans then
					self.translationDoors[i].trans = self.translationDoors[i].trans + dt*self.translationDoors[i].speed;
				end;
			end;
        end;
	end;
        for i=1, table.getn(self.translationDoors) do
			if self.translationDoors[i].transDirection == "x" then
				setTranslation(self.translationDoors[i].index, self.translationDoors[i].trans, 0, 0);	
			elseif	self.translationDoors[i].transDirection == "y" then
				setTranslation(self.translationDoors[i].index, 0, self.translationDoors[i].trans, 0);			
			elseif self.translationDoors[i].transDirection == "z" then
				setTranslation(self.translationDoors[i].index, 0, 0, self.translationDoors[i].trans);			
			end;
        end; 

end;
  
function translationDoors:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter then
        self.count = self.count + 1;
    elseif onLeave then
        self.count = self.count - 1;
    end; 
end;
    
g_onCreateUtil.addOnCreateFunction("translationDoorsOnCreate", translationDoors.onCreate);

